/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class HyperlinkFactory {
    private static Logger log = LogManager.getLogger(HyperlinkFactory.class);

    public static JLabel createLink(String label, final String link) throws HeadlessException {
        JLabel hyperLink = new JLabel(label);
        hyperLink.setForeground(Globals.isDarkMode() ? Color.CYAN : Color.BLUE.darker());
        hyperLink.setCursor(new Cursor(12));
        hyperLink.setToolTipText(link);
        try {
            final URI uri = new URI(link);
            hyperLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        log.error("Error following hyperlink: " + link, ex);
                    }
                }
            });
            return hyperLink;
        }
        catch (URISyntaxException e) {
            return new JLabel(link);
        }
    }
}

