/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.SAMRecord;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.sbx.NullAlignment;

public class SbxUtils {
    public static final Color fullDiscordantInsertionColor = new Color(180, 180, 180);
    public static final Color discordantInsertionColor = new Color(140, 140, 140);
    public static final int DISCORDANT_BASE_QUALITY_MAX = 10;
    public static final int SBX_LOW_BASEQ_TAIL_THRESHOLD = 30;

    public static boolean isDiscordantInsertion(Alignment alignment, AlignmentBlock aBlock) {
        return aBlock != null && (SbxUtils.isDiscordantInsertion(aBlock) || SbxUtils.isDiscordantHpInsertion(alignment, aBlock) || SbxUtils.hasAdjacentDiscordantBase(alignment, aBlock));
    }

    public static boolean isFullDiscordantInsertion(AlignmentBlock aBlock) {
        if (aBlock == null) {
            return false;
        }
        for (int i = 0; i < aBlock.getLength(); ++i) {
            if (aBlock.getQuality(i) <= 10) continue;
            return false;
        }
        return true;
    }

    public static boolean isDiscordantInsertion(AlignmentBlock aBlock) {
        for (int i = 0; i < aBlock.getLength(); ++i) {
            if (aBlock.getQuality(i) > 10) continue;
            return true;
        }
        return false;
    }

    public static boolean isDiscordantHpInsertion(Alignment alignment, AlignmentBlock aBlock) {
        int position;
        byte base = aBlock.getBase(0);
        for (int i = 1; i < aBlock.getLength(); ++i) {
            byte nextBase = aBlock.getBase(i);
            if (nextBase == base) continue;
            return false;
        }
        for (position = aBlock.getStart() - 1; position >= 0 && alignment.getBase(position) == base; --position) {
        }
        ++position;
        while (position < alignment.getReadSequence().length() && alignment.getBase(position) == base) {
            if (alignment.getPhred(position) <= 10) {
                return true;
            }
            ++position;
        }
        return false;
    }

    public static boolean hasAdjacentDiscordantBase(Alignment alignment, AlignmentBlock aBlock) {
        int position = aBlock.getStart();
        if (alignment.getBase(position) != 0 && alignment.getPhred(position) <= 10) {
            return true;
        }
        return alignment.getBase(position - 1) != 0 && alignment.getPhred(position - 1) <= 10;
    }

    public static String qualityString(String rawQualString) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < rawQualString.length(); ++i) {
            if (i > 0) {
                res.append(",");
            }
            res.append((int)rawQualString.charAt(i));
        }
        return res.toString();
    }

    public static boolean isSBXAlignments(Set<Integer> qualityScores) {
        HashSet<Integer> expectedScores1 = new HashSet<Integer>(Arrays.asList(5, 22, 39));
        HashSet<Integer> expectedScores2 = new HashSet<Integer>(Arrays.asList(0, 18, 93));
        if (qualityScores.size() == 0 || qualityScores.size() == 1 && qualityScores.contains(0)) {
            return false;
        }
        HashSet<Integer> expectedSet = null;
        for (Integer score : qualityScores) {
            if (expectedSet == null) {
                if (expectedScores1.contains(score)) {
                    expectedSet = expectedScores1;
                    continue;
                }
                if (expectedScores2.contains(score)) {
                    expectedSet = expectedScores2;
                    continue;
                }
                return false;
            }
            if (expectedSet.contains(score)) continue;
            return false;
        }
        return true;
    }

    public static int[] trimTails(Alignment alignment) {
        int simplexTailRightStart;
        int simplexTailLeftEnd;
        int alignmentLength = alignment.getEnd() - alignment.getStart();
        for (simplexTailLeftEnd = 0; simplexTailLeftEnd < alignmentLength && (alignment.getPhred(alignment.getStart() + simplexTailLeftEnd) <= 30 || alignment.getBase(alignment.getStart() + simplexTailLeftEnd) == 0); ++simplexTailLeftEnd) {
        }
        for (simplexTailRightStart = alignmentLength - 1; simplexTailRightStart >= 0 && (alignment.getPhred(alignment.getStart() + simplexTailRightStart) <= 30 || alignment.getBase(alignment.getStart() + simplexTailRightStart) == 0); --simplexTailRightStart) {
        }
        return new int[]{simplexTailLeftEnd, simplexTailRightStart};
    }

    public static Alignment trimSimplexTails(SAMAlignment parent) {
        int end;
        int start;
        SAMRecord record = parent.getRecord().deepCopy();
        String cigarString = record.getCigarString();
        byte[] readBases = record.getReadBases();
        byte[] readBaseQualities = record.getBaseQualities();
        for (start = 0; start < readBases.length && readBaseQualities[start] <= 30; ++start) {
        }
        for (end = readBases.length - 1; end >= 0 && readBaseQualities[end] <= 30; --end) {
        }
        if (start == 0 && end == readBases.length - 1) {
            return parent;
        }
        if (start > end) {
            return NullAlignment.getInstance();
        }
        byte[] newReadBases = Arrays.copyOfRange(readBases, start, end + 1);
        byte[] newBaseQuals = Arrays.copyOfRange(readBaseQualities, start, end + 1);
        record.setReadBases(newReadBases);
        record.setBaseQualities(newBaseQuals);
        List<SAMAlignment.CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
        StringBuilder newCigarString = new StringBuilder();
        int readStart = 0;
        int newAlignmentStart = record.getAlignmentStart();
        for (SAMAlignment.CigarOperator op : operators) {
            int truncatedRight;
            int length = op.nBases;
            char type = op.operator;
            boolean consumesQuery = SbxUtils.isConsumesQuery(type);
            boolean consumesRef = SbxUtils.isConsumesRef(type);
            int curEnd = readStart;
            if (consumesQuery) {
                curEnd += length;
            }
            if (curEnd <= start) {
                if (consumesRef) {
                    newAlignmentStart += length;
                }
                if (!consumesQuery) continue;
                readStart = curEnd;
                continue;
            }
            if (readStart > end) break;
            if (readStart >= start && curEnd <= end + 1) {
                newCigarString.append(length).append(type);
                readStart = curEnd;
                continue;
            }
            int truncatedLeft = Math.max(0, start - readStart);
            int newLength = length - truncatedLeft - (truncatedRight = Math.max(0, curEnd - (end + 1)));
            if (newLength > 0) {
                newCigarString.append(newLength).append(type);
            }
            if (consumesRef) {
                newAlignmentStart += truncatedLeft;
            }
            readStart = curEnd;
        }
        record.setAlignmentStart(newAlignmentStart);
        record.setCigarString(newCigarString.toString());
        return new SAMAlignment(record);
    }

    private static boolean isConsumesRef(char type) {
        boolean consumesRef = switch (type) {
            case '=', 'D', 'M', 'N', 'X' -> true;
            default -> false;
        };
        return consumesRef;
    }

    private static boolean isConsumesQuery(char type) {
        boolean consumesQuery = switch (type) {
            case '=', 'I', 'M', 'S', 'X' -> true;
            default -> false;
        };
        return consumesQuery;
    }
}

