/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.IGVNamedFeature;

public class Cytoband
implements IGVNamedFeature {
    String chromosome;
    String name;
    int end;
    int start;
    char type;
    short stain;

    public Cytoband(String chromosome) {
        this.chromosome = chromosome;
        this.name = "";
    }

    public Cytoband(String chromosome, int start, int end, String name, String gieStain) {
        this.chromosome = chromosome;
        this.end = end;
        this.start = start;
        this.name = name;
        if (gieStain.equals("acen")) {
            this.setType('c');
        } else {
            this.setType(gieStain.charAt(1));
            if (this.type == 'p') {
                String stainString = gieStain.substring(4).trim();
                short stain = stainString.length() == 0 ? (short)100 : (short)Short.parseShort(stainString);
                this.setStain(stain);
            }
        }
    }

    public void trim() {
    }

    public String getContig() {
        return this.chromosome;
    }

    public String getChr() {
        return this.chromosome;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getEnd() {
        return this.end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setType(char type) {
        this.type = type;
    }

    public char getType() {
        return this.type;
    }

    public void setStain(short stain) {
        this.stain = stain;
    }

    public short getStain() {
        return this.stain;
    }
}

