/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPERenderer;
import org.broad.igv.bedpe.BedPEShape;
import org.broad.igv.bedpe.NestedArcRenderer;
import org.broad.igv.bedpe.PEBlockRenderer;
import org.broad.igv.bedpe.ProportionalArcRenderer;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.jbrowse.CircularViewUtilities;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InteractionTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(InteractionTrack.class);
    private FeatureSource<BedPE> featureSource;
    private JCheckBoxMenuItem autoscaleCB;
    private JMenuItem maxScoreItem;
    Direction direction = Direction.UP;
    GraphType graphType;
    private ArcOption arcOption = ArcOption.ALL;
    int thickness = 1;
    boolean autoscale = true;
    double maxScore = -1.0;
    int gap = 5;
    boolean showBlocks = false;
    private Map<GraphType, BedPERenderer> renderers;
    transient Map<ReferenceFrame, List<BedPE>> lastRenderedFeatures = new HashMap<ReferenceFrame, List<BedPE>>();

    public InteractionTrack() {
    }

    public InteractionTrack(ResourceLocator locator, FeatureSource<BedPE> src) {
        super(locator);
        String blockString;
        String directionString;
        this.featureSource = src;
        this.setHeight(250, true);
        this.setColor(new Color(180, 25, 137));
        this.renderers = new HashMap<GraphType, BedPERenderer>();
        this.renderers.put(GraphType.NESTED_ARC, new NestedArcRenderer(this));
        this.renderers.put(GraphType.PROPORTIONAL_ARC, new ProportionalArcRenderer(this));
        this.renderers.put(GraphType.BLOCK, new PEBlockRenderer(this));
        String typeString = PreferencesManager.getPreferences().get("ARC_TYPE");
        if (typeString != null) {
            try {
                this.graphType = GraphType.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal graph type: " + typeString, e);
                this.graphType = GraphType.NESTED_ARC;
            }
        } else {
            this.graphType = GraphType.PROPORTIONAL_ARC;
        }
        if ((directionString = PreferencesManager.getPreferences().get("ARC_DIRECTION")) != null) {
            try {
                this.direction = Direction.valueOf(directionString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal arc direction: " + directionString, e);
                this.direction = Direction.UP;
            }
        } else {
            this.direction = Direction.UP;
        }
        if ((blockString = PreferencesManager.getPreferences().get("ARC_BLOCKS")) != null) {
            try {
                this.showBlocks = Boolean.valueOf(blockString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal arc blocks option: " + blockString, e);
            }
        }
    }

    protected boolean isShowFeatures(ReferenceFrame frame) {
        if (frame.getChrName().equals("All")) {
            return true;
        }
        double windowSize = frame.getEnd() - frame.getOrigin();
        int vw = this.getVisibilityWindow();
        return vw <= 0 || windowSize <= (double)vw;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return true;
    }

    @Override
    public void load(ReferenceFrame frame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle trackRectangle) {
        Graphics2D g2d = context.getGraphics();
        Rectangle clip = new Rectangle(g2d.getClip().getBounds());
        g2d.setClip(trackRectangle.intersection(clip.getBounds()));
        context.clearGraphicsCache();
        if (!this.isShowFeatures(context.getReferenceFrame())) {
            String message = "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, trackRectangle, context.getGraphics());
            return;
        }
        try {
            String chr = context.getReferenceFrame().getChrName();
            ArrayList<BedPE> features = new ArrayList<BedPE>();
            Iterator<BedPE> iter = this.featureSource.getFeatures(chr, (int)context.getOrigin(), (int)context.getEndLocation());
            while (iter.hasNext()) {
                features.add(iter.next());
            }
            if (features != null && features.size() > 0) {
                if (this.graphType == GraphType.PROPORTIONAL_ARC) {
                    if (this.autoscale || this.maxScore <= 0.0) {
                        this.maxScore = this.autoscale(features);
                    }
                    this.drawScale(context, trackRectangle);
                }
                this.renderers.get((Object)this.graphType).render(features, context, trackRectangle, this.arcOption);
            }
            if (this.showBlocks) {
                this.renderers.get((Object)GraphType.BLOCK).render(features, context, trackRectangle, this.arcOption);
            }
            this.lastRenderedFeatures.put(context.getReferenceFrame(), features);
        }
        catch (IOException e) {
            log.error("Error fetching features. ", e);
        }
        finally {
            context.clearGraphicsCache();
            g2d.setClip(clip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScale(RenderContext context, Rectangle arect) {
        if (!context.multiframe) {
            Graphics2D g = context.getGraphic2DForColor(Color.black);
            Font font = g.getFont();
            Font smallFont = FontManager.getFont(8);
            try {
                g.setFont(smallFont);
                String minString = "0";
                String fmtString = this.maxScore > 10.0 ? "%.0f" : "%.2f";
                String maxString = String.format(fmtString, this.maxScore);
                String scale = "[" + minString + " - " + maxString + "]";
                g.drawString(scale, arect.x + 5, arect.y + 10);
            }
            finally {
                g.setFont(font);
            }
        }
    }

    private double autoscale(List<BedPE> features) {
        double maxScore = 0.0;
        for (BedPE f : features) {
            maxScore = Math.max(maxScore, (double)f.getScore());
        }
        return maxScore;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        JMenuItem item;
        IGVPopupMenu menu = new IGVPopupMenu();
        if (PreferencesManager.getPreferences().getAsBoolean("CIRC_VIEW_ENABLED") && CircularViewUtilities.ping()) {
            menu.addSeparator();
            item = new JMenuItem("Add Features to Circular View");
            item.addActionListener(e -> {
                List<ReferenceFrame> frames = te.getFrame() != null ? Arrays.asList(te.getFrame()) : FrameManager.getFrames();
                List<? extends BedPE> visibleFeatures = this.getVisibleFeatures(frames);
                CircularViewUtilities.sendBedpeToJBrowse(visibleFeatures, this.getName(), this.getColor());
            });
            menu.add(item);
            menu.addSeparator();
        }
        menu.add(TrackMenuUtils.getTrackRenameItem(Collections.singleton(this)));
        item = new JMenuItem("Set Track Height...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackHeight(Collections.singleton(this)));
        menu.add(item);
        item = new JMenuItem("Set Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(Collections.singleton(this)));
        menu.add(item);
        menu.addSeparator();
        menu.add(new JLabel("<html><b>Graph Type</b>"));
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, GraphType> modes = new LinkedHashMap<String, GraphType>(4);
        modes.put("Nested Arcs", GraphType.NESTED_ARC);
        modes.put("Proportional Arcs", GraphType.PROPORTIONAL_ARC);
        for (Map.Entry entry : modes.entrySet()) {
            JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
            mm.setSelected(this.graphType == entry.getValue());
            mm.addActionListener(evt -> {
                this.setGraphType((GraphType)((Object)((Object)((Object)entry.getValue()))));
                PreferencesManager.getPreferences().put("ARC_TYPE", ((GraphType)((Object)((Object)((Object)entry.getValue())))).toString());
                this.autoscaleCB.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
                this.maxScoreItem.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
                this.repaint();
            });
            group.add(mm);
            menu.add(mm);
        }
        menu.addSeparator();
        menu.add(new JLabel("<html><b>Arcs</b>"));
        ButtonGroup group2 = new ButtonGroup();
        LinkedHashMap<String, ArcOption> modes2 = new LinkedHashMap<String, ArcOption>(4);
        modes2.put("All", ArcOption.ALL);
        modes2.put("One End In View", ArcOption.ONE_END);
        modes2.put("Both Ends In View", ArcOption.BOTH_ENDS);
        for (Map.Entry entry : modes2.entrySet()) {
            JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
            mm.setSelected(this.arcOption == entry.getValue());
            mm.addActionListener(evt -> {
                this.arcOption = (ArcOption)((Object)((Object)((Object)entry.getValue())));
                this.repaint();
            });
            group2.add(mm);
            menu.add(mm);
        }
        menu.addSeparator();
        JCheckBoxMenuItem showBlocksCB = new JCheckBoxMenuItem("Show Blocks");
        showBlocksCB.setSelected(this.showBlocks);
        showBlocksCB.addActionListener(e -> {
            this.showBlocks = showBlocksCB.isSelected();
            PreferencesManager.getPreferences().put("ARC_BLOCKS", String.valueOf(showBlocksCB.isSelected()));
            this.repaint();
        });
        menu.add(showBlocksCB);
        menu.addSeparator();
        this.autoscaleCB = new JCheckBoxMenuItem("Autoscale");
        this.autoscaleCB.setSelected(this.autoscale);
        this.autoscaleCB.addActionListener(e -> {
            this.autoscale = this.autoscaleCB.isSelected();
            this.repaint();
        });
        menu.add(this.autoscaleCB);
        this.maxScoreItem = new JMenuItem("Set Max Score...");
        this.maxScoreItem.addActionListener(e -> {
            String maxScoreString = MessageUtils.showInputDialog("Enter maximum score:", String.valueOf(this.maxScore));
            if (maxScoreString != null) {
                try {
                    double ms = Double.parseDouble(maxScoreString);
                    if (ms > 0.0) {
                        this.maxScore = ms;
                        this.autoscale = false;
                        this.repaint();
                    } else {
                        MessageUtils.showMessage("maximum score must be > 0");
                    }
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showMessage("maximum score must be a number");
                }
            }
        });
        menu.add(this.maxScoreItem);
        this.autoscaleCB.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
        this.maxScoreItem.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
        menu.addSeparator();
        item = new JMenuItem("Toggle Arc Orientation");
        item.addActionListener(evt -> {
            this.direction = this.direction == Direction.UP ? Direction.DOWN : Direction.UP;
            this.repaint();
        });
        menu.add(item);
        item = new JMenuItem("Set Line Thickness...");
        item.addActionListener(e -> {
            String t = MessageUtils.showInputDialog("Line thickness", String.valueOf(this.thickness));
            if (t != null) {
                try {
                    this.thickness = Integer.parseInt(t);
                    this.repaint();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Line thickness must be an integer", e1);
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        menu.add(TrackMenuUtils.getChangeFeatureWindow(Arrays.asList(this)));
        return menu;
    }

    private void setGraphType(GraphType value) {
        this.graphType = value;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        double tolerance = frame.getScale() * 3.0;
        List<BedPE> features = this.lastRenderedFeatures.get(frame);
        if (features == null) {
            return "";
        }
        ArrayList<BedPE> candidates = new ArrayList<BedPE>();
        for (BedPE bedPE : features) {
            if ((double)bedPE.getEnd() < position - tolerance) continue;
            if ((double)bedPE.getStart() > position + tolerance) break;
            candidates.add(bedPE);
        }
        Comparator sorter = this.graphType == GraphType.PROPORTIONAL_ARC ? (o1, o2) -> {
            double score2;
            double score1 = o1.getScore();
            if (score1 > (score2 = (double)o2.getScore())) {
                return 1;
            }
            if (score1 < score2) {
                return -1;
            }
            return 0;
        } : (o1, o2) -> {
            double d2;
            double d1 = o1.getCenterDistance();
            if (d1 > (d2 = o2.getCenterDistance())) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        };
        Collections.sort(candidates, sorter);
        for (BedPE f : candidates) {
            BedPEShape s = f.getShape();
            if (s != null && !s.contains(mouseX, mouseY)) continue;
            return f.getValueString();
        }
        return super.getValueStringAt(chr, position, mouseX, mouseY, frame);
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("direction", String.valueOf((Object)this.direction));
        element.setAttribute("thickness", String.valueOf(this.thickness));
        element.setAttribute("graphType", String.valueOf((Object)this.graphType));
        element.setAttribute("arcOption", String.valueOf((Object)this.arcOption));
        element.setAttribute("showBlocks", String.valueOf(this.showBlocks));
        element.setAttribute("autoscale", String.valueOf(this.autoscale));
        if (!this.autoscale) {
            element.setAttribute("maxScore", String.valueOf(this.maxScore));
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        String typeString;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("arcOption")) {
            typeString = element.getAttribute("arcOption").toUpperCase();
            this.arcOption = ArcOption.valueOf(typeString);
        }
        if (element.hasAttribute("direction")) {
            this.direction = Direction.valueOf(element.getAttribute("direction"));
        }
        if (element.hasAttribute("thickness")) {
            this.thickness = Integer.parseInt(element.getAttribute("thickness"));
        }
        if (element.hasAttribute("graphType")) {
            typeString = element.getAttribute("graphType").toUpperCase();
            if (typeString.equals("ARC")) {
                typeString = "NESTED_ARC";
            }
            this.graphType = GraphType.valueOf(typeString);
        }
        if (element.hasAttribute("showBlocks")) {
            this.showBlocks = Boolean.parseBoolean(element.getAttribute("showBlocks"));
        }
        if (element.hasAttribute("autoscale")) {
            this.autoscale = Boolean.parseBoolean(element.getAttribute("autoscale"));
        }
        if (element.hasAttribute("maxScore")) {
            this.maxScore = Double.parseDouble(element.getAttribute("maxScore"));
        }
    }

    public List<? extends BedPE> getVisibleFeatures(List<ReferenceFrame> frames) {
        Function<ReferenceFrame, List> frameFeatures = f -> this.lastRenderedFeatures.get(f);
        if (frames.size() == 0) {
            return Collections.emptyList();
        }
        if (frames.size() == 1) {
            return frameFeatures.apply(frames.get(0));
        }
        ArrayList inView = new ArrayList();
        for (ReferenceFrame f2 : frames) {
            inView.addAll(frameFeatures.apply(f2));
        }
        return inView;
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof FrameManager.ChangeEvent) {
            this.lastRenderedFeatures.clear();
        }
    }

    static enum Direction {
        UP,
        DOWN;

    }

    static enum ArcOption {
        ALL,
        ONE_END,
        BOTH_ENDS;

    }

    static enum GraphType {
        BLOCK,
        NESTED_ARC,
        PROPORTIONAL_ARC;

    }
}

