/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.logging.LogFileHandler;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;

public class DirectoryManager {
    private static Logger log = LogManager.getLogger(DirectoryManager.class);
    private static File USER_HOME;
    private static File USER_DIRECTORY;
    private static File IGV_DIRECTORY;
    private static File AUTOSAVE_DIRECTORY;
    private static File GENOME_CACHE_DIRECTORY;
    private static File GENE_LIST_DIRECTORY;
    private static File BAM_CACHE_DIRECTORY;
    public static final String IGV_DIR_USERPREF = "igvDir";

    public static File getUserHome() {
        if (USER_HOME == null) {
            String userHomeString = System.getProperty("user.home");
            USER_HOME = new File(userHomeString);
        }
        return USER_HOME;
    }

    public static synchronized File getUserDefaultDirectory() {
        if (USER_DIRECTORY == null && (USER_DIRECTORY = FileSystemView.getFileSystemView().getDefaultDirectory()) == null) {
            USER_DIRECTORY = DirectoryManager.getUserHome();
        }
        return USER_DIRECTORY;
    }

    public static void setIgvDirectory(File dir) {
        log.info("IGV Directory: " + dir.getAbsolutePath());
        IGV_DIRECTORY = dir;
    }

    public static File getIgvDirectory() {
        if (IGV_DIRECTORY == null) {
            File rootDir;
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    Runtime.getRuntime().exec("attrib -r \"" + DirectoryManager.getUserDefaultDirectory().getAbsolutePath() + "\"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((IGV_DIRECTORY = DirectoryManager.getIgvDirectoryOverride()) == null && !(IGV_DIRECTORY = new File(rootDir = DirectoryManager.getUserHome(), "igv")).exists()) {
                try {
                    boolean wasSuccessful = IGV_DIRECTORY.mkdir();
                    if (!wasSuccessful) {
                        log.error("Failed to create user directory!");
                        IGV_DIRECTORY = null;
                    }
                }
                catch (Exception e) {
                    log.error("Error creating igv directory", e);
                }
            }
            if (IGV_DIRECTORY == null || !IGV_DIRECTORY.exists() || !DirectoryManager.canWrite(IGV_DIRECTORY)) {
                if (Globals.isHeadless() || Globals.isSuppressMessages()) {
                    System.err.println("Cannot write to igv directory: " + IGV_DIRECTORY.getAbsolutePath());
                    IGV_DIRECTORY = new File(".").getParentFile();
                } else {
                    File parentDirectory;
                    int option = JOptionPane.showConfirmDialog(null, "<html>The default IGV directory (" + String.valueOf(IGV_DIRECTORY) + ") cannot be accessed.  Click Yes to choose a new folder or No to exit.<br>This folder will be used to create the 'igv' directory", "IGV Directory Error", 0);
                    if (option == 0 && (parentDirectory = FileDialogUtils.chooseDirectory("Select a location for the igv directory", null)) != null) {
                        IGV_DIRECTORY = new File(parentDirectory, "igv");
                        IGV_DIRECTORY.mkdir();
                        Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                        prefs.put(IGV_DIR_USERPREF, IGV_DIRECTORY.getAbsolutePath());
                    }
                }
            }
            if (IGV_DIRECTORY == null || !IGV_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", IGV_DIRECTORY.getAbsolutePath());
            }
            if (!DirectoryManager.canWrite(IGV_DIRECTORY)) {
                throw new DataLoadException("Cannot write to user directory", IGV_DIRECTORY.getAbsolutePath());
            }
        }
        return IGV_DIRECTORY;
    }

    private static File getIgvDirectoryOverride() {
        Preferences userPrefs = null;
        File override = null;
        try {
            userPrefs = Preferences.userNodeForPackage(Globals.class);
            String userDir = userPrefs.get(IGV_DIR_USERPREF, null);
            if (userDir != null && !(override = new File(userDir)).exists()) {
                override = null;
                userPrefs.remove(IGV_DIR_USERPREF);
            }
        }
        catch (Exception e) {
            userPrefs.remove(IGV_DIR_USERPREF);
            override = null;
            log.error("Error creating user directory", e);
        }
        return override;
    }

    public static File getAutosaveDirectory() {
        if (AUTOSAVE_DIRECTORY == null) {
            AUTOSAVE_DIRECTORY = new File(DirectoryManager.getIgvDirectory(), "autosave");
            if (!AUTOSAVE_DIRECTORY.exists()) {
                AUTOSAVE_DIRECTORY.mkdir();
            }
            if (!AUTOSAVE_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", AUTOSAVE_DIRECTORY.getAbsolutePath());
            }
            if (!AUTOSAVE_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", AUTOSAVE_DIRECTORY.getAbsolutePath());
            }
        }
        return AUTOSAVE_DIRECTORY;
    }

    public static File getGenomeCacheDirectory() {
        if (GENOME_CACHE_DIRECTORY == null) {
            GENOME_CACHE_DIRECTORY = new File(DirectoryManager.getIgvDirectory(), "genomes");
            if (!GENOME_CACHE_DIRECTORY.exists()) {
                GENOME_CACHE_DIRECTORY.mkdir();
            }
            if (!GENOME_CACHE_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
            if (!GENOME_CACHE_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
        }
        return GENOME_CACHE_DIRECTORY;
    }

    public static File getFastaCacheDirectory() {
        File directory = null;
        String cachePref = PreferencesManager.getPreferences().get("CRAM.CACHE_DIRECTORY");
        if (cachePref != null) {
            directory = new File(cachePref);
        }
        if (!(directory != null && directory.exists() && directory.isDirectory() || (directory = new File(DirectoryManager.getGenomeCacheDirectory(), "seq")).exists())) {
            directory.mkdir();
        }
        return directory;
    }

    public static File getGeneListDirectory() {
        if (GENE_LIST_DIRECTORY == null) {
            GENE_LIST_DIRECTORY = new File(DirectoryManager.getIgvDirectory(), "lists");
            if (!GENE_LIST_DIRECTORY.exists()) {
                GENE_LIST_DIRECTORY.mkdir();
            }
            if (!GENE_LIST_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
            if (!GENE_LIST_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
        }
        return GENE_LIST_DIRECTORY;
    }

    public static synchronized File getCacheDirectory() {
        File defaultDir;
        if (BAM_CACHE_DIRECTORY == null && (defaultDir = DirectoryManager.getIgvDirectory()).exists() && !(BAM_CACHE_DIRECTORY = new File(defaultDir, "bam")).exists()) {
            BAM_CACHE_DIRECTORY.mkdir();
        }
        return BAM_CACHE_DIRECTORY;
    }

    public static synchronized File getSamDirectory() {
        File samDir = new File(DirectoryManager.getIgvDirectory(), "sam");
        if (!samDir.exists()) {
            samDir.mkdir();
        }
        return samDir;
    }

    public static synchronized File getLogFile() throws IOException {
        File logFile = new File(DirectoryManager.getIgvDirectory(), "igv.log");
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    public static synchronized File getPreferencesFile() {
        File oldFile;
        File igvDirectoy = DirectoryManager.getIgvDirectory();
        File igvPropertyFile = new File(igvDirectoy, "prefs.properties");
        if (!igvPropertyFile.exists() && (oldFile = DirectoryManager.getLegacyPreferencesFile()).exists()) {
            try {
                org.apache.commons.io.FileUtils.copyFile((File)oldFile, (File)igvPropertyFile);
            }
            catch (IOException e) {
                log.error("Error copy property file from: " + String.valueOf(oldFile) + " to: " + String.valueOf(igvPropertyFile), e);
            }
        }
        if (!igvPropertyFile.exists()) {
            try {
                igvPropertyFile.createNewFile();
            }
            catch (IOException e) {
                log.error("Could not create property file: " + String.valueOf(igvPropertyFile), e);
            }
        }
        return igvPropertyFile;
    }

    public static void moveIGVDirectory(File newIGVDirectoryParent) {
        File newIGVDirectory = new File(newIGVDirectoryParent, "igv");
        if (newIGVDirectory.equals(IGV_DIRECTORY)) {
            return;
        }
        if (IGV_DIRECTORY != null) {
            File oldDirectory = IGV_DIRECTORY;
            try {
                log.info("Moving igv directory from " + oldDirectory.getParent() + " to " + newIGVDirectory.getAbsolutePath());
                org.apache.commons.io.FileUtils.copyDirectory((File)IGV_DIRECTORY, (File)newIGVDirectory);
                IGV_DIRECTORY = newIGVDirectory;
                Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                prefs.put(IGV_DIR_USERPREF, newIGVDirectory.getAbsolutePath());
                PreferencesManager.setPrefsFile(DirectoryManager.getPreferencesFile().getAbsolutePath());
            }
            catch (IOException e) {
                log.error("Error copying IGV directory", e);
                MessageUtils.showMessage("<html>Error moving IGV directory:<br/>&nbsp;nbsp;" + e.getMessage());
                return;
            }
            DirectoryManager.initializeLog();
            FileUtils.deleteDir(oldDirectory);
        }
        AUTOSAVE_DIRECTORY = null;
        GENOME_CACHE_DIRECTORY = null;
        GENE_LIST_DIRECTORY = null;
        BAM_CACHE_DIRECTORY = null;
    }

    public static void moveDirectoryContents(File oldDirectory, File newDirectory) {
        if (oldDirectory != null && oldDirectory.exists() && oldDirectory.isDirectory() && newDirectory != null && newDirectory.exists() && newDirectory.isDirectory()) {
            for (File f : oldDirectory.listFiles()) {
                Path p1 = f.toPath();
                Path p2 = new File(newDirectory, f.getName()).toPath();
                try {
                    Files.move(p1, p2, new CopyOption[0]);
                }
                catch (IOException e) {
                    log.error("Error moving file", e);
                }
            }
        }
    }

    public static boolean isChildOf(File base, File child) {
        for (File parent = child.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!base.equals(parent)) continue;
            return true;
        }
        return false;
    }

    private static synchronized File getLegacyPreferencesFile() {
        File rootDir = DirectoryManager.getLegacyIGVDirectory();
        return new File(rootDir, "prefs.properties");
    }

    private static File getLegacyIGVDirectory() {
        File rootDir = DirectoryManager.getUserHome();
        rootDir = Globals.IS_MAC ? new File(rootDir, ".igv") : new File(rootDir, "igv");
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File directory) {
        if (Globals.IS_WINDOWS) {
            File testFile = null;
            try {
                testFile = new File(directory, "igv332415dsfjdsklt.testfile");
                if (testFile.exists()) {
                    testFile.delete();
                }
                testFile.deleteOnExit();
                testFile.createNewFile();
                boolean bl = testFile.exists();
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (testFile.exists()) {
                    testFile.delete();
                }
            }
        }
        return directory.canWrite();
    }

    public static void initializeLog() {
        LogFileHandler.getInstance().updateHandler();
    }
}

