/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.readers.sam.SamComparison;

public class SamPerPositionComparison
extends SamComparison {
    private static final List<SAMRecord> EMPTY_SAM_LIST = new ArrayList<SAMRecord>(0);
    private static final List<Alignments.AlignmentEntry> EMPTY_GOBY_LIST = new ArrayList<Alignments.AlignmentEntry>(0);
    private int currentPosition = -1;
    private final List<SAMRecord> sources = new ArrayList<SAMRecord>();
    private final Map<String, List<SAMRecord>> destsMap = new HashMap<String, List<SAMRecord>>();
    private final Map<String, List<Alignments.AlignmentEntry>> gobyDestsMap = new HashMap<String, List<Alignments.AlignmentEntry>>();
    private boolean compareAtEachNewPosition = true;

    public boolean isCompareAtEachNewPosition() {
        return this.compareAtEachNewPosition;
    }

    public void setCompareAtEachNewPosition(boolean compareAtEachNewPosition) {
        this.compareAtEachNewPosition = compareAtEachNewPosition;
    }

    @Override
    public int compare(SAMRecord source, SAMRecord dest, Alignments.AlignmentEntry gobyDest) {
        int result = 0;
        if (this.compareAtEachNewPosition && source.getAlignmentStart() != this.currentPosition) {
            result = this.makeComparisons();
        }
        this.sources.add(source);
        this.addToSamMap(dest);
        if (gobyDest != null) {
            this.addToGobyMap(gobyDest);
        }
        this.currentPosition = source.getAlignmentStart();
        return result;
    }

    private void addToSamMap(SAMRecord dest) {
        String key = dest.getReadName();
        List<SAMRecord> list = this.destsMap.get(key);
        if (list == null) {
            list = new LinkedList<SAMRecord>();
            this.destsMap.put(key, list);
        }
        list.add(dest);
    }

    private void addToGobyMap(Alignments.AlignmentEntry dest) {
        String key = dest.getReadName();
        List<Alignments.AlignmentEntry> list = this.gobyDestsMap.get(key);
        if (list == null) {
            list = new LinkedList<Alignments.AlignmentEntry>();
            this.gobyDestsMap.put(key, list);
        }
        list.add(dest);
    }

    private void removeFromSamMap(SAMRecord dest) {
        String key = dest.getReadName();
        List<SAMRecord> list = this.destsMap.get(key);
        list.remove(dest);
    }

    private void removeFromGobyMap(Alignments.AlignmentEntry dest) {
        if (dest != null) {
            String key = dest.getReadName();
            List<Alignments.AlignmentEntry> list = this.gobyDestsMap.get(key);
            list.remove(dest);
        }
    }

    @Override
    public int finished() {
        return this.makeComparisons();
    }

    private void resetForPosition() {
        this.sources.clear();
        this.destsMap.clear();
        this.gobyDestsMap.clear();
    }

    private int makeComparisons() {
        int resultSum = 0;
        if (!this.sources.isEmpty()) {
            for (SAMRecord sAMRecord : this.sources) {
                List<SamAndGobyDestPair> toCompares = this.findDestPairsForSource(sAMRecord);
                if (toCompares.isEmpty()) {
                    ++this.readNum;
                    ++this.comparisonFailureCount;
                    System.out.println("WARNING: Couldn't find any records to compare against source.readName=" + sAMRecord.getReadName());
                    continue;
                }
                this.countComparisonFailures = false;
                boolean tempOutputFailedComparisons = this.outputFailedComparisons;
                this.outputFailedComparisons = false;
                int leastDiffIndex = -1;
                int leastDiffScore = Integer.MAX_VALUE;
                int currentDestIndex = 0;
                for (SamAndGobyDestPair toCompare : toCompares) {
                    int currentDiffScore = super.compare(sAMRecord, toCompare.dest, toCompare.gobyDest);
                    if (currentDiffScore < leastDiffScore) {
                        leastDiffScore = currentDiffScore;
                        leastDiffIndex = currentDestIndex;
                        if (currentDiffScore == 0) break;
                    }
                    ++currentDestIndex;
                }
                this.outputFailedComparisons = tempOutputFailedComparisons;
                this.countComparisonFailures = true;
                if (leastDiffScore > 0 && this.outputFailedComparisons) {
                    super.compare(sAMRecord, toCompares.get((int)leastDiffIndex).dest, toCompares.get((int)leastDiffIndex).gobyDest);
                }
                this.removeFromSamMap(toCompares.get((int)leastDiffIndex).dest);
                this.removeFromGobyMap(toCompares.get((int)leastDiffIndex).gobyDest);
            }
        }
        for (Map.Entry entry : this.destsMap.entrySet()) {
            for (SAMRecord dest : (List)entry.getValue()) {
                System.out.println("WARNING: Remaining dest.readName=" + dest.getReadName());
            }
        }
        this.resetForPosition();
        return resultSum;
    }

    private List<SamAndGobyDestPair> findDestPairsForSource(SAMRecord source) {
        List<SAMRecord> localDests = this.findDestsForSource(source);
        List<Alignments.AlignmentEntry> localGobyDests = this.findGobyDestsForSource(source);
        LinkedList<SamAndGobyDestPair> result = new LinkedList<SamAndGobyDestPair>();
        for (SAMRecord dest : localDests) {
            if (localGobyDests.isEmpty()) {
                result.add(new SamAndGobyDestPair(dest, null));
                continue;
            }
            for (Alignments.AlignmentEntry gobyDest : localGobyDests) {
                result.add(new SamAndGobyDestPair(dest, gobyDest));
            }
        }
        return result;
    }

    private List<SAMRecord> findDestsForSource(SAMRecord source) {
        List<SAMRecord> result = this.destsMap.get(source.getReadName());
        if (result == null) {
            return EMPTY_SAM_LIST;
        }
        return result;
    }

    private List<Alignments.AlignmentEntry> findGobyDestsForSource(SAMRecord source) {
        List<Alignments.AlignmentEntry> result = this.gobyDestsMap.get(source.getReadName());
        if (result == null) {
            return EMPTY_GOBY_LIST;
        }
        return result;
    }

    private static class SamAndGobyDestPair {
        SAMRecord dest;
        Alignments.AlignmentEntry gobyDest;

        SamAndGobyDestPair(SAMRecord dest, Alignments.AlignmentEntry gobyDest) {
            this.dest = dest;
            this.gobyDest = gobyDest;
        }
    }
}

