/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.IndexNotFoundException;
import org.broad.igv.sam.reader.SAMQueryIterator;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class SAMReader
implements AlignmentReader<SAMAlignment> {
    static Logger log = Logger.getLogger(SAMReader.class);
    String samFile;
    FeatureIndex featureIndex;
    SAMFileHeader header;
    List<String> sequenceNames;
    private SamReaderFactory factory;

    public SAMReader(String samFile) throws IOException {
        this(samFile, true);
    }

    public SAMReader(String samFile, boolean requireIndex) throws IOException {
        this.samFile = samFile;
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(samFile);
            if (this.featureIndex == null) {
                throw new IndexNotFoundException(samFile);
            }
        }
        this.factory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
        this.loadHeader();
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    private void loadHeader() {
        this.header = this.getSamReader(this.samFile, 0L).getFileHeader();
    }

    @Override
    public CloseableIterator<SAMAlignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        int startAdjustment = contained ? 0 : this.featureIndex.getLongestFeature(sequence);
        int startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
        FeatureIndex.TileDef seekPos = this.featureIndex.getTileDef(sequence, startTileNumber);
        if (seekPos != null) {
            SamReader reader = this.getSamReader(this.samFile, seekPos.getStartPosition());
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(sequence, start, end, contained, (CloseableIterator<SAMRecord>)iter);
        }
        return EmptyAlignmentIterator.getInstance();
    }

    private SamReader getSamReader(String samFile, long startPosition) {
        SeekableStream stream = null;
        try {
            stream = IGVSeekableStreamFactory.getInstance().getStreamFor(samFile);
            if (startPosition >= 0L) {
                stream.seek(startPosition);
            }
            SamInputResource resource = SamInputResource.of((SeekableStream)stream);
            return this.factory.open(resource);
        }
        catch (IOException ex) {
            log.error((Object)"Error opening sam file", (Throwable)ex);
            throw new RuntimeException("Error opening: " + samFile, ex);
        }
    }

    @Override
    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.getIndex();
        }
        return this.featureIndex != null;
    }

    @Override
    public void close() throws IOException {
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        return this.featureIndex;
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            FeatureIndex idx = this.getIndex();
            if (idx == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>(idx.getIndexedChromosomes());
        }
        return this.sequenceNames;
    }

    @Override
    public CloseableIterator<SAMAlignment> iterator() {
        SamReader reader = this.getSamReader(this.samFile, -1L);
        SAMRecordIterator iter = reader.iterator();
        return new SAMQueryIterator((CloseableIterator<SAMRecord>)iter);
    }
}

