/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.util.StringUtil;
import java.util.Arrays;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.ByteSubarray;

public class AlignmentUtils {
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    static int[] emptyArray = new int[0];

    public static boolean compareBases(byte refbase, byte readbase) {
        if (readbase == 61) {
            return true;
        }
        if (refbase > 90) {
            refbase = (byte)(refbase - 32);
        }
        if (readbase > 90) {
            readbase = (byte)(readbase - 32);
        }
        if (refbase == readbase) {
            return true;
        }
        switch (refbase) {
            case 78: {
                return true;
            }
            case 85: {
                return readbase == 84;
            }
            case 77: {
                return readbase == 65 || readbase == 67;
            }
            case 82: {
                return readbase == 65 || readbase == 71;
            }
            case 87: {
                return readbase == 65 || readbase == 84;
            }
            case 83: {
                return readbase == 67 || readbase == 71;
            }
            case 89: {
                return readbase == 67 || readbase == 84;
            }
            case 75: {
                return readbase == 71 || readbase == 84;
            }
            case 86: {
                return readbase == 65 || readbase == 67 || readbase == 71;
            }
            case 72: {
                return readbase == 65 || readbase == 67 || readbase == 84;
            }
            case 68: {
                return readbase == 65 || readbase == 71 || readbase == 84;
            }
            case 66: {
                return readbase == 67 || readbase == 71 || readbase == 84;
            }
        }
        return false;
    }

    static boolean isMisMatch(byte[] reference, ByteSubarray read, boolean isSoftClipped, int idx) {
        if (reference == null) {
            return false;
        }
        boolean misMatch = false;
        if (isSoftClipped) {
            byte readbase = read.getByte(idx);
            misMatch = readbase != 61;
        } else {
            int referenceLength = reference.length;
            byte refbase = idx < referenceLength ? reference[idx] : (byte)0;
            byte readbase = read.getByte(idx);
            misMatch = readbase != 61 && idx < referenceLength && refbase != 0 && !AlignmentUtils.compareBases(refbase, readbase);
        }
        return misMatch;
    }

    public static byte[] reverseComplementCopy(byte[] bases) {
        int lastIndex = bases.length - 1;
        byte[] out = new byte[bases.length];
        for (int i = 0; i <= lastIndex; ++i) {
            out[lastIndex - i] = AlignmentUtils.complement(bases[i]);
        }
        return out;
    }

    public static void reverseComplement(byte[] bases) {
        int lastIndex = bases.length - 1;
        int i = 0;
        for (int j = lastIndex; i < j; ++i, --j) {
            byte tmp = AlignmentUtils.complement(bases[i]);
            bases[i] = AlignmentUtils.complement(bases[j]);
            bases[j] = tmp;
        }
        if (bases.length % 2 == 1) {
            bases[i] = AlignmentUtils.complement(bases[i]);
        }
    }

    public static ByteSubarray reverseComplementCopy(ByteSubarray bases) {
        int lastIndex = bases.length - 1;
        byte[] out = new byte[bases.length];
        for (int i = 0; i <= lastIndex; ++i) {
            out[lastIndex - i] = AlignmentUtils.complement(bases.getByte(i));
        }
        return new ByteSubarray(out, 0, out.length);
    }

    public static final byte complement(byte b) {
        switch (b) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b;
    }

    public static String reverseComplement(String sequenceData) {
        byte[] bases = StringUtil.stringToBytes((String)sequenceData);
        AlignmentUtils.reverseComplement(bases);
        return StringUtil.bytesToString((byte[])bases);
    }

    static void testGetModificationPositions() {
        byte[] sequence = "AGGATCTCTAGCGGATCGGCGGGGGATATGCCATAT".getBytes();
        String mm = "C+m,1,3,0";
        int[] expectedPositions = new int[]{7, 30, 31};
        int[] positions = AlignmentUtils.getModificationPositions(mm, sequence);
        System.out.println(positions);
    }

    public static AlignmentBlockImpl buildAlignmentBlock(char operator, byte[] readBases, byte[] readBaseQualities, int blockStart, int fromIdx, int nBases) {
        int nBasesAvailable;
        byte[] blockBases = null;
        byte[] blockQualities = null;
        if (readBases != null && readBases.length > 0) {
            blockBases = new byte[nBases];
            nBasesAvailable = readBases.length - fromIdx;
            if (nBasesAvailable < nBases) {
                Arrays.fill(blockBases, (byte)63);
            }
            System.arraycopy(readBases, fromIdx, blockBases, 0, nBases);
        }
        if (readBaseQualities != null && readBaseQualities.length > 0) {
            blockQualities = new byte[nBases];
            nBasesAvailable = readBaseQualities.length - fromIdx;
            if (nBasesAvailable < nBases) {
                Arrays.fill(blockQualities, (byte)126);
            }
            System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, nBases);
        }
        AlignmentBlockImpl block = new AlignmentBlockImpl(blockStart, readBases, readBaseQualities, fromIdx, nBases, operator);
        return block;
    }

    public static int[] getModificationPositions(String mm, byte[] sequence) {
        String firstMM = mm.split(";")[0];
        String[] tokens = firstMM.split(",");
        if (tokens.length == 1) {
            return emptyArray;
        }
        char base = tokens[0].charAt(0);
        char strand = tokens[0].charAt(1);
        String modification = tokens[0].substring(2);
        int[] positions = new int[tokens.length - 1];
        int idx = 0;
        int s = 0;
        int skip = Integer.parseInt(tokens[idx + 1]);
        int matchCount = 0;
        while (idx < positions.length) {
            if (sequence[s] == base) {
                if (matchCount == skip) {
                    positions[idx] = s;
                    if (idx + 1 == positions.length) break;
                    skip = Integer.parseInt(tokens[++idx + 1]);
                    matchCount = 0;
                } else {
                    ++matchCount;
                }
            }
            ++s;
        }
        return positions;
    }

    public static void main(String[] args) {
        AlignmentUtils.testGetModificationPositions();
    }
}

