/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.List;
import org.broad.igv.feature.CodonAA;
import org.broad.igv.feature.Strand;

public class AminoAcidSequence {
    private final Strand strand;
    private final int start;
    private final List<CodonAA> sequence;
    private boolean nonNullSequence;
    private final String codonTableKey;

    public AminoAcidSequence(Strand strand, int startPosition, List<CodonAA> sequence, String codonTableKey) {
        this.strand = strand;
        this.start = startPosition;
        this.sequence = sequence;
        this.codonTableKey = codonTableKey;
        this.nonNullSequence = false;
        for (CodonAA aa : sequence) {
            if (aa == null) continue;
            this.nonNullSequence = true;
            break;
        }
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getStart() {
        return this.start;
    }

    public List<CodonAA> getSequence() {
        return this.sequence;
    }

    public boolean hasNonNullSequence() {
        return this.nonNullSequence;
    }

    public String getCodonTableKey() {
        return this.codonTableKey;
    }

    public String getSequenceString() {
        Object ss = "";
        for (CodonAA c : this.sequence) {
            ss = (String)ss + c.getAminoAcid().getSymbol();
        }
        return ss;
    }
}

