/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.Globals;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.methyl.MethylDataSource;
import org.broad.igv.methyl.MethylScore;

public class BBMethylDataSource
implements MethylDataSource {
    static Pattern percentPattern = Pattern.compile("%");
    BBFileReader reader;
    Type type;
    Map<String, String> chrNameMap;

    public BBMethylDataSource(BBFileReader reader, Type type, Genome genome) throws IOException {
        this.reader = reader;
        this.type = type;
        this.init(genome);
    }

    @Override
    public Iterator<MethylScore> query(String chr, int start, int end) throws IOException {
        String tmp = this.chrNameMap.get(chr);
        String querySeq = tmp == null ? chr : tmp;
        BigBedIterator bedIterator = this.reader.getBigBedIterator(querySeq, start, chr, end, false);
        return new WrappedIterator(bedIterator, this.type);
    }

    private void init(Genome genome) {
        ArrayList<String> seqNames;
        this.chrNameMap = new HashMap<String, String>();
        if (genome != null && (seqNames = this.reader.getChromosomeNames()) != null) {
            for (String seqName : seqNames) {
                String igvChr = genome.getCanonicalChrName(seqName);
                if (igvChr == null || igvChr.equals(seqName)) continue;
                this.chrNameMap.put(igvChr, seqName);
            }
        }
    }

    public static class WrappedIterator
    implements Iterator<MethylScore> {
        BigBedIterator bedIterator;
        Type type;

        public WrappedIterator(BigBedIterator bedIterator, Type type) {
            this.bedIterator = bedIterator;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.bedIterator.hasNext();
        }

        @Override
        public MethylScore next() {
            BedFeature feat = null;
            if (feat == null && this.bedIterator.hasNext()) {
                feat = this.bedIterator.next();
                String[] restOfFields = feat.getRestOfFields();
                MethylScore score = this.type == Type.ZILLER ? this.createZillerScore(feat, restOfFields) : this.createUSCScore(feat, restOfFields);
                return score;
            }
            return null;
        }

        private MethylScore createZillerScore(BedFeature feat, String[] restOfFields) {
            float count;
            float percent;
            String name = restOfFields[0];
            if (name.contains("%")) {
                String[] tokens = percentPattern.split(name.replace("'", "").replace("[", "").replace("]", ""));
                percent = Float.parseFloat(tokens[0]);
                count = Float.parseFloat(tokens[1]);
            } else {
                String[] tokens = Globals.forwardSlashPattern.split(name.replace("'", ""));
                float methylatedReads = Float.parseFloat(tokens[0]);
                count = Float.parseFloat(tokens[1]);
                percent = methylatedReads / count * 100.0f;
            }
            return new MethylScore(feat.getChromosome(), feat.getStartBase(), feat.getEndBase(), Strand.NONE, percent, (int)count);
        }

        private MethylScore createUSCScore(BedFeature feat, String[] restOfFields) {
            char strandChar = restOfFields[2].charAt(0);
            Strand strand = strandChar == '+' ? Strand.POSITIVE : (strandChar == '-' ? Strand.NEGATIVE : Strand.NONE);
            float percentMethyl = Float.parseFloat(restOfFields[3]);
            int count = Integer.parseInt(restOfFields[4]);
            return new MethylScore(feat.getChromosome(), feat.getStartBase(), feat.getEndBase(), strand, percentMethyl, count);
        }

        @Override
        public void remove() {
        }
    }

    static enum Type {
        ZILLER,
        USC;

    }
}

