/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ByteSubarray;

public class AlignmentBlockImpl
implements AlignmentBlock {
    private static ByteSubarray EMPTY_ARRAY = new ByteSubarray(new byte[0], 0, 0);
    private int start;
    private int length;
    private ByteSubarray bases;
    private int basesLength = -1;
    public ByteSubarray qualities;
    private boolean softClipped = false;
    private int pixelStart;
    private int pixelEnd;
    private int padding = 0;
    private char cigarOperator;

    public AlignmentBlockImpl(int start, byte[] bases, byte[] qualities) {
        this(start, bases, qualities, 0, bases.length, '\u0000');
    }

    public AlignmentBlockImpl(int start, byte[] bases, byte[] qualities, int offset, int nBases, char cigarOperator) {
        this.start = start;
        this.bases = new ByteSubarray(bases, offset, nBases);
        this.basesLength = nBases;
        this.qualities = new ByteSubarray(qualities, offset, nBases);
        this.cigarOperator = cigarOperator;
    }

    @Override
    public void setPixelRange(int s, int e) {
        this.pixelStart = s;
        this.pixelEnd = e;
    }

    @Override
    public boolean containsPixel(int x) {
        return x >= this.pixelStart && x <= this.pixelEnd;
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    @Override
    public char getCigarOperator() {
        return this.cigarOperator;
    }

    @Override
    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.getLength();
    }

    @Override
    public int getBasesLength() {
        return this.basesLength;
    }

    @Override
    public int getLength() {
        return this.basesLength + this.padding;
    }

    @Override
    public byte getBase(int offset) {
        return this.bases != null && offset < this.bases.length ? this.bases.getByte(offset) : (byte)0;
    }

    @Override
    public ByteSubarray getBases() {
        return this.bases == null ? EMPTY_ARRAY : this.bases;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public byte getQuality(int offset) {
        return this.qualities == null || offset >= this.qualities.length ? (byte)126 : this.qualities.getByte(offset);
    }

    @Override
    public ByteSubarray getQualities() {
        return this.qualities == null ? EMPTY_ARRAY : this.qualities;
    }

    @Override
    public int getEnd() {
        return this.start + this.getLength();
    }

    @Override
    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        if (this.bases != null) {
            sb.append(this.bases.getString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean hasBases() {
        return this.bases != null && this.bases.length > 0;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }
}

