/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.util.ArrayList;
import java.util.List;

public class Switch
extends Parameter
implements Flagged {
    private char shortFlag = '\u0000';
    private String longFlag = JSAP.NO_LONGFLAG;

    public Switch(String id) {
        super(id);
        this.setDefault("FALSE");
    }

    public Switch(String id, char shortFlag, String longFlag, String help) {
        this(id);
        this.setShortFlag(shortFlag);
        this.setLongFlag(longFlag);
        this.setHelp(help);
    }

    public Switch(String id, char shortFlag, String longFlag) {
        this(id, shortFlag, longFlag, JSAP.NO_HELP);
    }

    public Switch setShortFlag(char shortFlag) {
        this.enforceParameterLock();
        this.shortFlag = shortFlag;
        return this;
    }

    @Override
    public char getShortFlag() {
        return this.shortFlag;
    }

    @Override
    public Character getShortFlagCharacter() {
        return this.shortFlag == '\u0000' ? null : new Character(this.shortFlag);
    }

    public Switch setLongFlag(String longFlag) {
        this.enforceParameterLock();
        this.longFlag = longFlag;
        return this;
    }

    @Override
    public String getLongFlag() {
        return this.longFlag;
    }

    @Override
    protected List parse(String arg) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>(1);
        result.add(BooleanStringParser.getParser().parse(arg));
        return result;
    }

    @Override
    public String getSyntax() {
        StringBuffer buf = new StringBuffer();
        boolean shortFlag = false;
        buf.append("[");
        if (this.getShortFlag() != '\u0000') {
            buf.append("-" + this.getShortFlag());
            shortFlag = true;
        }
        if (this.getLongFlag() != JSAP.NO_LONGFLAG) {
            if (shortFlag) {
                buf.append("|");
            }
            buf.append("--" + this.getLongFlag());
        }
        buf.append("]");
        return buf.toString();
    }

    public Switch setDefault(String defaultValue) {
        this._setDefault(defaultValue);
        return this;
    }

    public Switch setDefault(String[] defaultValues) {
        this._setDefault(defaultValues);
        return this;
    }
}

