/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.SplitMix64RandomGenerator;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class XoRoShiRo128PlusRandomGenerator
extends AbstractRandomGenerator {
    private long s0;
    private long s1;
    private static final long[] JUMP = new long[]{-4707382666127344949L, -2852180941702784734L};

    public XoRoShiRo128PlusRandomGenerator() {
        this(Util.randomSeed());
    }

    public XoRoShiRo128PlusRandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = s0 + s1;
        this.s0 = Long.rotateLeft(s0, 55) ^ (s1 ^= s0) ^ s1 << 14;
        this.s1 = Long.rotateLeft(s1, 36);
        return result;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(this.nextLong() >>> 12 | 0x3FF0000000000000L) - 1.0;
    }

    public float nextFloat() {
        return Float.intBitsToFloat((int)(this.nextLong() >>> 41) | 0x3F800000) - 1.0f;
    }

    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    public void jump() {
        long s0 = 0L;
        long s1 = 0L;
        for (int i = 0; i < JUMP.length; ++i) {
            for (int b = 0; b < 64; ++b) {
                if ((JUMP[i] & 1L << b) != 0L) {
                    s0 ^= this.s0;
                    s1 ^= this.s1;
                }
                this.nextLong();
            }
        }
        this.s0 = s0;
        this.s1 = s1;
    }

    public XoRoShiRo128PlusRandomGenerator split() {
        XoRoShiRo128PlusRandomGenerator split = new XoRoShiRo128PlusRandomGenerator();
        split.s0 = HashCommon.murmurHash3((long)this.s0);
        split.s1 = HashCommon.murmurHash3((long)this.s1);
        return split;
    }

    public void setSeed(long seed) {
        SplitMix64RandomGenerator r = new SplitMix64RandomGenerator(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
    }

    public void setState(long[] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 2);
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }

    public static void main(String[] arg) {
        long n = Long.parseLong(arg[0]);
        long x = 0L;
        ProgressLogger pl = new ProgressLogger();
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator(0L);
        int k = 10;
        while (k-- != 0) {
            pl.start("Measuring...");
            long i = n;
            while (i-- != 0L) {
                x ^= r.nextLong();
            }
            pl.done(n);
            if (x != 0L) continue;
            System.out.println(x);
        }
    }
}

