/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import biz.source_code.base64Coder.Base64Coder;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.google.OAuthUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.StringUtils;

public class CommandListener
implements Runnable {
    public static final String OK = "OK";
    private static boolean isListening = false;
    public static int currentListenerPort = -1;
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private static final String CRLF = "\r\n";
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    public static Set<String> fileParams;
    public static Set<String> indexParams;
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONNECTION_CLOSE = "Connection: close";
    private static final String NO_CACHE = "Cache-Control: no-cache, no-store";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin: *";

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    public static boolean isListening() {
        return isListening;
    }

    @Override
    public void run() {
        block7: {
            CommandExecutor cmdExe = new CommandExecutor();
            try {
                this.serverSocket = new ServerSocket(this.port);
                log.info((Object)("Listening on port " + this.port));
                currentListenerPort = this.port;
                isListening = true;
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error in client socket loop", (Throwable)e);
                        isListening = false;
                    }
                }
            }
            catch (BindException e) {
                log.error((Object)e);
                currentListenerPort = -1;
                isListening = false;
            }
            catch (ClosedByInterruptException e) {
                log.error((Object)e);
                isListening = false;
            }
            catch (IOException e) {
                isListening = false;
                if (this.halt) break block7;
                log.error((Object)"IO Error on port socket ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                String cmd = inputLine;
                if (cmd.startsWith("GET")) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    String nextLine = in.readLine();
                    while (nextLine != null && nextLine.length() > 0) {
                        nextLine = in.readLine();
                        Object[] tokens = Globals.colonPattern.split(nextLine, 2);
                        if (tokens.length == 2) {
                            headers.put(((String)tokens[0]).trim(), ((String)tokens[1]).trim());
                        }
                        log.debug((Object)("Tokens (as in *tokenized* headers, not oauth tokens):  " + Arrays.toString(tokens)));
                    }
                    log.debug((Object)("Headers: " + headers));
                    log.debug((Object)("Command: " + cmd));
                    String command = null;
                    HashMap<String, String> params = null;
                    String[] tokens = inputLine.split(" ");
                    if (tokens.length < 2) {
                        this.sendTextResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    Object[] parts = tokens[1].split("\\?");
                    command = parts[0];
                    log.debug((Object)("Parts of the request: " + Arrays.toString(parts)));
                    Map<String, String> map = params = parts.length < 2 ? new HashMap<String, String>() : this.parseParameters((String)parts[1]);
                    if (command.equals("/oauthCallback")) {
                        log.debug((Object)("Response parameters: " + ((Object)params).toString()));
                        if (params.containsKey("code")) {
                            OAuthUtils.getInstance().setAuthorizationCode((String)params.get("code"));
                        } else if (params.containsKey("token")) {
                            OAuthUtils.getInstance().setAccessToken((String)params.get("token"));
                        }
                        this.sendTextResponse(out, OK);
                    } else {
                        String callback = (String)params.get("callback");
                        if (callback != null) {
                            this.sendJavascriptResponse(out, callback);
                        }
                        String result = this.processGet(command, params, cmdExe);
                        if (callback == null) {
                            if (result.equals(OK)) {
                                result = null;
                            }
                            this.sendTextResponse(out, result);
                        }
                    }
                    return;
                }
                Globals.setBatch(true);
                Globals.setSuppressMessages(true);
                String response = cmdExe.execute(inputLine);
                out.println(response);
                out.flush();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error processing client session", (Throwable)e);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e) {
                log.error((Object)"Error closing clientSocket", (Throwable)e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                log.error((Object)"Error closing server socket", (Throwable)e);
            }
        }
    }

    private void sendJavascriptResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "application/javascript");
    }

    private void sendTextResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "text/html");
    }

    private void sendHTTPResponse(PrintWriter out, String result, String contentType) {
        out.print(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_ORIGIN);
        out.print(CRLF);
        if (result != null) {
            out.print("Content-Type: " + contentType);
            out.print(CRLF);
            out.print("Content-Length: " + result.length());
            out.print(CRLF);
            out.print(NO_CACHE);
            out.print(CRLF);
            out.print(CONNECTION_CLOSE);
            out.print(CRLF);
            out.print(CRLF);
            out.print(result);
            out.print(CRLF);
        }
        out.close();
    }

    private String processGet(String command, Map<String, String> params, CommandExecutor cmdExe) throws IOException {
        String result = OK;
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/load")) {
            String fp;
            String file = null;
            Iterator<String> iterator = fileParams.iterator();
            while (iterator.hasNext() && (file = params.get(fp = iterator.next())) == null) {
            }
            String genome = params.get("genome");
            if (genome == null) {
                genome = params.get("db");
            }
            if (genome != null) {
                GenomeManager.getInstance().loadGenomeById(genome);
            }
            if (file != null) {
                String mergeValue = params.get("merge");
                if (mergeValue != null) {
                    mergeValue = URLDecoder.decode(mergeValue, "UTF-8");
                }
                boolean merge = mergeValue != null ? mergeValue.equalsIgnoreCase("true") : !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
                String name = params.get("name");
                String format = params.get("format");
                String locus = params.get("locus");
                String index = params.get("index");
                String coverage = params.get("coverage");
                String sort = params.get("sort");
                String sortTag = params.get("sortTag");
                result = cmdExe.loadFiles(file, index, coverage, name, format, locus, merge, params, sort, sortTag);
            } else {
                result = OK;
            }
        } else if (command.equals("/reload") || command.equals("/goto")) {
            String locus = params.get("locus");
            IGV.getInstance().goToLocus(locus);
        } else {
            if (command.equals("/execute")) {
                String param = StringUtils.decodeURL(params.get("command"));
                return cmdExe.execute(param);
            }
            return "ERROR Unknown command: " + command;
        }
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            boolean cmdExeWillDecode = (fileParams.contains(key) || indexParams.contains(key)) && CommandExecutor.needsDecode(kv[1]);
            String value = cmdExeWillDecode ? kv[1] : StringUtils.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }

    static String computeResponseKey(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = null;
        digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(input.getBytes("UTF-8"));
        return new String(Base64Coder.encode(digest.digest()));
    }

    static {
        String[] fps = new String[]{"file", "bigDataURL", "sessionURL", "dataURL"};
        fileParams = new LinkedHashSet<String>(Arrays.asList(fps));
        fileParams = Collections.unmodifiableSet(fileParams);
        indexParams = new HashSet<String>(Arrays.asList("index"));
    }
}

