/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.MergedTracks;
import org.broad.igv.track.Range;
import org.broad.igv.track.ScalableTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelLayout;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;

public class DataPanelContainer
extends TrackPanelComponent
implements Paintable {
    private static Logger log = Logger.getLogger(DataPanelContainer.class);
    TrackPanel parent;

    public DataPanelContainer(TrackPanel trackPanel) {
        super(trackPanel);
        DropTarget target = new DropTarget(this, new FileDropTargetListener(trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
        this.setLayout(new DataPanelLayout());
        this.parent = trackPanel;
        this.createDataPanels();
    }

    public void createDataPanels() {
        this.removeAll();
        for (ReferenceFrame f : FrameManager.getFrames()) {
            if (!f.isVisible()) continue;
            DataPanel dp = new DataPanel(f, this);
            this.add(dp);
        }
        this.invalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            c.setBackground(color);
        }
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    public void setCurrentTool(RegionOfInterestTool regionOfInterestTool) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            ((DataPanel)c).setCurrentTool(regionOfInterestTool);
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        Component[] components = this.getComponents();
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component1) {
                return component.getX() - component1.getX();
            }
        });
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            Graphics2D g2d = (Graphics2D)g.create();
            Rectangle clipRect = new Rectangle(c.getBounds());
            clipRect.height = rect.height;
            g2d.setClip(clipRect);
            g2d.translate(c.getX(), 0);
            ((DataPanel)c).paintOffscreen(g2d, clipRect);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.autoscale();
        super.paintChildren(g);
        if (IGV.getInstance().isRulerEnabled()) {
            int start = MouseInfo.getPointerInfo().getLocation().x - this.getLocationOnScreen().x;
            g.setColor(Color.BLACK);
            g.drawLine(start, 0, start, this.getHeight());
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            boolean allChrMode = frame.getChrName().equals("All");
            if (!FrameManager.isGeneListMode() && !allChrMode) {
                int y = MouseInfo.getPointerInfo().getLocation().y - this.getLocationOnScreen().y;
                int pos = (int)frame.getChromosomePosition(start) + 1;
                g.setFont(FontManager.getDefaultFont());
                g.drawString(Globals.DECIMAL_FORMAT.format((double)pos), start + 10, y + 30);
            }
        }
    }

    private void autoscale() {
        List<Track> trackList = IGV.getInstance().getAllTracks();
        HashMap autoscaleGroups = new HashMap();
        for (Track track : trackList) {
            if (!track.isVisible()) continue;
            String asGroup = track.getAttributeValue("AUTOSCALE GROUP");
            if (asGroup != null) {
                if (!autoscaleGroups.containsKey(asGroup)) {
                    autoscaleGroups.put(asGroup, new ArrayList());
                }
                if (track instanceof MergedTracks) {
                    for (Track track2 : ((MergedTracks)track).getMemberTracks()) {
                        ((List)autoscaleGroups.get(asGroup)).add(track);
                    }
                    continue;
                }
                ((List)autoscaleGroups.get(asGroup)).add(track);
                continue;
            }
            if (!track.getAutoScale()) continue;
            if (track instanceof MergedTracks) {
                ArrayList<Track> memberTracks = new ArrayList<Track>(((MergedTracks)track).getMemberTracks());
                this.autoscaleGroup(memberTracks);
                continue;
            }
            this.autoscaleGroup(Arrays.asList(track));
        }
        if (autoscaleGroups.size() > 0) {
            for (List tracks : autoscaleGroups.values()) {
                this.autoscaleGroup(tracks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoscaleGroup(List<Track> trackList) {
        List<ReferenceFrame> frames = FrameManager.isGeneListMode() ? FrameManager.getFrames() : Arrays.asList(FrameManager.getDefaultFrame());
        ArrayList<Range> inViewRanges = new ArrayList<Range>();
        List<Track> list = trackList;
        synchronized (list) {
            for (Track track : trackList) {
                if (!(track instanceof ScalableTrack)) continue;
                for (ReferenceFrame frame : frames) {
                    Range range = ((ScalableTrack)((Object)track)).getInViewRange(frame);
                    if (range == null) continue;
                    inViewRanges.add(range);
                }
            }
            if (inViewRanges.size() > 0) {
                Range inter = DataPanelContainer.computeScale(inViewRanges);
                for (Track track : trackList) {
                    DataRange dr = track.getDataRange();
                    float min = Math.min(0.0f, inter.min);
                    float base = Math.max(min, dr.getBaseline());
                    float max = inter.max;
                    if (max - min <= 2.8E-45f) {
                        max = min + 1.0f;
                    }
                    DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                    newDR.setType(dr.getType());
                    track.setDataRange(newDR);
                }
            }
        }
    }

    public static Range computeScale(List<Range> ranges) {
        float min = 0.0f;
        float max = 0.0f;
        if (ranges.size() > 0) {
            max = ranges.get((int)0).max;
            min = ranges.get((int)0).min;
            for (int i = 1; i < ranges.size(); ++i) {
                Range r = ranges.get(i);
                max = Math.max(r.max, max);
                min = Math.min(r.min, min);
            }
        }
        return new Range(min, max);
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(TrackPanel dataPanel) {
            this.panel = dataPanel;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            block11: {
                if (!this.isDropAcceptable(event)) {
                    event.rejectDrop();
                    return;
                }
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                MessageCollection messages = new MessageCollection();
                try {
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : files) {
                        try {
                            ResourceLocator locator = new ResourceLocator(file.getAbsolutePath());
                            IGV.getInstance().load(locator, this.panel);
                        }
                        catch (DataLoadException de) {
                            messages.append(de.getMessage());
                        }
                    }
                    String obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                    if (HttpUtils.isRemoteURL(obj)) {
                        IGV.getInstance().load(new ResourceLocator(obj), this.panel);
                    }
                    if (messages != null && !messages.isEmpty()) {
                        log.error((Object)messages.getFormattedMessage());
                        MessageUtils.showMessage(messages.getFormattedMessage());
                    }
                }
                catch (Exception e) {
                    String obj = null;
                    try {
                        obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        if (HttpUtils.isRemoteURL(obj)) {
                            IGV.getInstance().load(new ResourceLocator(obj), this.panel);
                        }
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                        if (messages == null || messages.isEmpty()) break block11;
                        MessageUtils.showMessage(messages.getFormattedMessage());
                    }
                }
            }
            IGV.getMainFrame().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

