/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.RendererFactory;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.Range;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.ScalableTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DataTrack
extends AbstractTrack
implements ScalableTrack,
IGVEventObserver {
    private static Logger log = Logger.getLogger(DataTrack.class);
    private DataRenderer renderer;
    private Map<String, LoadedDataInterval<List<LocusScore>>> loadedIntervalCache = new HashMap<String, LoadedDataInterval<List<LocusScore>>>(200);

    public DataTrack(ResourceLocator locator, String id, String name) {
        super(id, name, locator);
        this.autoScale = PreferencesManager.getPreferences().getAsBoolean("CHART.AUTOSCALE");
        this.loadedIntervalCache = Collections.synchronizedMap(new HashMap());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            List<ReferenceFrame> frames = ((FrameManager.ChangeEvent)event).getFrames();
            Map<String, LoadedDataInterval<List<LocusScore>>> newCache = Collections.synchronizedMap(new HashMap());
            for (ReferenceFrame f : frames) {
                newCache.put(f.getName(), this.loadedIntervalCache.get(f.getName()));
            }
            this.loadedIntervalCache = newCache;
        } else {
            log.info((Object)("Unknown event type: " + event.getClass()));
        }
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int zoom = frame.getZoom();
        LoadedDataInterval<List<LocusScore>> interval = this.loadedIntervalCache.get(frame.getName());
        return interval != null && interval.contains(chr, start, end, zoom);
    }

    @Override
    public synchronized void load(ReferenceFrame referenceFrame) {
        if (this.isReadyToPaint(referenceFrame)) {
            return;
        }
        String chr = referenceFrame.getChrName();
        int start = (int)referenceFrame.getOrigin();
        int end = (int)referenceFrame.getEnd() + 1;
        int zoom = referenceFrame.getZoom();
        int maxEnd = end;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        String queryChr = chr;
        if (genome != null) {
            queryChr = genome.getCanonicalChrName(chr);
            Chromosome c = genome.getChromosome(chr);
            if (c != null) {
                maxEnd = Math.max(c.getLength(), end);
            }
        }
        boolean multiLocus = FrameManager.getFrames().size() > 4;
        int delta = multiLocus ? 1 : (end - start) / 2;
        int expandedStart = Math.max(0, start - delta);
        int expandedEnd = Math.min(maxEnd, end + delta);
        LoadedDataInterval<List<LocusScore>> interval = this.getSummaryScores(queryChr, expandedStart, expandedEnd, zoom);
        this.loadedIntervalCache.put(referenceFrame.getName(), interval);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        List<LocusScore> inViewScores = this.getInViewScores(context.getReferenceFrame());
        if ((inViewScores == null || inViewScores.size() == 0) && "All".equals(context.getChr())) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Data not available for whole genome view; zoom in to see data", rect, g);
        } else {
            this.getRenderer().render(inViewScores, context, rect, (Track)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        List<LocusScore> inViewScores = this.getInViewScores(context.getReferenceFrame());
        if ((inViewScores == null || inViewScores.size() == 0) && "All".equals(context.getChr())) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Data not available for whole genome view; select chromosome to see data", rect, g);
        } else if (inViewScores != null) {
            List<LocusScore> list = inViewScores;
            synchronized (list) {
                this.getRenderer().renderScores(this, inViewScores, context, rect);
            }
        }
        this.getRenderer().renderBorder(this, context, rect);
    }

    public List<LocusScore> getInViewScores(ReferenceFrame referenceFrame) {
        LoadedDataInterval<List<LocusScore>> interval = this.loadedIntervalCache.get(referenceFrame.getName());
        String chr = referenceFrame.getChrName();
        int start = (int)referenceFrame.getOrigin();
        int end = (int)referenceFrame.getEnd() + 1;
        int zoom = referenceFrame.getZoom();
        if (interval == null || !chr.equals(interval.range.chr)) {
            return Collections.EMPTY_LIST;
        }
        List<LocusScore> inViewScores = interval.getFeatures();
        int startIdx = Math.max(0, FeatureUtils.getIndexBefore(start, inViewScores));
        int endIdx = inViewScores.size();
        int tmp = FeatureUtils.getIndexBefore(end, inViewScores);
        if (tmp < 0) {
            return Collections.EMPTY_LIST;
        }
        for (int i = tmp; i < inViewScores.size(); ++i) {
            if (inViewScores.get(i).getStart() <= end) continue;
            endIdx = i + 1;
            break;
        }
        endIdx = Math.max(startIdx + 1, endIdx);
        return startIdx == 0 && endIdx == inViewScores.size() ? inViewScores : inViewScores.subList(startIdx, endIdx);
    }

    @Override
    public Range getInViewRange(ReferenceFrame referenceFrame) {
        List<LocusScore> scores = this.getInViewScores(referenceFrame);
        if (scores.size() > 0) {
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (LocusScore score : scores) {
                float value = score.getScore();
                if (Float.isNaN(value)) continue;
                min = Math.min(value, min);
                max = Math.max(value, max);
            }
            return new Range(min, max);
        }
        return null;
    }

    public void clearCaches() {
        this.loadedIntervalCache.clear();
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (DataRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error((Object)"Error instantiating renderer ", (Throwable)ex);
        }
    }

    @Override
    protected void setRenderer(Renderer renderer) {
        this.renderer = (DataRenderer)renderer;
    }

    @Override
    public DataRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(this.getDefaultRendererClass());
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        StringBuffer buf = new StringBuffer();
        LocusScore score = this.getLocusScoreAt(chr, position, frame);
        if (score == null) {
            return null;
        }
        buf.append(this.getName() + "<br>");
        if (this.getDataRange() != null && this.getRenderer() instanceof XYPlotRenderer) {
            buf.append("Data scale: " + this.getDataRange().getMinimum() + " - " + this.getDataRange().getMaximum() + "<br>");
        }
        buf.append(score.getValueString(position, mouseX, this.getWindowFunction()));
        return buf.toString();
    }

    private LocusScore getLocusScoreAt(String chr, double position, ReferenceFrame frame) {
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.getSummaryScores(chr, (int)position - 10, (int)position + 10, zoom).getFeatures();
        if (scores == null) {
            return null;
        }
        double bpPerPixel = frame.getScale();
        int buffer = (int)(2.0 * bpPerPixel);
        return FeatureUtils.getFeatureAt(position, buffer, scores);
    }

    public abstract LoadedDataInterval<List<LocusScore>> getSummaryScores(String var1, int var2, int var3, int var4);

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName, List<Track> tracks) {
        if (end <= start) {
            return 0.0f;
        }
        if (this.isRegionScoreType(type)) {
            LoadedDataInterval<List<LocusScore>> loadedInterval;
            List<LocusScore> scores = null;
            if (frameName == null) {
                frameName = chr + start + end;
                frameName = (String)frameName + zoom;
                frameName = (String)frameName + type;
            }
            if ((loadedInterval = this.loadedIntervalCache.get(frameName)) != null && loadedInterval.contains(chr, start, end, zoom)) {
                scores = loadedInterval.getFeatures();
            } else {
                scores = this.getSummaryScores(chr, start, end, zoom).getFeatures();
                this.loadedIntervalCache.put((String)frameName, new LoadedDataInterval<List<LocusScore>>(chr, start, end, zoom, scores));
            }
            if (type == RegionScoreType.FLUX) {
                float sumDiffs = 0.0f;
                float lastScore = Float.NaN;
                for (LocusScore score : scores) {
                    if (score.getEnd() < start || score.getStart() > end) continue;
                    if (Float.isNaN(lastScore)) {
                        lastScore = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                        continue;
                    }
                    float s = Math.min(2.0f, Math.max(-2.0f, this.logScaleData(score.getScore())));
                    sumDiffs += Math.abs(s - lastScore);
                    lastScore = s;
                }
                return sumDiffs;
            }
            if (type == RegionScoreType.MUTATION_COUNT) {
                if (!Globals.isHeadless() && tracks == null) {
                    tracks = IGV.getInstance().getOverlayTracks(this);
                }
                float count = 0.0f;
                String tSamp = this.getSample();
                if (tracks != null && tSamp != null) {
                    for (Track t : tracks) {
                        if (t.getTrackType() != TrackType.MUTATION || !tSamp.equals(t.getSample())) continue;
                        count += t.getRegionScore(chr, start, end, zoom, type, (String)frameName);
                    }
                }
                return count;
            }
            float regionScore = 0.0f;
            int intervalSum = 0;
            boolean hasNan = false;
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                if (Float.isNaN(value)) {
                    hasNan = true;
                    continue;
                }
                regionScore += value * (float)interval;
                intervalSum += interval;
            }
            if (intervalSum <= 0) {
                if (hasNan) {
                    return Float.NaN;
                }
                return -3.4028235E38f;
            }
            return type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum);
        }
        return -3.4028235E38f;
    }

    public double getAverageScore(String chr, int start, int end, int zoom) {
        double regionScore = 0.0;
        int intervalSum = 0;
        Collection scores = this.getSummaryScores(chr, start, end, zoom).getFeatures();
        for (LocusScore score : scores) {
            if (score.getEnd() < start || score.getStart() > end) continue;
            int interval = 1;
            float value = score.getScore();
            regionScore += (double)(value * (float)interval);
            intervalSum += interval;
        }
        if (intervalSum > 0) {
            regionScore /= (double)intervalSum;
        }
        return regionScore;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        RendererFactory.RendererType type;
        super.marshalXML(document, element);
        if (this.renderer != null && (type = RendererFactory.getRenderType(this.renderer)) != null) {
            element.setAttribute("renderer", type.name());
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        Class rendererClass;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("renderer") && (rendererClass = RendererFactory.getRendererClass(element.getAttribute("renderer"))) != null) {
            try {
                this.renderer = (DataRenderer)rendererClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Error instantiating renderer: " + rendererClass.getName()), (Throwable)e);
            }
        }
    }
}

