/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.algorithmic.indels;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.lang.MutableString;
import java.util.Set;
import org.campagnelab.goby.alignments.Alignments;

public class EquivalentIndelRegion {
    public int referenceIndex;
    public int startPosition;
    public int endPosition;
    public String from;
    public String to;
    public String flankLeft;
    public String flankRight;
    public Set<Alignments.AlignmentEntry> supportingEntries = new ObjectArraySet();
    private int forwardFrequency = 0;
    private int reverseFrequency = 0;
    public int sampleIndex;
    private boolean matchesReference;
    private boolean matchesRefCached;
    public IntArraySet forwardReadIndices = new IntArraySet();
    public IntArraySet reverseReadIndices = new IntArraySet();
    public Set<byte[]> forwardQualityScores = new ObjectArraySet();
    public Set<byte[]> reverseQualityScores = new ObjectArraySet();
    private boolean filtered;

    public String fromInContext() {
        MutableString fromC = new MutableString();
        fromC.append(this.flankLeft);
        fromC.append(this.from);
        fromC.append(this.flankRight);
        return fromC.toString();
    }

    public String toInContext() {
        MutableString toC = new MutableString();
        toC.append(this.flankLeft);
        toC.append(this.to);
        toC.append(this.flankRight);
        return toC.toString();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof EquivalentIndelRegion)) {
            return false;
        }
        EquivalentIndelRegion other = (EquivalentIndelRegion)o;
        return this.startPosition == other.startPosition && this.endPosition == other.endPosition && this.referenceIndex == other.referenceIndex && this.sampleIndex == other.sampleIndex && this.from.equals(other.from) && this.to.equals(other.to);
    }

    public final int hashCode() {
        return (this.sampleIndex * 31 + (this.referenceIndex * 31 + this.endPosition)) * 31 + this.startPosition;
    }

    public String toString() {
        return String.format("indel count=%d,%d %s %s/%s %s %d-%d filtered=%b", this.getForwardFrequency(), this.getReverseFrequency(), this.flankLeft, this.from, this.to, this.flankRight, this.startPosition, this.endPosition, this.filtered);
    }

    public EquivalentIndelRegion copy() {
        EquivalentIndelRegion result = new EquivalentIndelRegion();
        result.from = this.from;
        result.to = this.to;
        result.flankLeft = this.flankLeft;
        result.flankRight = this.flankRight;
        result.referenceIndex = this.referenceIndex;
        result.startPosition = this.startPosition;
        result.endPosition = this.endPosition;
        result.sampleIndex = this.sampleIndex;
        result.supportingEntries.addAll(this.supportingEntries);
        result.forwardFrequency = this.forwardFrequency;
        result.reverseFrequency = this.reverseFrequency;
        return result;
    }

    public boolean matchesReference() {
        if (!this.matchesRefCached) {
            this.matchesReference = this.from.equals(this.to);
            this.matchesRefCached = true;
        }
        return this.matchesReference;
    }

    public void markFiltered() {
        this.filtered = true;
    }

    public void removeFiltered() {
        this.filtered = false;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void incrementForwardFrequency() {
        ++this.forwardFrequency;
    }

    public void incrementReverseFrequency() {
        ++this.reverseFrequency;
    }

    public void setForwardFrequency(int frequency) {
        this.forwardFrequency = frequency;
    }

    public void setReverseFrequency(int frequency) {
        this.reverseFrequency = frequency;
    }

    public int getReverseFrequency() {
        return this.filtered ? 0 : this.reverseFrequency;
    }

    public int getForwardFrequency() {
        return this.filtered ? 0 : this.forwardFrequency;
    }

    public int getFrequency() {
        return this.getForwardFrequency() + this.getReverseFrequency();
    }

    public void mergeInto(EquivalentIndelRegion candidateIndel, Alignments.AlignmentEntry alignmentEntry) {
        if (alignmentEntry.getMatchingReverseStrand()) {
            this.incrementReverseFrequency();
        } else {
            this.incrementForwardFrequency();
        }
        this.supportingEntries.addAll(candidateIndel.supportingEntries);
        this.supportingEntries.add(alignmentEntry);
        this.forwardReadIndices.addAll((IntCollection)candidateIndel.forwardReadIndices);
        this.reverseReadIndices.addAll((IntCollection)candidateIndel.reverseReadIndices);
        this.forwardQualityScores.addAll(candidateIndel.forwardQualityScores);
        this.reverseQualityScores.addAll(candidateIndel.reverseQualityScores);
    }
}

