/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class CramIO {
    @Deprecated
    public static final String CRAM_FILE_EXTENSION = ".cram";
    public static final byte[] ZERO_B_EOF_MARKER = CramIO.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");
    public static final byte[] ZERO_F_EOF_MARKER = CramIO.bytesFromHex("0f 00 00 00 ff ff ff ff 0f e0 45 4f 46 00 00 00 00 01 00 05 bd d9 4f 00 01 00 06 06 01 00 01 00 01 00 ee 63 01 4b");
    private static final int DEFINITION_LENGTH = 26;
    private static final Log log = Log.getInstance(CramIO.class);

    private static byte[] bytesFromHex(String string) {
        String clean = string.replaceAll("[^0-9a-fA-F]", "");
        if (clean.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + string);
        }
        byte[] data = new byte[clean.length() / 2];
        for (int i = 0; i < clean.length(); i += 2) {
            data[i / 2] = Integer.decode("0x" + clean.charAt(i) + clean.charAt(i + 1)).byteValue();
        }
        return data;
    }

    public static long issueEOF(Version version, OutputStream outputStream) {
        try {
            if (version.compatibleWith(CramVersions.CRAM_v3)) {
                outputStream.write(ZERO_F_EOF_MARKER);
                return ZERO_F_EOF_MARKER.length;
            }
            if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
                outputStream.write(ZERO_B_EOF_MARKER);
                return ZERO_B_EOF_MARKER.length;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return 0L;
    }

    public static long writeHeader(Version cramVersion, OutputStream outStream, SAMFileHeader samFileHeader, String cramID) {
        CramHeader cramHeader = new CramHeader(cramVersion, cramID, samFileHeader);
        return CramIO.writeCramHeader(cramHeader, outStream);
    }

    private static boolean streamEndsWith(SeekableStream seekableStream, byte[] marker) throws IOException {
        byte[] tail = new byte[marker.length];
        seekableStream.seek(seekableStream.length() - (long)marker.length);
        InputStreamUtils.readFully(seekableStream, tail, 0, tail.length);
        if (Arrays.equals(tail, marker)) {
            return true;
        }
        tail[8] = marker[8];
        return Arrays.equals(tail, marker);
    }

    private static boolean checkEOF(Version version, SeekableStream seekableStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_F_EOF_MARKER);
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_B_EOF_MARKER);
        }
        return false;
    }

    public static boolean checkHeaderAndEOF(File file) {
        boolean bl;
        SeekableFileStream seekableStream = new SeekableFileStream(file);
        try {
            CramHeader cramHeader = CramIO.readCramHeader(seekableStream);
            bl = CramIO.checkEOF(cramHeader.getVersion(), seekableStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((SeekableStream)seekableStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        ((SeekableStream)seekableStream).close();
        return bl;
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) {
        try {
            outputStream.write("CRAM".getBytes("US-ASCII"));
            outputStream.write(cramHeader.getVersion().major);
            outputStream.write(cramHeader.getVersion().minor);
            outputStream.write(cramHeader.getId());
            for (int i = cramHeader.getId().length; i < 20; ++i) {
                outputStream.write(0);
            }
            long length = CramIO.writeContainerForSamFileHeader(cramHeader.getVersion().major, cramHeader.getSamFileHeader(), outputStream);
            return 26L + length;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static CramHeader readFormatDefinition(InputStream inputStream) throws IOException {
        for (byte magicByte : CramHeader.MAGIC) {
            if (magicByte == inputStream.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        Version version = new Version(inputStream.read(), inputStream.read(), 0);
        CramHeader header = new CramHeader(version, null, null);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(header.getId());
        return header;
    }

    public static CramHeader readCramHeader(InputStream inputStream) {
        try {
            CramHeader header = CramIO.readFormatDefinition(inputStream);
            long containerByteOffset = 26L;
            SAMFileHeader samFileHeader = CramIO.readSAMFileHeader(header.getVersion(), inputStream, new String(header.getId()), 26L);
            return new CramHeader(header.getVersion(), new String(header.getId()), samFileHeader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static byte[] toByteArray(SAMFileHeader samFileHeader) {
        ByteArrayOutputStream headerBodyOS = new ByteArrayOutputStream();
        OutputStreamWriter outStreamWriter = new OutputStreamWriter(headerBodyOS);
        new SAMTextHeaderCodec().encode(outStreamWriter, samFileHeader);
        try {
            outStreamWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(headerBodyOS.size());
        buf.flip();
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        ByteArrayOutputStream headerOS = new ByteArrayOutputStream();
        try {
            headerOS.write(bytes);
            headerOS.write(headerBodyOS.toByteArray(), 0, headerBodyOS.size());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return headerOS.toByteArray();
    }

    private static long writeContainerForSamFileHeader(int major, SAMFileHeader samFileHeader, OutputStream os) {
        byte[] data = CramIO.toByteArray(samFileHeader);
        int length = Math.max(1024, data.length + data.length / 2);
        byte[] blockContent = new byte[length];
        System.arraycopy(data, 0, blockContent, 0, Math.min(data.length, length));
        Block block = Block.createRawFileHeaderBlock(blockContent);
        Container container = new Container(new ReferenceContext(0));
        container.blockCount = 1;
        container.blocks = new Block[]{block};
        container.landmarks = new int[0];
        container.bases = 0L;
        container.globalRecordCounter = 0L;
        container.nofRecords = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block.write(major, byteArrayOutputStream);
        container.containerBlocksByteSize = byteArrayOutputStream.size();
        int containerHeaderByteSize = ContainerHeaderIO.writeContainerHeader(major, container, os);
        try {
            os.write(byteArrayOutputStream.toByteArray(), 0, container.containerBlocksByteSize);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return containerHeaderByteSize + container.containerBlocksByteSize;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static SAMFileHeader readSAMFileHeader(Version version, InputStream inputStream, String id, long containerByteOffset) {
        Block block;
        byte[] bytes;
        Container container = ContainerHeaderIO.readContainerHeader(version.major, inputStream, containerByteOffset);
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            bytes = new byte[container.containerBlocksByteSize];
            InputStreamUtils.readFully(inputStream, bytes, 0, bytes.length);
            block = Block.read(version.major, new ByteArrayInputStream(bytes));
        } else {
            block = Block.read(version.major, inputStream);
        }
        try (ByteArrayInputStream blockStream = new ByteArrayInputStream(block.getUncompressedContent());){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < 4; ++i) {
                buffer.put((byte)((InputStream)blockStream).read());
            }
            buffer.flip();
            int size = buffer.asIntBuffer().get();
            DataInputStream dataInputStream = new DataInputStream(blockStream);
            bytes = new byte[size];
            dataInputStream.readFully(bytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);){
            BufferedLineReader lineReader = new BufferedLineReader(byteStream);
            try {
                SAMFileHeader sAMFileHeader = codec.decode(lineReader, id);
                lineReader.close();
                return sAMFileHeader;
            }
            catch (Throwable throwable) {
                try {
                    lineReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean replaceCramHeader(File file, CramHeader newHeader) {
        try (CountingInputStream countingInputStream = new CountingInputStream(new FileInputStream(file));){
            ByteArrayOutputStream byteArrayOutputStream;
            long pos;
            RandomAccessFile randomAccessFile;
            block14: {
                boolean bl;
                randomAccessFile = new RandomAccessFile(file, "rw");
                try {
                    CramHeader cramHeader = CramIO.readFormatDefinition(countingInputStream);
                    Container c = ContainerHeaderIO.readContainerHeader(cramHeader.getVersion().major, countingInputStream);
                    pos = countingInputStream.getCount();
                    countingInputStream.close();
                    Block block = Block.createRawFileHeaderBlock(CramIO.toByteArray(newHeader.getSamFileHeader()));
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    block.write(newHeader.getVersion().major, byteArrayOutputStream);
                    if (byteArrayOutputStream.size() <= c.containerBlocksByteSize) break block14;
                    log.error("Failed to replace CRAM header because the new header does not fit.");
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                randomAccessFile.close();
                return bl;
            }
            randomAccessFile.seek(pos);
            randomAccessFile.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            randomAccessFile.close();
            boolean bl = true;
            randomAccessFile.close();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

