/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.maf.AbstractMultipleAlignmentDialog;
import org.broad.igv.maf.MAFListReader;
import org.broad.igv.maf.MAFParser;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFRenderer;
import org.broad.igv.maf.MultipleAlignmentBlock;
import org.broad.igv.maf.Multiz44ConfigurationDialog;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class MultipleAlignmentTrack
extends AbstractTrack {
    public static final int margin = 5;
    private static Logger log = Logger.getLogger(MultipleAlignmentTrack.class);
    private static int EXPANDED_HEIGHT = 14;
    private static int GAPS_HEIGHT = 25;
    Genome genome;
    private String refId;
    private List<String> selectedSpecies;
    MAFRenderer renderer = new MAFRenderer();
    Rectangle visibleNameRect;
    private int tileSize = 500;
    MAFReader reader;
    MAFCache loadedAlignments;
    private HashMap<String, String> chrMappings;

    public MultipleAlignmentTrack() {
    }

    public MultipleAlignmentTrack(ResourceLocator locator, Genome genome) throws IOException {
        super(locator);
        this.genome = genome;
        if (locator.getPath().endsWith(".maf.dict")) {
            this.reader = new MAFListReader(locator.getPath());
        } else {
            MAFParser parser = new MAFParser(locator.getPath());
            String trackName = parser.getTrackName();
            if (trackName != null) {
                this.setName(trackName);
            }
            this.reader = parser;
        }
        this.refId = this.reader.getRefId();
        Collection<String> mafChrNames = this.getChrNames();
        if (mafChrNames != null) {
            this.chrMappings = new HashMap();
            for (String mafChr : mafChrNames) {
                String chr = genome.getCanonicalChrName(mafChr);
                this.chrMappings.put(chr, mafChr);
            }
        }
        this.selectedSpecies = new ArrayList<String>();
        this.selectedSpecies.addAll(this.reader.getSpecies());
    }

    public List<String> getSelectedSpecies() {
        return this.selectedSpecies;
    }

    public void setSelectedSpecies(List<String> selectedSpecies) {
        this.selectedSpecies = selectedSpecies;
    }

    public String getSpeciesName(String speciesId) {
        String name = this.reader.getSpeciesName(speciesId);
        return name == null ? speciesId : name;
    }

    @Override
    public int getHeight() {
        return GAPS_HEIGHT + (this.getSelectedSpecies().size() + 1) * EXPANDED_HEIGHT;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        this.visibleNameRect = trackRectangle;
        if (this.isSelected()) {
            g2D.setBackground(Color.LIGHT_GRAY);
        } else {
            g2D.setBackground(Color.WHITE);
        }
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.clearRect(rect.x, rect.y, rect.width, rect.height);
        Font font = FontManager.getFont(this.fontSize);
        g2D.setFont(font);
        int y = trackRectangle.y;
        rect.height = GAPS_HEIGHT;
        rect.y = y;
        GraphicUtils.drawVerticallyCenteredText("Gaps", 5, rect, g2D, true);
        rect.y += rect.height;
        rect.height = EXPANDED_HEIGHT;
        for (String sp : this.getSelectedSpecies()) {
            String name = this.getSpeciesName(sp);
            if (name == null) {
                name = sp;
            }
            if (visibleRectangle.intersects(rect)) {
                GraphicUtils.drawVerticallyCenteredText(name, 5, rect, g2D, true);
            }
            rect.y += rect.height;
        }
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (frame.getScale() > 1.0) {
            return true;
        }
        String chr = frame.getChrName();
        int start = Math.max(0, (int)frame.getOrigin());
        int end = (int)frame.getEnd();
        return this.loadedAlignments != null && this.loadedAlignments.contains(chr, start, end);
    }

    @Override
    public void load(ReferenceFrame frame) {
        String chr = frame.getChrName();
        double origin = frame.getOrigin();
        double w = frame.getEnd() - origin;
        String mafChr = this.chrMappings != null && this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        int start = (int)Math.max(0.0, origin - w);
        int end = (int)(origin + 2.0 * w);
        List<MultipleAlignmentBlock> alignments = null;
        try {
            alignments = this.reader.loadAlignments(mafChr, start, end);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        this.loadedAlignments = new MAFCache(chr, start, end, alignments);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        double locScale = context.getScale();
        if (locScale > 10.0) {
            Rectangle r = new Rectangle(rect);
            if (this.visibleNameRect != null) {
                r.y = this.visibleNameRect.y;
                r.height = this.visibleNameRect.height;
            }
            Graphics2D g = context.getGraphic2DForColor(Color.black);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", r, g);
            return;
        }
        ReferenceFrame frame = context.getReferenceFrame();
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        List<MultipleAlignmentBlock> alignments = null;
        if (this.loadedAlignments != null && this.loadedAlignments.overlaps(chr, start, end) && (alignments = this.loadedAlignments.getAlignments()) != null) {
            for (MultipleAlignmentBlock ma : alignments) {
                this.renderAlignment(context, rect, ma);
            }
        }
    }

    private void renderAlignment(RenderContext context, Rectangle trackRectangle, MultipleAlignmentBlock ma) {
        int y = trackRectangle.y;
        MultipleAlignmentBlock.Sequence reference = ma.getRefSequence();
        if (reference == null) {
            return;
        }
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = GAPS_HEIGHT;
        rect.y = y;
        this.renderer.renderGaps(ma.getGaps(), context, rect);
        rect.y += rect.height;
        rect.height = EXPANDED_HEIGHT;
        for (String sp : this.getSelectedSpecies()) {
            MultipleAlignmentBlock.Sequence seq = ma.getSequence(sp);
            if (seq != null) {
                this.renderer.renderSequence(ma, seq, reference, ma.getGaps(), context, rect, this);
            }
            rect.y += rect.height;
        }
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        return "Multiple alignments";
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        if (this.getId().endsWith("hg18.maf.dict") || this.getId().endsWith("hg19.maf.dict")) {
            menu.addSeparator();
            JMenuItem configTrack = new JMenuItem("Configure track...");
            configTrack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultipleAlignmentTrack.this.configureTrack();
                }
            });
            menu.add(configTrack);
            menu.addSeparator();
        }
        List<Track> selfAsList = Arrays.asList(this);
        return menu;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        if (e.isPopupTrigger()) {
            this.configureTrack();
        } else if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
        }
        return true;
    }

    private void configureTrack() {
        Multiz44ConfigurationDialog dialog = this.getId().endsWith("hg18.maf.dict") || this.getId().endsWith("hg19.maf.dict") ? new Multiz44ConfigurationDialog(IGV.getMainFrame(), true, this) : null;
        dialog.setLocationRelativeTo(IGV.getMainFrame());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        dialog.setVisible(true);
        if (!((AbstractMultipleAlignmentDialog)dialog).isCancelled()) {
            List<String> selectedSpecies = ((AbstractMultipleAlignmentDialog)dialog).getSelectedSpecies();
            this.setSelectedSpecies(selectedSpecies);
            IGV.getInstance().repaint();
        }
    }

    public Collection<String> getChrNames() {
        return this.reader.getChrNames();
    }

    static String getKey(String chr, int tileNo) {
        return chr + tileNo;
    }

    static class MAFCache {
        String chr;
        int start;
        int end;
        List<MultipleAlignmentBlock> alignments;

        MAFCache(String chr, int start, int end, List<MultipleAlignmentBlock> alignments) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.alignments = alignments;
        }

        boolean contains(String chr, int start, int end) {
            return this.start <= start && this.end >= end && this.chr.equals(chr);
        }

        boolean overlaps(String chr, int start, int end) {
            return this.start <= end && this.end >= start && this.chr.equals(chr);
        }

        public List<MultipleAlignmentBlock> getAlignments() {
            return this.alignments;
        }
    }
}

