/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import cern.jet.random.engine.RandomEngine;
import java.util.Random;
import org.apache.commons.math3.random.AbstractRandomGenerator;

public class RandomAdapter
extends Random {
    private static final long serialVersionUID = 680027482734212120L;
    private final RandomEngine engine;
    private final AbstractRandomGenerator randomGenerator;

    @Override
    public double nextGaussian() {
        return this.randomGenerator.nextGaussian();
    }

    public RandomAdapter(final RandomEngine engine) {
        this.engine = engine;
        this.randomGenerator = new AbstractRandomGenerator(){

            public void setSeed(long l) {
            }

            public double nextDouble() {
                return engine.nextDouble();
            }
        };
    }

    @Override
    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextInt(int n) {
        return this.choose(0, n - 1);
    }

    @Override
    public boolean nextBoolean() {
        return this.choose(0, 1) == 0;
    }

    @Override
    public long nextLong() {
        return this.engine.nextLong();
    }

    @Override
    public int nextInt() {
        return this.engine.nextInt();
    }

    @Override
    public float nextFloat() {
        return this.engine.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.engine.nextDouble();
    }

    public int choose(int hi) {
        return this.choose(1, hi);
    }

    public int choose(int lo, int hi) {
        return (int)((long)lo + (long)((double)(1L + (long)hi - (long)lo) * this.engine.raw()));
    }
}

