/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.aws.IGVS3Object;
import org.broad.igv.google.OAuthProvider;
import org.broad.igv.google.OAuthUtils;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.util.AmazonS3URI;
import org.broad.igv.util.JWTParser;
import org.broad.igv.util.S3Presigner;
import org.broad.igv.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class AmazonUtils {
    private static Logger log = Logger.getLogger(AmazonUtils.class);
    private static S3Client s3Client;
    private static List<String> bucketsFinalList;
    private static CognitoIdentityClient cognitoIdentityClient;
    private static Region AWSREGION;
    private static Map<String, String> locatorTos3PresignedMap;
    private static JsonObject CognitoConfig;

    public static void setCognitoConfig(JsonObject json) {
        CognitoConfig = json;
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().updateAWSMenu();
        }
    }

    public static JsonObject GetCognitoConfig() {
        return CognitoConfig;
    }

    public static boolean isAWSProviderPresent() {
        boolean OauthAWSConfigured;
        try {
            if (AmazonUtils.GetCognitoConfig().get("auth_provider").getAsString().contains("Amazon")) {
                log.info((Object)"AWS configuration found. AWS support enabled under 'Amazon' menu");
                OauthAWSConfigured = true;
            } else {
                log.info((Object)"AWS configuration not found.");
                OauthAWSConfigured = false;
            }
        }
        catch (NullPointerException np) {
            OauthAWSConfigured = false;
        }
        return OauthAWSConfigured;
    }

    private static Region getAWSREGION() {
        if (AWSREGION == null) {
            AWSREGION = Region.of((String)AmazonUtils.GetCognitoConfig().get("aws_region").getAsString());
        }
        return AWSREGION;
    }

    public static Credentials GetCognitoAWSCredentials() {
        OAuthProvider provider = OAuthUtils.getInstance().getProvider("Amazon");
        JsonObject igv_oauth_conf = AmazonUtils.GetCognitoConfig();
        JsonObject response = provider.getResponse();
        JsonObject payload = JWTParser.getPayload(response.get("id_token").getAsString());
        log.debug((Object)("JWT payload id token: " + payload));
        String idTokenStr = response.get("id_token").getAsString();
        String idProvider = payload.get("iss").toString().replace("https://", "").replace("\"", "");
        String email = payload.get("email").getAsString();
        String federatedPoolId = igv_oauth_conf.get("aws_cognito_fed_pool_id").getAsString();
        String cognitoRoleARN = igv_oauth_conf.get("aws_cognito_role_arn").getAsString();
        HashMap<String, String> logins = new HashMap<String, String>();
        logins.put(idProvider, idTokenStr);
        AnonymousCredentialsProvider anoCredProv = AnonymousCredentialsProvider.create();
        CognitoIdentityClientBuilder cognitoIdentityBuilder = CognitoIdentityClient.builder();
        ((CognitoIdentityClientBuilder)cognitoIdentityBuilder.region(AmazonUtils.getAWSREGION())).credentialsProvider((AwsCredentialsProvider)anoCredProv);
        cognitoIdentityClient = (CognitoIdentityClient)cognitoIdentityBuilder.build();
        GetIdRequest.Builder idrequest = GetIdRequest.builder().identityPoolId(federatedPoolId).logins(logins);
        GetIdResponse idResult = cognitoIdentityClient.getId((GetIdRequest)idrequest.build());
        GetOpenIdTokenRequest.Builder openidrequest = GetOpenIdTokenRequest.builder().logins(logins).identityId(idResult.identityId());
        GetOpenIdTokenResponse openId = cognitoIdentityClient.getOpenIdToken((GetOpenIdTokenRequest)openidrequest.build());
        AssumeRoleWithWebIdentityRequest.Builder webidrequest = AssumeRoleWithWebIdentityRequest.builder().webIdentityToken(openId.token()).roleSessionName(email).roleArn(cognitoRoleARN);
        AssumeRoleWithWebIdentityResponse stsClientResponse = ((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)anoCredProv)).region(AmazonUtils.getAWSREGION())).build()).assumeRoleWithWebIdentity((AssumeRoleWithWebIdentityRequest)webidrequest.build());
        return stsClientResponse.credentials();
    }

    public static void updateS3Client(Credentials credentials) {
        AwsSessionCredentials creds = AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
        StaticCredentialsProvider s3CredsProvider = StaticCredentialsProvider.create((AwsCredentials)creds);
        s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)s3CredsProvider)).region(AmazonUtils.getAWSREGION())).build();
    }

    public static List<String> ListBucketsForUser() {
        if (bucketsFinalList.isEmpty()) {
            OAuthUtils.getInstance().getProvider("Amazon").getAccessToken();
            AmazonUtils.updateS3Client(AmazonUtils.GetCognitoAWSCredentials());
            ArrayList<String> bucketsList = new ArrayList<String>();
            ListBucketsRequest listBucketsRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
            ListBucketsResponse listBucketsResponse = s3Client.listBuckets(listBucketsRequest);
            listBucketsResponse.buckets().stream().forEach(x -> bucketsList.add(x.name()));
            bucketsFinalList = AmazonUtils.getReadableBuckets(bucketsList);
        }
        return bucketsFinalList;
    }

    public static HeadObjectResponse getObjectMetadata(String bucket, String key) {
        HeadObjectRequest HeadObjReq = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build();
        HeadObjectResponse HeadObjRes = s3Client.headObject(HeadObjReq);
        log.debug((Object)("getObjectMetadata(): " + HeadObjRes.toString()));
        return HeadObjRes;
    }

    public static s3ObjectAccessResult isObjectAccessible(String bucket, String key) {
        String s3ObjectStorageClass;
        s3ObjectAccessResult res = new s3ObjectAccessResult();
        String s3ObjectStorageStatus = null;
        HeadObjectResponse s3Meta = AmazonUtils.getObjectMetadata(bucket, key);
        try {
            s3ObjectStorageClass = s3Meta.storageClass().toString();
        }
        catch (NullPointerException npe) {
            log.error((Object)"S3Meta StorageClass: Must be STANDARD since there is no Storage Class metadata");
            res.setErrorReason("Object is in an accessible tier, no errors are expected");
            res.setObjAvailable(true);
            return res;
        }
        String archived = "Amazon S3 object is in " + s3ObjectStorageClass + " storage tier, not accessible at this moment. Please contact your local system administrator about object: s3://" + bucket + "/" + key;
        String restoreInProgress = "Amazon S3 object is in " + s3ObjectStorageClass + " and being restored right now, please be patient, this can take up to 48h. For further enquiries about this dataset, please use the following path when communicating with your system administrator: s3://" + bucket + "/" + key;
        if (s3ObjectStorageClass.contains("DEEP_ARCHIVE") || s3ObjectStorageClass.contains("GLACIER")) {
            try {
                s3ObjectStorageStatus = ((List)s3Meta.sdkHttpResponse().headers().get("x-amz-restore")).toString();
            }
            catch (NullPointerException npe) {
                res.setObjAvailable(false);
                res.setErrorReason(archived);
                return res;
            }
            if (s3ObjectStorageStatus.contains("ongoing-request=\"true\"")) {
                res.setObjAvailable(false);
                res.setErrorReason(restoreInProgress);
            } else if (s3ObjectStorageStatus.contains("ongoing-request=\"false\"") && s3ObjectStorageStatus.contains("expiry-date=")) {
                res.setObjAvailable(true);
            } else {
                res.setObjAvailable(false);
                res.setErrorReason(archived);
            }
        } else {
            res.setErrorReason("Object is in an accessible tier, no errors are expected");
            res.setObjAvailable(true);
        }
        return res;
    }

    private static List<String> getReadableBuckets(List<String> buckets) {
        List futures = buckets.stream().map(bucket -> {
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                if (AmazonUtils.ListBucketObjects(bucket, "").size() > 0) {
                    return bucket;
                }
                return null;
            });
            return future;
        }).collect(Collectors.toList());
        List<String> result = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        result.removeAll(Collections.singleton(null));
        return result;
    }

    public static ArrayList<IGVS3Object> ListBucketObjects(String bucketName, String prefix) {
        ArrayList<IGVS3Object> objects = new ArrayList<IGVS3Object>();
        log.debug((Object)("Listing objects for bucketName: " + bucketName));
        OAuthUtils.getInstance().getProvider("Amazon").getAccessToken();
        AmazonUtils.updateS3Client(AmazonUtils.GetCognitoAWSCredentials());
        try {
            ListObjectsV2Request listReq = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix).delimiter("/").build();
            ListObjectsV2Response response = s3Client.listObjectsV2(listReq);
            ListObjectsV2Iterable resultIt = s3Client.listObjectsV2Paginator(listReq);
            do {
                for (CommonPrefix folder : resultIt.commonPrefixes()) {
                    log.debug((Object)("S3 Bucket folder: " + folder));
                    String folder_prefix = folder.prefix().substring(0, folder.prefix().length() - 1);
                    objects.add(new IGVS3Object(folder_prefix.replace(prefix, ""), true, "STANDARD"));
                }
                for (S3Object content : response.contents()) {
                    log.debug((Object)("S3 Bucket key: " + content.key()));
                    objects.add(new IGVS3Object(content.key().replace(prefix, ""), false, content.storageClassAsString()));
                }
                String token = response.nextContinuationToken();
                log.debug((Object)("Next S3 bucket pagination continuation Token: " + token));
                response.continuationToken();
            } while (response.isTruncated().booleanValue());
        }
        catch (SdkClientException | SdkServiceException e) {
            log.debug((Object)("AccessDenied for ListBucket " + bucketName + " with prefix " + prefix));
        }
        return objects;
    }

    public static String getBucketFromS3URL(String s3URL) {
        AmazonS3URI s3URI = new AmazonS3URI(s3URL);
        return s3URI.getBucket();
    }

    public static String getKeyFromS3URL(String s3URL) {
        AmazonS3URI s3URI = new AmazonS3URI(s3URL);
        return s3URI.getKey();
    }

    private static String createPresignedURL(String s3Path) throws IOException {
        OAuthProvider provider = OAuthUtils.getInstance().getProvider("Amazon");
        provider.getAccessToken();
        Credentials credentials = AmazonUtils.GetCognitoAWSCredentials();
        AwsSessionCredentials creds = AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
        StaticCredentialsProvider awsCredsProvider = StaticCredentialsProvider.create((AwsCredentials)creds);
        S3Presigner s3Presigner = S3Presigner.builder().expiration(provider.getExpirationTime()).awsCredentials((AwsCredentialsProvider)awsCredsProvider).region(AmazonUtils.getAWSREGION()).build();
        String bucket = AmazonUtils.getBucketFromS3URL(s3Path);
        String key = AmazonUtils.getKeyFromS3URL(s3Path);
        URI presigned = s3Presigner.presignS3DownloadLink(bucket, key);
        log.debug((Object)("AWS presigned URL from translateAmazonCloudURL is: " + presigned));
        return presigned.toString();
    }

    public static String translateAmazonCloudURL(String s3UrlString) throws IOException {
        String presignedUrl = locatorTos3PresignedMap.get(s3UrlString);
        if (presignedUrl == null || !AmazonUtils.isPresignedURLValid(new URL(presignedUrl))) {
            presignedUrl = AmazonUtils.createPresignedURL(s3UrlString);
            locatorTos3PresignedMap.put(s3UrlString, presignedUrl);
        }
        return presignedUrl;
    }

    public static Boolean isAwsS3Path(String path) {
        return path.startsWith("s3://");
    }

    public static void checkLogin() {
        if (!OAuthUtils.getInstance().getProvider("Amazon").isLoggedIn()) {
            OAuthUtils.getInstance().getProvider("Amazon").doSecureLogin();
        }
    }

    public static boolean isS3PresignedValid(String url) throws MalformedURLException {
        String s3Mapping = locatorTos3PresignedMap.get(url);
        return s3Mapping != null && AmazonUtils.isPresignedURLValid(new URL(s3Mapping));
    }

    private static boolean isPresignedURLValid(URL url) {
        boolean isValidSignedUrl;
        try {
            long presignedTime = AmazonUtils.signedURLValidity(url);
            isValidSignedUrl = presignedTime - System.currentTimeMillis() - (long)Globals.TOKEN_EXPIRE_GRACE_TIME > 0L;
        }
        catch (ParseException e) {
            log.error((Object)"The AWS signed URL date parameter X-Amz-Date has incorrect formatting");
            isValidSignedUrl = false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            isValidSignedUrl = false;
        }
        return isValidSignedUrl;
    }

    private static long signedURLValidity(URL url) throws ParseException, UnsupportedEncodingException {
        Map<String, String> params = StringUtils.splitQuery(url);
        String amzDateStr = params.get("X-Amz-Date");
        long amzExpires = Long.parseLong(params.get("X-Amz-Expires"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date amzDate = formatter.parse(amzDateStr);
        long timeOfExpirationMillis = amzDate.getTime() + amzExpires * 1000L;
        log.debug((Object)("The date of expiration is " + amzDate + ", expires after " + amzExpires + " seconds for url: " + url));
        return timeOfExpirationMillis;
    }

    static {
        bucketsFinalList = new ArrayList<String>();
        locatorTos3PresignedMap = new HashMap<String, String>();
    }

    public static class s3ObjectAccessResult {
        private boolean objAvailable;
        private String errorReason;

        public boolean getObjAvailable() {
            return this.objAvailable;
        }

        public void setObjAvailable(boolean objAvailable) {
            this.objAvailable = objAvailable;
        }

        public String getErrorReason() {
            return this.errorReason;
        }

        public void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }
    }
}

