/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.tribble.annotation.Strand;
import java.util.Collections;
import java.util.Map;

public class Gff3BaseData {
    private static final String ID_ATTRIBUTE_KEY = "ID";
    private static final String NAME_ATTRIBUTE_KEY = "Name";
    private static final String ALIAS_ATTRIBUTE_KEY = "Alias";
    final String contig;
    final String source;
    final String type;
    final int start;
    final int end;
    final Strand strand;
    final int phase;
    final Map<String, String> attributes;
    final String id;
    final String name;
    final String alias;

    Gff3BaseData(String contig, String source, String type, int start, int end, Strand strand, int phase, Map<String, String> attributes) {
        this.contig = contig;
        this.source = source;
        this.type = type;
        this.start = start;
        this.end = end;
        this.phase = phase;
        this.strand = strand;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.id = attributes.get(ID_ATTRIBUTE_KEY);
        this.name = attributes.get(NAME_ATTRIBUTE_KEY);
        this.alias = attributes.get(ALIAS_ATTRIBUTE_KEY);
    }

    public boolean equals(Object other) {
        boolean ret;
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(Gff3BaseData.class)) {
            return false;
        }
        Gff3BaseData otherBaseData = (Gff3BaseData)other;
        boolean bl = ret = otherBaseData.contig.equals(this.contig) && otherBaseData.source.equals(this.source) && otherBaseData.type.equals(this.type) && otherBaseData.start == this.start && otherBaseData.end == this.end && otherBaseData.phase == this.phase && otherBaseData.strand.equals((Object)this.strand) && otherBaseData.attributes.equals(this.attributes);
        if (this.id == null) {
            ret = ret && otherBaseData.id == null;
        } else {
            boolean bl2 = ret = ret && otherBaseData.id != null && otherBaseData.id.equals(this.id);
        }
        if (this.name == null) {
            ret = ret && otherBaseData.name == null;
        } else {
            boolean bl3 = ret = ret && otherBaseData.name != null && otherBaseData.name.equals(this.name);
        }
        ret = this.alias == null ? ret && otherBaseData.alias == null : ret && otherBaseData.alias != null && otherBaseData.alias.equals(this.alias);
        return ret;
    }

    public int hashCode() {
        int hash = this.contig.hashCode();
        hash = 31 * hash + this.source.hashCode();
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.start;
        hash = 31 * hash + this.end;
        hash = 31 * hash + this.phase;
        hash = 31 * hash + this.strand.hashCode();
        hash = 31 * hash + this.attributes.hashCode();
        if (this.id != null) {
            hash = 31 * hash + this.id.hashCode();
        }
        if (this.name != null) {
            hash = 31 * hash + this.name.hashCode();
        }
        if (this.alias != null) {
            hash = 31 * hash + this.alias.hashCode();
        }
        return hash;
    }
}

