/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.ParsingUtils;

public class GenomeUtils {
    public static void main(String[] args) throws IOException {
        String genomeListFile = args.length > 0 ? args[0] : "genomes/genomes.txt";
        String outputFile = args.length > 1 ? args[1] : "nonFastas.txt";
        GenomeUtils.findNonFastas(genomeListFile, new File(outputFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChromSizes(String genomeListPath, File directory) throws IOException {
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(genomeListPath);
            while ((nextLine = br.readLine()) != null) {
                String genomeID;
                File outputFile;
                String[] tokens = nextLine.split("\t");
                if (tokens.length <= 2 || (outputFile = new File(directory, (genomeID = tokens[2]) + ".chrom.sizes")).exists()) continue;
                System.out.println("Updating " + genomeID);
                String genomePath = tokens[1];
                try {
                    Genome genome = GenomeManager.getInstance().loadGenome(genomePath, null);
                    GenomeUtils.exportChromSizes(directory, genome);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportChromSizes(File directory, Genome genome) throws FileNotFoundException {
        String fn = genome.getId() + ".chrom.sizes";
        File file = new File(directory, fn);
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file);
            for (String chr : genome.getAllChromosomeNames()) {
                Chromosome chromosome = genome.getChromosome(chr);
                pw.println(chromosome.getName() + "\t" + chromosome.getLength());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeINCDCNames(File aliasFile, File assemblyFile, File outputDirectory) throws IOException {
        String nextLine;
        LinkedHashMap<String, LinkedHashSet<String>> aliasRows = new LinkedHashMap<String, LinkedHashSet<String>>();
        BufferedReader br = null;
        PrintWriter pw = null;
        br = new BufferedReader(new FileReader(aliasFile));
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = Globals.whitespacePattern.split(nextLine);
            LinkedHashSet<String> row = new LinkedHashSet<String>(Arrays.asList(tokens));
            for (String string : tokens) {
                aliasRows.put(string, row);
            }
        }
        br.close();
        int[] chrIndeces = new int[]{0, 4, 6, 9};
        br = new BufferedReader(new FileReader(assemblyFile));
        boolean start = false;
        ArrayList<void> newRows = new ArrayList<void>();
        while ((nextLine = br.readLine()) != null) {
            if (start) {
                void var12_20;
                String[] tokens = Globals.tabPattern.split(nextLine);
                boolean foundRow = false;
                for (int i : chrIndeces) {
                    Set row = (Set)aliasRows.get(tokens[i]);
                    if (row == null) continue;
                    for (int j : chrIndeces) {
                        if ("na".equals(tokens[j])) continue;
                        row.add(tokens[j]);
                    }
                    foundRow = true;
                    break;
                }
                if (foundRow) continue;
                String string = tokens[chrIndeces[0]];
                for (int i = 1; i < chrIndeces.length; ++i) {
                    String chrNm = tokens[chrIndeces[i]];
                    if ("na".equals(chrNm)) continue;
                    String string2 = (String)var12_20 + "\t" + chrNm;
                }
                newRows.add(var12_20);
                System.out.println("New alias row: " + (String)var12_20);
                continue;
            }
            if (!nextLine.startsWith("# Sequence-Name")) continue;
            start = true;
        }
        br.close();
        pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputDirectory, aliasFile.getName()))));
        HashSet<Set> output = new HashSet<Set>();
        for (Set set : aliasRows.values()) {
            if (set.size() == 0 || output.contains(set)) continue;
            output.add(set);
            ArrayList chrNames = new ArrayList(set);
            pw.print((String)chrNames.get(0));
            for (int i = 1; i < chrNames.size(); ++i) {
                pw.print("\t" + (String)chrNames.get(i));
            }
            pw.println();
        }
        for (String string : newRows) {
            pw.println(string);
        }
        pw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findNonFastas(String genomeListPath, File outputFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            br = ParsingUtils.openBufferedReader(genomeListPath);
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                if (tokens.length <= 2) continue;
                String genomeID = tokens[2];
                String genomePath = tokens[1];
                try {
                    Genome genome = GenomeManager.getInstance().loadGenome(genomePath, null);
                    if (genome.sequenceIsFasta()) continue;
                    pw.println("Updating " + genomeID);
                }
                catch (Exception e) {
                    System.err.println(e.toString());
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }
}

