/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import java.io.IOException;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.FileSlice;
import org.campagnelab.goby.alignments.GenomicRange;

public abstract class AlignmentReaderFactoryBase
implements AlignmentReaderFactory {
    @Override
    public AlignmentReader[] createReaderArray(int numElements) throws IOException {
        return new AlignmentReaderImpl[numElements];
    }

    @Override
    public AlignmentReader createReader(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        return new AlignmentReaderImpl(basename, startReferenceIndex, startPosition, endReferenceIndex, endPosition, false);
    }

    @Override
    public AlignmentReader createReader(String basename, GenomicRange range) throws IOException {
        if (range == null) {
            return this.createReader(basename);
        }
        return this.createReader(basename, range.startReferenceIndex, range.startPosition, range.endReferenceIndex, range.endPosition);
    }

    @Override
    public FileSlice getSlice(String basename, GenomicRange range) throws IOException {
        return FileSlice.getSlice(this, basename, range);
    }

    @Override
    public AlignmentReader[] createReader(String[] basenames, boolean upgrade) throws IOException {
        AlignmentReader[] array = this.createReaderArray(basenames.length);
        int i = 0;
        for (String basename : basenames) {
            array[i++] = this.createReader(basename);
        }
        return array;
    }

    @Override
    public String[] getBasenames(String[] inputFilenames) {
        return AlignmentReaderImpl.getBasenames(inputFilenames);
    }
}

