/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.AlignmentTooManyHitsReader;
import org.campagnelab.goby.alignments.AlignmentTooManyHitsWriter;
import org.campagnelab.goby.alignments.AlignmentWriterImpl;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.filters.AbstractAlignmentEntryFilter;
import org.campagnelab.goby.alignments.filters.BestScoreAmbiguityAlignmentFilter;
import org.campagnelab.goby.alignments.filters.TranscriptBestScoreAlignmentFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merge {
    private static final Logger LOG = LoggerFactory.getLogger(Merge.class);
    private String geneTranscriptMapFile;
    private boolean verbose;
    private int k;
    private ObjectList<int[]> referenceIndexPermutation;

    public Merge(String geneTranscriptMapFile, int k) {
        this.geneTranscriptMapFile = geneTranscriptMapFile;
        this.k = k;
    }

    public Merge(int k) {
        this.k = k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setSilent(boolean status) {
        this.verbose = !status;
    }

    public void setGeneTranscriptMapFile(String geneTranscriptMapFile) {
        this.geneTranscriptMapFile = geneTranscriptMapFile;
    }

    public void merge(List<File> inputFiles, String outputFile) throws IOException {
        this.referenceIndexPermutation = new ObjectArrayList();
        int maxNumberOfReads = Integer.MIN_VALUE;
        if (this.verbose) {
            System.out.println("Finding max number of reads...");
            System.out.flush();
        }
        int mergedReferenceIndex = 0;
        IndexedIdentifier mergedTargetIdentifiers = new IndexedIdentifier();
        Int2IntOpenHashMap mergedTargetLengths = new Int2IntOpenHashMap();
        IntArraySet numberOfReadsSet = new IntArraySet();
        int minQueryIndex = Integer.MAX_VALUE;
        for (File inputFile : inputFiles) {
            AlignmentReaderImpl reader = new AlignmentReaderImpl(inputFile.toString());
            reader.readHeader();
            this.message("Found input file with " + reader.getNumberOfTargets() + " target(s)");
            mergedReferenceIndex = this.constructTargetIndexPermutations(mergedReferenceIndex, mergedTargetIdentifiers, (Int2IntMap)mergedTargetLengths, reader);
            minQueryIndex = Math.min(minQueryIndex, reader.getSmallestSplitQueryIndex());
            numberOfReadsSet.add(reader.getNumberOfQueries());
            reader.close();
            AlignmentTooManyHitsReader tmhReader = new AlignmentTooManyHitsReader(inputFile.toString());
            IntIterator intIterator = tmhReader.getQueryIndices().iterator();
            while (intIterator.hasNext()) {
                int queryIndex = (Integer)intIterator.next();
                minQueryIndex = Math.min(minQueryIndex, queryIndex);
            }
        }
        if (numberOfReadsSet.size() != 1) {
            this.message("Aborting: the input alignments must have exactly the same number of reads, we found different number of reads in " + numberOfReadsSet + " input files:");
            return;
        }
        maxNumberOfReads = numberOfReadsSet.iterator().nextInt();
        this.message("... max number of reads was " + maxNumberOfReads);
        AbstractAlignmentEntryFilter entryFilter = this.getFilter(maxNumberOfReads, minQueryIndex);
        entryFilter.setTargetIdentifiers(mergedTargetIdentifiers);
        ProgressLogger progress = new ProgressLogger(LOG);
        progress.expectedUpdates = inputFiles.size();
        progress.start();
        float totalNumberOfLogicalEntries = 0.0f;
        this.message("First pass: determine which reads should be kept in the merged alignment.");
        int totalNumberOfEntries = 0;
        for (File inputFile : inputFiles) {
            this.message("Scanning " + inputFile.getName());
            AlignmentReaderImpl reader = new AlignmentReaderImpl(inputFile.toString());
            reader.readHeader();
            entryFilter.setTargetIdentifiers(reader.getTargetIdentifiers());
            while (reader.hasNext()) {
                Alignments.AlignmentEntry entry = reader.next();
                entryFilter.inspectEntry(entry);
                ++totalNumberOfEntries;
                totalNumberOfLogicalEntries += (float)entry.getMultiplicity();
            }
            progress.update();
            reader.close();
        }
        progress.stop();
        entryFilter.postProcessing();
        this.message(String.format("Found %d logical alignment entries.", (int)totalNumberOfLogicalEntries));
        this.message("Prepare merged too many hits information.");
        Merge.prepareMergedTooManyHits(outputFile, maxNumberOfReads, minQueryIndex, inputFiles.toArray(new File[inputFiles.size()]));
        this.message("Second pass: writing the merged alignment.");
        int wrote = 0;
        int skipped = 0;
        int skippedTooManyHits = 0;
        int skippedNotBestScore = 0;
        AlignmentWriterImpl writer = new AlignmentWriterImpl(outputFile);
        progress = new ProgressLogger(LOG);
        progress.expectedUpdates = totalNumberOfEntries;
        progress.start();
        if (mergedTargetIdentifiers.size() > 0) {
            writer.setTargetIdentifiers(mergedTargetIdentifiers);
        }
        int inputFileIndex = 0;
        AlignmentTooManyHitsReader tmhReader = new AlignmentTooManyHitsReader(outputFile);
        IntOpenHashSet queriesIndicesAligned = new IntOpenHashSet();
        for (File inputFile : inputFiles) {
            String basename = inputFile.toString();
            AlignmentReaderImpl reader = new AlignmentReaderImpl(basename);
            reader.readHeader();
            entryFilter.setTargetIdentifiers(reader.getTargetIdentifiers());
            AlignmentTooManyHitsReader specificTmhReader = new AlignmentTooManyHitsReader(basename);
            while (reader.hasNext()) {
                Alignments.AlignmentEntry entry = reader.next();
                progress.lightUpdate();
                if (entryFilter.shouldRetainEntry(entry)) {
                    int matchLength;
                    int queryIndex = entry.getQueryIndex();
                    if (!tmhReader.isQueryAmbiguous(queryIndex, this.k, matchLength = specificTmhReader.getLengthOfMatch(queryIndex))) {
                        int newTargetIndex = ((int[])this.referenceIndexPermutation.get(inputFileIndex))[entry.getTargetIndex()];
                        Alignments.AlignmentEntry entry1 = entry;
                        entry1 = entry1.newBuilderForType().mergeFrom(entry1).setTargetIndex(newTargetIndex).build();
                        writer.appendEntry(entry1);
                        wrote += entry.getMultiplicity();
                        queriesIndicesAligned.add(entry.getQueryIndex());
                    } else {
                        skipped += entry.getMultiplicity();
                        skippedTooManyHits += entry.getMultiplicity();
                    }
                } else {
                    skipped += entry.getMultiplicity();
                    skippedNotBestScore += entry.getMultiplicity();
                }
                if ((wrote + skipped) % 1000000 != 0) continue;
                this.printStatus(wrote + skipped, wrote, skipped, skippedTooManyHits, skippedNotBestScore);
            }
            reader.close();
            ++inputFileIndex;
        }
        progress.stop();
        writer.setNumTargets(mergedReferenceIndex);
        int[] targetLengths = new int[mergedReferenceIndex];
        for (int i = 0; i < mergedReferenceIndex; ++i) {
            targetLengths[i] = mergedTargetLengths.get(i);
        }
        writer.setTargetLengths(targetLengths);
        this.printStatus((int)totalNumberOfLogicalEntries, wrote, skipped, skippedTooManyHits, skippedNotBestScore);
        if (this.verbose) {
            writer.printStats(System.out);
        }
        entryFilter.printStats();
        float numQuerySequences = maxNumberOfReads;
        float percentWritten = (float)wrote * 100.0f / totalNumberOfLogicalEntries;
        float skippedPercent = (float)skipped * 100.0f / totalNumberOfLogicalEntries;
        float skippedTooManyHitsPercent = (float)skippedTooManyHits * 100.0f / totalNumberOfLogicalEntries;
        float skippedNotBestScorePercent = (float)skippedNotBestScore * 100.0f / totalNumberOfLogicalEntries;
        float percentAligned = queriesIndicesAligned.size();
        percentAligned /= numQuerySequences;
        percentAligned *= 100.0f;
        double percentEntriesRetained = (double)wrote / (double)numQuerySequences * 100.0;
        writer.putStatistic("entries.written.number", wrote);
        writer.putStatistic("entries.written.percent", percentWritten);
        writer.putStatistic("entries.input.logical.number", totalNumberOfLogicalEntries);
        writer.putStatistic("entries.input.number", totalNumberOfEntries);
        writer.putStatistic("skipped.Total.percent", skippedPercent);
        writer.putStatistic("skipped.TooManyHits.percent", skippedTooManyHitsPercent);
        writer.putStatistic("skipped.TooManyHits.number", skippedTooManyHits);
        writer.putStatistic("skipped.NotBestScore.percent", skippedNotBestScorePercent);
        writer.putStatistic("skipped.NotBestScore.number", skippedNotBestScore);
        writer.putStatistic("entries.retained.percent", percentEntriesRetained);
        writer.putStatistic("number.Query", maxNumberOfReads);
        writer.putStatistic("number.Target", mergedTargetIdentifiers.size());
        writer.putStatistic("reads.aligned.number", queriesIndicesAligned.size());
        writer.putStatistic("reads.aligned.percent", percentAligned);
        writer.close();
        this.message("Percent aligned: " + percentAligned);
    }

    private void printStatus(int totalNumberOfLogicalEntries, int wrote, int skipped, int skippedTooManyHits, int skippedNotBestScore) {
        this.message(String.format("Wrote %,d  skipped: %,d %f%% too many hits %f%% notBestScore: %f%%", wrote, skipped, Float.valueOf((float)skipped / (float)totalNumberOfLogicalEntries * 100.0f), Float.valueOf((float)skippedTooManyHits / (float)totalNumberOfLogicalEntries * 100.0f), Float.valueOf((float)skippedNotBestScore / (float)totalNumberOfLogicalEntries * 100.0f)));
    }

    public static void prepareMergedTooManyHits(String outputFilename, int numberOfReads, int minQueryIndex, File[] inputFiles) throws IOException {
        String[] inputFilenames = new String[inputFiles.length];
        int i = 0;
        for (File file : inputFiles) {
            inputFilenames[i++] = file.toString();
        }
        Merge.prepareMergedTooManyHits(outputFilename, numberOfReads, minQueryIndex, inputFilenames);
    }

    public static int prepareMergedTooManyHits(String outputFile, int numberOfReads, int minQueryIndex, String ... basenames) throws IOException {
        Int2IntAVLTreeMap tmhMap = new Int2IntAVLTreeMap();
        tmhMap.defaultReturnValue(0);
        int consensusAlignerThreshold = Integer.MAX_VALUE;
        LOG.debug("TMH first pass");
        int maxQueryIndex = numberOfReads - 1;
        int maxCapacity = 0;
        for (String basename : basenames) {
            LOG.debug("processing " + basename);
            AlignmentTooManyHitsReader tmhReader = new AlignmentTooManyHitsReader(basename);
            IntSet queryIndices = tmhReader.getQueryIndices();
            maxCapacity = Math.max(maxCapacity, queryIndices.size());
            IntIterator intIterator = queryIndices.iterator();
            while (intIterator.hasNext()) {
                int queryIndex = (Integer)intIterator.next();
                maxQueryIndex = Math.max(maxQueryIndex, queryIndex);
            }
            tmhReader.close();
        }
        LOG.debug("TMH second pass");
        numberOfReads = maxQueryIndex + 1;
        Int2IntAVLTreeMap queryIndex2MaxDepth = new Int2IntAVLTreeMap();
        queryIndex2MaxDepth.defaultReturnValue(-1);
        for (String basename : basenames) {
            LOG.debug("processing " + basename);
            AlignmentTooManyHitsReader tmhReader = new AlignmentTooManyHitsReader(basename);
            consensusAlignerThreshold = Math.min(consensusAlignerThreshold, tmhReader.getAlignerThreshold());
            IntSet queryIndices = tmhReader.getQueryIndices();
            IntIterator queryIndex = queryIndices.iterator();
            while (queryIndex.hasNext()) {
                int queryIndex2 = (Integer)queryIndex.next();
                int currentMatchLength = tmhReader.getLengthOfMatch(queryIndex2);
                int maxDepth = Math.max(currentMatchLength, queryIndex2MaxDepth.get(queryIndex2));
                if (maxDepth == -1) continue;
                queryIndex2MaxDepth.put(queryIndex2, maxDepth);
            }
            tmhReader.close();
        }
        boolean foundDepth = false;
        ProgressLogger pg = new ProgressLogger(LOG);
        pg.expectedUpdates = basenames.length;
        pg.start((CharSequence)"TMH third pass");
        for (String basename : basenames) {
            LOG.debug("processing " + basename);
            AlignmentTooManyHitsReader tmhReader = new AlignmentTooManyHitsReader(basename);
            IntSet queryIndices = tmhReader.getQueryIndices();
            IntIterator intIterator = queryIndices.iterator();
            while (intIterator.hasNext()) {
                int queryIndex = (Integer)intIterator.next();
                int depthForBasename = tmhReader.getLengthOfMatch(queryIndex);
                if (depthForBasename != queryIndex2MaxDepth.get(queryIndex) || depthForBasename == 1) continue;
                int newValue = tmhMap.get(queryIndex) + tmhReader.getNumberOfHits(queryIndex);
                tmhMap.put(queryIndex, newValue);
                foundDepth = true;
            }
            tmhReader.close();
            pg.update();
        }
        pg.done();
        pg.start((CharSequence)"TMH fourth pass");
        if (!foundDepth) {
            System.out.println("Warning: could not find depth/max-length-of-match in too many hits information.");
        }
        AlignmentTooManyHitsWriter mergedTmhWriter = new AlignmentTooManyHitsWriter(outputFile, consensusAlignerThreshold);
        pg.expectedUpdates = tmhMap.size();
        pg.displayFreeMemory = true;
        for (Int2IntMap.Entry entry : tmhMap.int2IntEntrySet()) {
            int queryIndex = entry.getIntKey();
            int value = entry.getIntValue();
            mergedTmhWriter.append(queryIndex, value, queryIndex2MaxDepth.get(queryIndex));
            pg.lightUpdate();
        }
        mergedTmhWriter.close();
        pg.done();
        return numberOfReads;
    }

    private int constructTargetIndexPermutations(int mergedReferenceIndex, IndexedIdentifier mergedTargetIdentifiers, Int2IntMap mergedTargetLengths, AlignmentReaderImpl reader) {
        IntIterator id;
        int[] targetLengths = reader.getTargetLength();
        int targetLengthCount = ArrayUtils.getLength((Object)targetLengths);
        Int2IntOpenHashMap tempPermutation = new Int2IntOpenHashMap();
        IndexedIdentifier targetIdentifers = reader.getTargetIdentifiers();
        DoubleIndexedIdentifier backward = new DoubleIndexedIdentifier(targetIdentifers);
        for (int i = 0; i < reader.getNumberOfTargets(); ++i) {
            id = backward.size() != 0 ? backward.getId(i) : new MutableString(String.valueOf(mergedTargetIdentifiers.size()));
            int newIndex = mergedTargetIdentifiers.registerIdentifier((MutableString)id);
            tempPermutation.put(i, newIndex);
            MutableString targetId = backward.getId(i);
            if (targetId == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("tempPermutation associating targetId: " + targetId + " to index " + newIndex);
            }
            mergedTargetIdentifiers.registerIdentifier(targetId);
            int targetLength = i < targetLengthCount ? targetLengths[i] : 0;
            mergedTargetLengths.put(newIndex, targetLength);
        }
        int size = 0;
        id = tempPermutation.keySet().iterator();
        while (id.hasNext()) {
            int key = (Integer)id.next();
            size = Math.max(key + 1, size);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating array with size " + size);
        }
        int[] newPermutation = new int[size];
        IntIterator intIterator = tempPermutation.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("about to get key : " + key);
            }
            newPermutation[key] = tempPermutation.get(key);
        }
        this.referenceIndexPermutation.add((Object)newPermutation);
        return mergedTargetIdentifiers.size();
    }

    public AbstractAlignmentEntryFilter getFilter(int maxNumberOfReads, int minQueryIndex) throws FileNotFoundException {
        AbstractAlignmentEntryFilter entryFilter = this.geneTranscriptMapFile != null ? new TranscriptBestScoreAlignmentFilter(this.geneTranscriptMapFile, this.k, maxNumberOfReads, minQueryIndex) : new BestScoreAmbiguityAlignmentFilter(this.k, maxNumberOfReads, minQueryIndex);
        return entryFilter;
    }

    private void message(String message) {
        if (this.verbose) {
            System.out.println(message);
        } else {
            LOG.debug(message);
        }
    }
}

