/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.encode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.encode.EncodeFileRecord;

public class UCSCEncodeUtils {
    static HashSet<String> labs = new HashSet();
    static HashSet<String> dataTypes = new HashSet();
    static HashSet<String> cells = new HashSet();
    static HashSet<String> antibodies = new HashSet();
    static HashSet<String> fileTypes = new HashSet();
    static HashSet<String> allHeaders = new LinkedHashSet<String>();
    private static List<String> rnaChipQualifiers = Arrays.asList("CellTotal", "Longnonpolya", "Longpolya", "NucleolusTotal", "ChromatinTotal", "ChromatinTotal", "NucleoplasmTotal");
    static String[] columnHeadings = new String[]{"cell", "dataType", "antibody", "view", "replicate", "type", "lab"};
    static HashSet knownFileTypes = new HashSet<String>(Arrays.asList("bam", "bigBed", "bed", "bb", "bw", "bigWig", "gtf", "broadPeak", "narrowPeak", "gappedPeak", "regionPeak", "gff"));

    public static void main(String[] args) throws IOException {
        UCSCEncodeUtils.updateEncodeTableFile(args[0], args[1]);
    }

    private static List<EncodeFileRecord> parseTableFile(String url) throws IOException {
        String nextLine;
        ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>(20000);
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(url);
        String[] headers = Globals.tabPattern.split(reader.readLine());
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("#")) continue;
            String[] tokens = Globals.tabPattern.split(nextLine, -1);
            String path = tokens[0];
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < headers.length; ++i) {
                String value = tokens[i];
                if (value.length() <= 0) continue;
                attributes.put(headers[i], value);
            }
            records.add(new EncodeFileRecord(path, attributes));
        }
        return records;
    }

    private static void updateEncodeTableFile(String inputFile, String outputFile) throws IOException {
        String nextLine;
        ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>();
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(inputFile);
        String rootPath = reader.readLine();
        String hub = null;
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#hub=")) continue;
                hub = nextLine.substring(5);
                continue;
            }
            String dir = nextLine.equals(".") ? rootPath : rootPath + nextLine;
            String filesDotTxt = dir + "/files.txt";
            try {
                if (!HttpUtils.getInstance().resourceAvailable(filesDotTxt)) continue;
                UCSCEncodeUtils.parseFilesDotTxt(filesDotTxt, records);
            }
            catch (IOException iOException) {}
        }
        for (String dt : fileTypes) {
            System.out.println(dt);
        }
        UCSCEncodeUtils.outputRecords(outputFile, records, hub);
    }

    private static void outputRecords(String outputFile, List<EncodeFileRecord> records, String hub) throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        pw.print("path");
        for (String h : columnHeadings) {
            pw.print("\t");
            pw.print(h);
        }
        if (hub != null) {
            pw.print("\thub");
        }
        pw.println();
        for (EncodeFileRecord rec : records) {
            pw.print(rec.getPath());
            for (String h : columnHeadings) {
                pw.print("\t");
                String value = rec.getAttributeValue(h);
                pw.print(value == null ? "" : value);
            }
            if (hub != null) {
                pw.print("\t" + hub);
            }
            pw.println();
        }
        pw.close();
    }

    public static void parseFilesDotTxt(String url, List<EncodeFileRecord> fileRecords) throws IOException {
        String nextLine;
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(url);
        while ((nextLine = reader.readLine()) != null) {
            String path;
            EncodeFileRecord df;
            String[] tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length < 2) continue;
            String fn = tokens[0];
            String[] attributes = Globals.semicolonPattern.split(tokens[1]);
            LinkedHashMap<String, String> kvalues = new LinkedHashMap<String, String>();
            for (String tk : attributes) {
                String[] kv = Globals.equalPattern.split(tk);
                if (kv.length <= 1) continue;
                kvalues.put(kv[0].trim(), kv[1].trim());
                allHeaders.add(kv[0].trim());
            }
            if ("RnaChip".equals(kvalues.get("dataType"))) {
                for (String qual : rnaChipQualifiers) {
                    if (!fn.contains(qual)) continue;
                    kvalues.put("antibody", qual);
                }
            }
            if (knownFileTypes.contains((df = new EncodeFileRecord(path = fn.startsWith("http") ? fn : url.replace("files.txt", fn), kvalues)).getFileType())) {
                fileRecords.add(df);
            }
            dataTypes.add(df.getAttributeValue("dataType"));
            antibodies.add(df.getAttributeValue("antibody"));
            cells.add(df.getAttributeValue("cell"));
            labs.add(df.getAttributeValue("lab"));
            fileTypes.add(df.getFileType());
        }
        reader.close();
    }
}

