/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.gff;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.AbstractFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.SimpleFeature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.gff.Gff3Feature;
import htsjdk.tribble.gff.Gff3FeatureImpl;
import htsjdk.tribble.gff.SequenceRegion;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.SynchronousLineReader;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class Gff3Codec
extends AbstractFeatureCodec<Gff3Feature, LineIterator> {
    private static final char FIELD_DELIMITER = '\t';
    private static final char ATTRIBUTE_DELIMITER = ';';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final char VALUE_DELIMITER = ',';
    private static final int NUM_FIELDS = 9;
    private static final int CHROMOSOME_NAME_INDEX = 0;
    private static final int ANNOTATION_SOURCE_INDEX = 1;
    private static final int FEATURE_TYPE_INDEX = 2;
    private static final int START_LOCATION_INDEX = 3;
    private static final int END_LOCATION_INDEX = 4;
    private static final int GENOMIC_STRAND_INDEX = 6;
    private static final int GENOMIC_PHASE_INDEX = 7;
    private static final int EXTRA_FIELDS_INDEX = 8;
    private static final String COMMENT_START = "#";
    private static final String DIRECTIVE_START = "##";
    static final String PARENT_ATTRIBUTE_KEY = "Parent";
    private static final String IS_CIRCULAR_ATTRIBUTE_KEY = "Is_circular";
    private static final String ARTEMIS_FASTA_MARKER = ">";
    private final Queue<Gff3FeatureImpl> activeFeatures = new ArrayDeque<Gff3FeatureImpl>();
    private final Queue<Gff3FeatureImpl> featuresToFlush = new ArrayDeque<Gff3FeatureImpl>();
    private final Map<String, Set<Gff3FeatureImpl>> activeFeaturesWithIDs = new HashMap<String, Set<Gff3FeatureImpl>>();
    private final Map<String, Set<Gff3FeatureImpl>> activeParentIDs = new HashMap<String, Set<Gff3FeatureImpl>>();
    private int currentLineNum = 0;
    private final Map<String, SequenceRegion> sequenceRegionMap = new HashMap<String, SequenceRegion>();
    private static final Log logger = Log.getInstance(Gff3Codec.class);
    private boolean reachedFasta = false;

    public Gff3Codec() {
        super(Gff3Feature.class);
    }

    @Override
    public Gff3Feature decode(LineIterator lineIterator) throws IOException {
        if (!lineIterator.hasNext()) {
            this.prepareToFlushFeatures();
            return this.featuresToFlush.poll();
        }
        String line = (String)lineIterator.next();
        ++this.currentLineNum;
        if (this.reachedFasta) {
            this.prepareToFlushFeatures();
            return this.featuresToFlush.poll();
        }
        if (line.startsWith(ARTEMIS_FASTA_MARKER)) {
            this.processDirective(Gff3Directive.FASTA_DIRECTIVE, null);
            return this.featuresToFlush.poll();
        }
        if (line.startsWith(COMMENT_START) && !line.startsWith(DIRECTIVE_START)) {
            return this.featuresToFlush.poll();
        }
        if (line.startsWith(DIRECTIVE_START)) {
            this.parseDirective(line);
            return this.featuresToFlush.poll();
        }
        List<String> splitLine = ParsingUtils.split(line, '\t');
        if (splitLine.size() != 9) {
            throw new TribbleException("Found an invalid number of columns in the given Gff3 file on line " + this.currentLineNum + " - Given: " + splitLine.size() + " Expected: " + 9 + " : " + line);
        }
        try {
            String contig = URLDecoder.decode(splitLine.get(0), "UTF-8");
            String source = URLDecoder.decode(splitLine.get(1), "UTF-8");
            String type = URLDecoder.decode(splitLine.get(2), "UTF-8");
            int start = Integer.parseInt(splitLine.get(3));
            int end = Integer.parseInt(splitLine.get(4));
            int phase = splitLine.get(7).equals(".") ? -1 : Integer.parseInt(splitLine.get(7));
            Strand strand = Strand.decode(splitLine.get(6));
            Map<String, String> attributes = Gff3Codec.parseAttributes(splitLine.get(8));
            String parentIDAttribute = attributes.get(PARENT_ATTRIBUTE_KEY);
            List<Object> parentIDs = parentIDAttribute != null ? ParsingUtils.split(parentIDAttribute, ',') : new ArrayList();
            Gff3FeatureImpl thisFeature = new Gff3FeatureImpl(contig, source, type, start, end, strand, phase, attributes);
            this.activeFeatures.add(thisFeature);
            String id = thisFeature.getID();
            for (String string : parentIDs) {
                Set<Gff3FeatureImpl> theseParents = this.activeFeaturesWithIDs.get(string);
                if (theseParents != null) {
                    for (Gff3FeatureImpl parent : theseParents) {
                        thisFeature.addParent(parent);
                    }
                }
                if (this.activeParentIDs.containsKey(string)) {
                    this.activeParentIDs.get(string).add(thisFeature);
                    continue;
                }
                this.activeParentIDs.put(string, new HashSet<Gff3FeatureImpl>(Collections.singleton(thisFeature)));
            }
            if (id != null) {
                if (this.activeFeaturesWithIDs.containsKey(id)) {
                    for (Gff3FeatureImpl gff3FeatureImpl : this.activeFeaturesWithIDs.get(id)) {
                        thisFeature.addCoFeature(gff3FeatureImpl);
                    }
                    this.activeFeaturesWithIDs.get(id).add(thisFeature);
                } else {
                    this.activeFeaturesWithIDs.put(id, new HashSet<Gff3FeatureImpl>(Collections.singleton(thisFeature)));
                }
            }
            if (this.activeParentIDs.containsKey(thisFeature.getID())) {
                for (Gff3FeatureImpl gff3FeatureImpl : this.activeParentIDs.get(thisFeature.getID())) {
                    gff3FeatureImpl.addParent(thisFeature);
                }
            }
            this.validateFeature(thisFeature);
            return this.featuresToFlush.poll();
        }
        catch (NumberFormatException ex) {
            throw new TribbleException("Cannot read integer value for start/end position!", ex);
        }
    }

    private static Map<String, String> parseAttributes(String attributesString) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        List<String> splitLine = ParsingUtils.split(attributesString, ';');
        for (String attribute : splitLine) {
            List<String> key_value = ParsingUtils.split(attribute, '=');
            if (key_value.size() < 2) continue;
            attributes.put(URLDecoder.decode(key_value.get(0).trim(), "UTF-8"), URLDecoder.decode(key_value.get(1).trim(), "UTF-8"));
        }
        return attributes;
    }

    private void validateFeature(Gff3Feature feature) {
        if (this.sequenceRegionMap.containsKey(feature.getContig())) {
            SequenceRegion region = this.sequenceRegionMap.get(feature.getContig());
            if (feature.getStart() == region.getStart() && feature.getEnd() == region.getEnd()) {
                boolean isCircular = Boolean.parseBoolean(feature.getAttribute(IS_CIRCULAR_ATTRIBUTE_KEY));
                region.setCircular(isCircular);
            }
            if (region.isCircular() ? !region.overlaps(feature) : !region.contains(feature)) {
                throw new TribbleException("feature at " + feature.getContig() + ":" + feature.getStart() + "-" + feature.getEnd() + " not contained in specified sequence region (" + region.getContig() + ":" + region.getStart() + "-" + region.getEnd());
            }
        }
    }

    @Override
    public Feature decodeLoc(LineIterator lineIterator) {
        String line = (String)lineIterator.next();
        if (line.startsWith(COMMENT_START)) {
            return null;
        }
        List<String> splitLine = ParsingUtils.split(line, '\t');
        try {
            return new SimpleFeature(splitLine.get(0), Integer.parseInt(splitLine.get(3)), Integer.parseInt(splitLine.get(4)));
        }
        catch (NumberFormatException ex) {
            throw new TribbleException("Cannot read integer value for start/end position!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canDecode(String inputFilePath) {
        try {
            Path p = IOUtil.getPath(inputFilePath);
            boolean canDecode = FileExtensions.GFF3.stream().anyMatch(fe -> p.toString().endsWith((String)fe));
            if (!canDecode) return canDecode;
            InputStream inputStream = IOUtil.hasGzipFileExtension(p) ? new GZIPInputStream(Files.newInputStream(p, new OpenOption[0])) : Files.newInputStream(p, new OpenOption[0]);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line = br.readLine();
                if (Gff3Directive.toDirective(line) != Gff3Directive.VERSION3_DIRECTIVE) {
                    boolean bl = false;
                    return bl;
                }
                while (line.startsWith(COMMENT_START)) {
                    line = br.readLine();
                    if (line != null) continue;
                    boolean bl = false;
                    return bl;
                }
                List<String> fields = ParsingUtils.split(line, '\t');
                if (!(canDecode &= fields.size() == 9)) return canDecode;
                try {
                    int start = Integer.parseInt(fields.get(3));
                    int n = Integer.parseInt(fields.get(4));
                }
                catch (NullPointerException | NumberFormatException nfe) {
                    boolean bl = false;
                    if (br == null) return bl;
                    if (var6_8 == null) {
                        br.close();
                        return bl;
                    }
                    try {
                        br.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var6_8.addSuppressed(throwable);
                        return bl;
                    }
                }
                String strand = fields.get(6);
                canDecode &= strand.equals(Strand.POSITIVE.toString()) || strand.equals(Strand.NEGATIVE.toString()) || strand.equals(Strand.NONE.toString()) || strand.equals("?");
                return canDecode;
            }
        }
        catch (FileNotFoundException ex) {
            logger.error(inputFilePath + " not found.");
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public FeatureCodecHeader readHeader(LineIterator lineIterator) {
        String line;
        ArrayList<String> header = new ArrayList<String>();
        while (lineIterator.hasNext() && (line = lineIterator.peek()).startsWith(COMMENT_START)) {
            header.add(line);
            lineIterator.next();
        }
        return new FeatureCodecHeader(header, 0L);
    }

    private void parseDirective(String directiveLine) throws IOException {
        Gff3Directive directive = Gff3Directive.toDirective(directiveLine);
        if (directive != null) {
            this.processDirective(directive, directive.decode(directiveLine));
        } else {
            logger.warn("ignoring directive " + directiveLine);
        }
    }

    private void processDirective(Gff3Directive directive, Object decodedResult) {
        switch (directive) {
            case VERSION3_DIRECTIVE: {
                break;
            }
            case SEQUENCE_REGION_DIRECTIVE: {
                SequenceRegion newRegion = (SequenceRegion)decodedResult;
                if (this.sequenceRegionMap.containsKey(newRegion.getContig())) {
                    throw new TribbleException("directive for sequence-region " + newRegion.getContig() + " included more than once.");
                }
                this.sequenceRegionMap.put(newRegion.getContig(), newRegion);
                break;
            }
            case FLUSH_DIRECTIVE: {
                this.prepareToFlushFeatures();
                break;
            }
            case FASTA_DIRECTIVE: {
                this.reachedFasta = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Directive " + (Object)((Object)directive) + " has been added to Gff3Directive, but is not being handled by Gff3Codec::processDirective.  This is a BUG.");
            }
        }
    }

    private void prepareToFlushFeatures() {
        this.featuresToFlush.addAll(this.activeFeatures);
        this.activeFeaturesWithIDs.clear();
        this.activeFeatures.clear();
        this.activeParentIDs.clear();
    }

    @Override
    public LineIterator makeSourceFromStream(InputStream bufferedInputStream) {
        return new LineIteratorImpl(new SynchronousLineReader(bufferedInputStream));
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        return new AsciiLineReaderIterator(AsciiLineReader.from(bufferedInputStream));
    }

    @Override
    public boolean isDone(LineIterator lineIterator) {
        return !lineIterator.hasNext() && this.activeFeatures.isEmpty() && this.featuresToFlush.isEmpty();
    }

    @Override
    public void close(LineIterator lineIterator) {
        this.featuresToFlush.clear();
        this.activeFeaturesWithIDs.clear();
        this.activeFeatures.clear();
        this.activeParentIDs.clear();
        CloserUtil.close(lineIterator);
    }

    @Override
    public TabixFormat getTabixFormat() {
        return TabixFormat.GFF;
    }

    static enum Gff3Directive {
        VERSION3_DIRECTIVE("##gff-version\\s+3(?:.\\d)*(?:\\.\\d)*$"),
        SEQUENCE_REGION_DIRECTIVE("##sequence-region\\s+.+ \\d+ \\d+$"){
            private int CONTIG_INDEX = 1;
            private int START_INDEX = 2;
            private int END_INDEX = 3;

            @Override
            public Object decode(String line) throws IOException {
                String[] splitLine = line.split("\\s+");
                String contig = URLDecoder.decode(splitLine[this.CONTIG_INDEX], "UTF-8");
                int start = Integer.parseInt(splitLine[this.START_INDEX]);
                int end = Integer.parseInt(splitLine[this.END_INDEX]);
                return new SequenceRegion(contig, start, end);
            }
        }
        ,
        FLUSH_DIRECTIVE("###$"),
        FASTA_DIRECTIVE("##FASTA$");

        private final Pattern regexPattern;

        private Gff3Directive(String regex) {
            this.regexPattern = Pattern.compile(regex);
        }

        public static Gff3Directive toDirective(String line) {
            for (Gff3Directive directive : Gff3Directive.values()) {
                if (!directive.regexPattern.matcher(line).matches()) continue;
                return directive;
            }
            return null;
        }

        public Object decode(String line) throws IOException {
            return null;
        }
    }
}

