/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;

public class ShutdownThread
extends Thread {
    private static Logger log = Logger.getLogger(ShutdownThread.class);
    private static long oneDayMS = 86400000L;

    public static void runS() {
        log.info((Object)"Shutting down");
        CommandListener.halt();
        if (IGV.hasInstance()) {
            IGV.getInstance().saveStateForExit();
            for (Track t : IGV.getInstance().getAllTracks()) {
                t.dispose();
            }
        }
    }

    @Override
    public void run() {
        ShutdownThread.runS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info((Object)"A blank Region of Interest export file was supplied!");
            return;
        }
        try {
            Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getAllRegionsOfInterest();
            if (regions == null || regions.isEmpty()) {
                return;
            }
            roiFile.createNewFile();
            try (PrintWriter writer = null;){
                writer = new PrintWriter(roiFile);
                for (RegionOfInterest regionOfInterest : regions) {
                    Integer regionStart = regionOfInterest.getStart();
                    if (regionStart == null) continue;
                    Integer regionEnd = regionOfInterest.getEnd();
                    if (regionEnd == null) {
                        regionEnd = regionStart;
                    }
                    writer.print(regionOfInterest.getChr());
                    writer.print("\t");
                    writer.print(regionStart);
                    writer.print("\t");
                    writer.print(regionEnd);
                    if (regionOfInterest.getDescription() != null) {
                        writer.print("\t");
                        writer.println(regionOfInterest.getDescription());
                        continue;
                    }
                    writer.println();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to write Region of Interest export file!", (Throwable)e);
        }
    }
}

