/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.GFFFeature;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.Strand;

public class GFFCombiner {
    List<Feature> igvFeatures;
    Map<String, GFFFeature> gffFeatures;
    List<BasicFeature> gffExons;
    Map<String, GFFCdsCltn> gffCdss;
    List<BasicFeature> gffUtrs;
    List<BasicFeature> gffMrnaParts;

    public GFFCombiner() {
        int numElements = 10000;
        this.igvFeatures = new ArrayList<Feature>(numElements);
        this.gffFeatures = new HashMap<String, GFFFeature>(numElements);
        this.gffExons = new ArrayList<BasicFeature>(numElements);
        this.gffCdss = new LinkedHashMap<String, GFFCdsCltn>(numElements);
        this.gffUtrs = new ArrayList<BasicFeature>(numElements);
        this.gffMrnaParts = new ArrayList<BasicFeature>(numElements);
    }

    public GFFCombiner addFeatures(Iterator<Feature> rawIter) {
        while (rawIter.hasNext()) {
            this.addFeature((BasicFeature)rawIter.next());
        }
        return this;
    }

    public void addFeature(BasicFeature bf) {
        String featureType = bf.getType();
        String[] parentIDs = bf.getParentIds();
        String id = bf.getIdentifier();
        if (SequenceOntology.mrnaParts.contains(featureType) && parentIDs != null) {
            this.gffMrnaParts.add(bf);
            if (SequenceOntology.exonTypes.contains(featureType) && parentIDs != null) {
                this.gffExons.add(bf);
            } else if (SequenceOntology.utrTypes.contains(featureType) && parentIDs != null) {
                this.gffUtrs.add(bf);
            } else if (SequenceOntology.cdsTypes.contains(featureType) && parentIDs != null) {
                for (String pid : parentIDs) {
                    GFFCdsCltn cds = this.gffCdss.get(pid);
                    if (cds == null) {
                        cds = new GFFCdsCltn(pid);
                        this.gffCdss.put(pid, cds);
                    }
                    cds.addPart(bf);
                }
            }
        } else if (id != null) {
            this.gffFeatures.put(id, new GFFFeature(bf));
        } else {
            this.igvFeatures.add(bf);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Feature> combineFeatures() {
        Object parent;
        for (BasicFeature gffExon : this.gffExons) {
            String[] parentIds;
            String[] stringArray = parentIds = gffExon.getParentIds();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                void var8_21;
                String parentId = stringArray[i];
                GFFFeature gFFFeature = this.gffFeatures.get(parentId);
                if (gFFFeature == null) {
                    GFFFeature gFFFeature2 = this.createParent(gffExon);
                    gFFFeature2.setIdentifier(parentId);
                    gFFFeature2.setName(parentId);
                    this.gffFeatures.put(parentId, gFFFeature2);
                }
                Exon exon = new Exon(gffExon);
                exon.setNonCoding(!SequenceOntology.isCoding(gffExon.getType()));
                var8_21.addExon(exon);
            }
        }
        for (BasicFeature utr : this.gffUtrs) {
            for (String parentId : utr.getParentIds()) {
                parent = this.gffFeatures.get(parentId);
                if (parent == null) {
                    parent = this.createParent(utr);
                    ((BasicFeature)parent).setIdentifier(parentId);
                    ((AbstractFeature)parent).setName(parentId);
                    this.gffFeatures.put(parentId, (GFFFeature)parent);
                }
                ((GFFFeature)parent).addUTRorCDS(utr);
            }
        }
        for (GFFCdsCltn gffCdsCltn : this.gffCdss.values()) {
            String[] parentId = gffCdsCltn.getParentId();
            GFFFeature parent3 = this.gffFeatures.get(parentId);
            if (parent3 == null) {
                parent3 = new GFFFeature(gffCdsCltn.chr, gffCdsCltn.start, gffCdsCltn.end, gffCdsCltn.strand);
                parent3.setIdentifier((String)parentId);
                parent3.setName((String)parentId);
                this.gffFeatures.put((String)parentId, parent3);
            }
            if (gffCdsCltn.isUniqueIds()) {
                for (BasicFeature cdsPart : gffCdsCltn.getParts()) {
                    parent3.addUTRorCDS(cdsPart);
                }
                continue;
            }
            Map<String, List<BasicFeature>> cdsPartsMap = gffCdsCltn.getPartsById();
            boolean first = true;
            for (Map.Entry entry : cdsPartsMap.entrySet()) {
                BasicFeature isoform;
                List cdsParts = (List)entry.getValue();
                if (first) {
                    isoform = parent3;
                } else {
                    isoform = GFFCombiner.copyForCDS(parent3);
                    this.igvFeatures.add(isoform);
                }
                for (BasicFeature cds : cdsParts) {
                    isoform.addUTRorCDS(cds);
                }
                first = false;
            }
        }
        for (BasicFeature mrnaPart : this.gffMrnaParts) {
            for (String parentId : mrnaPart.getParentIds()) {
                parent = this.gffFeatures.get(parentId);
                if (parent == null) {
                    this.igvFeatures.add(mrnaPart);
                    continue;
                }
                ((GFFFeature)parent).mergeAttributes(mrnaPart);
            }
        }
        this.igvFeatures.addAll(this.gffFeatures.values());
        for (Feature f : this.igvFeatures) {
            BasicFeature bf = (BasicFeature)f;
            if (!bf.hasExons()) continue;
            bf.sortExons();
            List<Exon> exons = bf.getExons();
            int exonNumber = bf.getStrand() == Strand.NEGATIVE ? exons.size() : 1;
            int increment = bf.getStrand() == Strand.NEGATIVE ? -1 : 1;
            for (Exon exon : exons) {
                exon.setNumber(exonNumber);
                exonNumber += increment;
            }
        }
        FeatureUtils.sortFeatureList(this.igvFeatures);
        return this.igvFeatures;
    }

    private GFFFeature createParent(BasicFeature gffExon) {
        return new GFFFeature(gffExon.getChr(), gffExon.getStart(), gffExon.getEnd(), gffExon.getStrand());
    }

    private static BasicFeature copyForCDS(BasicFeature bf) {
        BasicFeature copy = new BasicFeature(bf.getChr(), bf.getStart(), bf.getEnd(), bf.getStrand());
        copy.setName(bf.getName());
        copy.setColor(bf.getColor());
        copy.setIdentifier(bf.getIdentifier());
        copy.setURL(bf.getURL());
        copy.setType(bf.getType());
        for (Exon ex : bf.getExons()) {
            Exon newExon = new Exon(ex);
            newExon.setNonCoding(true);
            copy.addExon(newExon);
        }
        return copy;
    }

    public static class GFFCdsCltn {
        String parentId;
        List<BasicFeature> cdsParts;
        String chr;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        Strand strand;

        public GFFCdsCltn(String parentId) {
            this.parentId = parentId;
            this.cdsParts = new ArrayList<BasicFeature>(5);
        }

        public void addPart(BasicFeature bf) {
            this.cdsParts.add(bf);
            this.chr = bf.getChr();
            this.start = Math.min(this.start, bf.getStart());
            this.end = Math.max(this.end, bf.getEnd());
            this.strand = bf.getStrand();
        }

        public String getParentId() {
            return this.parentId;
        }

        public List<BasicFeature> getParts() {
            return this.cdsParts;
        }

        public Map<String, List<BasicFeature>> getPartsById() {
            HashMap<String, List<BasicFeature>> map = new HashMap<String, List<BasicFeature>>();
            for (BasicFeature bf : this.cdsParts) {
                String id = bf.getIdentifier();
                ArrayList<BasicFeature> parts = (ArrayList<BasicFeature>)map.get(id);
                if (parts == null) {
                    parts = new ArrayList<BasicFeature>();
                    map.put(id, parts);
                }
                parts.add(bf);
            }
            return map;
        }

        public boolean isUniqueIds() {
            if (this.cdsParts.isEmpty()) {
                return true;
            }
            Iterator<BasicFeature> iter = this.cdsParts.iterator();
            String firstId = iter.next().getIdentifier();
            while (iter.hasNext()) {
                BasicFeature bf = iter.next();
                if (!firstId.equals(bf.getIdentifier())) continue;
                return false;
            }
            return true;
        }
    }
}

