/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jidesoft.swing.JideSplitPane;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.ProgressMonitor;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.ShiftEvent;
import org.broad.igv.event.StopEvent;
import org.broad.igv.event.TrackGroupEvent;
import org.broad.igv.event.ViewChange;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.MaximumContigGenomeException;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeBuilderDialog;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.google.OAuthUtils;
import org.broad.igv.lists.GeneList;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesEditor;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionSelectionEvent;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.IndexAwareSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.UCSCSessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.DesktopIntegration;
import org.broad.igv.ui.IGVContentPane;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.PanelName;
import org.broad.igv.ui.ShowDetailsBehavior;
import org.broad.igv.ui.StatusWindow;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.CheckListDialog;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.SnapshotFileChooser;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLUtils;
import org.broad.igv.variant.VariantTrack;

public class IGV
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(IGV.class);
    private static IGV theInstance;
    private Frame mainFrame;
    private JRootPane rootPane;
    private IGVContentPane contentPane;
    private IGVMenuBar menuBar;
    private StatusWindow statusWindow;
    Component glassPane;
    GhostGlassPane dNdGlassPane;
    public static Cursor fistCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static Cursor dragNDropCursor;
    Session session;
    private GenomeManager genomeManager;
    private String groupByAttribute = null;
    private Map<String, List<Track>> overlayTracksMap = new HashMap<String, List<Track>>();
    private Set<Track> overlaidTracks = new HashSet<Track>();
    public static final String DATA_PANEL_NAME = "DataPanel";
    public static final String FEATURE_PANEL_NAME = "FeaturePanel";
    private LinkedList<String> recentSessionList = new LinkedList();
    private boolean isExportingSnapshot = false;
    private List<JComponent> otherToolMenus = new ArrayList<JComponent>();
    private boolean rulerEnabled;
    JCheckBoxMenuItem showPeakMenuItem;

    public static IGV createInstance(Frame frame) {
        if (theInstance != null) {
            throw new RuntimeException("Only a single instance is allowed.");
        }
        theInstance = new IGV(frame);
        return theInstance;
    }

    public static IGV getInstance() {
        if (theInstance == null) {
            throw new RuntimeException("IGV has not been initialized.  Must call createInstance(Frame) first");
        }
        return theInstance;
    }

    static void destroyInstance() {
        IGVMenuBar.destroyInstance();
        theInstance = null;
    }

    public static boolean hasInstance() {
        return theInstance != null;
    }

    public static JRootPane getRootPane() {
        return IGV.getInstance().rootPane;
    }

    public static Frame getMainFrame() {
        return IGV.getInstance().mainFrame;
    }

    private IGV(Frame frame) {
        theInstance = this;
        IGVPreferences preferences = PreferencesManager.getPreferences();
        this.genomeManager = GenomeManager.getInstance();
        this.mainFrame = frame;
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }
        });
        this.session = new Session(null);
        this.createHandCursor();
        this.createZoomCursors();
        this.createDragAndDropCursor();
        this.mainFrame.setTitle("IGV");
        if (this.mainFrame instanceof JFrame) {
            JFrame jf = (JFrame)this.mainFrame;
            this.rootPane = jf.getRootPane();
        } else {
            this.rootPane = new JRootPane();
            this.mainFrame.add(this.rootPane);
        }
        this.contentPane = new IGVContentPane(this);
        this.menuBar = IGVMenuBar.createInstance(this);
        this.rootPane.setContentPane(this.contentPane);
        this.rootPane.setJMenuBar(this.menuBar);
        this.glassPane = this.rootPane.getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.dNdGlassPane = new GhostGlassPane();
        this.mainFrame.pack();
        this.mainFrame.setMinimumSize(new Dimension(300, 300));
        Dimension screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle applicationBounds = preferences.getApplicationFrameBounds();
        if (applicationBounds == null || applicationBounds.getMaxX() > screenBounds.getWidth() || applicationBounds.getMaxY() > screenBounds.getHeight() || applicationBounds.width == 0 || applicationBounds.height == 0) {
            int width = Math.min(1150, (int)screenBounds.getWidth());
            int height = Math.min(800, (int)screenBounds.getHeight());
            applicationBounds = new Rectangle(0, 0, width, height);
        }
        this.mainFrame.setBounds(applicationBounds);
        this.subscribeToEvents();
    }

    private void consumeEvents(final Component glassPane) {
        glassPane.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent e) {
                Point glassPanePoint = e.getPoint();
                IGVContentPane container = IGV.this.contentPane;
                Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, container);
                Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
                if (component == IGV.this.contentPane.getStatusBar().stopButton) {
                    IGVEventBus.getInstance().post(new StopEvent());
                }
                e.consume();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                e.consume();
            }
        });
        glassPane.setFocusable(true);
        glassPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }
        });
    }

    public GhostGlassPane getDnDGlassPane() {
        return this.dNdGlassPane;
    }

    public void startDnD() {
        this.rootPane.setGlassPane(this.dNdGlassPane);
        this.dNdGlassPane.setVisible(true);
    }

    public void endDnD() {
        this.rootPane.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
    }

    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    public void addRegionOfInterest(RegionOfInterest roi) {
        this.session.addRegionOfInterestWithNoListeners(roi);
        RegionOfInterestPanel.setSelectedRegion(roi);
        this.doRefresh();
    }

    public void beginROI(JButton button) {
        for (TrackPanel tp : this.getTrackPanels()) {
            TrackPanelScrollPane tsv = tp.getScrollPane();
            DataPanelContainer dpc = tsv.getDataPanel();
            for (Component c : dpc.getComponents()) {
                if (!(c instanceof DataPanel)) continue;
                DataPanel dp = (DataPanel)c;
                RegionOfInterestTool regionOfInterestTool = new RegionOfInterestTool(dp, button);
                dp.setCurrentTool(regionOfInterestTool);
            }
        }
    }

    public void endROI() {
        for (TrackPanel tp : this.getTrackPanels()) {
            DataPanelContainer dp = tp.getScrollPane().getDataPanel();
            dp.setCurrentTool(null);
        }
    }

    public void focusSearchBox() {
        this.contentPane.getCommandBar().focusSearchBox();
    }

    public void selectGenomeFromList(String genomeId) {
        this.contentPane.getCommandBar().selectGenome(genomeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineGenome(ProgressMonitor monitor) {
        String genomePath;
        Dialog progressDialog = null;
        File archiveFile = null;
        try {
            GenomeBuilderDialog genomeBuilderDialog = new GenomeBuilderDialog(this.mainFrame, this);
            genomeBuilderDialog.setVisible(true);
            File genomeZipFile = genomeBuilderDialog.getArchiveFile();
            if (genomeBuilderDialog.isCanceled() || genomeZipFile == null) {
                return;
            }
            String cytobandFileName = genomeBuilderDialog.getCytobandFileName();
            String geneAnnotFileName = genomeBuilderDialog.getGeneAnnotFileName();
            String fastaFileName = genomeBuilderDialog.getFastaFileName();
            String chrAliasFile = genomeBuilderDialog.getChrAliasFileName();
            String genomeDisplayName = genomeBuilderDialog.getGenomeDisplayName();
            String genomeId = genomeBuilderDialog.getGenomeId();
            GenomeListItem genomeListItem = this.getGenomeManager().defineGenome(genomeZipFile, cytobandFileName, geneAnnotFileName, fastaFileName, chrAliasFile, genomeDisplayName, genomeId, monitor);
            if (genomeListItem != null) {
                this.contentPane.getCommandBar().refreshGenomeListComboBox();
                this.contentPane.getCommandBar().selectGenome(genomeListItem.getId());
            }
            if (monitor != null) {
                monitor.setProgress(100);
            }
        }
        catch (MaximumContigGenomeException e) {
            genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error((Object)("Failed to define genome: " + genomePath), (Throwable)e);
            JOptionPane.showMessageDialog(this.mainFrame, "Failed to define genome " + genomePath + "\n" + e.getMessage());
        }
        catch (GenomeException e) {
            log.error((Object)"Failed to define genome.", (Throwable)e);
            MessageUtils.showMessage(e.getMessage());
        }
        catch (Exception e) {
            genomePath = "";
            if (archiveFile != null) {
                genomePath = archiveFile.getAbsolutePath();
            }
            log.error((Object)("Failed to define genome: " + genomePath), (Throwable)e);
            MessageUtils.showMessage("Unexpected error while importing a genome: " + e.getMessage());
        }
        finally {
            if (progressDialog != null) {
                progressDialog.setVisible(false);
            }
        }
    }

    public void enableExtrasMenu() {
        this.menuBar.enableExtrasMenu();
    }

    public Future loadTracks(final Collection<ResourceLocator> locators) {
        this.contentPane.getStatusBar().setMessage("Loading ...");
        log.debug((Object)"Run loadTracks");
        Future toRet = null;
        if (locators != null && !locators.isEmpty()) {
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    List<Map<TrackPanelScrollPane, Integer>> trackPanelAttrs = IGV.this.getTrackPanelAttrs();
                    IGV.this.loadResources(locators);
                    IGV.this.resetPanelHeights(trackPanelAttrs.get(0), trackPanelAttrs.get(1));
                    IGV.this.showLoadedTrackCount();
                }

                @Override
                public String getName() {
                    return "Load Tracks";
                }
            };
            toRet = LongRunningTask.submit(runnable);
        }
        log.debug((Object)"Finish loadTracks");
        return toRet;
    }

    public List<Map<TrackPanelScrollPane, Integer>> getTrackPanelAttrs() {
        HashMap<TrackPanelScrollPane, Integer> trackCountMap = new HashMap<TrackPanelScrollPane, Integer>();
        HashMap<TrackPanelScrollPane, Integer> panelSizeMap = new HashMap<TrackPanelScrollPane, Integer>();
        for (TrackPanel tp : this.getTrackPanels()) {
            TrackPanelScrollPane sp = tp.getScrollPane();
            trackCountMap.put(sp, sp.getDataPanel().getAllTracks().size());
            panelSizeMap.put(sp, sp.getDataPanel().getHeight());
        }
        return Arrays.asList(trackCountMap, panelSizeMap);
    }

    public void resetPanelHeights(Map<TrackPanelScrollPane, Integer> trackCountMap, Map<TrackPanelScrollPane, Integer> panelSizeMap) {
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            double totalHeight = 0.0;
            for (TrackPanel tp : this.getTrackPanels()) {
                int prevTrackCount;
                TrackPanelScrollPane sp = tp.getScrollPane();
                if (trackCountMap.containsKey(sp) && (prevTrackCount = ((Integer)trackCountMap.get(sp)).intValue()) != sp.getDataPanel().getAllTracks().size()) {
                    int scrollPosition = (Integer)panelSizeMap.get(sp);
                    if (prevTrackCount != 0 && sp.getVerticalScrollBar().isShowing()) {
                        sp.getVerticalScrollBar().setMaximum(sp.getDataPanel().getHeight());
                        sp.getVerticalScrollBar().setValue(scrollPosition);
                    }
                }
                if (sp.getTrackPanel().getTracks().size() <= 0) continue;
                totalHeight += (double)Math.min(300, sp.getTrackPanel().getPreferredPanelHeight());
            }
            JideSplitPane centerSplitPane = this.contentPane.getMainPanel().getCenterSplitPane();
            int htotal = centerSplitPane.getHeight();
            int y = 0;
            int i = 0;
            for (Component c : centerSplitPane.getComponents()) {
                if (!(c instanceof TrackPanelScrollPane)) continue;
                TrackPanel trackPanel = ((TrackPanelScrollPane)((Object)c)).getTrackPanel();
                if (trackPanel.getTracks().size() > 0) {
                    int panelWeight = Math.min(300, trackPanel.getPreferredPanelHeight());
                    int dh = (int)((double)panelWeight / totalHeight * (double)htotal);
                    y += dh;
                }
                centerSplitPane.setDividerLocation(i, y);
                ++i;
            }
            this.contentPane.getMainPanel().invalidate();
        });
    }

    public void setGeneList(GeneList geneList) {
        this.setGeneList(geneList, true);
    }

    public void setGeneList(final GeneList geneList, final boolean recordHistory) {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingUtilities.invokeLater(new NamedRunnable(){

            @Override
            public void run() {
                try {
                    if (geneList == null) {
                        IGV.this.session.setCurrentGeneList(null);
                    } else {
                        if (recordHistory) {
                            IGV.this.session.getHistory().push("List: " + geneList.getName(), 0);
                        }
                        IGV.this.session.setCurrentGeneList(geneList);
                    }
                    IGV.this.resetFrames();
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public String getName() {
                return "Set gene list";
            }
        });
    }

    public void setDefaultFrame(String searchString) {
        FrameManager.setToDefaultFrame(searchString);
        this.resetFrames();
    }

    public final void doViewPreferences() {
        try {
            PreferencesEditor.open(this.mainFrame);
        }
        catch (Exception e) {
            log.error((Object)"Error openining preference dialog", (Throwable)e);
        }
    }

    public final void saveStateForExit() {
        if (!this.getRecentSessionList().isEmpty()) {
            int size = this.getRecentSessionList().size();
            if (size > 3) {
                size = 3;
            }
            Object recentSessions = "";
            for (int i = 0; i < size; ++i) {
                recentSessions = (String)recentSessions + this.getRecentSessionList().get(i);
                if (i >= size - 1) continue;
                recentSessions = (String)recentSessions + ";";
            }
            PreferencesManager.getPreferences().remove("IGV.Session.recent.sessions");
            PreferencesManager.getPreferences().setRecentSessions((String)recentSessions);
        }
    }

    public final void doShowAttributeDisplay(boolean enableAttributeView) {
        boolean oldState = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
        if (oldState != enableAttributeView) {
            PreferencesManager.getPreferences().setShowAttributeView(enableAttributeView);
            this.doRefresh();
        }
    }

    public final void doSelectDisplayableAttribute() {
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        CheckListDialog dlg = new CheckListDialog(this.mainFrame, allAttributes, hiddenAttributes, false);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            Set<String> selections = dlg.getSelections();
            for (String att : AttributeManager.defaultTrackAttributes) {
                if (!selections.contains(att)) continue;
                PreferencesManager.getPreferences().put("SHOW_DEFAULT_TRACK_ATTRIBUTES", true);
                break;
            }
            IGV.getInstance().getSession().setHiddenAttributes(dlg.getNonSelections());
            this.doRefresh();
        }
    }

    public final void saveImage(Component target) {
        this.saveImage(target, "igv_snapshot");
    }

    public final void saveImage(Component target, String title) {
        this.contentPane.getStatusBar().setMessage("Creating image...");
        File defaultFile = new File(title + ".png");
        this.createSnapshot(target, defaultFile);
    }

    public boolean isExportingSnapshot() {
        return this.isExportingSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSnapshot(Component target, File defaultFile) {
        File file = this.selectSnapshotFile(defaultFile);
        if (file == null) {
            return;
        }
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            this.contentPane.getStatusBar().setMessage("Exporting image: " + defaultFile.getAbsolutePath());
            String msg = this.createSnapshotNonInteractive(target, file, false);
            if (msg != null && msg.toLowerCase().startsWith("error")) {
                MessageUtils.showMessage(msg);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error creating exporting image ", (Throwable)e);
            MessageUtils.showMessage("Error creating the image file: " + defaultFile + "<br> " + e.getMessage());
        }
        finally {
            if (token != null) {
                WaitCursorManager.removeWaitCursor(token);
            }
            this.resetStatusMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSnapshotNonInteractive(Component target, File file, boolean paintOffscreen) throws Exception {
        String message;
        log.debug((Object)("Creating snapshot: " + file.getName()));
        String extension = FileUtils.getFileExtension(file.getAbsolutePath());
        if (extension == null) {
            extension = ".png";
            file = new File(file.getAbsolutePath() + extension);
        }
        SnapshotFileChooser.SnapshotFileType type = SnapshotFileChooser.getSnapshotFileType(extension);
        Exception exc = null;
        if (type == SnapshotFileChooser.SnapshotFileType.NULL) {
            String message2 = "ERROR: Unknown file extension " + extension;
            log.error((Object)message2);
            return message2;
        }
        if (type == SnapshotFileChooser.SnapshotFileType.EPS && !SnapshotUtilities.canExportScreenshotEps()) {
            String message3 = "ERROR: EPS output requires EPSGraphics library. See https://www.broadinstitute.org/software/igv/third_party_tools#epsgraphics";
            log.error((Object)message3);
            return message3;
        }
        try {
            this.setExportingSnapshot(true);
            message = SnapshotUtilities.doComponentSnapshot(target, file, type, paintOffscreen);
        }
        catch (Exception e) {
            exc = e;
            message = e.getMessage();
        }
        finally {
            this.setExportingSnapshot(false);
        }
        log.debug((Object)("Finished creating snapshot: " + file.getName()));
        if (exc != null) {
            throw exc;
        }
        return message;
    }

    public File selectSnapshotFile(File defaultFile) {
        File directory;
        File snapshotDirectory = PreferencesManager.getPreferences().getLastSnapshotDirectory();
        SnapshotFileChooser fc = new SnapshotFileChooser(snapshotDirectory, defaultFile);
        fc.showSaveDialog(this.mainFrame);
        File file = fc.getSelectedFile();
        if (file != null && (directory = file.getParentFile()) != null) {
            PreferencesManager.getPreferences().setLastSnapshotDirectory(directory);
        }
        return file;
    }

    private void createZoomCursors() throws HeadlessException, IndexOutOfBoundsException {
        if (zoomInCursor == null || zoomOutCursor == null) {
            Image zoomInImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_IN).getImage();
            Image zoomOutImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_OUT).getImage();
            Point hotspot = new Point(10, 10);
            zoomInCursor = this.createCustomCursor(zoomInImage, hotspot, "Zoom in", 1);
            zoomOutCursor = this.createCustomCursor(zoomOutImage, hotspot, "Zoom out", 0);
        }
    }

    private void createHandCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (fistCursor == null) {
            final BufferedImage handImage = new BufferedImage(32, 32, 2);
            Graphics2D g = handImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g.fill(rect);
            g = handImage.createGraphics();
            boolean ready = g.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if ((infoflags & 0x20) != 0) {
                        fistCursor = IGV.this.createCustomCursor(handImage, new Point(8, 6), "Move", 12);
                        return false;
                    }
                    return true;
                }
            });
            if (ready) {
                try {
                    fistCursor = this.createCustomCursor(handImage, new Point(8, 6), "Move", 12);
                }
                catch (Exception e) {
                    log.info((Object)"Warning: could not create fistCursor");
                    fistCursor = Cursor.getPredefinedCursor(13);
                }
            }
        }
    }

    private void createDragAndDropCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (dragNDropCursor == null) {
            ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.DRAG_AND_DROP);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            final BufferedImage dragNDropImage = new BufferedImage(width, height, 2);
            Graphics2D g = dragNDropImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
            g.fill(rect);
            g = dragNDropImage.createGraphics();
            Image image = icon.getImage();
            boolean ready = g.drawImage(image, 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if ((infoflags & 0x20) != 0) {
                        dragNDropCursor = IGV.this.createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop", 1);
                        return false;
                    }
                    return true;
                }
            });
            if (ready) {
                dragNDropCursor = this.createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop", 0);
            }
        }
    }

    private Cursor createCustomCursor(Image image, Point hotspot, String name, int defaultCursor) {
        try {
            return this.mainFrame.getToolkit().createCustomCursor(image, hotspot, name);
        }
        catch (Exception e) {
            log.info((Object)("Could not create cursor: " + name));
            return Cursor.getPredefinedCursor(defaultCursor);
        }
    }

    public void resetSession(String sessionPath) {
        System.gc();
        List<Track> oldTracks = this.getAllTracks();
        AttributeManager.getInstance().clearAllAttributes();
        String tile = sessionPath == null ? "IGV" : sessionPath;
        this.mainFrame.setTitle(tile);
        this.menuBar.resetSessionActions();
        AttributeManager.getInstance().clearAllAttributes();
        if (this.session == null) {
            this.session = new Session(sessionPath);
        } else {
            this.session.reset(sessionPath);
        }
        this.contentPane.getMainPanel().resetPanels();
        SeekableFileStream.closeAllInstances();
        HashSet<Track> newTracks = new HashSet<Track>(this.getAllTracks());
        for (Track track : oldTracks) {
        }
        this.doRefresh();
        System.gc();
    }

    private void subscribeToEvents() {
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
        IGVEventBus.getInstance().subscribe(ShiftEvent.class, this);
        IGVEventBus.getInstance().subscribe(InsertionSelectionEvent.class, this);
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, this);
    }

    public void newSession() {
        this.resetSession(null);
        this.setGenomeTracks(GenomeManager.getInstance().getCurrentGenome().getGeneTrack());
        this.menuBar.disableReloadSession();
    }

    public void setStatusBarMessage(String message) {
        if (message.equals("Done.")) {
            this.resetStatusMessage();
        }
        this.contentPane.getStatusBar().setMessage(message);
    }

    public void setStatusBarMessag2(String message) {
        this.contentPane.getStatusBar().setMessage2(message);
    }

    public void setStatusBarMessage3(String message) {
        this.contentPane.getStatusBar().setMessage3(message);
    }

    public void enableStopButton(boolean enable) {
        this.contentPane.getStatusBar().enableStopButton(enable);
    }

    public void resetToFactorySettings() {
        try {
            PreferencesManager.getPreferences().clear();
            boolean isShow = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
            this.doShowAttributeDisplay(isShow);
            Preferences prefs = Preferences.userNodeForPackage(Globals.class);
            prefs.remove("igvDir");
            this.doRefresh();
        }
        catch (Exception e) {
            String message = "Failure while resetting preferences!";
            log.error((Object)message, (Throwable)e);
            MessageUtils.showMessage(message + ": " + e.getMessage());
        }
    }

    public void setFilterMatchAll(boolean value) {
        this.menuBar.setFilterMatchAll(value);
    }

    public boolean isFilterMatchAll() {
        return this.menuBar.isFilterMatchAll();
    }

    public void setFilterShowAllTracks(boolean value) {
        this.menuBar.setFilterShowAllTracks(value);
    }

    public boolean isFilterShowAllTracks() {
        return this.menuBar.isFilterShowAllTracks();
    }

    public TrackPanelScrollPane addDataPanel(String name) {
        return this.contentPane.getMainPanel().addDataPanel(name);
    }

    public TrackPanel getTrackPanel(String name) {
        for (TrackPanel sp : this.getTrackPanels()) {
            if (!name.equals(sp.getName())) continue;
            return sp;
        }
        TrackPanelScrollPane sp = this.addDataPanel(name);
        return sp.getTrackPanel();
    }

    public List<TrackPanel> getTrackPanels() {
        return this.contentPane.getMainPanel().getTrackPanels();
    }

    public boolean scrollToTrack(String trackName) {
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!tp.getScrollPane().getNamePanel().scrollTo(trackName)) continue;
            return true;
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }

    public final void doRestoreSession(File sessionFile, String locus) {
        if (sessionFile.exists()) {
            this.doRestoreSession(sessionFile.getAbsolutePath(), locus, false);
        } else {
            String message = "Session file does not exist! : " + sessionFile.getAbsolutePath();
            log.error((Object)message);
            MessageUtils.showMessage(message);
        }
    }

    public void doRestoreSession(final String sessionPath, final String locus, final boolean merge) {
        OAuthUtils.getInstance().getProvider().checkServerLogin(sessionPath);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IGV.this.restoreSessionSynchronous(sessionPath, locus, merge);
            }
        };
        LongRunningTask.submit(runnable);
    }

    public boolean restoreSessionSynchronous(String sessionPath, String locus, boolean merge) {
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(ParsingUtils.openInputStreamGZ(new ResourceLocator(sessionPath)));
            }
            catch (IOException e) {
                log.error((Object)"Error loading session", (Throwable)e);
                MessageUtils.showMessage("Error loading session: " + sessionPath);
                boolean bl = false;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Error closing session stream", (Throwable)iOException);
                    }
                    this.resetStatusMessage();
                }
                return bl;
            }
            if (!merge) {
                this.resetSession(sessionPath);
            }
            this.setStatusBarMessage("Opening session...");
            boolean e = this.restoreSessionFromStream(sessionPath, locus, inputStream);
            return e;
        }
        catch (Exception e) {
            String message = "Error loading session session : <br>&nbsp;&nbsp;" + sessionPath + "<br>" + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.error((Object)"Error closing session stream", (Throwable)iOException);
                }
                this.resetStatusMessage();
            }
        }
    }

    public boolean restoreSessionFromStream(String sessionPath, String locus, InputStream inputStream) throws IOException {
        String searchText;
        boolean isIndexAware;
        boolean isUCSC = sessionPath != null && (sessionPath.endsWith(".session") || sessionPath.endsWith(".session.txt"));
        boolean bl = isIndexAware = sessionPath != null && (sessionPath.endsWith(".idxsession") || sessionPath.endsWith(".idxsession.txt"));
        SessionReader sessionReader = isUCSC ? new UCSCSessionReader(this) : (isIndexAware ? new IndexAwareSessionReader(this) : new IGVSessionReader(this));
        sessionReader.loadSession(inputStream, this.session, sessionPath);
        String string = searchText = locus == null ? this.session.getLocus() : locus;
        if (!FrameManager.isGeneListMode() && searchText != null && !searchText.equals("All") && searchText.trim().length() > 0) {
            this.goToLocus(searchText);
        }
        System.gc();
        double[] dividerFractions = this.session.getDividerFractions();
        if (dividerFractions != null) {
            this.contentPane.getMainPanel().setDividerFractions(dividerFractions);
        }
        this.session.clearDividerLocations();
        RegionNavigatorDialog.destroyInstance();
        if (sessionPath != null) {
            this.mainFrame.setTitle("IGV - Session: " + sessionPath);
            if (!this.getRecentSessionList().contains(sessionPath)) {
                this.getRecentSessionList().addFirst(sessionPath);
            }
            this.menuBar.enableReloadSession();
        }
        this.doRefresh();
        return true;
    }

    public static String getPersistent(String key, String def) {
        if (IGV.hasInstance()) {
            return IGV.getInstance().getSession().getPersistent(key, def);
        }
        return PreferencesManager.getPreferences().getPersistent(key, def);
    }

    public void resetStatusMessage() {
        this.contentPane.getStatusBar().setMessage(this.getVisibleTrackCount() + " tracks loaded");
    }

    public void showLoadedTrackCount() {
        int visibleTrackCount = this.getVisibleTrackCount();
        this.contentPane.getStatusBar().setMessage(visibleTrackCount + (visibleTrackCount == 1 ? " track" : " tracks"));
    }

    private void closeWindow(final ProgressBar.ProgressDialog progressDialog) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
            }
        });
    }

    public void goToLocus(String locus) {
        this.contentPane.getCommandBar().searchByLocus(locus);
    }

    public void goToLociList(List<String> loci) {
        List<ReferenceFrame> frames = FrameManager.getFrames();
        if (frames.size() == loci.size()) {
            for (int i = 0; i < loci.size(); ++i) {
                frames.get(i).jumpTo(new Locus(loci.get(i)));
            }
            this.repaint();
        } else {
            GeneList geneList = new GeneList("", loci, false);
            this.getSession().setCurrentGeneList(geneList);
            this.resetFrames();
        }
    }

    public void tweakPanelDivider() {
        this.contentPane.getMainPanel().tweakPanelDivider();
    }

    public void removeDataPanel(String name) {
        this.contentPane.getMainPanel().removeDataPanel(name);
    }

    public void layoutMainPanel() {
        this.contentPane.getMainPanel().doLayout();
    }

    public MainPanel getMainPanel() {
        return this.contentPane.getMainPanel();
    }

    public void setExportingSnapshot(boolean exportingSnapshot) {
        this.isExportingSnapshot = exportingSnapshot;
        if (this.isExportingSnapshot) {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(false);
        } else {
            RepaintManager.currentManager(this.contentPane).setDoubleBufferingEnabled(true);
        }
    }

    public LinkedList<String> getRecentSessionList() {
        return this.recentSessionList;
    }

    public void setRecentSessionList(LinkedList<String> recentSessionList) {
        this.recentSessionList = recentSessionList;
    }

    public IGVContentPane getContentPane() {
        return this.contentPane;
    }

    public GenomeManager getGenomeManager() {
        return this.genomeManager;
    }

    public boolean isShowDetailsOnClick() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == ShowDetailsBehavior.CLICK;
    }

    public boolean isShowDetailsOnHover() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == ShowDetailsBehavior.HOVER;
    }

    public void openStatusWindow() {
        if (this.statusWindow == null) {
            this.statusWindow = new StatusWindow();
        }
        this.statusWindow.setVisible(true);
    }

    public void setStatusWindowText(String text) {
        if (this.statusWindow != null && this.statusWindow.isVisible()) {
            this.statusWindow.updateText(text);
        }
    }

    public void loadResources(Collection<ResourceLocator> locators) {
        log.info((Object)("Loading " + locators.size() + " resources."));
        MessageCollection messages = new MessageCollection();
        for (ResourceLocator locator : locators) {
            File trackSetFile;
            if (locator.isLocal() && !(trackSetFile = new File(locator.getPath())).exists()) {
                messages.append("File not found: " + locator.getPath() + "\n");
                continue;
            }
            try {
                List<Track> tracks = this.load(locator);
                this.addTracks(tracks, locator);
            }
            catch (Exception e) {
                log.error((Object)"Error loading track", (Throwable)e);
                messages.append("Error loading " + locator + ": " + e.getMessage());
            }
        }
        if (!messages.isEmpty()) {
            for (String message : messages.getMessages()) {
                MessageUtils.showMessage(message);
            }
        }
    }

    public void addTracks(List<Track> tracks, PanelName panelName) {
        TrackPanel panel = this.getTrackPanel(panelName.getName());
        panel.addTracks(tracks);
        this.doRefresh();
    }

    void addTracks(List<Track> tracks, ResourceLocator locator) {
        if (tracks.size() > 0) {
            Track t;
            String path = locator.getPath();
            TrackPanel panel = this.getPanelFor(locator);
            if ((path.endsWith(".vcf") || path.endsWith(".vcf.gz") || path.endsWith(".vcf4") || path.endsWith(".vcf4.gz")) && (t = tracks.get(0)) instanceof VariantTrack && ((VariantTrack)t).getAllSamples().size() > 10) {
                String newPanelName = "Panel" + System.currentTimeMillis();
                panel = this.addDataPanel(newPanelName).getTrackPanel();
            }
            panel.addTracks(tracks);
        }
    }

    public List<Track> load(ResourceLocator locator) throws DataLoadException {
        TrackLoader loader = new TrackLoader();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        List<Track> newTracks = loader.load(locator, genome);
        if (newTracks.size() > 0) {
            for (Track track : newTracks) {
                String fn = locator.getPath();
                int lastSlashIdx = fn.lastIndexOf("/");
                if (lastSlashIdx < 0) {
                    lastSlashIdx = fn.lastIndexOf("\\");
                }
                if (lastSlashIdx > 0) {
                    fn = fn.substring(lastSlashIdx + 1);
                }
                track.setAttributeValue("NAME", track.getName());
                track.setAttributeValue("DATA FILE", fn);
                track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
            }
        }
        return newTracks;
    }

    public void load(ResourceLocator locator, TrackPanel panel) throws DataLoadException {
        if (locator.getPath().endsWith(".xml") || locator.getPath().endsWith("session")) {
            boolean merge = false;
            this.doRestoreSession(locator.getPath(), null, merge);
        } else {
            Runnable runnable = () -> {
                List<Track> tracks = this.load(locator);
                panel.addTracks(tracks);
                this.doRefresh();
            };
            LongRunningTask.submit(runnable);
        }
    }

    public TrackPanel getPanelFor(ResourceLocator locator) {
        String path = locator.getPath().toLowerCase();
        if ("alist".equals(locator.getType())) {
            return this.getVcfBamPanel();
        }
        if (PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane")) {
            return this.getTrackPanel(DATA_PANEL_NAME);
        }
        if (TrackLoader.isAlignmentTrack(locator.getTypeString())) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.addDataPanel(newPanelName).getTrackPanel();
        }
        return this.getDefaultPanel(locator);
    }

    public Set<TrackType> getLoadedTypes() {
        HashSet<TrackType> types = new HashSet<TrackType>();
        for (Track t : this.getAllTracks()) {
            TrackType type = t.getTrackType();
            if (t == null) continue;
            types.add(type);
        }
        return types;
    }

    public TrackPanel getVcfBamPanel() {
        String panelName = "VCF_BAM";
        TrackPanel panel = this.getTrackPanel(panelName);
        if (panel != null) {
            return panel;
        }
        return this.addDataPanel(panelName).getTrackPanel();
    }

    private TrackPanel getDefaultPanel(ResourceLocator locator) {
        if (locator.getType() != null && locator.getType().equalsIgnoreCase("das")) {
            return this.getTrackPanel(FEATURE_PANEL_NAME);
        }
        String filename = locator.getPath().toLowerCase();
        if (filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") || filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        if (this.isAnnotationFile(filename)) {
            return this.getTrackPanel(FEATURE_PANEL_NAME);
        }
        return this.getTrackPanel(DATA_PANEL_NAME);
    }

    private boolean isAnnotationFile(String filename) {
        return filename.contains("refflat") || filename.contains("ucscgene") || filename.contains("genepred") || filename.contains("ensgene") || filename.contains("refgene") || filename.endsWith("gff") || filename.endsWith("gtf") || filename.endsWith("gff3") || filename.endsWith("embl") || filename.endsWith("bed") || filename.endsWith("gistic") || filename.endsWith("bedz") || filename.endsWith("repmask") || filename.contains("dranger") || filename.endsWith("ucscsnp");
    }

    public void reset() {
        this.groupByAttribute = null;
        for (TrackPanel sp : this.getTrackPanels()) {
            if (!DATA_PANEL_NAME.equals(sp.getName())) continue;
            sp.reset();
            break;
        }
    }

    public boolean sortAlignmentTracks(AlignmentTrack.SortOption option, String tag) {
        return this.sortAlignmentTracks(option, null, tag);
    }

    public boolean sortAlignmentTracks(AlignmentTrack.SortOption option, Double location, String tag) {
        boolean toRet = true;
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                double actloc = location != null ? location.doubleValue() : frame.getCenter();
                toRet &= ((AlignmentTrack)t).sortRows(option, frame, actloc, tag);
            }
        }
        return toRet;
    }

    public void groupAlignmentTracks(AlignmentTrack.GroupOption option, String tag, Range pos) {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        prefMgr.put("SAM.GROUP_OPTION", option.toString());
        if (option == AlignmentTrack.GroupOption.TAG && tag != null) {
            prefMgr.put("SAM.GROUP_BY_TAG", tag);
        }
        if (option == AlignmentTrack.GroupOption.BASE_AT_POS && pos != null) {
            prefMgr.put("SAM.GROUP_BY_POS", pos.getChr() + " " + String.valueOf(pos.getStart()));
        }
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).groupAlignments(option, tag, pos);
        }
    }

    public void packAlignmentTracks() {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).packAlignments();
        }
    }

    public void setTrackDisplayMode(Track.DisplayMode mode, String trackName) {
        for (Track t : this.getAllTracks()) {
            if (trackName != null && !t.getName().equals(trackName)) continue;
            t.setDisplayMode(mode);
        }
    }

    public void resetOverlayTracks() {
        List<Track> trackList;
        String sample;
        log.debug((Object)"Resetting Overlay Tracks");
        this.overlayTracksMap.clear();
        this.overlaidTracks.clear();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION || (sample = track.getSample()) == null) continue;
            trackList = this.overlayTracksMap.get(sample);
            if (trackList == null) {
                trackList = new ArrayList<Track>();
                this.overlayTracksMap.put(sample, trackList);
            }
            trackList.add(track);
        }
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() == TrackType.MUTATION || (sample = track.getSample()) == null || (trackList = this.overlayTracksMap.get(sample)) == null) continue;
            this.overlaidTracks.addAll(trackList);
        }
        boolean displayOverlays = this.getSession().getOverlayMutationTracks();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION) continue;
            track.setOverlayed(displayOverlays && this.overlaidTracks.contains(track));
        }
    }

    public List<Track> getOverlayTracks(Track track) {
        String sample = track.getSample();
        if (sample != null) {
            return this.overlayTracksMap.get(sample);
        }
        return null;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackPanel tsv : this.getTrackPanels()) {
            count += tsv.getVisibleTrackCount();
        }
        return count;
    }

    public List<Track> getAllTracks() {
        ArrayList<Track> allTracks = new ArrayList<Track>();
        for (TrackPanel tp : this.getTrackPanels()) {
            allTracks.addAll(tp.getTracks());
        }
        return allTracks;
    }

    public List<FeatureTrack> getFeatureTracks() {
        Iterable featureTracksIter = Iterables.filter(this.getAllTracks(), FeatureTrack.class);
        ArrayList featureTracks = Lists.newArrayList((Iterable)featureTracksIter);
        return featureTracks;
    }

    public List<DataTrack> getDataTracks() {
        Iterable dataTracksIter = Iterables.filter(this.getAllTracks(), DataTrack.class);
        ArrayList dataTracks = Lists.newArrayList((Iterable)dataTracksIter);
        return dataTracks;
    }

    public void clearSelections() {
        for (Track t : this.getAllTracks()) {
            if (t == null) continue;
            t.setSelected(false);
        }
    }

    public void setTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(true);
        }
    }

    public void shiftSelectTracks(Track track) {
        int clickedTrackIndex;
        List<Track> allTracks = this.getAllTracks();
        int otherIndex = clickedTrackIndex = allTracks.indexOf(track);
        for (int i = 0; i < allTracks.size(); ++i) {
            if (!allTracks.get(i).isSelected() || i == clickedTrackIndex) continue;
            otherIndex = i;
            break;
        }
        int left = Math.min(otherIndex, clickedTrackIndex);
        int right = Math.max(otherIndex, clickedTrackIndex);
        for (int i = left; i <= right; ++i) {
            Track t = allTracks.get(i);
            if (!t.isVisible()) continue;
            t.setSelected(true);
        }
    }

    public void toggleTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(!t.isSelected());
        }
    }

    public List<Track> getSelectedTracks() {
        ArrayList<Track> selectedTracks = new ArrayList<Track>();
        for (Track t : this.getAllTracks()) {
            if (t == null || !t.isSelected()) continue;
            selectedTracks.add(t);
        }
        return selectedTracks;
    }

    public Set<ResourceLocator> getDataResourceLocators() {
        HashSet<ResourceLocator> locators = new HashSet<ResourceLocator>();
        for (Track track : this.getAllTracks()) {
            Collection<ResourceLocator> tlocators = track.getResourceLocators();
            if (tlocators == null) continue;
            locators.addAll(tlocators);
        }
        locators.remove(null);
        return locators;
    }

    public void setAllTrackHeights(int newHeight) {
        for (Track track : this.getAllTracks()) {
            track.setHeight(newHeight, true);
        }
    }

    public void removeTracks(Collection<? extends Track> tracksToRemove) {
        this.removeTracks(tracksToRemove, true);
    }

    public void removeTracks(Collection<? extends Track> tracksToRemove, boolean dispose) {
        List<TrackPanel> panels = this.getTrackPanels();
        for (TrackPanel trackPanel : panels) {
            trackPanel.removeTracks(tracksToRemove);
            if (trackPanel.hasTracks()) continue;
            this.removeDataPanel(trackPanel.getName());
        }
        for (Track track : tracksToRemove) {
            if (!(track instanceof IGVEventObserver)) continue;
            IGVEventBus.getInstance().unsubscribe((IGVEventObserver)((Object)track));
        }
        if (dispose) {
            for (Track track : tracksToRemove) {
                track.dispose();
            }
        }
    }

    public void setGenomeTracks(FeatureTrack newGeneTrack) {
        TrackPanel panel = PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane") ? this.getTrackPanel(DATA_PANEL_NAME) : this.getTrackPanel(FEATURE_PANEL_NAME);
        SequenceTrack newSeqTrack = new SequenceTrack("Reference sequence");
        panel.addTrack(newSeqTrack);
        if (newGeneTrack != null) {
            panel.addTrack(newGeneTrack);
        }
    }

    public boolean hasGeneTrack() {
        FeatureTrack geneTrack = GenomeManager.getInstance().getCurrentGenome().getGeneTrack();
        if (geneTrack == null) {
            return false;
        }
        for (Track track : this.getFeatureTracks()) {
            if (geneTrack != track) continue;
            return true;
        }
        return false;
    }

    public boolean hasSequenceTrack() {
        return this.getSequenceTrack() != null;
    }

    public SequenceTrack getSequenceTrack() {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof SequenceTrack)) continue;
            return (SequenceTrack)t;
        }
        return null;
    }

    public void sortAllTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortTracksByAttributes(attributeNames, ascending);
        }
    }

    public void sortByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        RegionOfInterest r = region == null ? new RegionOfInterest(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd() + 1, frame.getName()) : region;
        List<String> sortedSamples = this.sortSamplesByRegionScore(r, type, frame);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortByRegionsScore(r, type, frame, sortedSamples);
        }
        this.revalidateTrackPanels();
    }

    private List<String> sortSamplesByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        List<Track> allTracks = this.getAllTracks();
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(allTracks.size());
        for (Track t : allTracks) {
            if (!t.isRegionScoreType(type)) continue;
            tracksWithScore.add(t);
        }
        IGV.sortByRegionScore(tracksWithScore, region, type, frame);
        ArrayList<String> sortedSamples = new ArrayList<String>(tracksWithScore.size());
        for (Track t : tracksWithScore) {
            String att = t.getSample();
            if (att == null) continue;
            sortedSamples.add(att);
        }
        return sortedSamples;
    }

    static void sortByRegionScore(List<Track> tracks, RegionOfInterest region, final RegionScoreType type, ReferenceFrame frame) {
        if (tracks != null && region != null && !tracks.isEmpty()) {
            final String frameName = frame != null ? frame.getName() : null;
            int tmpzoom = frame != null ? frame.getZoom() : 0;
            final int zoom = Math.max(0, tmpzoom);
            final String chr = region.getChr();
            final int start = region.getStart();
            final int end = region.getEnd();
            Comparator<Track> c = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    try {
                        if (t1 == null && t2 == null) {
                            return 0;
                        }
                        if (t1 == null) {
                            return 1;
                        }
                        if (t2 == null) {
                            return -1;
                        }
                        float s1 = t1.getRegionScore(chr, start, end, zoom, type, frameName);
                        float s2 = t2.getRegionScore(chr, start, end, zoom, type, frameName);
                        return Float.compare(s2, s1);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error sorting tracks. Sort might not be accurate.", (Throwable)e);
                        return 0;
                    }
                }
            };
            Collections.sort(tracks, c);
        }
    }

    public String getGroupByAttribute() {
        return this.groupByAttribute;
    }

    public void setGroupByAttribute(String attributeName) {
        this.groupByAttribute = attributeName;
        this.resetGroups();
        IGVEventBus.getInstance().post(new TrackGroupEvent(this));
    }

    private void resetGroups() {
        log.debug((Object)"Resetting Groups");
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.groupTracksByAttribute(this.groupByAttribute);
        }
    }

    public Future startUp(Main.IGVArgs igvArgs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"startUp");
        }
        return LongRunningTask.submit(new StartupRunnable(igvArgs));
    }

    public void setRulerEnabled(boolean rulerEnabled) {
        this.rulerEnabled = rulerEnabled;
    }

    public boolean isRulerEnabled() {
        return this.rulerEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySequenceToClipboard(Genome genome, String chr, int start, int end, Strand strand) {
        try {
            IGV.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            byte[] seqBytes = genome.getSequence(chr, start, end);
            if (seqBytes == null) {
                MessageUtils.showMessage("Sequence not available");
            } else {
                String sequence = new String(seqBytes);
                SequenceTrack sequenceTrack = IGV.getInstance().getSequenceTrack();
                if (strand == Strand.NEGATIVE || sequenceTrack != null && sequenceTrack.getStrand() == Strand.NEGATIVE) {
                    sequence = SequenceTrack.getReverseComplement(sequence);
                }
                StringUtils.copyTextToClipboard(sequence);
            }
        }
        finally {
            IGV.getMainFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForNotify(long timeout) {
        boolean completed = false;
        IGV iGV = this;
        synchronized (iGV) {
            if (!completed) {
                try {
                    this.wait(timeout);
                    completed = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return completed;
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof ViewChange || event instanceof InsertionSelectionEvent) {
            this.revalidateTrackPanels();
        } else if (event instanceof ShiftEvent) {
            this.revalidateTrackPanels();
        } else if (event instanceof GenomeChangeEvent) {
            this.doRefresh();
        } else {
            log.info((Object)("Unknown event type: " + event.getClass()));
        }
    }

    public void repaint() {
        this.mainFrame.repaint();
    }

    public void resetFrames() {
        this.contentPane.getMainPanel().headerPanelContainer.createHeaderPanels();
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.createDataPanels();
        }
        this.contentPane.getCommandBar().setGeneListMode(FrameManager.isGeneListMode());
        this.contentPane.getMainPanel().applicationHeaderPanel.revalidate();
        this.contentPane.getMainPanel().validate();
        this.contentPane.getMainPanel().repaint();
    }

    public final void doRefresh() {
        this.contentPane.getMainPanel().revalidate();
        this.mainFrame.repaint();
        this.getContentPane().repaint();
    }

    public void revalidateTrackPanels() {
        UIUtilities.invokeOnEventThread(() -> {
            if (Globals.isBatch()) {
                this.contentPane.revalidateTrackPanels();
                this.rootPane.paintImmediately(this.rootPane.getBounds());
            } else {
                this.contentPane.revalidateTrackPanels();
                this.rootPane.repaint();
            }
        });
    }

    public void repaintNamePanels() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().getNamePanel().repaint();
        }
    }

    public class StartupRunnable
    implements Runnable {
        Main.IGVArgs igvArgs;
        ProgressBar.ProgressDialog progressDialog;

        StartupRunnable(Main.IGVArgs args) {
            this.igvArgs = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String genomeId;
            final boolean runningBatch = this.igvArgs.getBatchFile() != null;
            BatchRunner.setIsBatchMode(runningBatch);
            UIUtilities.invokeOnEventThread(() -> IGV.this.mainFrame.setIconImage(this.getIconImage()));
            if (Globals.IS_MAC) {
                this.setAppleDockIcon();
            }
            IGVPreferences preferenceManager = PreferencesManager.getPreferences();
            boolean genomeLoaded = false;
            if (this.igvArgs.getGenomeId() != null) {
                genomeId = this.igvArgs.getGenomeId();
                try {
                    GenomeManager.getInstance().loadGenomeById(genomeId);
                    genomeLoaded = true;
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e);
                    log.error((Object)("Error loading genome: " + genomeId), (Throwable)e);
                }
            }
            if (!genomeLoaded && this.igvArgs.getSessionFile() == null) {
                genomeId = preferenceManager.getDefaultGenome();
                try {
                    GenomeManager.getInstance().loadGenomeById(genomeId);
                    genomeLoaded = true;
                }
                catch (Exception e) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e);
                    log.error((Object)("Error loading genome: " + genomeId), (Throwable)e);
                }
            }
            if (!genomeLoaded && this.igvArgs.getSessionFile() == null) {
                genomeId = GenomeManager.DEFAULT_GENOME.getId();
                try {
                    GenomeManager.getInstance().loadGenomeById(genomeId);
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e);
                    log.error((Object)("Error loading genome: " + genomeId), (Throwable)e);
                }
            }
            if (this.igvArgs.getSessionFile() != null || this.igvArgs.getDataFileStrings() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loading session data");
                }
                IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor();
                ProgressBar.ProgressDialog progressDialog2 = ProgressBar.showProgressDialog(IGV.this.mainFrame, "Loading session data", indefMonitor, false);
                indefMonitor.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Calling restore session");
                }
                if (this.igvArgs.getSessionFile() != null) {
                    boolean success = false;
                    if (HttpUtils.isRemoteURL(this.igvArgs.getSessionFile())) {
                        boolean merge = false;
                        success = IGV.this.restoreSessionSynchronous(this.igvArgs.getSessionFile(), this.igvArgs.getLocusString(), merge);
                    } else {
                        File sf = new File(this.igvArgs.getSessionFile());
                        if (sf.exists()) {
                            success = IGV.this.restoreSessionSynchronous(sf.getAbsolutePath(), this.igvArgs.getLocusString(), false);
                        }
                    }
                    if (!success) {
                        String genomeId2 = preferenceManager.getDefaultGenome();
                        IGV.this.contentPane.getCommandBar().selectGenome(genomeId2);
                    }
                } else if (this.igvArgs.getDataFileStrings() != null) {
                    List<String> dataFiles = this.igvArgs.getDataFileStrings();
                    String[] names = null;
                    if (this.igvArgs.getName() != null) {
                        names = this.igvArgs.getName().split(",");
                    }
                    String[] indexFiles = null;
                    if (this.igvArgs.getIndexFile() != null) {
                        indexFiles = this.igvArgs.getIndexFile().split(",");
                    }
                    String[] coverageFiles = null;
                    if (this.igvArgs.getCoverageFile() != null) {
                        coverageFiles = this.igvArgs.getCoverageFile().split(",");
                    }
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    for (int i = 0; i < dataFiles.size(); ++i) {
                        String p = dataFiles.get(i).trim();
                        if (URLUtils.isURL(p) && !FileUtils.isRemote(p)) {
                            p = StringUtils.decodeURL(p);
                        }
                        ResourceLocator rl = new ResourceLocator(p);
                        if (names != null && i < names.length) {
                            String name = names[i];
                            rl.setName(name);
                        }
                        if (indexFiles != null && i < indexFiles.length) {
                            String idxP = indexFiles[i];
                            if (URLUtils.isURL(idxP) && !FileUtils.isRemote(idxP)) {
                                idxP = StringUtils.decodeURL(idxP);
                            }
                            if (idxP.length() > 0) {
                                rl.setIndexPath(idxP);
                            }
                        }
                        if (coverageFiles != null && i < coverageFiles.length) {
                            String covP = coverageFiles[i];
                            if (URLUtils.isURL(covP) && !FileUtils.isRemote(covP)) {
                                covP = StringUtils.decodeURL(covP);
                            }
                            if (covP.length() > 0) {
                                rl.setCoverage(covP);
                            }
                        }
                        locators.add(rl);
                    }
                    IGV.this.loadTracks(locators);
                }
                indefMonitor.stop();
                IGV.this.closeWindow(progressDialog2);
            }
            IGV.this.session.recordHistory();
            boolean portEnabled = preferenceManager.getAsBoolean("PORT_ENABLED");
            String portString = this.igvArgs.getPort();
            if (portEnabled || portString != null) {
                int port = preferenceManager.getAsInt("PORT_NUMBER");
                if (portString != null) {
                    port = Integer.parseInt(portString);
                }
                CommandListener.start(port);
            }
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    IGV.this.mainFrame.setVisible(true);
                    if (StartupRunnable.this.igvArgs.getLocusString() != null) {
                        IGV.this.goToLocus(StartupRunnable.this.igvArgs.getLocusString());
                    }
                    if (runningBatch) {
                        Globals.setBatch(false);
                        LongRunningTask.submit(new BatchRunner(StartupRunnable.this.igvArgs.getBatchFile()));
                    }
                }
            });
            IGV iGV = IGV.getInstance();
            synchronized (iGV) {
                IGV.getInstance().notifyAll();
            }
        }

        private void setAppleDockIcon() {
            try {
                Image image = this.getIconImage();
                DesktopIntegration.setDockIcon(image);
            }
            catch (Exception e) {
                log.error((Object)"Error setting apple dock icon", (Throwable)e);
            }
        }

        private Image getIconImage() {
            String path = "resources/IGV_64.png";
            URL url = IGV.class.getResource(path);
            Image image = new ImageIcon(url).getImage();
            return image;
        }
    }
}

