/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.Date;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.model.Credentials;

@SdkInternalApi
@ThreadSafe
final class SessionCredentialsHolder {
    private final AwsSessionCredentials sessionCredentials;
    private final Date sessionCredentialsExpiration;

    SessionCredentialsHolder(Credentials credentials) {
        this.sessionCredentials = AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
        this.sessionCredentialsExpiration = Date.from(credentials.expiration());
    }

    public AwsSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public Date getSessionCredentialsExpiration() {
        return this.sessionCredentialsExpiration;
    }
}

