/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.prefs;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.data.expression.ProbeToLocusMap;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.color.ColorChooserPanel;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.legend.MutationColorMapEditor;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.FontChooser;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CollUtils;

public class PreferencesEditor
extends JDialog {
    static Logger log = Logger.getLogger(PreferencesEditor.class);
    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = Collections.synchronizedMap(new HashMap<String, String>(){

        @Override
        public String put(String k, String v) {
            String oldValue = PreferencesEditor.this.prefMgr.get(k);
            if (v == null && oldValue != null || !v.equals(oldValue)) {
                return super.put(k, v);
            }
            return v;
        }
    });
    IGVPreferences prefMgr = PreferencesManager.getPreferences();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    private static int lastSelectedIndex = 0;
    boolean proxySettingsChanged = false;
    boolean tooltipSettingsChanged = false;
    private File newIGVDirectory;
    private File newCramCacheDirectory;
    private File cramCacheDirectory;
    static String overlayText = "<html>These options control the treatment of mutation tracks.  Mutation data may optionally<br>be overlaid on other tracks that have a matching attribute value from the sample info <br>file. This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in thetext field below.";
    private JScrollPane panel7;
    private JPanel panel6;
    private JTabbedPane tabbedPane;
    private JScrollPane panel22;
    private JPanel generalPanel;
    private JPanel vSpacer7;
    private JPanel jPanel10;
    private JCheckBox sessionPathsCB;
    private JLabel missingDataExplanation;
    private JCheckBox showDefaultTrackAttributesCB;
    private JCheckBox combinePanelsCB;
    private JCheckBox showAttributesDisplayCheckBox;
    private JCheckBox searchZoomCB;
    private JLabel label4;
    private JTextField geneListFlankingField;
    private JLabel zoomToFeatureExplanation2;
    private JLabel label6;
    private JTextField seqResolutionThreshold;
    private JLabel label10;
    private JButton fontChangeButton;
    private JCheckBox showRegionBoundariesCB;
    private JLabel label7;
    private JPanel backgroundColorPanel;
    private JCheckBox enableGoogleCB;
    private JLabel label33;
    private JCheckBox saveGoogleCredentialsCB;
    private JLabel label34;
    private JLabel textField1;
    private JTextField featureVisibilityWindowField;
    private JLabel zoomToFeatureExplanation3;
    private JTextField defaultFontField;
    private JButton resetFontButton;
    private JCheckBox scaleFontsCB;
    private JLabel label8;
    private JButton resetBackgroundButton;
    private JScrollPane panel23;
    private JPanel tracksPanel;
    private JPanel vSpacer1;
    private JLabel jLabel5;
    private JTextField defaultChartTrackHeightField;
    private JLabel trackNameAttributeLabel;
    private JTextField trackNameAttributeField;
    private JLabel jLabel8;
    private JTextField defaultTrackHeightField;
    private JPanel hSpacer1;
    private JCheckBox expandCB;
    private JCheckBox normalizeCoverageCB;
    private JLabel missingDataExplanation8;
    private JScrollPane panel24;
    private JPanel overlaysPanel;
    private JPanel jPanel5;
    private JLabel jLabel3;
    private JTextField overlayAttributeTextField;
    private JCheckBox overlayTrackCB;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JCheckBox colorCodeMutationsCB;
    private JButton chooseMutationColorsButton;
    private JLabel label11;
    private JCheckBox showOrphanedMutationsCB;
    private JLabel label12;
    private JPanel panel33;
    private JLabel label36;
    private ColorChooserPanel homRefColorChooser;
    private JLabel label38;
    private ColorChooserPanel homVarColorChooser;
    private JLabel label37;
    private ColorChooserPanel hetVarColorChooser;
    private JLabel label40;
    private ColorChooserPanel noCallColorChooser;
    private JLabel label41;
    private ColorChooserPanel afRefColorChooser;
    private JLabel label42;
    private ColorChooserPanel afVarColorChooser;
    private JButton resetVCFButton;
    private JPanel panel35;
    private JLabel label43;
    private JRadioButton alleleFreqRB;
    private JRadioButton alleleFractionRB;
    private JScrollPane panel25;
    private JPanel chartPanel;
    private JPanel jPanel4;
    private JCheckBox topBorderCB;
    private JLabel label1;
    private JCheckBox chartDrawTrackNameCB;
    private JCheckBox bottomBorderCB;
    private JLabel jLabel7;
    private JCheckBox colorBordersCB;
    private JCheckBox labelYAxisCB;
    private JCheckBox autoscaleCB;
    private JLabel jLabel9;
    private JCheckBox showDatarangeCB;
    private JPanel panel1;
    private JLabel label13;
    private JCheckBox showAllHeatmapFeauresCB;
    private JLabel label14;
    private JScrollPane panel20;
    private JPanel alignmentPanel;
    private JPanel jPanel11;
    private JPanel panel32;
    private JLabel label39;
    private JCheckBox showAlignmentTrackCB;
    private JCheckBox showCovTrackCB;
    private JCheckBox showJunctionTrackCB;
    private JPanel jPanel12;
    private JPanel panel13;
    private JPanel panel31;
    private JLabel jLabel11;
    private JTextField samMaxWindowSizeField;
    private JLabel jLabel12;
    private JPanel panel4;
    private JCheckBox downsampleReadsCB;
    private JPanel hSpacer3;
    private JLabel label23;
    private JTextField samDownsampleCountField;
    private JLabel jLabel13;
    private JTextField samSamplingWindowField;
    private JPanel panel11;
    private JCheckBox samShadeMismatchedBaseCB;
    private JTextField samMinBaseQualityField;
    private JLabel label2;
    private JTextField samMaxBaseQualityField;
    private JPanel panel12;
    private JLabel jLabel15;
    private JTextField mappingQualityThresholdField;
    private JPanel panel10;
    private JCheckBox samFlagIndelsCB;
    private JTextField samFlagIndelsThresholdField;
    private JLabel label31;
    private JPanel panel10clip;
    private JCheckBox samFlagClippingCB;
    private JTextField samFlagClippingThresholdField;
    private JLabel label31clip;
    private JPanel panel9;
    private JCheckBox hideIndelsBasesCB;
    private JTextField hideIndelsBasesField;
    private JLabel label45;
    private JPanel panel8;
    private JCheckBox samFilterDuplicatesCB;
    private JCheckBox samFlagUnmappedPairCB;
    private JCheckBox filterFailedReadsCB;
    private JCheckBox showSoftClippedCB;
    private JCheckBox filterSecondaryAlignmentsCB;
    private JCheckBox quickConsensusModeCB;
    private JCheckBox showCenterLineCB;
    private JCheckBox filterSupplementaryAlignmentsCB;
    private JPanel panel31b;
    private JLabel jLabel11b;
    private JTextField samHiddenTagsField;
    private JPanel vSpacer5;
    private JPanel panel34;
    private JPanel panel5;
    private JLabel jLabel26;
    private JTextField snpThresholdField;
    private JPanel hSpacer2;
    private JCheckBox useAlleleQualityCB;
    private JPanel panel3;
    private JCheckBox showJunctionFlankingRegionsCB;
    private JLabel label15;
    private JTextField junctionFlankingTextField;
    private JLabel label16;
    private JTextField junctionCoverageTextField;
    private JPanel vSpacer6;
    private JPanel panel2;
    private JPanel panel19;
    private JPanel panel16;
    private JLabel label9;
    private JLabel jLabel20;
    private JTextField insertSizeMinThresholdField;
    private JLabel jLabel17;
    private JTextField insertSizeThresholdField;
    private JPanel panel15;
    private JCheckBox isizeComputeCB;
    private JLabel jLabel30;
    private JTextField insertSizeMinPercentileField;
    private JLabel jLabel18;
    private JTextField insertSizeMaxPercentileField;
    private JScrollPane panel26;
    private JPanel expressionPane;
    private JPanel jPanel8;
    private JPanel panel18;
    private JLabel jLabel24;
    private JLabel jLabel21;
    private JRadioButton expMapToLociCB;
    private JRadioButton expMapToGeneCB;
    private JPanel panel17;
    private JCheckBox useProbeMappingCB;
    private JLabel label22;
    private JPanel panel14;
    private JTextField probeMappingFileTextField;
    private JButton probeMappingBrowseButton;
    private JScrollPane panel27;
    private JPanel proxyPanel;
    private JPanel jPanel15;
    private JLabel label3;
    private JButton clearProxySettingsButton;
    private JTextField proxyUsernameField;
    private JLabel jLabel28;
    private JCheckBox authenticateProxyCB;
    private JLabel jLabel29;
    private JPasswordField proxyPasswordField;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JLabel jLabel27;
    private JLabel jLabel23;
    private JCheckBox useProxyCB;
    private JComboBox<String> proxyTypeCB;
    private JLabel label27;
    private JLabel label35;
    private JTextField proxyWhitelistTextArea;
    private JScrollPane panel30;
    private JPanel dbPanel;
    private JLabel label20;
    private JPanel panel21;
    private JLabel label17;
    private JLabel label19;
    private JTextField dbNameField;
    private JTextField dbHostField;
    private JLabel label18;
    private JTextField dbPortField;
    private JScrollPane panel29;
    private JPanel advancedPanel;
    private JButton clearGenomeCacheButton;
    private JCheckBox enablePortCB;
    private JTextField portField;
    private JLabel jLabel22;
    private JPanel vSpacer12;
    private JCheckBox genomeUpdateCB;
    private JLabel jLabel6;
    private JTextField dataServerURLTextField;
    private JLabel jLabel1;
    private JTextField genomeServerURLTextField;
    private JCheckBox editServerPropertiesCB;
    private JButton jButton1;
    private JPanel vSpacer11;
    private JCheckBox autoFileDisoveryCB;
    private JButton igvDirectoryButton;
    private JLabel igvDirectoryField;
    private JLabel label21;
    private JPanel tooltipOptionsPanel;
    private JLabel label24;
    private JLabel label25;
    private JLabel label26;
    private JTextField toolTipInitialDelayField;
    private JTextField tooltipReshowDelayField;
    private JTextField tooltipDismissDelayField;
    private JCheckBox antialiasingCB;
    private JLabel label5;
    private JTextField blatURLField;
    private JPanel vSpacer8;
    private JPanel vSpacer9;
    private JPanel vSpacer10;
    private JScrollPane panel36;
    private JPanel cramPanel;
    private JPanel panel28;
    private JPanel panel37;
    private JLabel label28;
    private JTextField cramCacheSizeField;
    private JPanel panel38;
    private JLabel label29;
    private JTextField cramCacheDirectoryField;
    private JButton cramCacheDirectoryButton;
    private JCheckBox cramCacheReferenceCB;
    private ButtonPanel okCancelButtonPanel;
    JButton okButton;
    private JButton cancelButton;

    public PreferencesEditor(Frame parent, boolean modal) {
        super(parent, modal);
        int idx;
        this.initComponents();
        this.initValues();
        this.tabbedPane.setSelectedIndex(lastSelectedIndex);
        if (!this.prefMgr.getAsBoolean("DB_ENABLED") && (idx = this.tabbedPane.indexOfTab("Database")) > 0) {
            this.tabbedPane.remove(idx);
        }
        this.setLocationRelativeTo(parent);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.inputValidated) {
            this.checkForVCFColors();
            this.checkForProbeChanges();
            lastSelectedIndex = this.tabbedPane.getSelectedIndex();
            this.prefMgr.putAll(this.updatedPreferenceMap);
            if (this.updatedPreferenceMap.containsKey("PORT_ENABLED") || this.updatedPreferenceMap.containsKey("PORT_NUMBER")) {
                CommandListener.halt();
                if (this.enablePortCB.isSelected()) {
                    int port = Integer.parseInt(this.updatedPreferenceMap.get("PORT_NUMBER"));
                    CommandListener.start(port);
                }
            }
            if (this.updateOverlays) {
                IGV.getInstance().resetOverlayTracks();
            }
            if (this.proxySettingsChanged) {
                HttpUtils.getInstance().updateProxySettings();
            }
            if (this.newIGVDirectory != null) {
                this.moveIGVDirectory();
            }
            if (this.newCramCacheDirectory != null) {
                this.moveCramCacheDirectory();
            }
            if (this.tooltipSettingsChanged) {
                Main.updateTooltipSettings();
            }
            if (this.updatedPreferenceMap.containsKey("ENABLE_GOOGLE_MENU")) {
                IGVMenuBar.getInstance().enableGoogleMenu(Boolean.valueOf(this.updatedPreferenceMap.get("ENABLE_GOOGLE_MENU")));
            }
            if (this.updatedPreferenceMap.containsKey("PROVISIONING.URL")) {
                // empty if block
            }
            this.updatedPreferenceMap.clear();
            IGV.getInstance().doRefresh();
            this.setVisible(false);
        } else {
            this.resetValidation();
        }
    }

    private void initComponents() {
        Rectangle bounds;
        this.panel7 = new JScrollPane();
        this.panel6 = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.panel22 = new JScrollPane();
        this.generalPanel = new JPanel();
        this.vSpacer7 = new JPanel(null);
        this.jPanel10 = new JPanel();
        this.sessionPathsCB = new JCheckBox();
        this.missingDataExplanation = new JLabel();
        this.showDefaultTrackAttributesCB = new JCheckBox();
        this.combinePanelsCB = new JCheckBox();
        this.showAttributesDisplayCheckBox = new JCheckBox();
        this.searchZoomCB = new JCheckBox();
        this.label4 = new JLabel();
        this.geneListFlankingField = new JTextField();
        this.zoomToFeatureExplanation2 = new JLabel();
        this.label6 = new JLabel();
        this.seqResolutionThreshold = new JTextField();
        this.label10 = new JLabel();
        this.fontChangeButton = new JButton();
        this.showRegionBoundariesCB = new JCheckBox();
        this.label7 = new JLabel();
        this.backgroundColorPanel = new JPanel();
        this.enableGoogleCB = new JCheckBox();
        this.label33 = new JLabel();
        this.saveGoogleCredentialsCB = new JCheckBox();
        this.label34 = new JLabel();
        this.textField1 = new JLabel();
        this.featureVisibilityWindowField = new JTextField();
        this.zoomToFeatureExplanation3 = new JLabel();
        this.defaultFontField = new JTextField();
        this.resetFontButton = new JButton();
        this.scaleFontsCB = new JCheckBox();
        this.label8 = new JLabel();
        this.resetBackgroundButton = new JButton();
        this.panel23 = new JScrollPane();
        this.tracksPanel = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.jLabel5 = new JLabel();
        this.defaultChartTrackHeightField = new JTextField();
        this.trackNameAttributeLabel = new JLabel();
        this.trackNameAttributeField = new JTextField();
        this.jLabel8 = new JLabel();
        this.defaultTrackHeightField = new JTextField();
        this.hSpacer1 = new JPanel(null);
        this.expandCB = new JCheckBox();
        this.normalizeCoverageCB = new JCheckBox();
        this.missingDataExplanation8 = new JLabel();
        this.panel24 = new JScrollPane();
        this.overlaysPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.overlayAttributeTextField = new JTextField();
        this.overlayTrackCB = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.colorCodeMutationsCB = new JCheckBox();
        this.chooseMutationColorsButton = new JButton();
        this.label11 = new JLabel();
        this.showOrphanedMutationsCB = new JCheckBox();
        this.label12 = new JLabel();
        this.panel33 = new JPanel();
        this.label36 = new JLabel();
        this.homRefColorChooser = new ColorChooserPanel();
        this.label38 = new JLabel();
        this.homVarColorChooser = new ColorChooserPanel();
        this.label37 = new JLabel();
        this.hetVarColorChooser = new ColorChooserPanel();
        this.label40 = new JLabel();
        this.noCallColorChooser = new ColorChooserPanel();
        this.label41 = new JLabel();
        this.afRefColorChooser = new ColorChooserPanel();
        this.label42 = new JLabel();
        this.afVarColorChooser = new ColorChooserPanel();
        this.resetVCFButton = new JButton();
        this.panel35 = new JPanel();
        this.label43 = new JLabel();
        this.alleleFreqRB = new JRadioButton();
        this.alleleFractionRB = new JRadioButton();
        this.panel25 = new JScrollPane();
        this.chartPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.topBorderCB = new JCheckBox();
        this.label1 = new JLabel();
        this.chartDrawTrackNameCB = new JCheckBox();
        this.bottomBorderCB = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.colorBordersCB = new JCheckBox();
        this.labelYAxisCB = new JCheckBox();
        this.autoscaleCB = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.showDatarangeCB = new JCheckBox();
        this.panel1 = new JPanel();
        this.label13 = new JLabel();
        this.showAllHeatmapFeauresCB = new JCheckBox();
        this.label14 = new JLabel();
        this.panel20 = new JScrollPane();
        this.alignmentPanel = new JPanel();
        this.jPanel11 = new JPanel();
        this.panel32 = new JPanel();
        this.label39 = new JLabel();
        this.showAlignmentTrackCB = new JCheckBox();
        this.showCovTrackCB = new JCheckBox();
        this.showJunctionTrackCB = new JCheckBox();
        this.jPanel12 = new JPanel();
        this.panel13 = new JPanel();
        this.panel31 = new JPanel();
        this.jLabel11 = new JLabel();
        this.samMaxWindowSizeField = new JTextField();
        this.jLabel12 = new JLabel();
        this.panel4 = new JPanel();
        this.downsampleReadsCB = new JCheckBox();
        this.hSpacer3 = new JPanel(null);
        this.label23 = new JLabel();
        this.samDownsampleCountField = new JTextField();
        this.jLabel13 = new JLabel();
        this.samSamplingWindowField = new JTextField();
        this.panel11 = new JPanel();
        this.samShadeMismatchedBaseCB = new JCheckBox();
        this.samMinBaseQualityField = new JTextField();
        this.label2 = new JLabel();
        this.samMaxBaseQualityField = new JTextField();
        this.panel12 = new JPanel();
        this.jLabel15 = new JLabel();
        this.mappingQualityThresholdField = new JTextField();
        this.panel10 = new JPanel();
        this.samFlagIndelsCB = new JCheckBox();
        this.samFlagIndelsThresholdField = new JTextField();
        this.label31 = new JLabel();
        this.panel10clip = new JPanel();
        this.samFlagClippingCB = new JCheckBox();
        this.samFlagClippingThresholdField = new JTextField();
        this.label31clip = new JLabel();
        this.panel9 = new JPanel();
        this.hideIndelsBasesCB = new JCheckBox();
        this.hideIndelsBasesField = new JTextField();
        this.label45 = new JLabel();
        this.panel8 = new JPanel();
        this.samFilterDuplicatesCB = new JCheckBox();
        this.samFlagUnmappedPairCB = new JCheckBox();
        this.filterFailedReadsCB = new JCheckBox();
        this.showSoftClippedCB = new JCheckBox();
        this.filterSecondaryAlignmentsCB = new JCheckBox();
        this.quickConsensusModeCB = new JCheckBox();
        this.showCenterLineCB = new JCheckBox();
        this.filterSupplementaryAlignmentsCB = new JCheckBox();
        this.panel31b = new JPanel();
        this.jLabel11b = new JLabel();
        this.samHiddenTagsField = new JTextField();
        this.vSpacer5 = new JPanel(null);
        this.panel34 = new JPanel();
        this.panel5 = new JPanel();
        this.jLabel26 = new JLabel();
        this.snpThresholdField = new JTextField();
        this.hSpacer2 = new JPanel(null);
        this.useAlleleQualityCB = new JCheckBox();
        this.panel3 = new JPanel();
        this.showJunctionFlankingRegionsCB = new JCheckBox();
        this.label15 = new JLabel();
        this.junctionFlankingTextField = new JTextField();
        this.label16 = new JLabel();
        this.junctionCoverageTextField = new JTextField();
        this.vSpacer6 = new JPanel(null);
        this.panel2 = new JPanel();
        this.panel19 = new JPanel();
        this.panel16 = new JPanel();
        this.label9 = new JLabel();
        this.jLabel20 = new JLabel();
        this.insertSizeMinThresholdField = new JTextField();
        this.jLabel17 = new JLabel();
        this.insertSizeThresholdField = new JTextField();
        this.panel15 = new JPanel();
        this.isizeComputeCB = new JCheckBox();
        this.jLabel30 = new JLabel();
        this.insertSizeMinPercentileField = new JTextField();
        this.jLabel18 = new JLabel();
        this.insertSizeMaxPercentileField = new JTextField();
        this.panel26 = new JScrollPane();
        this.expressionPane = new JPanel();
        this.jPanel8 = new JPanel();
        this.panel18 = new JPanel();
        this.jLabel24 = new JLabel();
        this.jLabel21 = new JLabel();
        this.expMapToLociCB = new JRadioButton();
        this.expMapToGeneCB = new JRadioButton();
        this.panel17 = new JPanel();
        this.useProbeMappingCB = new JCheckBox();
        this.label22 = new JLabel();
        this.panel14 = new JPanel();
        this.probeMappingFileTextField = new JTextField();
        this.probeMappingBrowseButton = new JButton();
        this.panel27 = new JScrollPane();
        this.proxyPanel = new JPanel();
        this.jPanel15 = new JPanel();
        this.label3 = new JLabel();
        this.clearProxySettingsButton = new JButton();
        this.proxyUsernameField = new JTextField();
        this.jLabel28 = new JLabel();
        this.authenticateProxyCB = new JCheckBox();
        this.jLabel29 = new JLabel();
        this.proxyPasswordField = new JPasswordField();
        this.proxyHostField = new JTextField();
        this.proxyPortField = new JTextField();
        this.jLabel27 = new JLabel();
        this.jLabel23 = new JLabel();
        this.useProxyCB = new JCheckBox();
        this.proxyTypeCB = new JComboBox();
        this.label27 = new JLabel();
        this.label35 = new JLabel();
        this.proxyWhitelistTextArea = new JTextField();
        this.panel30 = new JScrollPane();
        this.dbPanel = new JPanel();
        this.label20 = new JLabel();
        this.panel21 = new JPanel();
        this.label17 = new JLabel();
        this.label19 = new JLabel();
        this.dbNameField = new JTextField();
        this.dbHostField = new JTextField();
        this.label18 = new JLabel();
        this.dbPortField = new JTextField();
        this.panel29 = new JScrollPane();
        this.advancedPanel = new JPanel();
        this.clearGenomeCacheButton = new JButton();
        this.enablePortCB = new JCheckBox();
        this.portField = new JTextField();
        this.jLabel22 = new JLabel();
        this.vSpacer12 = new JPanel(null);
        this.genomeUpdateCB = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.dataServerURLTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.genomeServerURLTextField = new JTextField();
        this.editServerPropertiesCB = new JCheckBox();
        this.jButton1 = new JButton();
        this.vSpacer11 = new JPanel(null);
        this.autoFileDisoveryCB = new JCheckBox();
        this.igvDirectoryButton = new JButton();
        this.igvDirectoryField = new JLabel();
        this.label21 = new JLabel();
        this.tooltipOptionsPanel = new JPanel();
        this.label24 = new JLabel();
        this.label25 = new JLabel();
        this.label26 = new JLabel();
        this.toolTipInitialDelayField = new JTextField();
        this.tooltipReshowDelayField = new JTextField();
        this.tooltipDismissDelayField = new JTextField();
        this.antialiasingCB = new JCheckBox();
        this.label5 = new JLabel();
        this.blatURLField = new JTextField();
        this.vSpacer8 = new JPanel(null);
        this.vSpacer9 = new JPanel(null);
        this.vSpacer10 = new JPanel(null);
        this.panel36 = new JScrollPane();
        this.cramPanel = new JPanel();
        this.panel28 = new JPanel();
        this.panel37 = new JPanel();
        this.label28 = new JLabel();
        this.cramCacheSizeField = new JTextField();
        this.panel38 = new JPanel();
        this.label29 = new JLabel();
        this.cramCacheDirectoryField = new JTextField();
        this.cramCacheDirectoryButton = new JButton();
        this.cramCacheReferenceCB = new JCheckBox();
        this.okCancelButtonPanel = new ButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.panel6.setLayout(new BorderLayout());
        this.tabbedPane.setPreferredSize(new Dimension(805, 800));
        this.tabbedPane.setMaximumSize(new Dimension(805, 800));
        this.generalPanel.setLayout(new BorderLayout());
        this.vSpacer7.setPreferredSize(new Dimension(10, 20));
        this.generalPanel.add((Component)this.vSpacer7, "North");
        this.jPanel10.setBorder(null);
        this.jPanel10.setLayout(new GridBagLayout());
        ((GridBagLayout)this.jPanel10.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.jPanel10.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.jPanel10.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.jPanel10.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.sessionPathsCB.setText("Use relative paths in sessions");
        this.sessionPathsCB.addActionListener(e -> this.sessionPathsCBActionPerformed(e));
        this.jPanel10.add((Component)this.sessionPathsCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.missingDataExplanation.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation.setText("(NAME, DATA_TYPE, and DATA_FILE).");
        this.jPanel10.add((Component)this.missingDataExplanation, new GridBagConstraints(3, 4, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.showDefaultTrackAttributesCB.setText("Show default track attributes");
        this.showDefaultTrackAttributesCB.setToolTipText("Display default track attributes (NAME, DATA_TYPE, and DATA_FILE) in the attribute panel.");
        this.showDefaultTrackAttributesCB.addActionListener(e -> this.showDefaultTrackAttributesCBActionPerformed(e));
        this.jPanel10.add((Component)this.showDefaultTrackAttributesCB, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.combinePanelsCB.setText("Display all tracks in a single panel");
        this.combinePanelsCB.addActionListener(e -> this.combinePanelsCBActionPerformed(e));
        this.jPanel10.add((Component)this.combinePanelsCB, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.showAttributesDisplayCheckBox.setText("Show attribute panel");
        this.showAttributesDisplayCheckBox.addActionListener(e -> this.showAttributesDisplayCheckBoxActionPerformed(e));
        this.jPanel10.add((Component)this.showAttributesDisplayCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.searchZoomCB.setText("Zoom to features");
        this.searchZoomCB.setToolTipText("This option controls the behavior of feature searches.  If true, the zoom level is changed as required to size the view to the feature size.  If false, the zoom level is unchanged.");
        this.searchZoomCB.addActionListener(e -> this.searchZoomCBActionPerformed(e));
        this.jPanel10.add((Component)this.searchZoomCB, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label4.setText("Feature flanking region (bp or %): ");
        this.label4.setToolTipText("Added before and after feature locus when zooming to a feature.  Also used when defining panel extents in gene/loci list views.  A negative number is interpreted as a percentage.");
        this.jPanel10.add((Component)this.label4, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
        this.geneListFlankingField.setToolTipText("Added before and after feature locus when zooming to a feature.  Also used when defining panel extents in gene/loci list views.  A negative number is interpreted as a percentage.");
        this.geneListFlankingField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.geneListFlankingFieldFocusLost(e);
            }
        });
        this.geneListFlankingField.addActionListener(e -> this.geneListFlankingFieldActionPerformed(e));
        this.jPanel10.add((Component)this.geneListFlankingField, new GridBagConstraints(4, 9, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.zoomToFeatureExplanation2.setFont(new Font("Lucida Grande", 2, 12));
        this.zoomToFeatureExplanation2.setText("<html><i>&lt; 0 is interpreted as a percentage.</b>");
        this.zoomToFeatureExplanation2.setVerticalAlignment(1);
        this.jPanel10.add((Component)this.zoomToFeatureExplanation2, new GridBagConstraints(7, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 15, 5), 0, 0));
        this.label6.setText("Sequence resolution threshold (bp/pixel):");
        this.jPanel10.add((Component)this.label6, new GridBagConstraints(0, 11, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
        this.seqResolutionThreshold.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.seqResolutionThresholdFocusLost(e);
            }
        });
        this.seqResolutionThreshold.addActionListener(e -> this.seqResolutionThresholdActionPerformed(e));
        this.jPanel10.add((Component)this.seqResolutionThreshold, new GridBagConstraints(4, 11, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label10.setText("Default font:");
        this.label10.setLabelFor(this.defaultFontField);
        this.jPanel10.add((Component)this.label10, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
        this.fontChangeButton.setText("Change...");
        this.fontChangeButton.addActionListener(e -> this.fontChangeButtonActionPerformed(e));
        this.jPanel10.add((Component)this.fontChangeButton, new GridBagConstraints(6, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.showRegionBoundariesCB.setText("Show region boundaries");
        this.showRegionBoundariesCB.addActionListener(e -> this.showRegionBoundariesCBActionPerformed(e));
        this.jPanel10.add((Component)this.showRegionBoundariesCB, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label7.setText("Background color (click to change):");
        this.jPanel10.add((Component)this.label7, new GridBagConstraints(0, 14, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
        this.backgroundColorPanel.setPreferredSize(new Dimension(20, 20));
        this.backgroundColorPanel.setBorder(new BevelBorder(0));
        this.backgroundColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PreferencesEditor.this.backgroundColorPanelMouseClicked(e);
            }
        });
        this.backgroundColorPanel.setLayout(null);
        this.jPanel10.add((Component)this.backgroundColorPanel, new GridBagConstraints(3, 14, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.enableGoogleCB.setText("Enable Google access");
        this.enableGoogleCB.addActionListener(e -> this.enableGoogleCBActionPerformed(e));
        this.jPanel10.add((Component)this.enableGoogleCB, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label33.setText("Enable loading from Google apis.");
        this.label33.setFont(new Font("Lucida Grande", 2, 13));
        this.jPanel10.add((Component)this.label33, new GridBagConstraints(3, 7, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.saveGoogleCredentialsCB.setText("Save Google credentials");
        this.saveGoogleCredentialsCB.addActionListener(e -> this.saveGoogleCredentialsCBActionPerformed(e));
        this.jPanel10.add((Component)this.saveGoogleCredentialsCB, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label34.setText("Save authorization credentials across sessions");
        this.label34.setFont(new Font("Lucida Grande", 2, 13));
        this.jPanel10.add((Component)this.label34, new GridBagConstraints(3, 8, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.textField1.setText("Default visibility window (kilobases):");
        this.textField1.setToolTipText("A value > 0 will set a default threshold windows size in kilobases above which features from indexed files are not loaded.  The threshold (\"visibility window\") can be overridden explicitly for individual tracks via the track menu.");
        this.jPanel10.add((Component)this.textField1, new GridBagConstraints(0, 10, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 15, 5), 0, 0));
        this.featureVisibilityWindowField.setToolTipText("A value > 0 will set a default threshold windows size in kilobases above which features from indexed files are not loaded.  The threshold (\"visibility window\") can be overridden explicitly for individual tracks via the track menu.");
        this.featureVisibilityWindowField.addActionListener(e -> this.featureVisibilityWindowFieldActionPerformed(e));
        this.featureVisibilityWindowField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.featureVisibilityWindowFieldFocusLost(e);
            }
        });
        this.jPanel10.add((Component)this.featureVisibilityWindowField, new GridBagConstraints(4, 10, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.zoomToFeatureExplanation3.setFont(new Font("Lucida Grande", 2, 12));
        this.zoomToFeatureExplanation3.setText("<html><i>&lt; 0 disables visibility window.</b>");
        this.zoomToFeatureExplanation3.setVerticalAlignment(1);
        this.jPanel10.add((Component)this.zoomToFeatureExplanation3, new GridBagConstraints(7, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 15, 5), 0, 0));
        this.defaultFontField.setEditable(false);
        this.jPanel10.add((Component)this.defaultFontField, new GridBagConstraints(1, 12, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.resetFontButton.setText("Reset to default");
        this.resetFontButton.addActionListener(e -> this.resetFontButtonActionPerformed(e));
        this.jPanel10.add((Component)this.resetFontButton, new GridBagConstraints(7, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.scaleFontsCB.setText("Scale fonts");
        this.scaleFontsCB.addActionListener(e -> this.scaleFontsCBActionPerformed(e));
        this.jPanel10.add((Component)this.scaleFontsCB, new GridBagConstraints(0, 13, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.label8.setText("<html><i>Scale fonts for high resolution screens.  Requires restart.");
        this.jPanel10.add((Component)this.label8, new GridBagConstraints(2, 13, 7, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
        this.resetBackgroundButton.setText("Reset to default");
        this.resetBackgroundButton.addActionListener(e -> this.resetBackgroundButtonActionPerformed(e));
        this.jPanel10.add((Component)this.resetBackgroundButton, new GridBagConstraints(7, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 5), 0, 0));
        this.generalPanel.add((Component)this.jPanel10, "Center");
        this.panel22.setViewportView(this.generalPanel);
        this.tabbedPane.addTab("General", this.panel22);
        this.tracksPanel.setMinimumSize(new Dimension(700, 407));
        this.tracksPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.tracksPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.tracksPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.tracksPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.tracksPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.tracksPanel.add((Component)this.vSpacer1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.jLabel5.setText("Default Track Height, Charts (Pixels)");
        this.tracksPanel.add((Component)this.jLabel5, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.defaultChartTrackHeightField.setText("40");
        this.defaultChartTrackHeightField.setMinimumSize(new Dimension(60, 28));
        this.defaultChartTrackHeightField.setToolTipText("Default height of chart tracks (barcharts, scatterplots, etc)");
        this.defaultChartTrackHeightField.addActionListener(e -> this.defaultChartTrackHeightFieldActionPerformed(e));
        this.defaultChartTrackHeightField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.defaultChartTrackHeightFieldFocusLost(e);
            }
        });
        this.tracksPanel.add((Component)this.defaultChartTrackHeightField, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.trackNameAttributeLabel.setText("Track Name Attribute");
        this.trackNameAttributeLabel.setToolTipText("Name of an attribute to be used to label tracks.  If provided, tracks will be labeled with the corresponding attribute values from the sample information file");
        this.tracksPanel.add((Component)this.trackNameAttributeLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.trackNameAttributeField.addActionListener(e -> this.trackNameAttributeFieldActionPerformed(e));
        this.trackNameAttributeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.trackNameAttributeFieldFocusLost(e);
            }
        });
        this.tracksPanel.add((Component)this.trackNameAttributeField, new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.jLabel8.setText("Default Track Height, Other (Pixels)");
        this.tracksPanel.add((Component)this.jLabel8, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.defaultTrackHeightField.setText("15");
        this.defaultTrackHeightField.setMinimumSize(new Dimension(60, 28));
        this.defaultTrackHeightField.addActionListener(e -> this.defaultTrackHeightFieldActionPerformed(e));
        this.defaultTrackHeightField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.defaultTrackHeightFieldFocusLost(e);
            }
        });
        this.tracksPanel.add((Component)this.defaultTrackHeightField, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.tracksPanel.add((Component)this.hSpacer1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.expandCB.setText("Expand Feature Tracks");
        this.expandCB.addActionListener(e -> this.expandCBActionPerformed(e));
        this.tracksPanel.add((Component)this.expandCB, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.normalizeCoverageCB.setText("Normalize Coverage Data");
        this.normalizeCoverageCB.addActionListener(e -> this.normalizeCoverageCBActionPerformed(e));
        this.normalizeCoverageCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.normalizeCoverageCBFocusLost(e);
            }
        });
        this.tracksPanel.add((Component)this.normalizeCoverageCB, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 10), 0, 0));
        this.missingDataExplanation8.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation8.setText("<html><i> Applies to coverage tracks computed with igvtools (.tdf files).  If selected, coverage values are scaled by (1,000,000 / totalCount),  where totalCount is the total number of features or alignments.");
        this.missingDataExplanation8.setMaximumSize(new Dimension(500, Integer.MAX_VALUE));
        this.missingDataExplanation8.setPreferredSize(new Dimension(500, 50));
        this.tracksPanel.add((Component)this.missingDataExplanation8, new GridBagConstraints(2, 7, 6, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
        this.panel23.setViewportView(this.tracksPanel);
        this.tabbedPane.addTab("Tracks", this.panel23);
        this.overlaysPanel.setLayout(null);
        this.jPanel5.setBorder(new TitledBorder("MAF Somatic Mutations"));
        this.jPanel5.setLayout(null);
        this.jLabel3.setText("Linking attribute column:");
        this.jPanel5.add(this.jLabel3);
        this.jLabel3.setBounds(new Rectangle(new Point(65, 86), this.jLabel3.getPreferredSize()));
        this.overlayAttributeTextField.setText("LINKING_ID");
        this.overlayAttributeTextField.addActionListener(e -> this.overlayAttributeTextFieldActionPerformed(e));
        this.overlayAttributeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.overlayAttributeTextFieldFocusLost(e);
            }
        });
        this.jPanel5.add(this.overlayAttributeTextField);
        this.overlayAttributeTextField.setBounds(240, 80, 228, this.overlayAttributeTextField.getPreferredSize().height);
        this.overlayTrackCB.setSelected(true);
        this.overlayTrackCB.setText("Overlay mutation tracks");
        this.overlayTrackCB.setActionCommand("overlayTracksCB");
        this.overlayTrackCB.addActionListener(e -> this.overlayTrackCBActionPerformed(e));
        this.jPanel5.add(this.overlayTrackCB);
        this.overlayTrackCB.setBounds(new Rectangle(new Point(6, 51), this.overlayTrackCB.getPreferredSize()));
        this.jLabel2.setFont(new Font("Lucida Grande", 2, 12));
        this.jPanel5.add(this.jLabel2);
        this.jLabel2.setBounds(new Rectangle(new Point(6, 6), this.jLabel2.getPreferredSize()));
        this.jLabel4.setFont(new Font("Lucida Grande", 2, 12));
        this.jPanel5.add(this.jLabel4);
        this.jLabel4.setBounds(new Rectangle(new Point(6, 12), this.jLabel4.getPreferredSize()));
        this.colorCodeMutationsCB.setText("Color code mutations");
        this.colorCodeMutationsCB.addActionListener(e -> this.colorMutationsCBActionPerformed(e));
        this.jPanel5.add(this.colorCodeMutationsCB);
        this.colorCodeMutationsCB.setBounds(new Rectangle(new Point(0, 295), this.colorCodeMutationsCB.getPreferredSize()));
        this.chooseMutationColorsButton.setText("Choose colors");
        this.chooseMutationColorsButton.setFont(UIManager.getFont("Button.font"));
        this.chooseMutationColorsButton.setVerticalTextPosition(3);
        this.chooseMutationColorsButton.addActionListener(e -> this.chooseMutationColorsButtonActionPerformed(e));
        this.jPanel5.add(this.chooseMutationColorsButton);
        this.chooseMutationColorsButton.setBounds(new Rectangle(new Point(185, 292), this.chooseMutationColorsButton.getPreferredSize()));
        this.label11.setText("<html><i>Name of a sample attribute column to link mutation and data tracks");
        this.label11.setVerticalAlignment(1);
        this.jPanel5.add(this.label11);
        this.label11.setBounds(110, 115, 360, 50);
        this.showOrphanedMutationsCB.setText("Show orphaned mutation tracks");
        this.showOrphanedMutationsCB.addActionListener(e -> this.showOrphanedMutationsCBActionPerformed(e));
        this.jPanel5.add(this.showOrphanedMutationsCB);
        this.showOrphanedMutationsCB.setBounds(new Rectangle(new Point(70, 180), this.showOrphanedMutationsCB.getPreferredSize()));
        this.label12.setText("<html><i>Select to show mutation tracks with no corresponding data track.");
        this.label12.setVerticalAlignment(1);
        this.jPanel5.add(this.label12);
        this.label12.setBounds(110, 210, 360, 55);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.jPanel5.getComponentCount(); ++i) {
            bounds = this.jPanel5.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.jPanel5.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel5.setMinimumSize(preferredSize);
        this.jPanel5.setPreferredSize(preferredSize);
        this.overlaysPanel.add(this.jPanel5);
        this.jPanel5.setBounds(20, 365, 690, 344);
        this.panel33.setBorder(new TitledBorder("VCF Variant Colors"));
        this.panel33.setLayout(null);
        this.label36.setText("Homozygous reference");
        this.panel33.add(this.label36);
        this.label36.setBounds(6, 22, 339, 29);
        this.panel33.add(this.homRefColorChooser);
        this.homRefColorChooser.setBounds(345, 22, 55, 29);
        this.label38.setText("Homozygous variant");
        this.panel33.add(this.label38);
        this.label38.setBounds(6, 51, 339, 29);
        this.panel33.add(this.homVarColorChooser);
        this.homVarColorChooser.setBounds(345, 51, 55, 29);
        this.label37.setText("Heterozygous variant");
        this.panel33.add(this.label37);
        this.label37.setBounds(6, 80, 339, 29);
        this.panel33.add(this.hetVarColorChooser);
        this.hetVarColorChooser.setBounds(345, 80, 55, 29);
        this.label40.setText("No call");
        this.panel33.add(this.label40);
        this.label40.setBounds(6, 109, 339, 29);
        this.panel33.add(this.noCallColorChooser);
        this.noCallColorChooser.setBounds(345, 109, 55, 29);
        this.label41.setText("Allele freq - reference");
        this.panel33.add(this.label41);
        this.label41.setBounds(6, 138, 339, 29);
        this.panel33.add(this.afRefColorChooser);
        this.afRefColorChooser.setBounds(345, 138, 55, 29);
        this.label42.setText("Allele freq - variant");
        this.panel33.add(this.label42);
        this.label42.setBounds(6, 167, 339, 29);
        this.panel33.add(this.afVarColorChooser);
        this.afVarColorChooser.setBounds(345, 167, 55, 29);
        this.resetVCFButton.setText("Reset to defaults");
        this.resetVCFButton.addActionListener(e -> this.resetVCFButtonActionPerformed(e));
        this.panel33.add(this.resetVCFButton);
        this.resetVCFButton.setBounds(5, 265, 144, this.resetVCFButton.getPreferredSize().height);
        this.panel35.setLayout(new FlowLayout(0));
        this.label43.setText("Color variant by: ");
        this.panel35.add(this.label43);
        this.alleleFreqRB.setText("Allele frequency");
        this.panel35.add(this.alleleFreqRB);
        this.alleleFractionRB.setText("Allele fraction");
        this.panel35.add(this.alleleFractionRB);
        this.panel33.add(this.panel35);
        this.panel35.setBounds(5, 220, 450, this.panel35.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i = 0; i < this.panel33.getComponentCount(); ++i) {
            bounds = this.panel33.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel33.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel33.setMinimumSize(preferredSize);
        this.panel33.setPreferredSize(preferredSize);
        this.overlaysPanel.add(this.panel33);
        this.panel33.setBounds(20, 25, 690, 325);
        preferredSize = new Dimension();
        for (int i = 0; i < this.overlaysPanel.getComponentCount(); ++i) {
            bounds = this.overlaysPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.overlaysPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.overlaysPanel.setMinimumSize(preferredSize);
        this.overlaysPanel.setPreferredSize(preferredSize);
        this.panel24.setViewportView(this.overlaysPanel);
        this.tabbedPane.addTab("Variants", this.panel24);
        this.chartPanel.setLayout(null);
        this.jPanel4.setBorder(null);
        this.jPanel4.setLayout(null);
        this.topBorderCB.setText("Draw Top Border");
        this.topBorderCB.addActionListener(e -> {
            this.topBorderCBActionPerformed(e);
            this.topBorderCBActionPerformed(e);
        });
        this.jPanel4.add(this.topBorderCB);
        this.topBorderCB.setBounds(new Rectangle(new Point(30, 36), this.topBorderCB.getPreferredSize()));
        this.label1.setFont(this.label1.getFont());
        this.label1.setText("<html><b>Default settings for barcharts and scatterplots:");
        this.jPanel4.add(this.label1);
        this.label1.setBounds(10, 10, 380, 25);
        this.chartDrawTrackNameCB.setText("Draw Track Label");
        this.chartDrawTrackNameCB.addActionListener(e -> this.chartDrawTrackNameCBActionPerformed(e));
        this.jPanel4.add(this.chartDrawTrackNameCB);
        this.chartDrawTrackNameCB.setBounds(new Rectangle(new Point(30, 126), this.chartDrawTrackNameCB.getPreferredSize()));
        this.bottomBorderCB.setText("Draw Bottom Border");
        this.bottomBorderCB.addActionListener(e -> this.bottomBorderCBActionPerformed(e));
        this.jPanel4.add(this.bottomBorderCB);
        this.bottomBorderCB.setBounds(new Rectangle(new Point(30, 66), this.bottomBorderCB.getPreferredSize()));
        this.jLabel7.setText("<html><i>Dynamically rescale to the range of the data in view.");
        this.jPanel4.add(this.jLabel7);
        this.jLabel7.setBounds(220, 170, 371, 50);
        this.colorBordersCB.setText("Color Borders");
        this.colorBordersCB.addActionListener(e -> this.colorBordersCBActionPerformed(e));
        this.jPanel4.add(this.colorBordersCB);
        this.colorBordersCB.setBounds(new Rectangle(new Point(30, 96), this.colorBordersCB.getPreferredSize()));
        this.labelYAxisCB.setText("Label Y Axis");
        this.labelYAxisCB.addActionListener(e -> this.labelYAxisCBActionPerformed(e));
        this.jPanel4.add(this.labelYAxisCB);
        this.labelYAxisCB.setBounds(new Rectangle(new Point(30, 156), this.labelYAxisCB.getPreferredSize()));
        this.autoscaleCB.setText("Continuous Autoscale");
        this.autoscaleCB.addActionListener(e -> this.autoscaleCBActionPerformed(e));
        this.jPanel4.add(this.autoscaleCB);
        this.autoscaleCB.setBounds(new Rectangle(new Point(30, 186), this.autoscaleCB.getPreferredSize()));
        this.jLabel9.setText("<html><i>Draw a label centered over the track. ");
        this.jPanel4.add(this.jLabel9);
        this.jLabel9.setBounds(220, 159, 355, this.jLabel9.getPreferredSize().height);
        this.showDatarangeCB.setText("Show Data Range");
        this.showDatarangeCB.addActionListener(e -> this.showDatarangeCBActionPerformed(e));
        this.showDatarangeCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.showDatarangeCBFocusLost(e);
            }
        });
        this.jPanel4.add(this.showDatarangeCB);
        this.showDatarangeCB.setBounds(30, 216, this.showDatarangeCB.getPreferredSize().width, 26);
        preferredSize = new Dimension();
        for (int i = 0; i < this.jPanel4.getComponentCount(); ++i) {
            bounds = this.jPanel4.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel4.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel4.setMinimumSize(preferredSize);
        this.jPanel4.setPreferredSize(preferredSize);
        this.chartPanel.add(this.jPanel4);
        this.jPanel4.setBounds(20, 20, 650, 290);
        this.panel1.setBorder(null);
        this.panel1.setLayout(null);
        this.label13.setText("<html><b>Default settings for heatmaps:");
        this.panel1.add(this.label13);
        this.label13.setBounds(10, 5, 250, 30);
        this.showAllHeatmapFeauresCB.setText("Show all features");
        this.showAllHeatmapFeauresCB.addActionListener(e -> this.showAllHeatmapFeauresCBActionPerformed(e));
        this.panel1.add(this.showAllHeatmapFeauresCB);
        this.showAllHeatmapFeauresCB.setBounds(new Rectangle(new Point(20, 45), this.showAllHeatmapFeauresCB.getPreferredSize()));
        this.label14.setText("<html><i>Paint all features/segments with a minimum width of 1 pixel.  If not checked, features/segments with screen widths less than 1 pixel are not drawn.");
        this.panel1.add(this.label14);
        this.label14.setBounds(200, 35, 425, 60);
        this.chartPanel.add(this.panel1);
        this.panel1.setBounds(20, 340, 650, 135);
        preferredSize = new Dimension();
        for (int i = 0; i < this.chartPanel.getComponentCount(); ++i) {
            bounds = this.chartPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.chartPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.chartPanel.setMinimumSize(preferredSize);
        this.chartPanel.setPreferredSize(preferredSize);
        this.panel25.setViewportView(this.chartPanel);
        this.tabbedPane.addTab("Charts", this.panel25);
        this.alignmentPanel.setLayout(new BoxLayout(this.alignmentPanel, 1));
        this.jPanel11.setBorder(new TitledBorder("Track Display Options"));
        this.jPanel11.setLayout(new FlowLayout(0));
        this.panel32.setLayout(new FlowLayout(0));
        this.label39.setText("On initial load show:");
        this.panel32.add(this.label39);
        this.showAlignmentTrackCB.setText("Alignment Track");
        this.showAlignmentTrackCB.setHorizontalAlignment(2);
        this.showAlignmentTrackCB.addActionListener(e -> this.showAlignmentTrackCBActionPerformed(e));
        this.panel32.add(this.showAlignmentTrackCB);
        this.showCovTrackCB.setText("Coverage Track");
        this.showCovTrackCB.addActionListener(e -> this.showCovTrackCBActionPerformed(e));
        this.panel32.add(this.showCovTrackCB);
        this.showJunctionTrackCB.setText("Splice Junction Track");
        this.showJunctionTrackCB.addActionListener(e -> this.showJunctionTrackCBActionPerformed(e));
        this.panel32.add(this.showJunctionTrackCB);
        this.jPanel11.add(this.panel32);
        this.alignmentPanel.add(this.jPanel11);
        this.jPanel12.setBorder(new TitledBorder("Alignment Track Options"));
        this.jPanel12.setLayout(new BoxLayout(this.jPanel12, 1));
        this.panel13.setLayout(new GridLayout(7, 0));
        this.panel31.setLayout(new FlowLayout(0));
        this.jLabel11.setText("Visibility range threshold (kb):");
        this.jLabel11.setPreferredSize(new Dimension(250, 16));
        this.panel31.add(this.jLabel11);
        this.samMaxWindowSizeField.setText("jTextField1");
        this.samMaxWindowSizeField.setPreferredSize(new Dimension(80, 28));
        this.samMaxWindowSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samMaxWindowSizeFieldFocusLost(e);
            }
        });
        this.samMaxWindowSizeField.addActionListener(e -> this.samMaxWindowSizeFieldActionPerformed(e));
        this.panel31.add(this.samMaxWindowSizeField);
        this.jLabel12.setText("<html><i>Range at which alignments become visible");
        this.panel31.add(this.jLabel12);
        this.panel13.add(this.panel31);
        this.panel4.setBorder(null);
        this.panel4.setLayout(new FlowLayout(0, 0, 5));
        this.downsampleReadsCB.setText("Downsample reads");
        this.downsampleReadsCB.setHorizontalAlignment(2);
        this.downsampleReadsCB.addActionListener(e -> this.downsampleReadsCBActionPerformed(e));
        this.panel4.add(this.downsampleReadsCB);
        this.panel4.add(this.hSpacer3);
        this.label23.setText("Max read count:");
        this.panel4.add(this.label23);
        this.samDownsampleCountField.setPreferredSize(new Dimension(100, 28));
        this.samDownsampleCountField.addActionListener(e -> this.samDownsampleCountFieldActionPerformed(e));
        this.samDownsampleCountField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samDownsampleCountFieldFocusLost(e);
            }
        });
        this.panel4.add(this.samDownsampleCountField);
        this.jLabel13.setText("per window size (bases):");
        this.panel4.add(this.jLabel13);
        this.samSamplingWindowField.setText("jTextField1");
        this.samSamplingWindowField.setPreferredSize(new Dimension(100, 28));
        this.samSamplingWindowField.addActionListener(e -> this.samSamplingWindowFieldActionPerformed(e));
        this.samSamplingWindowField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samSamplingWindowFieldFocusLost(e);
            }
        });
        this.panel4.add(this.samSamplingWindowField);
        this.panel13.add(this.panel4);
        this.panel11.setBorder(null);
        this.panel11.setLayout(new FlowLayout(0, 0, 5));
        this.samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality:");
        this.samShadeMismatchedBaseCB.addActionListener(e -> this.samShadeMismatchedBaseCBActionPerformed(e));
        this.panel11.add(this.samShadeMismatchedBaseCB);
        this.samMinBaseQualityField.setText("0");
        this.samMinBaseQualityField.setPreferredSize(new Dimension(60, 28));
        this.samMinBaseQualityField.addActionListener(e -> this.samMinBaseQualityFieldActionPerformed(e));
        this.samMinBaseQualityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samMinBaseQualityFieldFocusLost(e);
            }
        });
        this.panel11.add(this.samMinBaseQualityField);
        this.label2.setText("to");
        this.panel11.add(this.label2);
        this.samMaxBaseQualityField.setText("0");
        this.samMaxBaseQualityField.setPreferredSize(new Dimension(60, 28));
        this.samMaxBaseQualityField.addActionListener(e -> this.samMaxBaseQualityFieldActionPerformed(e));
        this.samMaxBaseQualityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samMaxBaseQualityFieldFocusLost(e);
            }
        });
        this.panel11.add(this.samMaxBaseQualityField);
        this.panel13.add(this.panel11);
        this.panel12.setLayout(new FlowLayout(0));
        this.jLabel15.setText("Mapping quality threshold:");
        this.panel12.add(this.jLabel15);
        this.mappingQualityThresholdField.setText("0");
        this.mappingQualityThresholdField.setPreferredSize(new Dimension(60, 28));
        this.mappingQualityThresholdField.addActionListener(e -> this.mappingQualityThresholdFieldActionPerformed(e));
        this.mappingQualityThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.mappingQualityThresholdFieldFocusLost(e);
            }
        });
        this.panel12.add(this.mappingQualityThresholdField);
        this.panel13.add(this.panel12);
        this.panel10.setBorder(null);
        this.panel10.setLayout(new FlowLayout(0, 0, 5));
        this.samFlagIndelsCB.setText("Label indels > ");
        this.samFlagIndelsCB.addActionListener(e -> this.samFlagIndelsCBActionPerformed(e));
        this.panel10.add(this.samFlagIndelsCB);
        this.samFlagIndelsThresholdField.setPreferredSize(new Dimension(60, 26));
        this.samFlagIndelsThresholdField.addActionListener(e -> {
            this.samFlagIndelsThresholdFieldActionPerformed(e);
            this.samFlagIndelsThresholdFieldActionPerformed(e);
        });
        this.samFlagIndelsThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samFlagIndelsThresholdFieldFocusLost(e);
            }
        });
        this.panel10.add(this.samFlagIndelsThresholdField);
        this.label31.setText(" bases");
        this.panel10.add(this.label31);
        this.panel13.add(this.panel10);
        this.panel10clip.setBorder(null);
        this.panel10clip.setLayout(new FlowLayout(0, 0, 5));
        this.samFlagClippingCB.setText("Flag clipping > ");
        this.samFlagClippingCB.addActionListener(e -> this.samFlagClippingCBActionPerformed(e));
        this.panel10clip.add(this.samFlagClippingCB);
        this.samFlagClippingThresholdField.setPreferredSize(new Dimension(60, 26));
        this.samFlagClippingThresholdField.addActionListener(e -> {
            this.samFlagClippingThresholdFieldActionPerformed(e);
            this.samFlagClippingThresholdFieldActionPerformed(e);
        });
        this.samFlagClippingThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samFlagClippingThresholdFieldFocusLost(e);
            }
        });
        this.panel10clip.add(this.samFlagClippingThresholdField);
        this.label31clip.setText(" bases");
        this.panel10clip.add(this.label31clip);
        this.panel13.add(this.panel10clip);
        this.panel9.setLayout(new FlowLayout(0, 0, 5));
        this.hideIndelsBasesCB.setText("Hide indels < ");
        this.hideIndelsBasesCB.addActionListener(e -> this.hideIndelsBasesCBActionPerformed(e));
        this.panel9.add(this.hideIndelsBasesCB);
        this.hideIndelsBasesField.setPreferredSize(new Dimension(60, 26));
        this.hideIndelsBasesField.addActionListener(e -> this.hideIndelsBasesFieldActionPerformed(e));
        this.hideIndelsBasesField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.hideIndelsBasesFieldFocusLost(e);
            }
        });
        this.panel9.add(this.hideIndelsBasesField);
        this.label45.setText(" bases");
        this.panel9.add(this.label45);
        this.panel13.add(this.panel9);
        this.jPanel12.add(this.panel13);
        this.panel8.setLayout(new GridLayout(4, 1));
        this.samFilterDuplicatesCB.setText("Filter duplicate reads");
        this.samFilterDuplicatesCB.addActionListener(e -> this.samShowDuplicatesCBActionPerformed(e));
        this.panel8.add(this.samFilterDuplicatesCB);
        this.samFlagUnmappedPairCB.setText("Flag unmapped pairs");
        this.samFlagUnmappedPairCB.addActionListener(e -> this.samFlagUnmappedPairCBActionPerformed(e));
        this.panel8.add(this.samFlagUnmappedPairCB);
        this.filterFailedReadsCB.setText("Filter vendor failed reads");
        this.filterFailedReadsCB.addActionListener(e -> this.filterVendorFailedReadsCBActionPerformed(e));
        this.panel8.add(this.filterFailedReadsCB);
        this.showSoftClippedCB.setText("Show soft-clipped bases");
        this.showSoftClippedCB.addActionListener(e -> this.showSoftClippedCBActionPerformed(e));
        this.panel8.add(this.showSoftClippedCB);
        this.filterSecondaryAlignmentsCB.setText("Filter secondary alignments");
        this.filterSecondaryAlignmentsCB.addActionListener(e -> this.filterSecondaryAlignmentsCBActionPerformed(e));
        this.panel8.add(this.filterSecondaryAlignmentsCB);
        this.quickConsensusModeCB.setText("Quick consensus mode");
        this.quickConsensusModeCB.addActionListener(e -> this.quickConsensusModeCBActionPerformed());
        this.panel8.add(this.quickConsensusModeCB);
        this.showCenterLineCB.setText("Show center line");
        this.showCenterLineCB.addActionListener(e -> this.showCenterLineCBActionPerformed(e));
        this.panel8.add(this.showCenterLineCB);
        this.filterSupplementaryAlignmentsCB.setText("Filter supplementary alignments");
        this.filterSupplementaryAlignmentsCB.addActionListener(e -> this.filterSupplementaryAlignmentsCBActionPerformed(e));
        this.panel8.add(this.filterSupplementaryAlignmentsCB);
        this.jPanel12.add(this.panel8);
        this.panel31b.setLayout(new FlowLayout(0));
        this.jLabel11b.setText("Hidden SAM tags:");
        this.jLabel11b.setPreferredSize(new Dimension(120, 16));
        this.panel31b.add(this.jLabel11b);
        this.samHiddenTagsField.setText("jTextField1b");
        this.samHiddenTagsField.setPreferredSize(new Dimension(250, 28));
        this.samHiddenTagsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.samHiddenTagsFieldFocusLost(e);
            }
        });
        this.samHiddenTagsField.addActionListener(e -> this.samHiddenTagsFieldActionPerformed(e));
        this.panel31b.add(this.samHiddenTagsField);
        this.jPanel12.add(this.panel31b);
        this.alignmentPanel.add(this.jPanel12);
        this.vSpacer5.setPreferredSize(new Dimension(10, 5));
        this.alignmentPanel.add(this.vSpacer5);
        this.panel34.setBorder(new TitledBorder("Coverage Track Options"));
        this.panel34.setLayout(new FlowLayout(0));
        this.panel5.setLayout(new FlowLayout(0));
        this.jLabel26.setText("Coverage allele-fraction threshold:");
        this.panel5.add(this.jLabel26);
        this.snpThresholdField.setText("0");
        this.snpThresholdField.setPreferredSize(new Dimension(60, 28));
        this.snpThresholdField.addActionListener(e -> this.snpThresholdFieldActionPerformed(e));
        this.snpThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.snpThresholdFieldFocusLost(e);
            }
        });
        this.panel5.add(this.snpThresholdField);
        this.hSpacer2.setPreferredSize(new Dimension(50, 10));
        this.panel5.add(this.hSpacer2);
        this.panel34.add(this.panel5);
        this.useAlleleQualityCB.setText("Quality weight allele fraction");
        this.useAlleleQualityCB.addActionListener(e -> this.useAlleleQualityCBActionPerformed(e));
        this.panel34.add(this.useAlleleQualityCB);
        this.alignmentPanel.add(this.panel34);
        this.panel3.setBorder(new TitledBorder("Splice Junction Track Options"));
        this.panel3.setLayout(new FlowLayout(0));
        this.showJunctionFlankingRegionsCB.setText("Show flanking regions");
        this.showJunctionFlankingRegionsCB.addActionListener(e -> this.showJunctionFlankingRegionsCBActionPerformed(e));
        this.panel3.add(this.showJunctionFlankingRegionsCB);
        this.label15.setText("Min flanking width:");
        this.panel3.add(this.label15);
        this.junctionFlankingTextField.setPreferredSize(new Dimension(80, 28));
        this.junctionFlankingTextField.addActionListener(e -> this.junctionFlankingTextFieldActionPerformed(e));
        this.junctionFlankingTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.junctionFlankingTextFieldFocusLost(e);
            }
        });
        this.panel3.add(this.junctionFlankingTextField);
        this.label16.setText("Min junction coverage:");
        this.panel3.add(this.label16);
        this.junctionCoverageTextField.setPreferredSize(new Dimension(80, 28));
        this.junctionCoverageTextField.addActionListener(e -> this.junctionCoverageTextFieldActionPerformed(e));
        this.junctionCoverageTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.junctionCoverageTextFieldFocusLost(e);
            }
        });
        this.panel3.add(this.junctionCoverageTextField);
        this.alignmentPanel.add(this.panel3);
        this.vSpacer6.setPreferredSize(new Dimension(10, 5));
        this.alignmentPanel.add(this.vSpacer6);
        this.panel2.setBorder(new TitledBorder("Insert Size Options"));
        this.panel2.setToolTipText("These options control the color coding of paired alignments by inferred insert size.  Base pair values set default values.  If \"compute\" is selected, values are computed from the actual size distribution of each library.");
        this.panel2.setLayout(new GridLayout());
        this.panel19.setLayout(new GridLayout());
        this.panel16.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel16.getLayout()).columnWidths = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panel16.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel16.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel16.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.label9.setText("Defaults ");
        this.panel16.add((Component)this.label9, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jLabel20.setText("Minimum (bp):");
        this.panel16.add((Component)this.jLabel20, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.insertSizeMinThresholdField.setText("0");
        this.insertSizeMinThresholdField.setPreferredSize(new Dimension(60, 28));
        this.insertSizeMinThresholdField.setMinimumSize(new Dimension(60, 28));
        this.insertSizeMinThresholdField.addActionListener(e -> {
            this.insertSizeThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
        });
        this.insertSizeMinThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e);
                PreferencesEditor.this.insertSizeMinThresholdFieldFocusLost(e);
            }
        });
        this.panel16.add((Component)this.insertSizeMinThresholdField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jLabel17.setText("Maximum (bp):");
        this.panel16.add((Component)this.jLabel17, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.insertSizeThresholdField.setText("0");
        this.insertSizeThresholdField.setPreferredSize(new Dimension(60, 28));
        this.insertSizeThresholdField.addActionListener(e -> {
            this.insertSizeThresholdFieldActionPerformed(e);
            this.insertSizeThresholdFieldActionPerformed(e);
        });
        this.insertSizeThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e);
            }
        });
        this.panel16.add((Component)this.insertSizeThresholdField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel19.add(this.panel16);
        this.panel15.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel15.getLayout()).columnWidths = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panel15.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel15.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel15.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0E-4};
        this.isizeComputeCB.setText("Compute");
        this.isizeComputeCB.setToolTipText("Min and max values are computed from the actual size distribution of each library.");
        this.isizeComputeCB.addActionListener(e -> {
            this.isizeComputeCBActionPerformed(e);
            this.isizeComputeCBActionPerformed(e);
            this.isizeComputeCBActionPerformed(e);
        });
        this.panel15.add((Component)this.isizeComputeCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jLabel30.setText("Minimum (percentile):");
        this.panel15.add((Component)this.jLabel30, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.insertSizeMinPercentileField.setText("0");
        this.insertSizeMinPercentileField.setPreferredSize(new Dimension(60, 28));
        this.insertSizeMinPercentileField.setMinimumSize(new Dimension(60, 28));
        this.insertSizeMinPercentileField.addActionListener(e -> {
            this.insertSizeThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
            this.insertSizeMinThresholdFieldActionPerformed(e);
            this.insertSizeMinPercentileFieldActionPerformed(e);
        });
        this.insertSizeMinPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e);
                PreferencesEditor.this.insertSizeMinThresholdFieldFocusLost(e);
                PreferencesEditor.this.insertSizeMinPercentileFieldFocusLost(e);
            }
        });
        this.panel15.add((Component)this.insertSizeMinPercentileField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jLabel18.setText("Maximum (percentile):");
        this.panel15.add((Component)this.jLabel18, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.insertSizeMaxPercentileField.setText("0");
        this.insertSizeMaxPercentileField.setPreferredSize(new Dimension(60, 28));
        this.insertSizeMaxPercentileField.addActionListener(e -> {
            this.insertSizeThresholdFieldActionPerformed(e);
            this.insertSizeThresholdFieldActionPerformed(e);
            this.insertSizeMaxPercentileFieldActionPerformed(e);
        });
        this.insertSizeMaxPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e);
                PreferencesEditor.this.insertSizeMaxPercentileFieldFocusLost(e);
            }
        });
        this.panel15.add((Component)this.insertSizeMaxPercentileField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel19.add(this.panel15);
        this.panel2.add(this.panel19);
        this.alignmentPanel.add(this.panel2);
        this.panel20.setViewportView(this.alignmentPanel);
        this.tabbedPane.addTab("Alignments", this.panel20);
        this.expressionPane.setLayout(null);
        this.jPanel8.setLayout(null);
        this.panel18.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel18.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.panel18.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panel18.getLayout()).columnWeights = new double[]{0.0, 1.0E-4};
        ((GridBagLayout)this.panel18.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.jLabel24.setText("Expression probe mapping options: ");
        this.panel18.add((Component)this.jLabel24, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
        this.jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");
        this.panel18.add((Component)this.jLabel21, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
        this.expMapToLociCB.setText("<html>Map probes to target loci");
        this.expMapToLociCB.addActionListener(e -> this.expMapToLociCBActionPerformed(e));
        this.panel18.add((Component)this.expMapToLociCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 15, 0), 0, 0));
        this.expMapToGeneCB.setText("Map probes to genes");
        this.expMapToGeneCB.addActionListener(e -> {
            this.expMapToGeneCBActionPerformed(e);
            this.expMapToGeneCBActionPerformed(e);
        });
        this.panel18.add((Component)this.expMapToGeneCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel8.add(this.panel18);
        this.panel18.setBounds(new Rectangle(new Point(20, 20), this.panel18.getPreferredSize()));
        this.panel17.setLayout(new GridLayout(3, 1));
        this.useProbeMappingCB.setText("Use probe mapping file");
        this.useProbeMappingCB.addActionListener(e -> this.useProbeMappingCBActionPerformed(e));
        this.panel17.add(this.useProbeMappingCB);
        this.label22.setText("<html><i>File path or URL to BED file containing genomic locations of probes:");
        this.panel17.add(this.label22);
        this.panel14.setLayout(null);
        this.probeMappingFileTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.probeMappingFileTextFieldFocusLost(e);
            }
        });
        this.probeMappingFileTextField.addActionListener(e -> this.probeMappingFileTextFieldActionPerformed(e));
        this.panel14.add(this.probeMappingFileTextField);
        this.probeMappingFileTextField.setBounds(0, 0, 581, this.probeMappingFileTextField.getPreferredSize().height);
        this.probeMappingBrowseButton.setText("Browse");
        this.probeMappingBrowseButton.addActionListener(e -> this.probeMappingBrowseButtonActionPerformed(e));
        this.panel14.add(this.probeMappingBrowseButton);
        this.probeMappingBrowseButton.setBounds(new Rectangle(new Point(592, 0), this.probeMappingBrowseButton.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i = 0; i < this.panel14.getComponentCount(); ++i) {
            bounds = this.panel14.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel14.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel14.setMinimumSize(preferredSize);
        this.panel14.setPreferredSize(preferredSize);
        this.panel17.add(this.panel14);
        this.jPanel8.add(this.panel17);
        this.panel17.setBounds(20, 247, 735, this.panel17.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i = 0; i < this.jPanel8.getComponentCount(); ++i) {
            bounds = this.jPanel8.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel8.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel8.setMinimumSize(preferredSize);
        this.jPanel8.setPreferredSize(preferredSize);
        this.expressionPane.add(this.jPanel8);
        this.jPanel8.setBounds(10, 30, 755, 470);
        preferredSize = new Dimension();
        for (int i = 0; i < this.expressionPane.getComponentCount(); ++i) {
            bounds = this.expressionPane.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.expressionPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.expressionPane.setMinimumSize(preferredSize);
        this.expressionPane.setPreferredSize(preferredSize);
        this.panel26.setViewportView(this.expressionPane);
        this.tabbedPane.addTab("Probes", this.panel26);
        this.proxyPanel.setLayout(new BoxLayout(this.proxyPanel, 0));
        this.jPanel15.setLayout(null);
        this.label3.setText("<html>Note:  do not use these settings unless you receive error or warning messages about server connections.  On most systems the correct settings will be automatically copied from your web browser.");
        this.jPanel15.add(this.label3);
        this.label3.setBounds(22, 20, 630, 63);
        this.clearProxySettingsButton.setText("Clear All");
        this.clearProxySettingsButton.addActionListener(e -> this.clearProxySettingsButtonActionPerformed(e));
        this.jPanel15.add(this.clearProxySettingsButton);
        this.clearProxySettingsButton.setBounds(new Rectangle(new Point(15, 620), this.clearProxySettingsButton.getPreferredSize()));
        this.proxyUsernameField.setText("jTextField1");
        this.proxyUsernameField.setEnabled(false);
        this.proxyUsernameField.setPreferredSize(new Dimension(500, 28));
        this.proxyUsernameField.addActionListener(e -> this.proxyUsernameFieldActionPerformed(e));
        this.proxyUsernameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.proxyUsernameFieldFocusLost(e);
            }
        });
        this.jPanel15.add(this.proxyUsernameField);
        this.proxyUsernameField.setBounds(120, 495, 615, this.proxyUsernameField.getPreferredSize().height);
        this.jLabel28.setText("Username:");
        this.jPanel15.add(this.jLabel28);
        this.jLabel28.setBounds(20, 495, this.jLabel28.getPreferredSize().width, 28);
        this.authenticateProxyCB.setText("Authentication required");
        this.authenticateProxyCB.addActionListener(e -> this.authenticateProxyCBActionPerformed(e));
        this.jPanel15.add(this.authenticateProxyCB);
        this.authenticateProxyCB.setBounds(20, 455, 571, this.authenticateProxyCB.getPreferredSize().height);
        this.jLabel29.setText("Password:");
        this.jPanel15.add(this.jLabel29);
        this.jLabel29.setBounds(20, 540, 66, 28);
        this.proxyPasswordField.setText("jPasswordField1");
        this.proxyPasswordField.setEnabled(false);
        this.proxyPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.proxyPasswordFieldFocusLost(e);
            }
        });
        this.jPanel15.add(this.proxyPasswordField);
        this.proxyPasswordField.setBounds(120, 540, 615, this.proxyPasswordField.getPreferredSize().height);
        this.proxyHostField.setText("jTextField1");
        this.proxyHostField.setPreferredSize(new Dimension(500, 28));
        this.proxyHostField.addActionListener(e -> this.proxyHostFieldActionPerformed(e));
        this.proxyHostField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.proxyHostFieldFocusLost(e);
            }
        });
        this.jPanel15.add(this.proxyHostField);
        this.proxyHostField.setBounds(120, 155, 615, this.proxyHostField.getPreferredSize().height);
        this.proxyPortField.setText("jTextField1");
        this.proxyPortField.addActionListener(e -> this.proxyPortFieldActionPerformed(e));
        this.proxyPortField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.proxyPortFieldFocusLost(e);
            }
        });
        this.jPanel15.add(this.proxyPortField);
        this.proxyPortField.setBounds(120, 213, 615, this.proxyPortField.getPreferredSize().height);
        this.jLabel27.setText("Proxy port:");
        this.jPanel15.add(this.jLabel27);
        this.jLabel27.setBounds(20, 213, 95, 28);
        this.jLabel23.setText("Proxy host:");
        this.jPanel15.add(this.jLabel23);
        this.jLabel23.setBounds(20, 155, 95, 28);
        this.useProxyCB.setText("Use proxy");
        this.useProxyCB.addActionListener(e -> this.useProxyCBActionPerformed(e));
        this.jPanel15.add(this.useProxyCB);
        this.useProxyCB.setBounds(new Rectangle(new Point(20, 105), this.useProxyCB.getPreferredSize()));
        this.proxyTypeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"HTTP", "SOCKS", "DIRECT"}));
        this.proxyTypeCB.addActionListener(e -> this.proxyTypeCBActionPerformed(e));
        this.jPanel15.add(this.proxyTypeCB);
        this.proxyTypeCB.setBounds(120, 271, 615, this.proxyTypeCB.getPreferredSize().height);
        this.label27.setText("Proxy type:");
        this.jPanel15.add(this.label27);
        this.label27.setBounds(20, 271, 95, 27);
        this.label35.setText("<html>Whitelist:  <i>comma delimited list of hosts to whitelist (bypass proxy)</i>");
        this.jPanel15.add(this.label35);
        this.label35.setBounds(new Rectangle(new Point(20, 328), this.label35.getPreferredSize()));
        this.proxyWhitelistTextArea.addActionListener(e -> this.proxyWhitelistTextAreaActionPerformed(e));
        this.proxyWhitelistTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.proxyWhitelistTextAreaFocusLost(e);
            }
        });
        this.jPanel15.add(this.proxyWhitelistTextArea);
        this.proxyWhitelistTextArea.setBounds(20, 355, 715, 35);
        preferredSize = new Dimension();
        for (int i = 0; i < this.jPanel15.getComponentCount(); ++i) {
            bounds = this.jPanel15.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel15.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel15.setMinimumSize(preferredSize);
        this.jPanel15.setPreferredSize(preferredSize);
        this.proxyPanel.add(this.jPanel15);
        this.panel27.setViewportView(this.proxyPanel);
        this.tabbedPane.addTab("Proxy", this.panel27);
        this.dbPanel.setLayout(null);
        this.label20.setText("<html><b>Database configuration  <i>(experimental, subject to change)");
        this.label20.setFont(new Font("Lucida Grande", 0, 14));
        this.dbPanel.add(this.label20);
        this.label20.setBounds(new Rectangle(new Point(50, 20), this.label20.getPreferredSize()));
        this.panel21.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel21.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel21.getLayout()).rowHeights = new int[]{0, 0, 0, 0};
        ((GridBagLayout)this.panel21.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel21.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        this.label17.setText("Host:");
        this.panel21.add((Component)this.label17, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.label19.setText("Name:");
        this.panel21.add((Component)this.label19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.dbNameField.setPreferredSize(new Dimension(500, 28));
        this.dbNameField.addActionListener(e -> this.dbNameFieldActionPerformed(e));
        this.dbNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.dbNameFieldFocusLost(e);
            }
        });
        this.panel21.add((Component)this.dbNameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dbHostField.setPreferredSize(new Dimension(500, 28));
        this.dbHostField.addActionListener(e -> this.dbHostFieldActionPerformed(e));
        this.dbHostField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.dbHostFieldFocusLost(e);
            }
        });
        this.panel21.add((Component)this.dbHostField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label18.setText("Port:");
        this.panel21.add((Component)this.label18, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.dbPortField.setPreferredSize(new Dimension(500, 28));
        this.dbPortField.addActionListener(e -> this.dbPortFieldActionPerformed(e));
        this.dbPortField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.dbPortFieldFocusLost(e);
            }
        });
        this.panel21.add((Component)this.dbPortField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dbPanel.add(this.panel21);
        this.panel21.setBounds(new Rectangle(new Point(20, 76), this.panel21.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i = 0; i < this.dbPanel.getComponentCount(); ++i) {
            bounds = this.dbPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.dbPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.dbPanel.setMinimumSize(preferredSize);
        this.dbPanel.setPreferredSize(preferredSize);
        this.panel30.setViewportView(this.dbPanel);
        this.tabbedPane.addTab("Database", this.panel30);
        this.advancedPanel.setBorder(new EmptyBorder(1, 10, 1, 10));
        this.advancedPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.advancedPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.advancedPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.advancedPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.advancedPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.clearGenomeCacheButton.setText("Clear Genome Cache");
        this.clearGenomeCacheButton.addActionListener(e -> this.clearGenomeCacheButtonActionPerformed(e));
        this.advancedPanel.add((Component)this.clearGenomeCacheButton, new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.enablePortCB.setText("Enable port");
        this.enablePortCB.addActionListener(e -> this.enablePortCBActionPerformed(e));
        this.advancedPanel.add((Component)this.enablePortCB, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.portField.setText("60151");
        this.portField.addActionListener(e -> this.portFieldActionPerformed(e));
        this.portField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.portFieldFocusLost(e);
            }
        });
        this.advancedPanel.add((Component)this.portField, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jLabel22.setFont(new Font("Lucida Grande", 2, 13));
        this.jLabel22.setText("Enable port to send commands and http requests to IGV. ");
        this.advancedPanel.add((Component)this.jLabel22, new GridBagConstraints(6, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.vSpacer12.setPreferredSize(new Dimension(10, 40));
        this.advancedPanel.add((Component)this.vSpacer12, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.genomeUpdateCB.setText("<html>Automatically check for updated genomes.    &nbsp;&nbsp;&nbsp;   <i>Most users should leave this checked.");
        this.genomeUpdateCB.addActionListener(e -> this.genomeUpdateCBActionPerformed(e));
        this.advancedPanel.add((Component)this.genomeUpdateCB, new GridBagConstraints(0, 6, 8, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jLabel6.setText("Data Registry URL");
        this.advancedPanel.add((Component)this.jLabel6, new GridBagConstraints(2, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.dataServerURLTextField.setEnabled(false);
        this.dataServerURLTextField.addActionListener(e -> this.dataServerURLTextFieldActionPerformed(e));
        this.dataServerURLTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.dataServerURLTextFieldFocusLost(e);
            }
        });
        this.advancedPanel.add((Component)this.dataServerURLTextField, new GridBagConstraints(5, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.jLabel1.setText("Genome Server URL");
        this.advancedPanel.add((Component)this.jLabel1, new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.genomeServerURLTextField.setText("jTextField1");
        this.genomeServerURLTextField.setEnabled(false);
        this.genomeServerURLTextField.addActionListener(e -> this.genomeServerURLTextFieldActionPerformed(e));
        this.genomeServerURLTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.genomeServerURLTextFieldFocusLost(e);
            }
        });
        this.advancedPanel.add((Component)this.genomeServerURLTextField, new GridBagConstraints(5, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.editServerPropertiesCB.setText("Edit server properties");
        this.editServerPropertiesCB.addActionListener(e -> this.editServerPropertiesCBActionPerformed(e));
        this.advancedPanel.add((Component)this.editServerPropertiesCB, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jButton1.setText("Reset to Defaults");
        this.jButton1.addActionListener(e -> this.jButton1ActionPerformed(e));
        this.advancedPanel.add((Component)this.jButton1, new GridBagConstraints(5, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.vSpacer11.setPreferredSize(new Dimension(10, 40));
        this.advancedPanel.add((Component)this.vSpacer11, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.autoFileDisoveryCB.setText("Automatically discover index and coverage files.");
        this.autoFileDisoveryCB.addActionListener(e -> this.autoFileDisoveryCBActionPerformed(e));
        this.advancedPanel.add((Component)this.autoFileDisoveryCB, new GridBagConstraints(0, 7, 8, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.igvDirectoryButton.setText("Move...");
        this.igvDirectoryButton.addActionListener(e -> this.igvDirectoryButtonActionPerformed(e));
        this.advancedPanel.add((Component)this.igvDirectoryButton, new GridBagConstraints(8, 15, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.igvDirectoryField.setBorder(new BevelBorder(1));
        this.advancedPanel.add((Component)this.igvDirectoryField, new GridBagConstraints(2, 15, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.label21.setText("IGV Directory: ");
        this.advancedPanel.add((Component)this.label21, new GridBagConstraints(0, 14, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.tooltipOptionsPanel.setLayout(null);
        this.label24.setText("Tooltip initial delay (ms)");
        this.tooltipOptionsPanel.add(this.label24);
        this.label24.setBounds(0, 11, 185, this.label24.getPreferredSize().height);
        this.label25.setText("Tooltip reshow delay (ms)");
        this.tooltipOptionsPanel.add(this.label25);
        this.label25.setBounds(0, 38, 185, 23);
        this.label26.setText("Tooltip dismiss delay (ms)");
        this.tooltipOptionsPanel.add(this.label26);
        this.label26.setBounds(0, 70, 185, 16);
        this.toolTipInitialDelayField.addActionListener(e -> this.toolTipInitialDelayFieldActionPerformed(e));
        this.toolTipInitialDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.toolTipInitialDelayFieldFocusLost(e);
            }
        });
        this.tooltipOptionsPanel.add(this.toolTipInitialDelayField);
        this.toolTipInitialDelayField.setBounds(220, 5, 455, this.toolTipInitialDelayField.getPreferredSize().height);
        this.tooltipReshowDelayField.addActionListener(e -> this.tooltipReshowDelayFieldActionPerformed(e));
        this.tooltipReshowDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.tooltipReshowDelayFieldFocusLost(e);
            }
        });
        this.tooltipOptionsPanel.add(this.tooltipReshowDelayField);
        this.tooltipReshowDelayField.setBounds(220, 35, 455, 28);
        this.tooltipDismissDelayField.addActionListener(e -> this.tooltipDismissDelayFieldActionPerformed(e));
        this.tooltipDismissDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.tooltipDismissDelayFieldFocusLost(e);
            }
        });
        this.tooltipOptionsPanel.add(this.tooltipDismissDelayField);
        this.tooltipDismissDelayField.setBounds(220, 64, 455, 28);
        preferredSize = new Dimension();
        for (int i = 0; i < this.tooltipOptionsPanel.getComponentCount(); ++i) {
            bounds = this.tooltipOptionsPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.tooltipOptionsPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.tooltipOptionsPanel.setMinimumSize(preferredSize);
        this.tooltipOptionsPanel.setPreferredSize(preferredSize);
        this.advancedPanel.add((Component)this.tooltipOptionsPanel, new GridBagConstraints(0, 10, 9, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.antialiasingCB.setText("Enable antialiasing");
        this.antialiasingCB.addActionListener(e -> this.antialiasingCBActionPerformed(e));
        this.advancedPanel.add((Component)this.antialiasingCB, new GridBagConstraints(0, 8, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.label5.setText("BLAT URL");
        this.advancedPanel.add((Component)this.label5, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.blatURLField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.blatURLFieldFocusLost(e);
            }
        });
        this.blatURLField.addActionListener(e -> this.blatURLFieldActionPerformed(e));
        this.advancedPanel.add((Component)this.blatURLField, new GridBagConstraints(3, 12, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.vSpacer8.setPreferredSize(new Dimension(10, 40));
        this.advancedPanel.add((Component)this.vSpacer8, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.vSpacer9.setPreferredSize(new Dimension(10, 40));
        this.advancedPanel.add((Component)this.vSpacer9, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.vSpacer10.setPreferredSize(new Dimension(10, 40));
        this.advancedPanel.add((Component)this.vSpacer10, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.panel29.setViewportView(this.advancedPanel);
        this.tabbedPane.addTab("Advanced", this.panel29);
        this.cramPanel.setBorder(new EmptyBorder(1, 10, 1, 10));
        this.cramPanel.setLayout(null);
        this.panel28.setLayout(new FlowLayout(0));
        this.cramPanel.add(this.panel28);
        this.panel28.setBounds(new Rectangle(new Point(15, 7), this.panel28.getPreferredSize()));
        this.panel37.setLayout(new FlowLayout(0));
        this.label28.setText("Reference cache size (mb): ");
        this.panel37.add(this.label28);
        this.cramCacheSizeField.setPreferredSize(new Dimension(100, 26));
        this.cramCacheSizeField.addActionListener(e -> this.cramCacheSizeFieldActionPerformed(e));
        this.cramCacheSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PreferencesEditor.this.cramCacheSizeFieldFocusLost(e);
            }
        });
        this.panel37.add(this.cramCacheSizeField);
        this.cramPanel.add(this.panel37);
        this.panel37.setBounds(new Rectangle(new Point(20, 93), this.panel37.getPreferredSize()));
        this.panel38.setLayout(new FlowLayout(0));
        this.label29.setText("Cache directory: ");
        this.panel38.add(this.label29);
        this.cramCacheDirectoryField.setMinimumSize(new Dimension(400, 26));
        this.cramCacheDirectoryField.setPreferredSize(new Dimension(400, 26));
        this.panel38.add(this.cramCacheDirectoryField);
        this.cramCacheDirectoryButton.setText("Change...");
        this.cramCacheDirectoryButton.addActionListener(e -> this.cramCacheDirectoryButtonActionPerformed(e));
        this.panel38.add(this.cramCacheDirectoryButton);
        this.cramPanel.add(this.panel38);
        this.panel38.setBounds(new Rectangle(new Point(20, 144), this.panel38.getPreferredSize()));
        this.cramCacheReferenceCB.setText("Cache reference sequences");
        this.cramCacheReferenceCB.addActionListener(e -> this.cramCacheReferenceCBActionPerformed(e));
        this.cramPanel.add(this.cramCacheReferenceCB);
        this.cramCacheReferenceCB.setBounds(new Rectangle(new Point(20, 55), this.cramCacheReferenceCB.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i = 0; i < this.cramPanel.getComponentCount(); ++i) {
            bounds = this.cramPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.cramPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.cramPanel.setMinimumSize(preferredSize);
        this.cramPanel.setPreferredSize(preferredSize);
        this.panel36.setViewportView(this.cramPanel);
        this.tabbedPane.addTab("Cram", this.panel36);
        this.panel6.add((Component)this.tabbedPane, "North");
        this.okCancelButtonPanel.setPreferredSize(new Dimension(178, 29));
        this.okCancelButtonPanel.setGroupGap(0);
        this.okButton.setText("OK");
        this.okButton.addActionListener(e -> this.okButtonActionPerformed(e));
        this.okCancelButtonPanel.add((Component)this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        this.okCancelButtonPanel.add((Component)this.cancelButton);
        this.panel6.add((Component)this.okCancelButtonPanel, "South");
        this.panel7.setViewportView(this.panel6);
        contentPane.add((Component)this.panel7, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.alleleFreqRB);
        buttonGroup2.add(this.alleleFractionRB);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.expMapToLociCB);
        buttonGroup1.add(this.expMapToGeneCB);
    }

    private void backgroundColorPanelMouseClicked(MouseEvent e) {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        Color backgroundColor = UIUtilities.showColorChooserDialog("Choose background color", prefMgr.getAsColor("BACKGROUND_COLOR"));
        if (backgroundColor != null) {
            prefMgr.put("BACKGROUND_COLOR", ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            this.backgroundColorPanel.setBackground(backgroundColor);
        }
    }

    private void resetBackgroundButtonActionPerformed(ActionEvent e) {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        prefMgr.remove("BACKGROUND_COLOR");
        Color backgroundColor = prefMgr.getAsColor("BACKGROUND_COLOR");
        if (backgroundColor != null) {
            prefMgr.put("BACKGROUND_COLOR", ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            this.backgroundColorPanel.setBackground(backgroundColor);
        }
    }

    private void resetFontButtonActionPerformed(ActionEvent e) {
        FontManager.resetDefaultFont();
        this.updateFontField();
    }

    private void filterSecondaryAlignmentsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.FILTER_SECONDARY_ALIGNMENTS", String.valueOf(this.filterSecondaryAlignmentsCB.isSelected()));
    }

    private void filterSupplementaryAlignmentsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.FILTER_SUPPLEMENTARY_ALIGNMENTS", String.valueOf(this.filterSupplementaryAlignmentsCB.isSelected()));
    }

    private void antialiasingCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("ENABLE_ANTIALIASING", String.valueOf(this.antialiasingCB.isSelected()));
    }

    private void useAlleleQualityCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.ALLELE_USE_QUALITY", String.valueOf(this.useAlleleQualityCB.isSelected()));
    }

    private void featureVisibilityWindowFieldActionPerformed(ActionEvent e) {
        boolean valid = false;
        String vw = this.featureVisibilityWindowField.getText().trim();
        try {
            double val = Double.parseDouble(vw);
            valid = true;
            this.updatedPreferenceMap.put("DEFAULT_VISIBILITY_WINDOW", vw);
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid && e != null) {
            this.junctionFlankingTextField.setText(this.prefMgr.get("DEFAULT_VISIBILITY_WINDOW"));
            MessageUtils.showMessage("Visibility window must be a number");
        }
    }

    private void featureVisibilityWindowFieldFocusLost(FocusEvent e) {
        this.featureVisibilityWindowFieldActionPerformed(null);
    }

    private void fontChangeButtonActionPerformed(ActionEvent e) {
        Font font;
        Font defaultFont = FontManager.getDefaultFont();
        FontChooser chooser = new FontChooser((Dialog)this, defaultFont);
        chooser.setModal(true);
        chooser.setVisible(true);
        if (!chooser.isCanceled() && (font = chooser.getSelectedFont()) != null) {
            this.prefMgr.put("DEFAULT_FONT_FAMILY", font.getFamily());
            this.prefMgr.put("DEFAULT_FONT_SIZE", String.valueOf(font.getSize()));
            int attrs = 0;
            if (font.isBold()) {
                attrs = 1;
            }
            if (font.isItalic()) {
                attrs |= 2;
            }
            this.prefMgr.put("DEFAULT_FONT_ATTRIBUTE", String.valueOf(attrs));
            FontManager.updateDefaultFont();
            this.updateFontField();
            IGV.getInstance().repaint();
        }
    }

    private void expMapToLociCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PROBE_MAPPING_KEY", String.valueOf(this.expMapToGeneCB.isSelected()));
    }

    private void clearGenomeCacheButtonActionPerformed(ActionEvent evt) {
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }

    private void editServerPropertiesCBActionPerformed(ActionEvent evt) {
        boolean edit = this.editServerPropertiesCB.isSelected();
        this.dataServerURLTextField.setEnabled(edit);
        this.genomeServerURLTextField.setEnabled(edit);
    }

    private void dataServerURLTextFieldFocusLost(FocusEvent evt) {
        String attributeName = this.dataServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", attributeName);
    }

    private void igvDirectoryButtonActionPerformed(ActionEvent e) {
        File igvDirectory = DirectoryManager.getIgvDirectory();
        File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
        if (newDirectory != null && !newDirectory.equals(igvDirectory.getParentFile())) {
            this.newIGVDirectory = new File(newDirectory, "igv");
            this.igvDirectoryField.setText(this.newIGVDirectory.getAbsolutePath());
        }
    }

    private void dataServerURLTextFieldActionPerformed(ActionEvent evt) {
        String attributeName = this.dataServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", attributeName);
    }

    private void genomeServerURLTextFieldFocusLost(FocusEvent evt) {
        String attributeName = this.genomeServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", attributeName);
    }

    private void genomeServerURLTextFieldActionPerformed(ActionEvent evt) {
        String attributeName = this.genomeServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", attributeName);
    }

    private void blatURLFieldFocusLost(FocusEvent e) {
        String attributeName = this.blatURLField.getText().trim();
        this.updatedPreferenceMap.put("BLAT_URL", attributeName);
    }

    private void blatURLFieldActionPerformed(ActionEvent e) {
        this.blatURLFieldFocusLost(null);
    }

    private void normalizeCoverageCBFocusLost(FocusEvent e) {
    }

    private void showJunctionTrackCBActionPerformed(ActionEvent evt) {
        boolean junctionTrackEnabled = this.showJunctionTrackCB.isSelected();
        this.updatedPreferenceMap.put("SAM.SHOW_JUNCTION_TRACK", String.valueOf(junctionTrackEnabled));
    }

    private void showJunctionFlankingRegionsCBActionPerformed(ActionEvent evt) {
        boolean junctionFlankingRegionsEnabled = this.showJunctionFlankingRegionsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.SHOW_JUNCTION_FLANKINGREGIONS", String.valueOf(junctionFlankingRegionsEnabled));
    }

    private void junctionFlankingTextFieldFocusLost(FocusEvent e) {
        this.junctionFlankingTextFieldActionPerformed(null);
    }

    private void junctionFlankingTextFieldActionPerformed(ActionEvent e) {
        boolean valid = false;
        String flankingWidth = this.junctionFlankingTextField.getText().trim();
        try {
            int val = Integer.parseInt(flankingWidth);
            if (val >= 0) {
                valid = true;
                this.updatedPreferenceMap.put("SAM.JUNCTION_MIN_FLANKING_WIDTH", flankingWidth);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid && e != null) {
            this.junctionFlankingTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_FLANKING_WIDTH"));
            MessageUtils.showMessage("Flanking width must be a positive integer.");
        }
    }

    private void junctionCoverageTextFieldActionPerformed(ActionEvent e) {
        this.junctionCoverageTextFieldFocusLost(null);
    }

    private void junctionCoverageTextFieldFocusLost(FocusEvent e) {
        boolean valid = false;
        String minCoverage = this.junctionCoverageTextField.getText().trim();
        try {
            int val = Integer.parseInt(minCoverage);
            if (val >= 0) {
                valid = true;
                this.updatedPreferenceMap.put("SAM.JUNCTION_MIN_COVERAGE", minCoverage);
            }
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid && e != null) {
            this.junctionCoverageTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_COVERAGE"));
            MessageUtils.showMessage("Minimum junction coverage must be a positive integer.");
        }
    }

    private void insertSizeThresholdFieldFocusLost(FocusEvent evt) {
        this.insertSizeThresholdFieldActionPerformed(null);
    }

    private void insertSizeThresholdFieldActionPerformed(ActionEvent evt) {
        String insertThreshold = this.insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            this.updatedPreferenceMap.put("SAM.INSERT_SIZE_THRESHOLD", insertThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void insertSizeMinThresholdFieldFocusLost(FocusEvent e) {
        this.insertSizeMinThresholdFieldActionPerformed(null);
    }

    private void insertSizeMinThresholdFieldActionPerformed(ActionEvent e) {
        String insertThreshold = this.insertSizeMinThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            this.updatedPreferenceMap.put("SAM.MIN_INSERT_SIZE_THRESHOLD", insertThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void mappingQualityThresholdFieldFocusLost(FocusEvent evt) {
        this.mappingQualityThresholdFieldActionPerformed(null);
    }

    private void mappingQualityThresholdFieldActionPerformed(ActionEvent evt) {
        String qualityThreshold = this.mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            this.updatedPreferenceMap.put("SAM.QUALITY_THRESHOLD", qualityThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void samFlagIndelsCBActionPerformed(ActionEvent e) {
        boolean flagInsertions = this.samFlagIndelsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.FLAG_LARGE_INDELS", String.valueOf(flagInsertions));
        this.samFlagIndelsThresholdField.setEnabled(flagInsertions);
    }

    private void samFlagIndelsThresholdFieldFocusLost(FocusEvent e) {
        this.samFlagIndelsThresholdFieldActionPerformed(null);
    }

    private void samFlagIndelsThresholdFieldActionPerformed(ActionEvent e) {
        String insertionThreshold = this.samFlagIndelsThresholdField.getText().trim();
        try {
            int tmp = Integer.parseInt(insertionThreshold);
            if (tmp <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Insertion threshold must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.LARGE_INSERTIONS_THRESOLD", insertionThreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Insertion threshold must be a positive integer.");
        }
    }

    private void samFlagClippingCBActionPerformed(ActionEvent e) {
        boolean flagClipping = this.samFlagClippingCB.isSelected();
        this.updatedPreferenceMap.put("SAM.FLAG_CLIPPING", String.valueOf(flagClipping));
        this.samFlagClippingThresholdField.setEnabled(flagClipping);
    }

    private void samFlagClippingThresholdFieldFocusLost(FocusEvent e) {
        this.samFlagClippingThresholdFieldActionPerformed(null);
    }

    private void samFlagClippingThresholdFieldActionPerformed(ActionEvent e) {
        String clippingThreshold = this.samFlagClippingThresholdField.getText().trim();
        try {
            int tmp = Integer.parseInt(clippingThreshold);
            if (tmp < 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Clipping threshold must be a non-negative integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.CLIPPING_THRESHOLD", clippingThreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Clipping threshold must be a non-negative integer.");
        }
    }

    private void hideIndelsBasesCBActionPerformed(ActionEvent e) {
        boolean flagInsertions = this.hideIndelsBasesCB.isSelected();
        this.updatedPreferenceMap.put("SAM.HIDE_SMALL_INDEL", String.valueOf(flagInsertions));
        this.hideIndelsBasesField.setEnabled(flagInsertions);
    }

    private void hideIndelsBasesFieldFocusLost(FocusEvent e) {
        this.hideIndelsBasesFieldActionPerformed(null);
    }

    private void hideIndelsBasesFieldActionPerformed(ActionEvent e) {
        String threshold = this.hideIndelsBasesField.getText().trim();
        try {
            int tmp = Integer.parseInt(threshold);
            if (tmp <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Threshold must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.SMALL_INDEL_BP_THRESHOLD", threshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Threshold must be a positive integer.");
        }
    }

    private void downsampleReadsCBActionPerformed(ActionEvent e) {
        boolean downsample = this.downsampleReadsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.DOWNSAMPLE_READS", String.valueOf(downsample));
        this.samSamplingWindowField.setEnabled(downsample);
        this.samDownsampleCountField.setEnabled(downsample);
    }

    private void samSamplingWindowFieldFocusLost(FocusEvent e) {
        this.samSamplingWindowFieldActionPerformed(null);
    }

    private void samSamplingWindowFieldActionPerformed(ActionEvent e) {
        String samplingWindowString = this.samSamplingWindowField.getText().trim();
        try {
            int samplingWindow = Integer.parseInt(samplingWindowString);
            if (samplingWindow <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Down-sampling window must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.SAMPLING_WINDOW", samplingWindowString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Down-sampling window must be a positive integer.");
        }
    }

    private void samDownsampleCountFieldFocusLost(FocusEvent evt) {
        this.samDownsampleCountFieldActionPerformed(null);
    }

    private void samDownsampleCountFieldActionPerformed(ActionEvent evt) {
        String maxLevelString = this.samDownsampleCountField.getText().trim();
        try {
            int maxLevel = Integer.parseInt(maxLevelString);
            if (maxLevel <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.MAX_LEVELS", maxLevelString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
        }
    }

    private void samShadeMismatchedBaseCBActionPerformed(ActionEvent evt) {
        if (this.samShadeMismatchedBaseCB.isSelected()) {
            this.updatedPreferenceMap.put("SAM.SHADE_BASE_QUALITY", AlignmentTrack.ShadeBasesOption.QUALITY.toString());
            this.samMinBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
            this.samMaxBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        } else {
            IGVPreferences prefMgr = PreferencesManager.getPreferences();
            if (AlignmentTrack.ShadeBasesOption.QUALITY == CollUtils.valueOf(AlignmentTrack.ShadeBasesOption.class, prefMgr.get("SAM.SHADE_BASE_QUALITY"), AlignmentTrack.ShadeBasesOption.QUALITY)) {
                this.updatedPreferenceMap.put("SAM.SHADE_BASE_QUALITY", AlignmentTrack.ShadeBasesOption.NONE.toString());
                this.samMinBaseQualityField.setEnabled(false);
                this.samMaxBaseQualityField.setEnabled(false);
            }
        }
    }

    private void showCenterLineCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.SHOW_CENTER_LINE", String.valueOf(this.showCenterLineCB.isSelected()));
    }

    private void genomeUpdateCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("AUTO_UPDATE_GENOMES", String.valueOf(this.genomeUpdateCB.isSelected()));
    }

    private void samFlagUnmappedPairCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.FLAG_UNMAPPED_PAIR", String.valueOf(this.samFlagUnmappedPairCB.isSelected()));
    }

    private void samShowDuplicatesCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.SHOW_DUPLICATES", String.valueOf(!this.samFilterDuplicatesCB.isSelected()));
    }

    private void showSoftClippedCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.SHOW_SOFT_CLIPPED", String.valueOf(this.showSoftClippedCB.isSelected()));
    }

    private void quickConsensusModeCBActionPerformed() {
        this.updatedPreferenceMap.put("SAM.QUICK_CONSENSUS_MODE", String.valueOf(this.quickConsensusModeCB.isSelected()));
    }

    private void isizeComputeCBActionPerformed(ActionEvent e) {
        boolean selected = this.isizeComputeCB.isSelected();
        this.updatedPreferenceMap.put("SAM.COMPUTE_ISIZES", String.valueOf(selected));
        this.insertSizeThresholdField.setEnabled(!selected);
        this.insertSizeMinThresholdField.setEnabled(!selected);
        this.insertSizeMinPercentileField.setEnabled(selected);
        this.insertSizeMaxPercentileField.setEnabled(selected);
    }

    public void selectTab(String tabname) {
        if (tabname == null) {
            return;
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equalsIgnoreCase(tabname)) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
    }

    private void insertSizeMinPercentileFieldFocusLost(FocusEvent e) {
        this.insertSizeMinPercentileFieldActionPerformed(null);
    }

    private void insertSizeMinPercentileFieldActionPerformed(ActionEvent e) {
        String valueString = this.insertSizeMinPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            this.updatedPreferenceMap.put("SAM.MIN_ISIZE_MIN_PERCENTILE", valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Minimum insert size percentile must be a number.");
        }
    }

    private void insertSizeMaxPercentileFieldFocusLost(FocusEvent e) {
        this.insertSizeMaxPercentileFieldActionPerformed(null);
    }

    private void insertSizeMaxPercentileFieldActionPerformed(ActionEvent e) {
        String valueString = this.insertSizeMaxPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            this.updatedPreferenceMap.put("SAM.ISIZE_MAX_PERCENTILE", valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Maximum insert size percentile must be a number.");
        }
    }

    private void samMaxWindowSizeFieldFocusLost(FocusEvent evt) {
        this.samMaxWindowSizeFieldActionPerformed(null);
    }

    private void samMaxWindowSizeFieldActionPerformed(ActionEvent evt) {
        String maxSAMWindowSize = String.valueOf(this.samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            this.updatedPreferenceMap.put("SAM.MAX_VISIBLE_RANGE", maxSAMWindowSize);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }

    private void samHiddenTagsFieldFocusLost(FocusEvent evt) {
        this.samHiddenTagsFieldActionPerformed(null);
    }

    private void samHiddenTagsFieldActionPerformed(ActionEvent evt) {
        String samHiddenTags = String.valueOf(this.samHiddenTagsField.getText());
        Object samHiddenTagsClean = "";
        for (String s : (samHiddenTags == null ? "" : samHiddenTags).split("[, ]")) {
            if (s.equals("")) continue;
            samHiddenTagsClean = (String)samHiddenTagsClean + (((String)samHiddenTagsClean).equals("") ? "" : ",") + s;
        }
        samHiddenTagsClean = (String)samHiddenTagsClean + ",";
        this.updatedPreferenceMap.put("SAM.HIDDEN_TAGS", (String)samHiddenTagsClean);
    }

    private void seqResolutionThresholdActionPerformed(ActionEvent e) {
    }

    private void seqResolutionThresholdFocusLost(FocusEvent e) {
        String seqResolutionSize = String.valueOf(this.seqResolutionThreshold.getText());
        try {
            float value = Float.parseFloat(seqResolutionSize.replace(",", ""));
            if (value < 1.0f || value > 10000.0f) {
                MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
            } else {
                this.updatedPreferenceMap.put("MAX_SEQUENCE_RESOLUTION", seqResolutionSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
        }
    }

    private void chartDrawTrackNameCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_TRACK_NAME", String.valueOf(this.chartDrawTrackNameCB.isSelected()));
    }

    private void autoscaleCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.AUTOSCALE", String.valueOf(this.autoscaleCB.isSelected()));
    }

    private void colorBordersCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.COLOR_BORDERS", String.valueOf(this.colorBordersCB.isSelected()));
    }

    private void bottomBorderCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_BOTTOM_BORDER", String.valueOf(this.bottomBorderCB.isSelected()));
    }

    private void topBorderCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_TOP_BORDER", String.valueOf(this.topBorderCB.isSelected()));
    }

    private void showAllHeatmapFeauresCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("CHART.SHOW_ALL_HEATMAP", String.valueOf(this.showAllHeatmapFeauresCB.isSelected()));
    }

    private void chooseMutationColorsButtonActionPerformed(ActionEvent e) {
        PaletteColorTable ct = PreferencesManager.getPreferences().getMutationColorScheme();
        MutationColorMapEditor editor = new MutationColorMapEditor(IGV.getMainFrame(), ct.getColorMap(), IGV.getInstance().getSession().getColorOverlay());
        editor.setVisible(true);
        Map<String, Color> changedColors = editor.getChangedColors();
        if (!changedColors.isEmpty()) {
            for (Map.Entry<String, Color> entry : changedColors.entrySet()) {
                ct.getColorMap().put(entry.getKey(), entry.getValue());
            }
            String mapString = ct.getMapAsString();
            this.updatedPreferenceMap.put("MUTATION_COLOR_TABLE", mapString);
        }
    }

    private void colorMutationsCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("COVER_OVERLAY_KEY", String.valueOf(this.colorCodeMutationsCB.isSelected()));
    }

    private void checkForVCFColors() {
        boolean alleleFreq;
        Color homRefColor = this.homRefColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("HOMREF.COLOR"))) {
            this.updatedPreferenceMap.put("HOMREF.COLOR", ColorUtilities.colorToString(homRefColor));
        }
        Color hetVarColor = this.hetVarColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("HETVAR.COLOR"))) {
            this.updatedPreferenceMap.put("HETVAR.COLOR", ColorUtilities.colorToString(hetVarColor));
        }
        Color homVarColor = this.homVarColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("HOMVAR.COLOR"))) {
            this.updatedPreferenceMap.put("HOMVAR.COLOR", ColorUtilities.colorToString(homVarColor));
        }
        Color noCallColor = this.noCallColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("NOCALL.COLOR"))) {
            this.updatedPreferenceMap.put("NOCALL.COLOR", ColorUtilities.colorToString(noCallColor));
        }
        Color afRefColor = this.afRefColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("AF_REF.COLOR"))) {
            this.updatedPreferenceMap.put("AF_REF.COLOR", ColorUtilities.colorToString(afRefColor));
        }
        Color afVarColor = this.afVarColorChooser.getSelectedColor();
        if (!homRefColor.equals(this.prefMgr.getAsColor("AF_VAR.COLOR"))) {
            this.updatedPreferenceMap.put("AF_VAR.COLOR", ColorUtilities.colorToString(afVarColor));
        }
        if ((alleleFreq = this.alleleFreqRB.isSelected()) != this.prefMgr.getAsBoolean("VARIANT_COLOR_BY_ALLELE_FREQ")) {
            this.updatedPreferenceMap.put("VARIANT_COLOR_BY_ALLELE_FREQ", Boolean.toString(alleleFreq));
        }
    }

    private void resetVCFButtonActionPerformed(ActionEvent e) {
        for (String vcfKey : Arrays.asList("HOMREF.COLOR", "HETVAR.COLOR", "HOMVAR.COLOR", "NOCALL.COLOR", "AF_REF.COLOR", "AF_VAR.COLOR", "VARIANT_COLOR_BY_ALLELE_FREQ")) {
            this.prefMgr.remove(vcfKey);
        }
        this.resetVCFColorChoosers();
    }

    private void resetVCFColorChoosers() {
        this.homRefColorChooser.setSelectedColor(this.prefMgr.getAsColor("HOMREF.COLOR"));
        this.hetVarColorChooser.setSelectedColor(this.prefMgr.getAsColor("HETVAR.COLOR"));
        this.homVarColorChooser.setSelectedColor(this.prefMgr.getAsColor("HOMVAR.COLOR"));
        this.noCallColorChooser.setSelectedColor(this.prefMgr.getAsColor("NOCALL.COLOR"));
        this.afRefColorChooser.setSelectedColor(this.prefMgr.getAsColor("AF_REF.COLOR"));
        this.afVarColorChooser.setSelectedColor(this.prefMgr.getAsColor("AF_VAR.COLOR"));
        if (this.prefMgr.getAsBoolean("VARIANT_COLOR_BY_ALLELE_FREQ")) {
            this.alleleFreqRB.setSelected(true);
            this.alleleFractionRB.setSelected(false);
        } else {
            this.alleleFreqRB.setSelected(false);
            this.alleleFractionRB.setSelected(true);
        }
    }

    private void showOrphanedMutationsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SHOW_ORPHANED_MUTATIONS", String.valueOf(this.showOrphanedMutationsCB.isSelected()));
    }

    private void overlayTrackCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("OVERLAY_TRACKS_KEY", String.valueOf(this.overlayTrackCB.isSelected()));
        this.overlayAttributeTextField.setEnabled(this.overlayTrackCB.isSelected());
        this.showOrphanedMutationsCB.setEnabled(this.overlayTrackCB.isSelected());
        this.updateOverlays = true;
    }

    private void overlayAttributeTextFieldFocusLost(FocusEvent evt) {
        String attributeName = String.valueOf(this.overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("OVERLAY_ATTRIBUTE_KEY", attributeName);
        this.updateOverlays = true;
    }

    private void overlayAttributeTextFieldActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("OVERLAY_ATTRIBUTE_KEY", String.valueOf(this.overlayAttributeTextField.getText()));
        this.updateOverlays = true;
    }

    private void defaultTrackHeightFieldFocusLost(FocusEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void defaultTrackHeightFieldActionPerformed(ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void trackNameAttributeFieldFocusLost(FocusEvent evt) {
        String attributeName = String.valueOf(this.trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("TRACK_ATTRIBUTE_NAME_KEY", attributeName);
    }

    private void trackNameAttributeFieldActionPerformed(ActionEvent evt) {
        String attributeName = String.valueOf(this.trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("TRACK_ATTRIBUTE_NAME_KEY", attributeName);
    }

    private void defaultChartTrackHeightFieldFocusLost(FocusEvent evt) {
        this.defaultChartTrackHeightFieldActionPerformed(null);
    }

    private void defaultChartTrackHeightFieldActionPerformed(ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.chart.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void geneListFlankingFieldFocusLost(FocusEvent e) {
        this.geneListFlankingFieldActionPerformed(null);
    }

    private void geneListFlankingFieldActionPerformed(ActionEvent e) {
        String flankingRegion = String.valueOf(this.geneListFlankingField.getText());
        try {
            Integer.parseInt(flankingRegion);
            this.updatedPreferenceMap.put("FLANKING_REGION", flankingRegion);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Flanking region must be an integer number.");
        }
    }

    private void showAttributesDisplayCheckBoxActionPerformed(ActionEvent evt) {
        boolean state = ((JCheckBox)evt.getSource()).isSelected();
        this.updatedPreferenceMap.put("IGV.track.show.attribute.views", String.valueOf(state));
        IGV.getInstance().doShowAttributeDisplay(state);
    }

    private void combinePanelsCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("IGV.single.track.pane", String.valueOf(this.combinePanelsCB.isSelected()));
    }

    private void showDefaultTrackAttributesCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SHOW_DEFAULT_TRACK_ATTRIBUTES", String.valueOf(this.showDefaultTrackAttributesCB.isSelected()));
    }

    private void showRegionBoundariesCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SHOW_REGION_BARS", String.valueOf(this.showRegionBoundariesCB.isSelected()));
    }

    private void filterVendorFailedReadsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAM.FILTER_FAILED_READS", String.valueOf(this.filterFailedReadsCB.isSelected()));
    }

    private void samMinBaseQualityFieldActionPerformed(ActionEvent evt) {
        String baseQuality = this.samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            this.updatedPreferenceMap.put("SAM.BASE_QUALITY_MIN", baseQuality);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }

    private void samMinBaseQualityFieldFocusLost(FocusEvent evt) {
        this.samMinBaseQualityFieldActionPerformed(null);
    }

    private void samMaxBaseQualityFieldActionPerformed(ActionEvent evt) {
        String baseQuality = this.samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            this.updatedPreferenceMap.put("SAM.BASE_QUALITY_MAX", baseQuality);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }

    private void samMaxBaseQualityFieldFocusLost(FocusEvent evt) {
        this.samMaxBaseQualityFieldActionPerformed(null);
    }

    private void expMapToGeneCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PROBE_MAPPING_KEY", String.valueOf(this.expMapToGeneCB.isSelected()));
    }

    private void labelYAxisCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_AXIS", String.valueOf(this.labelYAxisCB.isSelected()));
    }

    private void showAlignmentTrackCBActionPerformed(ActionEvent e) {
        boolean coverageOnlyCBSelected = this.showAlignmentTrackCB.isSelected();
        this.updatedPreferenceMap.put("SAM.SHOW_ALIGNMENT_TRACK", String.valueOf(coverageOnlyCBSelected));
    }

    private void showCovTrackCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.SHOW_COV_TRACK", String.valueOf(this.showCovTrackCB.isSelected()));
    }

    private void portFieldActionPerformed(ActionEvent evt) {
        String portString = this.portField.getText().trim();
        try {
            Integer.parseInt(portString);
            this.updatedPreferenceMap.put("PORT_NUMBER", portString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Port must be an integer.");
        }
    }

    private void portFieldFocusLost(FocusEvent evt) {
        this.portFieldActionPerformed(null);
    }

    private void enablePortCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PORT_ENABLED", String.valueOf(this.enablePortCB.isSelected()));
        this.portField.setEnabled(this.enablePortCB.isSelected());
    }

    private void expandCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("EXPAND_FEATURE_TRACKS", String.valueOf(this.expandCB.isSelected()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        this.genomeServerURLTextField.setEnabled(true);
        this.genomeServerURLTextField.setText("http://igv.broadinstitute.org/genomes/genomes.txt");
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", null);
        this.dataServerURLTextField.setEnabled(true);
        this.dataServerURLTextField.setText("https://data.broadinstitute.org/igvdata/$$_dataServerRegistry.txt");
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", null);
    }

    private void searchZoomCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SEARCH_ZOOM", String.valueOf(this.searchZoomCB.isSelected()));
    }

    private void showDatarangeCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.SHOW_DATA_RANGE", String.valueOf(this.showDatarangeCB.isSelected()));
    }

    private void showDatarangeCBFocusLost(FocusEvent evt) {
        this.showDatarangeCBActionPerformed(null);
    }

    private void snpThresholdFieldActionPerformed(ActionEvent evt) {
        String snpThreshold = this.snpThresholdField.getText().trim();
        try {
            Double.parseDouble(snpThreshold);
            this.updatedPreferenceMap.put("SAM.ALLELE_THRESHOLD", snpThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Allele frequency threshold must be a number.");
        }
    }

    private void snpThresholdFieldFocusLost(FocusEvent evt) {
        this.snpThresholdFieldActionPerformed(null);
    }

    private void autoFileDisoveryCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("BYPASS_FILE_AUTO_DISCOVERY", String.valueOf(!this.autoFileDisoveryCB.isSelected()));
    }

    private void normalizeCoverageCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("NORMALIZE_COVERAGE", String.valueOf(this.normalizeCoverageCB.isSelected()));
        this.portField.setEnabled(this.enablePortCB.isSelected());
    }

    private void clearProxySettingsButtonActionPerformed(ActionEvent e) {
        if (MessageUtils.confirm("This will immediately clear all proxy settings.  Are you sure?")) {
            this.proxyHostField.setText("");
            this.proxyPortField.setText("");
            this.proxyUsernameField.setText("");
            this.proxyPasswordField.setText("");
            this.proxyTypeCB.setSelectedIndex(0);
            this.useProxyCB.setSelected(false);
            PreferencesManager.getPreferences().clearProxySettings();
        }
    }

    private void useProxyCBActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        boolean useProxy = this.useProxyCB.isSelected();
        boolean authenticateProxy = this.authenticateProxyCB.isSelected();
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.updateProxyState(useProxy, authenticateProxy);
        this.updatedPreferenceMap.put("PROXY.USE", String.valueOf(useProxy));
    }

    private void authenticateProxyCBActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        boolean useProxy = this.useProxyCB.isSelected();
        boolean authenticateProxy = this.authenticateProxyCB.isSelected();
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.updateProxyState(useProxy, authenticateProxy);
        this.updatedPreferenceMap.put("PROXY.AUTHENTICATE", String.valueOf(authenticateProxy));
        this.proxyUsernameField.setEnabled(authenticateProxy);
        this.proxyPasswordField.setEnabled(authenticateProxy);
    }

    private void proxyHostFieldFocusLost(FocusEvent evt) {
        this.proxyHostFieldActionPerformed(null);
    }

    private void proxyHostFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        this.updatedPreferenceMap.put("PROXY.HOST", this.proxyHostField.getText());
    }

    private void proxyPortFieldFocusLost(FocusEvent evt) {
        this.proxyPortFieldActionPerformed(null);
    }

    private void proxyPortFieldActionPerformed(ActionEvent evt) {
        try {
            Integer.parseInt(this.proxyPortField.getText());
            this.proxySettingsChanged = true;
            this.updatedPreferenceMap.put("PROXY.PORT", this.proxyPortField.getText());
        }
        catch (NumberFormatException e) {
            MessageUtils.showMessage("Proxy port must be an integer.");
        }
    }

    private void proxyWhitelistTextAreaActionPerformed(ActionEvent evt) {
        String[] urls = this.proxyWhitelistTextArea.getText().split("\n");
        Object setting = "";
        for (String u : urls) {
            setting = (String)setting + u + ",";
        }
        this.updatedPreferenceMap.put("PROXY.WHITELIST", (String)setting);
        this.proxySettingsChanged = true;
    }

    private void proxyWhitelistTextAreaFocusLost(FocusEvent e) {
        this.proxyWhitelistTextAreaActionPerformed(null);
    }

    private void proxyTypeCBActionPerformed(ActionEvent e) {
        this.proxySettingsChanged = true;
        String proxyTypeString = this.proxyTypeCB.getSelectedItem().toString();
        this.updatedPreferenceMap.put("PROXY.TYPE", proxyTypeString);
    }

    private void proxyUsernameFieldFocusLost(FocusEvent evt) {
        this.proxyUsernameFieldActionPerformed(null);
    }

    private void proxyUsernameFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        String user = this.proxyUsernameField.getText();
        this.updatedPreferenceMap.put("PROXY.USERNAME", user);
    }

    private void proxyPasswordFieldFocusLost(FocusEvent evt) {
        this.proxyPasswordFieldActionPerformed(null);
    }

    private void proxyPasswordFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        String pw = new String(this.proxyPasswordField.getPassword());
        String pwEncoded = Utilities.base64Encode(pw);
        this.updatedPreferenceMap.put("PROXY.PW", pwEncoded);
    }

    private void updateProxyState(boolean useProxy, boolean authenticateProxy) {
        this.proxyHostField.setEnabled(useProxy);
        this.proxyPortField.setEnabled(useProxy);
        this.proxyUsernameField.setEnabled(useProxy && authenticateProxy);
        this.proxyPasswordField.setEnabled(useProxy && authenticateProxy);
    }

    private void resetValidation() {
        this.inputValidated = true;
    }

    private void dbHostFieldFocusLost(FocusEvent e) {
        this.dbHostFieldActionPerformed(null);
    }

    private void dbHostFieldActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("DB_HOST", this.dbHostField.getText());
    }

    private void dbNameFieldFocusLost(FocusEvent e) {
        this.dbNameFieldActionPerformed(null);
    }

    private void dbNameFieldActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("DB_NAME", this.dbNameField.getText());
    }

    private void dbPortFieldActionPerformed(ActionEvent e) {
        this.dbPortFieldFocusLost(null);
    }

    private void dbPortFieldFocusLost(FocusEvent e) {
        String portText = this.dbPortField.getText().trim();
        if (portText.length() == 0) {
            this.updatedPreferenceMap.put("DB_PORT", "-1");
        } else {
            try {
                Integer.parseInt(portText);
                this.updatedPreferenceMap.put("DB_PORT", portText);
            }
            catch (NumberFormatException e1) {
                this.updatedPreferenceMap.put("DB_PORT", "-1");
            }
        }
    }

    private void probeMappingBrowseButtonActionPerformed(ActionEvent e) {
        File f = FileDialogUtils.chooseFile("Probe mapping file (BED format)");
        if (f != null) {
            this.probeMappingFileTextField.setText(f.getAbsolutePath());
            this.updatedPreferenceMap.put("PROBE_MAPPING_FILE", f.getAbsolutePath());
        }
    }

    private void useProbeMappingCBActionPerformed(ActionEvent e) {
        boolean isSelected = this.useProbeMappingCB.isSelected();
        this.updatedPreferenceMap.put("USE_PROBE_MAPPING_FILE", String.valueOf(isSelected));
        this.updateProbeMappingOptions(isSelected);
    }

    private void updateProbeMappingOptions(boolean isSelected) {
        this.probeMappingFileTextField.setEnabled(isSelected);
        this.probeMappingBrowseButton.setEnabled(isSelected);
        this.expMapToGeneCB.setEnabled(!isSelected);
        this.expMapToLociCB.setEnabled(!isSelected);
    }

    private void probeMappingFileTextFieldFocusLost(FocusEvent e) {
        this.probeMappingFileTextFieldActionPerformed(null);
    }

    private void probeMappingFileTextFieldActionPerformed(ActionEvent e) {
        String name = this.probeMappingFileTextField.getText();
        if (name != null) {
            name = name.trim();
            this.updatedPreferenceMap.put("PROBE_MAPPING_FILE", name);
        }
    }

    private void toolTipInitialDelayFieldFocusLost(FocusEvent e) {
        this.toolTipInitialDelayFieldActionPerformed(null);
    }

    private void toolTipInitialDelayFieldActionPerformed(ActionEvent e) {
        String ttText = this.toolTipInitialDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.INITIAL_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip initial delay must be a number.");
        }
    }

    private void tooltipReshowDelayFieldFocusLost(FocusEvent e) {
        this.tooltipReshowDelayFieldActionPerformed(null);
    }

    private void tooltipReshowDelayFieldActionPerformed(ActionEvent e) {
        String ttText = this.tooltipReshowDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.RESHOW_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip reshow delay must be a number.");
        }
    }

    private void tooltipDismissDelayFieldFocusLost(FocusEvent e) {
        this.tooltipDismissDelayFieldActionPerformed(null);
    }

    private void tooltipDismissDelayFieldActionPerformed(ActionEvent e) {
        String ttText = this.tooltipDismissDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.DISMISS_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip dismiss delay must be a number.");
        }
    }

    private void scaleFontsCBActionPerformed(ActionEvent e) {
        PreferencesManager.getPreferences().put("SCALE_FONTS", this.scaleFontsCB.isSelected());
    }

    private void enableGoogleCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("ENABLE_GOOGLE_MENU", String.valueOf(this.enableGoogleCB.isSelected()));
    }

    private void saveGoogleCredentialsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SAVE_GOOGLE_CREDENTIALS", String.valueOf(this.saveGoogleCredentialsCB.isSelected()));
    }

    private void sessionPathsCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("SESSION.RELATIVE_PATH", String.valueOf(this.sessionPathsCB.isSelected()));
    }

    private void coverageOnlyCBActionPerformed(ActionEvent e) {
    }

    private void cramCacheSizeFieldFocusLost(FocusEvent e) {
        this.cramCacheSizeFieldActionPerformed(null);
    }

    private void cramCacheSizeFieldActionPerformed(ActionEvent e) {
        try {
            String p = this.cramCacheSizeField.getText();
            Float.parseFloat(p);
            this.updatedPreferenceMap.put("CRAM.CACHE_SIZE", p);
        }
        catch (NumberFormatException ex) {
            MessageUtils.showMessage("Cache size must be a number");
            this.cramCacheSizeField.setText(this.prefMgr.get("CRAM.CACHE_SIZE"));
        }
    }

    private void cramCacheDirectoryButtonActionPerformed(ActionEvent e) {
        this.cramCacheDirectory = DirectoryManager.getFastaCacheDirectory();
        File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
        if (newDirectory != null && !newDirectory.equals(this.cramCacheDirectory.getParentFile())) {
            this.newCramCacheDirectory = new File(newDirectory, "igv");
            this.cramCacheDirectoryField.setText(this.newCramCacheDirectory.getAbsolutePath());
        }
    }

    private void cramCacheReferenceCBActionPerformed(ActionEvent e) {
        this.updatedPreferenceMap.put("CRAM.CACHE_SEQUENCES", String.valueOf(this.cramCacheReferenceCB.isSelected()));
    }

    private void initValues() {
        File igvDirectory;
        this.combinePanelsCB.setSelected(this.prefMgr.getAsBoolean("IGV.single.track.pane"));
        this.showRegionBoundariesCB.setSelected(this.prefMgr.getAsBoolean("SHOW_REGION_BARS"));
        this.defaultChartTrackHeightField.setText(this.prefMgr.get("IGV.chart.track.height"));
        this.defaultTrackHeightField.setText(this.prefMgr.get("IGV.track.height"));
        this.showOrphanedMutationsCB.setSelected(this.prefMgr.getAsBoolean("SHOW_ORPHANED_MUTATIONS"));
        this.overlayAttributeTextField.setText(this.prefMgr.get("OVERLAY_ATTRIBUTE_KEY"));
        this.overlayTrackCB.setSelected(this.prefMgr.getAsBoolean("OVERLAY_TRACKS_KEY"));
        this.showDefaultTrackAttributesCB.setSelected(this.prefMgr.getAsBoolean("SHOW_DEFAULT_TRACK_ATTRIBUTES"));
        this.colorCodeMutationsCB.setSelected(this.prefMgr.getAsBoolean("COVER_OVERLAY_KEY"));
        this.overlayAttributeTextField.setEnabled(this.overlayTrackCB.isSelected());
        this.showOrphanedMutationsCB.setEnabled(this.overlayTrackCB.isSelected());
        this.seqResolutionThreshold.setText(this.prefMgr.get("MAX_SEQUENCE_RESOLUTION"));
        this.scaleFontsCB.setSelected(this.prefMgr.getAsBoolean("SCALE_FONTS"));
        this.enableGoogleCB.setSelected(this.prefMgr.getAsBoolean("ENABLE_GOOGLE_MENU"));
        this.saveGoogleCredentialsCB.setSelected(this.prefMgr.getAsBoolean("SAVE_GOOGLE_CREDENTIALS"));
        this.sessionPathsCB.setSelected(this.prefMgr.getAsBoolean("SESSION.RELATIVE_PATH"));
        this.geneListFlankingField.setText(this.prefMgr.get("FLANKING_REGION"));
        this.enablePortCB.setSelected(this.prefMgr.getAsBoolean("PORT_ENABLED"));
        this.portField.setText(String.valueOf(this.prefMgr.getAsInt("PORT_NUMBER")));
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.expandCB.setSelected(this.prefMgr.getAsBoolean("EXPAND_FEATURE_TRACKS"));
        this.searchZoomCB.setSelected(this.prefMgr.getAsBoolean("SEARCH_ZOOM"));
        this.showAttributesDisplayCheckBox.setSelected(this.prefMgr.getAsBoolean("IGV.track.show.attribute.views"));
        this.trackNameAttributeField.setText(this.prefMgr.get("TRACK_ATTRIBUTE_NAME_KEY"));
        this.genomeServerURLTextField.setText(this.prefMgr.getGenomeListURL());
        this.dataServerURLTextField.setText(this.prefMgr.getDataServerURL());
        this.blatURLField.setText(this.prefMgr.get("BLAT_URL"));
        this.topBorderCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_TOP_BORDER"));
        this.bottomBorderCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_BOTTOM_BORDER"));
        this.colorBordersCB.setSelected(this.prefMgr.getAsBoolean("CHART.COLOR_BORDERS"));
        this.chartDrawTrackNameCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_TRACK_NAME"));
        this.autoscaleCB.setSelected(this.prefMgr.getAsBoolean("CHART.AUTOSCALE"));
        this.showDatarangeCB.setSelected(this.prefMgr.getAsBoolean("CHART.SHOW_DATA_RANGE"));
        this.labelYAxisCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_AXIS"));
        this.showAllHeatmapFeauresCB.setSelected(this.prefMgr.getAsBoolean("CHART.SHOW_ALL_HEATMAP"));
        this.samMaxWindowSizeField.setText(this.prefMgr.get("SAM.MAX_VISIBLE_RANGE"));
        this.samSamplingWindowField.setText(this.prefMgr.get("SAM.SAMPLING_WINDOW"));
        this.samDownsampleCountField.setText(this.prefMgr.get("SAM.MAX_LEVELS"));
        boolean downsample = this.prefMgr.getAsBoolean("SAM.DOWNSAMPLE_READS");
        this.downsampleReadsCB.setSelected(downsample);
        this.samSamplingWindowField.setEnabled(downsample);
        this.samDownsampleCountField.setEnabled(downsample);
        this.mappingQualityThresholdField.setText(this.prefMgr.get("SAM.QUALITY_THRESHOLD"));
        this.insertSizeThresholdField.setText(this.prefMgr.get("SAM.INSERT_SIZE_THRESHOLD"));
        this.insertSizeMinThresholdField.setText(this.prefMgr.get("SAM.MIN_INSERT_SIZE_THRESHOLD"));
        this.insertSizeMinPercentileField.setText(this.prefMgr.get("SAM.MIN_ISIZE_MIN_PERCENTILE"));
        this.insertSizeMaxPercentileField.setText(this.prefMgr.get("SAM.ISIZE_MAX_PERCENTILE"));
        boolean isizeComputeSelected = this.prefMgr.getAsBoolean("SAM.COMPUTE_ISIZES");
        this.isizeComputeCB.setSelected(isizeComputeSelected);
        this.insertSizeThresholdField.setEnabled(!isizeComputeSelected);
        this.insertSizeMinThresholdField.setEnabled(!isizeComputeSelected);
        this.insertSizeMinPercentileField.setEnabled(isizeComputeSelected);
        this.insertSizeMaxPercentileField.setEnabled(isizeComputeSelected);
        this.snpThresholdField.setText(String.valueOf(this.prefMgr.getAsFloat("SAM.ALLELE_THRESHOLD")));
        this.useAlleleQualityCB.setSelected(this.prefMgr.getAsBoolean("SAM.ALLELE_USE_QUALITY"));
        this.samFilterDuplicatesCB.setSelected(!this.prefMgr.getAsBoolean("SAM.SHOW_DUPLICATES"));
        this.filterFailedReadsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_FAILED_READS"));
        this.filterSecondaryAlignmentsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_SECONDARY_ALIGNMENTS"));
        this.filterSupplementaryAlignmentsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_SUPPLEMENTARY_ALIGNMENTS"));
        this.showSoftClippedCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_SOFT_CLIPPED"));
        this.quickConsensusModeCB.setSelected(this.prefMgr.getAsBoolean("SAM.QUICK_CONSENSUS_MODE"));
        this.samFlagUnmappedPairCB.setSelected(this.prefMgr.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR"));
        this.showCenterLineCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_CENTER_LINE"));
        this.samShadeMismatchedBaseCB.setSelected(AlignmentTrack.ShadeBasesOption.QUALITY == CollUtils.valueOf(AlignmentTrack.ShadeBasesOption.class, this.prefMgr.get("SAM.SHADE_BASE_QUALITY"), AlignmentTrack.ShadeBasesOption.QUALITY));
        this.samMinBaseQualityField.setText(String.valueOf(this.prefMgr.getAsInt("SAM.BASE_QUALITY_MIN")));
        this.samMaxBaseQualityField.setText(String.valueOf(this.prefMgr.getAsInt("SAM.BASE_QUALITY_MAX")));
        this.samMinBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        this.samMaxBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        this.showCovTrackCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_COV_TRACK"));
        String samHiddenTags = this.prefMgr.get("SAM.HIDDEN_TAGS");
        Object samHiddenTagsClean = "";
        for (String s : (samHiddenTags == null ? "" : samHiddenTags).split("[, ]")) {
            if (s.equals("")) continue;
            samHiddenTagsClean = (String)samHiddenTagsClean + (((String)samHiddenTagsClean).equals("") ? "" : ",") + s;
        }
        this.samHiddenTagsField.setText((String)samHiddenTagsClean);
        boolean junctionTrackEnabled = this.prefMgr.getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        this.showJunctionTrackCB.setSelected(junctionTrackEnabled);
        this.showJunctionFlankingRegionsCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_JUNCTION_FLANKINGREGIONS"));
        this.junctionFlankingTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_FLANKING_WIDTH"));
        this.junctionCoverageTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_COVERAGE"));
        this.genomeUpdateCB.setSelected(this.prefMgr.getAsBoolean("AUTO_UPDATE_GENOMES"));
        this.antialiasingCB.setSelected(this.prefMgr.getAsBoolean("ENABLE_ANTIALIASING"));
        boolean mapProbesToGenes = PreferencesManager.getPreferences().getAsBoolean("PROBE_MAPPING_KEY");
        this.expMapToGeneCB.setSelected(mapProbesToGenes);
        this.expMapToLociCB.setSelected(!mapProbesToGenes);
        this.probeMappingFileTextField.setText(this.prefMgr.get("PROBE_MAPPING_FILE"));
        boolean useProbeMapping = this.prefMgr.getAsBoolean("USE_PROBE_MAPPING_FILE");
        this.useProbeMappingCB.setSelected(useProbeMapping);
        this.updateProbeMappingOptions(useProbeMapping);
        this.autoFileDisoveryCB.setSelected(!this.prefMgr.getAsBoolean("BYPASS_FILE_AUTO_DISCOVERY"));
        this.normalizeCoverageCB.setSelected(this.prefMgr.getAsBoolean("NORMALIZE_COVERAGE"));
        boolean useProxy = this.prefMgr.getAsBoolean("PROXY.USE");
        this.useProxyCB.setSelected(useProxy);
        boolean authenticateProxy = this.prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        this.authenticateProxyCB.setSelected(authenticateProxy);
        this.proxyHostField.setText(this.prefMgr.get("PROXY.HOST", ""));
        this.proxyPortField.setText(this.prefMgr.get("PROXY.PORT", ""));
        this.proxyUsernameField.setText(this.prefMgr.get("PROXY.USERNAME", ""));
        String pwCoded = this.prefMgr.get("PROXY.PW", "");
        this.proxyPasswordField.setText(Utilities.base64Decode(pwCoded));
        this.proxyWhitelistTextArea.setText(this.prefMgr.get("PROXY.WHITELIST"));
        String proxyTypeString = this.prefMgr.get("PROXY.TYPE", null);
        if (proxyTypeString != null) {
            this.proxyTypeCB.setSelectedItem(proxyTypeString);
        }
        this.backgroundColorPanel.setBackground(PreferencesManager.getPreferences().getAsColor("BACKGROUND_COLOR"));
        this.dbHostField.setText(this.prefMgr.get("DB_HOST"));
        this.dbNameField.setText(this.prefMgr.get("DB_NAME"));
        String portText = this.prefMgr.get("DB_PORT");
        if (!portText.equals("-1")) {
            this.dbPortField.setText(portText);
        }
        if ((igvDirectory = DirectoryManager.getIgvDirectory()) != null) {
            this.igvDirectoryField.setText(igvDirectory.getAbsolutePath());
        }
        this.tooltipDismissDelayField.setText(this.prefMgr.get("TOOLTIP.DISMISS_DELAY"));
        this.tooltipReshowDelayField.setText(this.prefMgr.get("TOOLTIP.RESHOW_DELAY"));
        this.toolTipInitialDelayField.setText(this.prefMgr.get("TOOLTIP.INITIAL_DELAY"));
        this.featureVisibilityWindowField.setText(this.prefMgr.get("DEFAULT_VISIBILITY_WINDOW"));
        this.showAlignmentTrackCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_ALIGNMENT_TRACK"));
        this.samFlagIndelsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FLAG_LARGE_INDELS"));
        this.samFlagIndelsThresholdField.setText(this.prefMgr.get("SAM.LARGE_INSERTIONS_THRESOLD"));
        this.samFlagIndelsThresholdField.setEnabled(this.samFlagIndelsCB.isSelected());
        this.samFlagClippingCB.setSelected(this.prefMgr.getAsBoolean("SAM.FLAG_CLIPPING"));
        this.samFlagClippingThresholdField.setText(this.prefMgr.get("SAM.CLIPPING_THRESHOLD"));
        this.samFlagClippingThresholdField.setEnabled(this.samFlagClippingCB.isSelected());
        this.hideIndelsBasesCB.setSelected(this.prefMgr.getAsBoolean("SAM.HIDE_SMALL_INDEL"));
        this.hideIndelsBasesField.setText(this.prefMgr.get("SAM.SMALL_INDEL_BP_THRESHOLD"));
        this.hideIndelsBasesField.setEnabled(this.hideIndelsBasesCB.isSelected());
        this.cramCacheReferenceCB.setSelected(this.prefMgr.getAsBoolean("CRAM.CACHE_SEQUENCES"));
        File cramCacheDirectory = DirectoryManager.getFastaCacheDirectory();
        if (cramCacheDirectory != null) {
            this.cramCacheDirectoryField.setText(cramCacheDirectory.getAbsolutePath());
        }
        this.cramCacheSizeField.setText(this.prefMgr.get("CRAM.CACHE_SIZE"));
        this.resetVCFColorChoosers();
        this.updateFontField();
        this.updateProxyState(useProxy, authenticateProxy);
    }

    private void updateFontField() {
        Font font = FontManager.getDefaultFont();
        StringBuffer buf = new StringBuffer();
        buf.append(font.getFamily());
        if (font.isBold()) {
            buf.append(" bold");
        }
        if (font.isItalic()) {
            buf.append(" italic");
        }
        buf.append(" " + font.getSize());
        this.defaultFontField.setText(buf.toString());
    }

    private void checkForProbeChanges() {
        if (this.updatedPreferenceMap.containsKey("PROBE_MAPPING_KEY")) {
            ProbeToLocusMap.getInstance().clearProbeMappings();
        }
    }

    private void moveIGVDirectory() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                PreferencesEditor.this.setCursor(Cursor.getPredefinedCursor(3));
                return DirectoryManager.moveIGVDirectory(PreferencesEditor.this.newIGVDirectory);
            }

            @Override
            protected void done() {
                PreferencesEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
        try {
            Boolean success = (Boolean)worker.get(30L, TimeUnit.SECONDS);
            if (success == Boolean.TRUE) {
                MessageUtils.showMessage("<html>The IGV directory has been successfully moved to: " + this.newIGVDirectory.getAbsolutePath() + "<br>Some files might need to be manually removed from the previous directory.<br/><b><i>It is recommended that you restart IGV.");
            }
        }
        catch (Exception ex) {
            MessageUtils.showMessage("<html>Unexpected error occurred while moving IGV directory:  " + this.newIGVDirectory.getAbsolutePath() + " " + ex.getMessage() + "<br/><b><i>It is recommended that you restart IGV.");
        }
    }

    private void moveCramCacheDirectory() {
        if (this.cramCacheDirectory != null && this.cramCacheDirectory.exists() && this.cramCacheDirectory.isDirectory() && this.newCramCacheDirectory != null && this.newCramCacheDirectory.exists() && this.newCramCacheDirectory.isDirectory()) {
            for (File f : this.cramCacheDirectory.listFiles()) {
                Path p1 = f.toPath();
                Path p2 = new File(this.newCramCacheDirectory, f.getName()).toPath();
                try {
                    Files.move(p1, p2, new CopyOption[0]);
                }
                catch (IOException e) {
                    log.error((Object)"Error moving cached sequence file", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferencesEditor dialog = new PreferencesEditor((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public String getOverlayText() {
        return overlayText;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

