/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.google;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.google.OAuthProvider;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;

public class OAuthUtils {
    private static Logger log = Logger.getLogger(OAuthUtils.class);
    public static String findString = null;
    public static String replaceString = null;
    private static final String PROPERTIES_URL = "https://s3.amazonaws.com/igv.org.app/desktop_google";
    private static OAuthUtils theInstance;
    static Map<String, OAuthProvider> providers;
    static OAuthProvider defaultProvider;

    public static synchronized OAuthUtils getInstance() {
        if (theInstance == null) {
            theInstance = new OAuthUtils();
        }
        return theInstance;
    }

    public OAuthProvider getProvider(String providerName) {
        if (providerName != null) {
            if (!providers.containsKey(providerName)) {
                throw new RuntimeException("Unknwon oAuth provider name: " + providerName);
            }
            return providers.get(providerName);
        }
        return defaultProvider;
    }

    public OAuthProvider getProvider() {
        return defaultProvider;
    }

    private OAuthUtils() {
        providers = new HashMap<String, OAuthProvider>();
        try {
            this.fetchOauthProperties();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void fetchOauthProperties() throws IOException {
        String oauthConfig;
        String provisioningURL = PreferencesManager.getPreferences().get("PROVISIONING.URL");
        if (provisioningURL != null && provisioningURL.length() > 0) {
            this.loadProvisioningURL(provisioningURL);
        }
        if (new File(oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config.json").exists()) {
            try {
                log.debug((Object)("Loading Oauth properties from: " + oauthConfig));
                String json = FileUtils.getContents(oauthConfig);
                this.parseProviderJson(json, oauthConfig);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        if (defaultProvider == null) {
            log.debug((Object)"$HOME/igv/oauth-config.json not found, reading Java .properties instead from: https://s3.amazonaws.com/igv.org.app/desktop_google");
            String propString = HttpUtils.getInstance().getContentsAsGzippedString(HttpUtils.createURL(PROPERTIES_URL));
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(propString).getAsJsonObject().get("installed").getAsJsonObject();
            defaultProvider = new OAuthProvider(obj);
        }
    }

    public void loadProvisioningURL(String provisioningURL) throws IOException {
        if (provisioningURL != null && provisioningURL.length() > 0) {
            InputStream is = ParsingUtils.openInputStream(provisioningURL);
            String json = ParsingUtils.readContentsFromStream(is);
            this.parseProviderJson(json, provisioningURL);
        }
    }

    private void parseProviderJson(String json, String path) throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(json).getAsJsonObject();
        OAuthProvider p = new OAuthProvider(obj);
        if (obj.has("auth_provider") && obj.get("auth_provider").getAsString().equals("Amazon")) {
            providers.put("Amazon", p);
            AmazonUtils.setCognitoConfig(obj);
        } else {
            if (defaultProvider != null) {
                log.info((Object)("Overriding default oAuth provider with " + path));
            }
            defaultProvider = p;
        }
    }

    public void setAuthorizationCode(Map<String, String> params) throws IOException {
        OAuthProvider provider = null;
        if (params.containsKey("scope") && params.get("scope").contains("googleapis")) {
            provider = defaultProvider;
        } else if (providers.containsKey("Amazon")) {
            provider = providers.get("Amazon");
        }
        if (provider == null) {
            provider = defaultProvider;
        }
        provider.setAuthorizationCode(params.get("code"));
    }

    public void setAccessToken(Map<String, String> params) {
        OAuthProvider provider = defaultProvider;
        provider.setAccessToken("token");
    }
}

