/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.rans.RANS;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class ExternalCompression {
    private static final int GZIP_COMPRESSION_LEVEL = Integer.parseInt(System.getProperty("gzip.compression.level", "5"));

    public static byte[] gzip(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(GZIP_COMPRESSION_LEVEL);
            }
        };){
            IOUtil.copyStream(new ByteArrayInputStream(data), gos);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzip(byte[] data) {
        byte[] byArray;
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(data));
        try {
            byArray = InputStreamUtils.readFully(gzipInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        gzipInputStream.close();
        return byArray;
    }

    public static byte[] bzip2(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BZip2CompressorOutputStream bos = new BZip2CompressorOutputStream((OutputStream)byteArrayOutputStream);){
            IOUtil.copyStream(new ByteArrayInputStream(data), (OutputStream)bos);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unbzip2(byte[] data) {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            byArray = InputStreamUtils.readFully((InputStream)new BZip2CompressorInputStream((InputStream)byteArrayInputStream));
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        byteArrayInputStream.close();
        return byArray;
    }

    public static byte[] rans(byte[] data, RANS.ORDER order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), order, null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] rans(byte[] data, int order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), RANS.ORDER.fromInt(order), null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] unrans(byte[] data) {
        ByteBuffer buf = RANS.uncompress(ByteBuffer.wrap(data), null);
        return ExternalCompression.toByteArray(buf);
    }

    public static byte[] xz(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(data.length * 2);
        try (XZCompressorOutputStream xzCompressorOutputStream = new XZCompressorOutputStream((OutputStream)byteArrayOutputStream);){
            xzCompressorOutputStream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unxz(byte[] data) {
        byte[] byArray;
        XZCompressorInputStream xzCompressorInputStream = new XZCompressorInputStream((InputStream)new ByteArrayInputStream(data));
        try {
            byArray = InputStreamUtils.readFully((InputStream)xzCompressorInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    xzCompressorInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        xzCompressorInputStream.close();
        return byArray;
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] uncompress(BlockCompressionMethod method, byte[] compressedContent) {
        switch (method) {
            case RAW: {
                return compressedContent;
            }
            case GZIP: {
                return ExternalCompression.gunzip(compressedContent);
            }
            case BZIP2: {
                return ExternalCompression.unbzip2(compressedContent);
            }
            case LZMA: {
                return ExternalCompression.unxz(compressedContent);
            }
            case RANS: {
                return ExternalCompression.unrans(compressedContent);
            }
        }
        throw new RuntimeException("Unknown block compression method: " + method.name());
    }
}

