/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.sam;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.lang.MutableString;
import java.util.ArrayList;
import java.util.List;
import org.campagnelab.goby.readers.sam.GobyQuickSeqvar;
import org.campagnelab.goby.util.pool.Resettable;
import org.campagnelab.goby.util.pool.ResettableObjectPoolInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobySamSegment
implements Resettable {
    private static final Logger LOG = LoggerFactory.getLogger(GobySamSegment.class);
    private ResettableObjectPoolInterface<GobyQuickSeqvar> gobyQuickSeqvarPool;
    boolean firstPositionsSet;
    int firstReadIndex;
    int firstRefPosition;
    int queryPosition;
    int distanceToNextSegment;
    int position;
    MutableString softClippedBasesLeft;
    MutableString softClippedBasesRight;
    List<GobyQuickSeqvar> sequenceVariations;
    MutableString readBases;
    ByteList readQuals;
    MutableString refBases;
    MutableString diffBases;
    int queryAlignedLength;
    int targetAlignedLength;
    boolean reverseStrand;
    private MutableString debugMessage;
    ByteList softClippedQualityLeft;
    ByteList softClippedQualityRight;

    private GobySamSegment() {
    }

    public GobySamSegment(ResettableObjectPoolInterface<GobyQuickSeqvar> gobyQuickSeqvarPool) {
        this();
        this.gobyQuickSeqvarPool = gobyQuickSeqvarPool;
        this.softClippedBasesLeft = new MutableString();
        this.softClippedBasesRight = new MutableString();
        this.softClippedQualityLeft = new ByteArrayList();
        this.softClippedQualityRight = new ByteArrayList();
        this.sequenceVariations = new ArrayList<GobyQuickSeqvar>();
        this.readBases = new MutableString();
        this.readQuals = new ByteArrayList();
        this.refBases = new MutableString();
        this.diffBases = new MutableString();
        this.debugMessage = new MutableString();
        this.reset();
    }

    @Override
    public void reset() {
        this.firstPositionsSet = false;
        this.firstReadIndex = 1;
        this.firstRefPosition = 0;
        this.queryPosition = 0;
        this.distanceToNextSegment = 0;
        this.position = 0;
        this.softClippedBasesLeft.length(0);
        this.softClippedBasesRight.length(0);
        this.softClippedQualityRight.size(0);
        this.softClippedQualityLeft.size(0);
        for (GobyQuickSeqvar seqvar : this.sequenceVariations) {
            this.gobyQuickSeqvarPool.returnObject(seqvar);
        }
        this.sequenceVariations.clear();
        this.readBases.length(0);
        this.readQuals.clear();
        this.refBases.length(0);
        this.diffBases.length(0);
        this.queryAlignedLength = 0;
        this.targetAlignedLength = 0;
        this.reverseStrand = false;
    }

    public void setPositions(int queryPosition, int readIndex, int refPosition) {
        if (!this.firstPositionsSet) {
            this.firstPositionsSet = true;
            this.queryPosition = queryPosition;
            this.firstReadIndex = readIndex;
            this.firstRefPosition = refPosition;
        }
    }

    public void debugOutput() {
        this.debugMessage.length(0);
        this.diffBases.length(0);
        int sizeRefBases = this.refBases.length();
        int sizeReadBases = this.readBases.length();
        if (sizeReadBases == 0 && sizeRefBases == 0) {
            this.debugMessage.append("No bases. Probably padding.");
        } else {
            this.debugMessage.append('\n');
            this.debugMessage.append("alignStart  =").append(this.position).append('\n');
            this.debugMessage.append("queryPos    =").append(this.queryPosition).append('\n');
            this.debugMessage.append("qAlignLen   =").append(this.queryAlignedLength).append('\n');
            this.debugMessage.append("tAlignLen   =").append(this.targetAlignedLength).append('\n');
            this.debugMessage.append("refPosition =").append(this.firstRefPosition).append('\n');
            this.debugMessage.append("readIndex   =").append(this.firstReadIndex).append('\n');
            this.debugMessage.append("refBases    =").append(this.refBases.toString()).append('\n');
            this.debugMessage.append("readBases   =").append(this.readBases.toString()).append('\n');
            this.debugMessage.append("readQuals   =");
            this.debugOutputQuals().append('\n');
            for (int i = 0; i < sizeRefBases; ++i) {
                char readChar;
                char refChar = this.refBases.charAt(i);
                if (refChar == (readChar = this.readBases.charAt(i))) {
                    this.diffBases.append('_');
                    continue;
                }
                this.diffBases.append('X');
            }
            this.debugMessage.append("diff        =").append(this.diffBases.toString()).append('\n');
            for (GobyQuickSeqvar seqvar : this.sequenceVariations) {
                this.debugMessage.append((Object)seqvar);
            }
        }
        LOG.debug(this.debugMessage.toString());
    }

    public MutableString debugOutputQuals() {
        int i = 0;
        for (Byte readQual : this.readQuals) {
            if (i > 0) {
                this.debugMessage.append(',');
            }
            this.debugMessage.append('[').append(i++).append(':').append((Object)readQual).append(']');
        }
        return this.debugMessage;
    }

    public int getPosition() {
        return this.position;
    }

    public int getQueryPosition() {
        return this.queryPosition;
    }

    public String getSoftClippedBasesLeft() {
        return this.softClippedBasesLeft.toString();
    }

    public String getSoftClippedBasesRight() {
        return this.softClippedBasesRight.toString();
    }

    public int getQueryAlignedLength() {
        return this.queryAlignedLength;
    }

    public int getTargetAlignedLength() {
        return this.targetAlignedLength;
    }

    public MutableString getReadBases() {
        return this.readBases;
    }

    public ByteList getReadQuals() {
        return this.readQuals;
    }

    public MutableString getRefBases() {
        return this.refBases;
    }

    public boolean isReverseStrand() {
        return this.reverseStrand;
    }

    public int getSequenceVariationsCount() {
        return this.sequenceVariations.size();
    }

    public List<GobyQuickSeqvar> getSequenceVariations() {
        return this.sequenceVariations;
    }

    public GobyQuickSeqvar getSequenceVariations(int i) {
        return this.sequenceVariations.get(i);
    }

    public void observeVariations() {
        boolean hasReadQuals = !this.readQuals.isEmpty();
        GobyQuickSeqvar seqvar = null;
        int currentReadIndex = this.firstReadIndex - (this.reverseStrand ? -1 : 1);
        int currentRefPosition = this.firstRefPosition - 1;
        for (int i = 0; i < Math.min(this.readBases.length(), this.refBases.length()); ++i) {
            char refChar = this.refBases.charAt(i);
            char readChar = this.readBases.charAt(i);
            if (readChar != '-') {
                currentReadIndex += (this.reverseStrand ? -1 : 1) * 1;
            }
            if (refChar != '-') {
                ++currentRefPosition;
            }
            if (readChar == refChar) continue;
            boolean makeNewSeqvar = false;
            if (seqvar == null || seqvar.lastIndexPosition != i - 1) {
                makeNewSeqvar = true;
            } else {
                int toLength = seqvar.to.length();
                char prevReadChar = seqvar.to.charAt(toLength - 1);
                char prevRefChar = seqvar.from.charAt(toLength - 1);
                if (prevReadChar == '-' && readChar != '-' || readChar == '-' && prevReadChar != '-' || prevRefChar == '-' && refChar != '-' || refChar == '-' && prevRefChar != '-') {
                    makeNewSeqvar = true;
                }
            }
            if (makeNewSeqvar) {
                seqvar = this.gobyQuickSeqvarPool.borrowObject();
                seqvar.lastIndexPosition = i;
                seqvar.setReadIndex(readChar == '-' && this.reverseStrand ? currentReadIndex - 1 : currentReadIndex);
                seqvar.setPosition(currentRefPosition);
                this.sequenceVariations.add(seqvar);
            } else {
                seqvar.lastIndexPosition = i;
            }
            seqvar.from.append(refChar);
            seqvar.to.append(readChar);
            if (!hasReadQuals || readChar == '-') continue;
            seqvar.toQuals.add(this.readQuals.get(i));
        }
    }

    public ByteString getSoftClippedQualityRight() {
        return ByteString.copyFrom((byte[])this.softClippedQualityRight.toByteArray());
    }

    public ByteString getSoftClippedQualityLeft() {
        return ByteString.copyFrom((byte[])this.softClippedQualityLeft.toByteArray());
    }
}

