/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.Decoding;
import java.nio.ByteBuffer;

class D04 {
    D04() {
    }

    static void uncompress(ByteBuffer in, Decoding.AriDecoder D, Decoding.RansDecSymbol[] syms, ByteBuffer out) {
        int rans0 = in.getInt();
        int rans1 = in.getInt();
        int rans2 = in.getInt();
        int rans3 = in.getInt();
        int out_sz = out.remaining();
        int out_end = out_sz & 0xFFFFFFFC;
        for (int i = 0; i < out_end; i += 4) {
            byte c0 = D.R[Decoding.RansDecGet(rans0, 12)];
            byte c1 = D.R[Decoding.RansDecGet(rans1, 12)];
            byte c2 = D.R[Decoding.RansDecGet(rans2, 12)];
            byte c3 = D.R[Decoding.RansDecGet(rans3, 12)];
            out.put(i, c0);
            out.put(i + 1, c1);
            out.put(i + 2, c2);
            out.put(i + 3, c3);
            rans0 = Decoding.RansDecAdvanceSymbolStep(rans0, syms[0xFF & c0], 12);
            rans1 = Decoding.RansDecAdvanceSymbolStep(rans1, syms[0xFF & c1], 12);
            rans2 = Decoding.RansDecAdvanceSymbolStep(rans2, syms[0xFF & c2], 12);
            rans3 = Decoding.RansDecAdvanceSymbolStep(rans3, syms[0xFF & c3], 12);
            rans0 = Decoding.RansDecRenormalize(rans0, in);
            rans1 = Decoding.RansDecRenormalize(rans1, in);
            rans2 = Decoding.RansDecRenormalize(rans2, in);
            rans3 = Decoding.RansDecRenormalize(rans3, in);
        }
        out.position(out_end);
        switch (out_sz & 3) {
            case 0: {
                break;
            }
            case 1: {
                byte c = D.R[Decoding.RansDecGet(rans0, 12)];
                Decoding.RansDecAdvanceSymbol(rans0, in, syms[0xFF & c], 12);
                out.put(c);
                break;
            }
            case 2: {
                byte c = D.R[Decoding.RansDecGet(rans0, 12)];
                Decoding.RansDecAdvanceSymbol(rans0, in, syms[0xFF & c], 12);
                out.put(c);
                c = D.R[Decoding.RansDecGet(rans1, 12)];
                Decoding.RansDecAdvanceSymbol(rans1, in, syms[0xFF & c], 12);
                out.put(c);
                break;
            }
            case 3: {
                byte c = D.R[Decoding.RansDecGet(rans0, 12)];
                Decoding.RansDecAdvanceSymbol(rans0, in, syms[0xFF & c], 12);
                out.put(c);
                c = D.R[Decoding.RansDecGet(rans1, 12)];
                Decoding.RansDecAdvanceSymbol(rans1, in, syms[0xFF & c], 12);
                out.put(c);
                c = D.R[Decoding.RansDecGet(rans2, 12)];
                Decoding.RansDecAdvanceSymbol(rans2, in, syms[0xFF & c], 12);
                out.put(c);
            }
        }
        out.position(0);
    }
}

