/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http2.ForkedHttp2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class MultiplexedChannelRecord {
    private final Future<Channel> connectionFuture;
    private final Map<ChannelId, Channel> childChannels;
    private final AtomicLong availableStreams;
    private final BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser;
    private volatile Channel connection;

    MultiplexedChannelRecord(Future<Channel> connectionFuture, long maxConcurrencyPerConnection, BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser) {
        this.connectionFuture = connectionFuture;
        this.availableStreams = new AtomicLong(maxConcurrencyPerConnection);
        this.childChannels = new ConcurrentHashMap<ChannelId, Channel>(NumericUtils.saturatedCast((long)maxConcurrencyPerConnection));
        this.channelReleaser = channelReleaser;
    }

    @SdkTestInternalApi
    MultiplexedChannelRecord(Future<Channel> connectionFuture, Channel connection, long maxConcurrencyPerConnection, BiConsumer<Channel, MultiplexedChannelRecord> channelReleaser) {
        this.connectionFuture = connectionFuture;
        this.childChannels = new ConcurrentHashMap<ChannelId, Channel>(NumericUtils.saturatedCast((long)maxConcurrencyPerConnection));
        this.availableStreams = new AtomicLong(maxConcurrencyPerConnection);
        this.channelReleaser = channelReleaser;
        this.connection = connection;
    }

    MultiplexedChannelRecord acquire(Promise<Channel> channelPromise) {
        this.availableStreams.decrementAndGet();
        if (this.connection != null) {
            this.createChildChannel(channelPromise, this.connection);
        } else {
            this.connectionFuture.addListener(future -> {
                if (future.isSuccess()) {
                    this.connection = (Channel)future.getNow();
                    this.connection.attr(ChannelAttributeKey.CHANNEL_POOL_RECORD).set((Object)this);
                    this.createChildChannel(channelPromise, this.connection);
                } else {
                    channelPromise.setFailure(future.cause());
                    this.channelReleaser.accept(this.connection, this);
                }
            });
        }
        return this;
    }

    public void shutdownChildChannels(Throwable t) {
        for (Channel childChannel : this.childChannels.values()) {
            childChannel.pipeline().fireExceptionCaught(t);
        }
    }

    private void createChildChannel(Promise<Channel> channelPromise, Channel parentChannel) {
        NettyUtils.doInEventLoop((EventExecutor)parentChannel.eventLoop(), () -> this.createChildChannel0(channelPromise, parentChannel), channelPromise);
    }

    private void createChildChannel0(Promise<Channel> channelPromise, Channel parentChannel) {
        ((CompletableFuture)parentChannel.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).whenComplete(NettyUtils.asyncPromiseNotifyingBiConsumer(this.bootstrapChildChannel(parentChannel), channelPromise));
    }

    private BiConsumer<Protocol, Promise<Channel>> bootstrapChildChannel(Channel parentChannel) {
        return (s, p) -> new ForkedHttp2StreamChannelBootstrap(parentChannel).open().addListener(future -> {
            if (future.isSuccess()) {
                Http2StreamChannel channel = (Http2StreamChannel)future.getNow();
                this.childChannels.put(channel.id(), (Channel)channel);
            } else {
                if (!this.connection.isActive()) {
                    this.channelReleaser.accept(this.connection, this);
                }
                this.availableStreams.incrementAndGet();
            }
        }).addListener(NettyUtils.promiseNotifyingListener(p));
    }

    void release(Channel channel) {
        this.availableStreams.incrementAndGet();
        this.childChannels.remove(channel.id());
    }

    public Future<Channel> getConnectionFuture() {
        return this.connectionFuture;
    }

    long availableStreams() {
        return this.availableStreams.get();
    }
}

