/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import biz.source_code.base64Coder.Base64Coder;
import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPStream;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.HttpDate;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.google.GoogleUtils;
import org.broad.igv.google.OAuthUtils;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.RunnableResult;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLDownloader;
import org.broad.igv.util.URLUtils;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CI;
import org.broad.igv.util.ftp.FTPUtils;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    private static HttpUtils instance;
    private Map<String, Boolean> byteRangeTestMap;
    private ProxySettings proxySettings = null;
    private final int MAX_REDIRECTS = 5;
    private String defaultUserName = null;
    private char[] defaultPassword = null;
    private static boolean BYTE_RANGE_DISABLED;
    private Map<URL, Boolean> headURLCache = new HashMap<URL, Boolean>();

    public static HttpUtils getInstance() {
        if (instance == null) {
            instance = new HttpUtils();
        }
        return instance;
    }

    private HttpUtils() {
        this.disableCertificateValidation();
        CookieHandler.setDefault(new IGVCookieManager());
        Authenticator.setDefault(new IGVAuthenticator());
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (Exception e) {
            log.info((Object)"Couldn't set useSystemProxies=true");
        }
        this.byteRangeTestMap = Collections.synchronizedMap(new HashMap());
    }

    public static URL createURL(String urlString) throws MalformedURLException {
        urlString = HttpUtils.mapURL(urlString.trim());
        return new URL(urlString);
    }

    public static String mapURL(String urlString) throws MalformedURLException {
        String host;
        if (urlString.startsWith("gs://")) {
            urlString = GoogleUtils.translateGoogleCloudURL(urlString);
        } else if (AmazonUtils.isAwsS3Path(urlString).booleanValue()) {
            try {
                urlString = AmazonUtils.translateAmazonCloudURL(urlString);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        if (GoogleUtils.isGoogleCloud(urlString) && urlString.indexOf("alt=media") < 0) {
            urlString = URLUtils.addParameter(urlString, "alt=media");
        }
        if ((host = URLUtils.getHost(urlString)).equals("igv.broadinstitute.org")) {
            urlString = urlString.replace("igv.broadinstitute.org", "s3.amazonaws.com/igv.broadinstitute.org");
        } else if (host.equals("igvdata.broadinstitute.org")) {
            urlString = urlString.replace("igvdata.broadinstitute.org", "dn7ywbm9isq8j.cloudfront.net");
        } else if (host.equals("www.broadinstitute.org")) {
            urlString = urlString.replace("www.broadinstitute.org/igvdata", "data.broadinstitute.org/igvdata");
        } else if (host.equals("www.dropbox.com")) {
            urlString = urlString.replace("//www.dropbox.com", "//dl.dropboxusercontent.com");
        } else if (host.equals("drive.google.com")) {
            urlString = GoogleUtils.driveDownloadURL(urlString);
        }
        urlString = urlString.replace("http://data.broadinstitute.org", "https://data.broadinstitute.org");
        return urlString;
    }

    public static boolean isRemoteURL(String string) {
        return FileUtils.isRemote(string);
    }

    public static void disableByteRange(boolean b) {
        BYTE_RANGE_DISABLED = b;
    }

    public String getContentsAsString(URL url) throws IOException {
        return this.getContentsAsString(url, null);
    }

    public String getContentsAsString(URL url, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = this.openConnection(url, headers);
        try (InputStream is = null;){
            is = conn.getInputStream();
            String string = this.readContents(is);
            return string;
        }
    }

    public String getContentsAsGzippedString(URL url) throws IOException {
        HttpURLConnection conn = this.openConnection(url, null);
        try (InputStream is = null;){
            is = conn.getInputStream();
            String string = this.readContents(new GZIPInputStream(is));
            return string;
        }
    }

    public String getContentsAsJSON(URL url) throws IOException {
        InputStream is = null;
        HashMap<String, String> reqProperties = new HashMap<String, String>();
        reqProperties.put("Accept", "application/json,text/plain");
        HttpURLConnection conn = this.openConnection(url, reqProperties);
        try {
            is = conn.getInputStream();
            String string = this.readContents(is);
            return string;
        }
        catch (IOException e) {
            this.readErrorStream(conn);
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String doPost(URL url, Map<String, String> params) throws IOException {
        int c;
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(param.getKey());
            postData.append('=');
            postData.append(param.getValue());
        }
        byte[] postDataBytes = postData.toString().getBytes();
        log.debug((Object)("Raw POST request: " + postData.toString()));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
        StringBuilder response = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        while ((c = ((Reader)in).read()) >= 0) {
            response.append((char)c);
        }
        ((Reader)in).close();
        return response.toString();
    }

    public InputStream openConnectionStream(URL url) throws IOException {
        log.debug((Object)("Opening connection stream to  " + url));
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo, new UserPasswordInputImpl());
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        return this.openConnectionStream(url, null);
    }

    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = this.openConnection(url, requestProperties);
        if (conn == null) {
            return null;
        }
        if (requestProperties != null && requestProperties.containsKey("Range") && conn.getResponseCode() != 206) {
            String msg = "Warning: range requested, but response code = " + conn.getResponseCode();
            log.error((Object)msg);
        }
        try {
            InputStream input = conn.getInputStream();
            return input;
        }
        catch (IOException e) {
            this.readErrorStream(conn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceAvailable(String urlString) {
        URL url = null;
        try {
            url = HttpUtils.createURL(urlString);
        }
        catch (MalformedURLException e) {
            return false;
        }
        log.debug((Object)("Checking if resource is available: " + url));
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return FTPUtils.resourceAvailable(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = this.openConnectionHeadOrGet(url);
            int code = conn.getResponseCode();
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    this.readErrorStream(conn);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private HttpURLConnection openConnectionHeadOrGet(URL url) throws IOException {
        boolean tryHead;
        String urlString = url.toString();
        boolean isAWS = urlString.contains("AWSAccessKeyId");
        boolean bl = tryHead = !isAWS && (!this.headURLCache.containsKey(url) || this.headURLCache.get(url) != false);
        if (tryHead) {
            try {
                HttpURLConnection conn = this.openConnection(url, null, "HEAD");
                this.headURLCache.put(url, true);
                return conn;
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    throw e;
                }
                log.debug((Object)("HEAD request failed for url: " + url.toExternalForm()));
                log.debug((Object)("Trying GET instead for url: " + url.toExternalForm()));
                this.headURLCache.put(url, false);
            }
        }
        return this.openConnection(url, null, "GET");
    }

    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return null;
        }
        return conn.getHeaderField(key);
    }

    public long getLastModified(URL url) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return 0L;
        }
        return conn.getLastModified();
    }

    public long getContentLength(URL url) throws IOException {
        try {
            String contentLengthString = this.getHeaderField(url, "Content-Length");
            if (contentLengthString == null) {
                return -1L;
            }
            return Long.parseLong(contentLengthString);
        }
        catch (Exception e) {
            log.error((Object)"Error fetching content length", (Throwable)e);
            return -1L;
        }
    }

    public boolean remoteIsNewer(File file, URL url) throws IOException {
        if (!file.exists()) {
            return false;
        }
        HttpURLConnection conn = this.openConnection(url, null, "HEAD");
        String lastModifiedString = conn.getHeaderField("Last-Modified");
        if (lastModifiedString == null) {
            return true;
        }
        HttpDate date = new HttpDate();
        date.parse(lastModifiedString);
        long remoteModifiedTime = date.getTime();
        long localModifiedTime = file.lastModified();
        return remoteModifiedTime > localModifiedTime;
    }

    public void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e) {
            proxyPort = -1;
        }
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE") && proxyHost != null && proxyHost.trim().length() > 0;
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        String proxyTypeString = prefMgr.get("PROXY.TYPE", "HTTP");
        Proxy.Type type = Proxy.Type.valueOf(proxyTypeString.trim().toUpperCase());
        String proxyWhitelistString = prefMgr.get("PROXY.WHITELIST");
        HashSet<String> whitelist = proxyWhitelistString == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(Globals.commaPattern.split(proxyWhitelistString)));
        this.proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort, type, whitelist);
    }

    private Proxy getSystemProxy(String uri) {
        try {
            if (PreferencesManager.getPreferences().getAsBoolean("DEBUG.PROXY")) {
                log.info((Object)("Getting system proxy for " + uri));
            }
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(uri));
            return proxyList.get(0);
        }
        catch (URISyntaxException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RunnableResult downloadFile(String url, File outputFile) throws IOException {
        URLDownloader downloader = this.downloadFile(url, outputFile, null, null);
        return downloader.getResult();
    }

    public URLDownloader downloadFile(String url, File outputFile, Frame dialogsParent, String dialogTitle) throws IOException {
        boolean showProgressDialog;
        final URLDownloader urlDownloader = new URLDownloader(url, outputFile);
        boolean bl = showProgressDialog = dialogsParent != null;
        if (!showProgressDialog) {
            urlDownloader.run();
            return urlDownloader;
        }
        ProgressMonitor monitor = new ProgressMonitor(IGV.getInstance().getMainPanel(), "Downloading " + outputFile.getName(), "", 0, 100);
        urlDownloader.setMonitor(monitor);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                urlDownloader.cancel(true);
            }
        };
        LongRunningTask.submit(urlDownloader);
        return urlDownloader;
    }

    public void uploadGenomeSpaceFile(String uri, File file, Map<String, String> headers) throws IOException {
        int i;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        URL url = HttpUtils.createURL(uri);
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while ((i = bis.read()) > 0) {
            ((OutputStream)bos).write(i);
        }
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        if (responseCode >= 400) {
            String message = this.readErrorStream(urlconnection);
            throw new IOException("Error uploading " + file.getName() + " : " + message);
        }
    }

    public String createGenomeSpaceDirectory(URL url, String body) throws IOException {
        String nextLine;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Content-Length", String.valueOf(body.getBytes().length));
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        ((OutputStream)bos).write(body.getBytes());
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        StringBuffer buf = new StringBuffer();
        InputStream inputStream = responseCode >= 200 && responseCode < 300 ? urlconnection.getInputStream() : urlconnection.getErrorStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((nextLine = br.readLine()) != null) {
            buf.append(nextLine);
            buf.append('\n');
        }
        inputStream.close();
        if (responseCode >= 200 && responseCode < 300) {
            return buf.toString();
        }
        throw new IOException("Error creating GS directory: " + buf.toString());
    }

    private void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
    }

    private String readContents(InputStream is) throws IOException {
        return ParsingUtils.readContentsFromStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readErrorStream(HttpURLConnection connection) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                String string = null;
                return string;
            }
            String string = this.readContents(inputStream);
            return string;
        }
    }

    public HttpURLConnection delete(URL url) throws IOException {
        return this.openConnection(url, Collections.emptyMap(), "DELETE");
    }

    public HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return this.openConnection(url, requestProperties, "GET");
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return this.openConnection(url, requestProperties, method, 0, 0);
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount, int retries) throws IOException {
        HttpURLConnection conn;
        boolean useProxy;
        boolean checkSystemProxy;
        if (url.getHost().equals("www.googleapis.com") && OAuthUtils.findString != null && OAuthUtils.replaceString != null) {
            url = HttpUtils.createURL(url.toExternalForm().replaceFirst(OAuthUtils.findString, OAuthUtils.replaceString));
        }
        url = StringUtils.encodeURLQueryString(url);
        if (log.isTraceEnabled()) {
            log.trace((Object)url);
        }
        if (StringUtils.countChar(url.toExternalForm(), ' ') > 0) {
            String newPath = url.toExternalForm().replaceAll(" ", "%20");
            url = HttpUtils.createURL(newPath);
        }
        Proxy sysProxy = null;
        boolean igvProxySettingsExist = this.proxySettings != null && this.proxySettings.useProxy;
        boolean bl = checkSystemProxy = !PreferencesManager.getPreferences().getAsBoolean("PROXY.DISABLE_CHECK") && !igvProxySettingsExist;
        if (checkSystemProxy) {
            sysProxy = this.getSystemProxy(url.toExternalForm());
        }
        boolean bl2 = useProxy = sysProxy != null && sysProxy.type() != Proxy.Type.DIRECT || igvProxySettingsExist && !this.proxySettings.getWhitelist().contains(url.getHost());
        if (useProxy) {
            Object proxy = sysProxy;
            if (igvProxySettingsExist) {
                if (this.proxySettings.type == Proxy.Type.DIRECT) {
                    if (PreferencesManager.getPreferences().getAsBoolean("DEBUG.PROXY")) {
                        log.info((Object)"NO_PROXY");
                    }
                    proxy = Proxy.NO_PROXY;
                } else {
                    if (PreferencesManager.getPreferences().getAsBoolean("DEBUG.PROXY")) {
                        log.info((Object)("PROXY " + this.proxySettings.proxyHost + "  " + this.proxySettings.proxyPort));
                    }
                    proxy = new Proxy(this.proxySettings.type, new InetSocketAddress(this.proxySettings.proxyHost, this.proxySettings.proxyPort));
                }
            }
            conn = (HttpURLConnection)url.openConnection((Proxy)proxy);
            if (igvProxySettingsExist && this.proxySettings.auth && this.proxySettings.user != null && this.proxySettings.pw != null) {
                byte[] byArray = (this.proxySettings.user + ":" + this.proxySettings.pw).getBytes();
                String encodedUserPwd = String.valueOf(Base64Coder.encode(byArray));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        } else {
            if (PreferencesManager.getPreferences().getAsBoolean("DEBUG.PROXY")) {
                log.info((Object)"PROXY NOT USED ");
                if (this.proxySettings.getWhitelist().contains(url.getHost())) {
                    log.info((Object)(url.getHost() + " is whitelisted"));
                }
            }
            conn = (HttpURLConnection)url.openConnection();
        }
        if (GSUtils.isGenomeSpace(url)) {
            conn.setRequestProperty("Accept", "application/json,text/plain");
        } else if (!"HEAD".equals(method)) {
            conn.setRequestProperty("Accept", "text/plain");
        }
        conn.setConnectTimeout(Globals.CONNECT_TIMEOUT);
        conn.setReadTimeout(Globals.READ_TIMEOUT);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (requestProperties != null) {
            for (Map.Entry entry : requestProperties.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        conn.setRequestProperty("User-Agent", Globals.applicationString());
        if (GoogleUtils.isGoogleURL(url.toExternalForm())) {
            String token = OAuthUtils.getInstance().getProvider().getAccessToken();
            if (token != null) {
                conn.setRequestProperty("Authorization", "Bearer " + token);
            }
            if (GoogleUtils.getProjectID() != null && GoogleUtils.getProjectID().length() > 0) {
                url = this.addQueryParameter(url, "userProject", GoogleUtils.getProjectID());
            }
        }
        if (method.equals("PUT")) {
            return conn;
        }
        int code = conn.getResponseCode();
        if (!this.isDropboxHost(url.getHost()) && requestProperties != null && requestProperties.containsKey("Range") && code == 200 && method.equals("GET")) {
            log.error((Object)("Range header removed by client or ignored by server for url: " + url.toString()));
            if (!SwingUtilities.isEventDispatchThread()) {
                MessageUtils.showMessage("Warning: unsuccessful attempt to execute 'Range byte' request to host " + url.getHost());
            }
            this.byteRangeTestMap.put(url.getHost(), false);
            String[] stringArray = requestProperties.get("Range").split("=")[1].split("-");
            int length = Integer.parseInt(stringArray[1]) - Integer.parseInt(stringArray[0]) + 1;
            requestProperties.remove("Range");
            URL wsUrl = HttpUtils.createURL("https://portals.broadinstitute.org/webservices/igv/range?file=" + url.toExternalForm() + "&position=" + stringArray[0] + "&length=" + length);
            return this.openConnection(wsUrl, requestProperties, "GET", redirectCount, retries);
        }
        if (log.isDebugEnabled()) {
            // empty if block
        }
        if (code >= 300 && code < 400) {
            if (redirectCount > 5) {
                throw new IOException("Too many redirects");
            }
            String string = conn.getHeaderField("Location");
            log.debug((Object)("Redirecting to " + string));
            return this.openConnection(HttpUtils.createURL(string), requestProperties, method, ++redirectCount, retries);
        }
        if (code >= 400) {
            if (code == 404) {
                String string = "File not found: " + url.toString();
                throw new FileNotFoundException(string);
            }
            if (code == 401) {
                if (GoogleUtils.isGoogleURL(url.toExternalForm()) && retries == 0) {
                    GoogleUtils.checkLogin();
                    return this.openConnection(url, requestProperties, method, redirectCount, ++retries);
                }
                String string = "You must log in to access this file";
                throw new HttpResponseException(code, string, "");
            }
            if (code == 403) {
                String string = "Access forbidden";
                throw new HttpResponseException(code, string, "");
            }
            if (code == 416) {
                throw new UnsatisfiableRangeException(conn.getResponseMessage());
            }
            String string = conn.getResponseMessage();
            String details = this.readErrorStream(conn);
            if (url.getHost().equals("www.googleapis.com") && details.contains("requester pays bucket")) {
                MessageUtils.showMessage("<html>" + details + "<br>Use Google menu to set project.");
            }
            throw new HttpResponseException(code, string, details);
        }
        return conn;
    }

    private boolean isDropboxHost(String host) {
        return host.equals("dl.dropboxusercontent.com") || host.equals("www.dropbox.com");
    }

    private URL addQueryParameter(URL url, String userProject, String projectID) {
        Object urlString;
        urlString = (String)urlString + (((String)(urlString = url.toExternalForm())).contains("?") ? "&" : "?") + userProject + "=" + projectID;
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error adding query parameter", (Throwable)e);
            return url;
        }
    }

    private void logHeaders(HttpURLConnection conn) {
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        log.debug((Object)("Headers for " + conn.getURL()));
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            log.debug((Object)(header.getKey() + ": " + StringUtils.join(header.getValue(), ",")));
        }
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword.toCharArray();
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    public void clearDefaultCredentials() {
        this.defaultPassword = null;
        this.defaultUserName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useByteRange(URL url) throws IOException {
        if (BYTE_RANGE_DISABLED) {
            return false;
        }
        Map<String, Boolean> map = this.byteRangeTestMap;
        synchronized (map) {
            boolean bl;
            block15: {
                String host = url.getHost();
                if (this.byteRangeTestMap.containsKey(host)) {
                    return this.byteRangeTestMap.get(host);
                }
                Object str = null;
                try {
                    boolean byteRangeTestSuccess = this.testByteRange(url);
                    if (byteRangeTestSuccess) {
                        log.info((Object)"Range-byte request succeeded");
                    } else {
                        log.info((Object)("Range-byte test failed -- Host: " + host + " does not support range-byte requests or there is a problem with client network environment."));
                    }
                    this.byteRangeTestMap.put(host, byteRangeTestSuccess);
                    bl = byteRangeTestSuccess;
                    if (str == null) break block15;
                }
                catch (Throwable throwable) {
                    if (str != null) {
                        try {
                            str.close();
                        }
                        catch (IOException e) {
                            log.error((Object)("Error closing stream (" + url.toExternalForm() + ")"), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                try {
                    str.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing stream (" + url.toExternalForm() + ")"), (Throwable)e);
                }
            }
            return bl;
        }
    }

    public boolean testByteRange(URL url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        String byteRange = "bytes=0-10";
        params.put("Range", byteRange);
        HttpURLConnection conn = HttpUtils.getInstance().openConnection(url, params);
        int statusCode = conn.getResponseCode();
        boolean byteRangeTestSuccess = statusCode == 206;
        HttpUtils.readFully(conn.getInputStream(), new byte[10]);
        return byteRangeTestSuccess;
    }

    public void shutdown() {
    }

    static boolean isExpectedRangeMissing(URLConnection conn, Map<String, String> requestProperties) {
        boolean rangeRequested;
        boolean bl = rangeRequested = requestProperties != null && new CI.CIHashMap<String>(requestProperties).containsKey("Range");
        if (!rangeRequested) {
            return false;
        }
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        boolean rangeReceived = headerFields != null && new CI.CIHashMap<List<String>>(headerFields).containsKey("Content-Range");
        return !rangeReceived;
    }

    public void setAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public void resetAuthenticator() {
        Authenticator.setDefault(new IGVAuthenticator());
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    static {
        BYTE_RANGE_DISABLED = false;
    }

    public class UnsatisfiableRangeException
    extends RuntimeException {
        String message;

        public UnsatisfiableRangeException(String message) {
            super(message);
            this.message = message;
        }
    }

    static class IGVCookieManager
    extends CookieHandler {
        CookieManager wrappedManager = new CookieManager();

        @Override
        public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
            String token;
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.putAll(this.wrappedManager.get(uri, requestHeaders));
            if (GSUtils.isGenomeSpace(uri.toURL()) && (token = GSUtils.getGSToken()) != null) {
                ArrayList<Object> cookieList = (ArrayList<Object>)headers.get("Cookie");
                boolean needsTokenCookie = true;
                boolean needsToolCookie = true;
                if (cookieList == null) {
                    cookieList = new ArrayList<Object>(1);
                    headers.put("Cookie", cookieList);
                }
                for (String string : cookieList) {
                    if (string.startsWith("gs-token")) {
                        needsTokenCookie = false;
                        continue;
                    }
                    if (!string.startsWith("gs-toolname")) continue;
                    needsToolCookie = false;
                }
                if (needsTokenCookie) {
                    cookieList.add("gs-token=" + token);
                }
                if (needsToolCookie) {
                    cookieList.add("gs-toolname=IGV");
                }
            }
            return Collections.unmodifiableMap(headers);
        }

        @Override
        public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
            List<String> cookies;
            String urilc = uri.toString().toLowerCase();
            if (urilc.contains("identity") && urilc.contains("genomespace") && (cookies = responseHeaders.get("Set-Cookie")) != null) {
                for (String cstring : cookies) {
                    List<HttpCookie> cookieList = HttpCookie.parse(cstring);
                    for (HttpCookie cookie : cookieList) {
                        String cookieName = cookie.getName();
                        String value = cookie.getValue();
                        if (cookieName.equals("gs-token")) {
                            GSUtils.setGSToken(value);
                            continue;
                        }
                        if (!cookieName.equals("gs-username")) continue;
                        GSUtils.setGSUser(value);
                    }
                }
            }
            this.wrappedManager.put(uri, responseHeaders);
        }
    }

    public class IGVAuthenticator
    extends Authenticator {
        Hashtable<String, PasswordAuthentication> pwCache = new Hashtable();
        HashSet<String> cacheAttempts = new HashSet();

        @Override
        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            Authenticator.RequestorType type = this.getRequestorType();
            String urlString = this.getRequestingURL().toString();
            boolean isProxyChallenge = type == Authenticator.RequestorType.PROXY;
            String pKey = type.toString() + this.getRequestingProtocol() + this.getRequestingHost();
            PasswordAuthentication pw = this.pwCache.get(pKey);
            if (pw != null) {
                if (this.cacheAttempts.contains(urlString)) {
                    this.cacheAttempts.remove(urlString);
                } else {
                    this.cacheAttempts.add(urlString);
                    return pw;
                }
            }
            if (isProxyChallenge && HttpUtils.this.proxySettings.auth && HttpUtils.this.proxySettings.user != null && HttpUtils.this.proxySettings.pw != null) {
                return new PasswordAuthentication(HttpUtils.this.proxySettings.user, HttpUtils.this.proxySettings.pw.toCharArray());
            }
            if (HttpUtils.this.defaultUserName != null && HttpUtils.this.defaultPassword != null) {
                return new PasswordAuthentication(HttpUtils.this.defaultUserName, HttpUtils.this.defaultPassword);
            }
            Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
            boolean isGenomeSpace = GSUtils.isGenomeSpace(this.getRequestingURL());
            if (isGenomeSpace) {
                GSUtils.logout();
            }
            LoginDialog dlg = new LoginDialog(owner, isGenomeSpace, urlString, isProxyChallenge);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            String userString = dlg.getUsername();
            char[] userPass = dlg.getPassword();
            if (isProxyChallenge) {
                HttpUtils.this.proxySettings.user = userString;
                HttpUtils.this.proxySettings.pw = new String(userPass);
            }
            pw = new PasswordAuthentication(userString, userPass);
            this.pwCache.put(pKey, pw);
            return pw;
        }
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;
        Proxy.Type type;
        Set<String> whitelist;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort, Proxy.Type proxyType, Set<String> whitelist) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
            this.type = proxyType;
            this.whitelist = whitelist;
        }

        public Set<String> getWhitelist() {
            return this.whitelist;
        }
    }
}

