/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache.internal.conn.TlsProtocol;
import software.amazon.awssdk.http.apache.internal.net.SdkSocket;
import software.amazon.awssdk.http.apache.internal.net.SdkSslSocket;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class SdkTlsSocketFactory
extends SSLConnectionSocketFactory {
    private static final Logger log = Logger.loggerFor(SdkTlsSocketFactory.class);
    private final SSLContext sslContext;

    public SdkTlsSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sslContext;
    }

    protected final void prepareSocket(SSLSocket socket) {
        String[] supported = socket.getSupportedProtocols();
        String[] enabled = socket.getEnabledProtocols();
        log.debug(() -> String.format("socket.getSupportedProtocols(): %s, socket.getEnabledProtocols(): %s", Arrays.toString(supported), Arrays.toString(enabled)));
        ArrayList<String> target = new ArrayList<String>();
        if (supported != null) {
            TlsProtocol[] tlsProtocolArray = TlsProtocol.values();
            for (int i = 0; i < tlsProtocolArray.length; ++i) {
                String pname = tlsProtocolArray[i].getProtocolName();
                if (!this.existsIn(pname, supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (String string : enabled) {
                if (target.contains(string)) continue;
                target.add(string);
            }
        }
        if (target.size() > 0) {
            String[] stringArray = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols(stringArray);
            log.debug(() -> "TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling));
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        log.trace(() -> String.format("Connecting to %s:%s", remoteAddress.getAddress(), remoteAddress.getPort()));
        Socket connectedSocket = super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
        if (connectedSocket instanceof SSLSocket) {
            return new SdkSslSocket((SSLSocket)connectedSocket);
        }
        return new SdkSocket(connectedSocket);
    }
}

