/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.util.RemoteURLHelper;
import htsjdk.tribble.util.URLHelper;
import htsjdk.tribble.util.URLHelperFactory;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;

public class ParsingUtils {
    public static final Map<Object, Color> colorCache = new WeakHashMap<Object, Color>(100);
    static Map<String, String> colorSymbols = new HashMap<String, String>();
    private static URLHelperFactory urlHelperFactory;
    private static final Class defaultUrlHelperClass;
    public static Class urlHelperClass;
    private static final Set<String> URL_SCHEMES;

    public static InputStream openInputStream(String path) throws IOException {
        return ParsingUtils.openInputStream(path, null);
    }

    public static InputStream openInputStream(String uri, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
        InputStream inputStream;
        if (URL_SCHEMES.stream().anyMatch(uri::startsWith)) {
            inputStream = ParsingUtils.getURLHelper(new URL(uri)).openInputStream();
        } else if (!IOUtil.hasScheme(uri)) {
            File file = new File(uri);
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        } else {
            inputStream = new SeekablePathStream(IOUtil.getPath(uri), wrapper);
        }
        return inputStream;
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        StringBuilder ret = new StringBuilder(iter.next().toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static <T extends Comparable> List<T> sortList(Collection<T> list) {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret);
        return ret;
    }

    public static <T extends Comparable<T>, V> String sortedString(Map<T, V> c) {
        ArrayList<T> t = new ArrayList<T>(c.keySet());
        Collections.sort(t);
        ArrayList<String> pairs = new ArrayList<String>();
        for (Comparable k : t) {
            pairs.add(k + "=" + c.get(k));
        }
        return "{" + ParsingUtils.join(", ", pairs.toArray(new String[pairs.size()])) + "}";
    }

    public static String join(String separator, String[] strings) {
        return ParsingUtils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i = start + 1; i < end; ++i) {
            ret.append(separator);
            ret.append(strings[i]);
        }
        return ret.toString();
    }

    public static List<String> split(String input, char delim) {
        if (input.isEmpty()) {
            return Arrays.asList("");
        }
        ArrayList<String> output = new ArrayList<String>(1 + input.length() / 2);
        int from = -1;
        int to = input.indexOf(delim);
        while (to >= 0) {
            output.add(input.substring(from + 1, to));
            from = to;
            to = input.indexOf(delim, from + 1);
        }
        output.add(input.substring(from + 1));
        return output;
    }

    public static int split(String aString, String[] tokens, char delim) {
        return ParsingUtils.split(aString, tokens, delim, false);
    }

    public static int split(String aString, String[] tokens, char delim, boolean condenseTrailingTokens) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end == 0) {
            if (aString.length() > 1) {
                start = 1;
                end = aString.indexOf(delim, start);
            } else {
                return 0;
            }
        }
        if (end < 0) {
            tokens[nTokens++] = aString.substring(start);
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (condenseTrailingTokens && nTokens == maxTokens) {
            tokens[nTokens - 1] = tokens[nTokens - 1] + delim + aString.substring(start);
        } else if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        int end;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int tabEnd = aString.indexOf(9);
        int spaceEnd = aString.indexOf(32);
        int n = tabEnd < 0 ? spaceEnd : (end = spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            for (start = end + 1; start < aString.length() && aString.charAt(start) == ' '; ++start) {
            }
            tabEnd = aString.indexOf(9, start);
            spaceEnd = aString.indexOf(32, start);
            end = tabEnd < 0 ? spaceEnd : (spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable) {
        Iterator<T> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        Comparable t = (Comparable)iter.next();
        while (iter.hasNext()) {
            Comparable t2 = (Comparable)iter.next();
            if (t.compareTo(t2) > 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    public static Color parseColor(String string) {
        try {
            Color c = colorCache.get(string);
            if (c == null) {
                if (string.contains(",")) {
                    String[] rgb = string.split(",");
                    int red = Integer.parseInt(rgb[0]);
                    int green = Integer.parseInt(rgb[1]);
                    int blue = Integer.parseInt(rgb[2]);
                    c = new Color(red, green, blue);
                } else if (string.startsWith("#")) {
                    c = ParsingUtils.hexToColor(string.substring(1));
                } else {
                    String hexString = colorSymbols.get(string.toLowerCase());
                    if (hexString != null) {
                        c = ParsingUtils.hexToColor(hexString);
                    }
                }
                if (c == null) {
                    c = Color.black;
                }
                colorCache.put(string, c);
            }
            return c;
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    private static Color hexToColor(String string) {
        if (string.length() == 6) {
            int red = Integer.parseInt(string.substring(0, 2), 16);
            int green = Integer.parseInt(string.substring(2, 4), 16);
            int blue = Integer.parseInt(string.substring(4, 6), 16);
            return new Color(red, green, blue);
        }
        return null;
    }

    public static boolean resourceExists(String resource) throws IOException {
        boolean remoteFile;
        boolean bl = remoteFile = resource.startsWith("http://") || resource.startsWith("https://") || resource.startsWith("ftp://");
        if (remoteFile) {
            URL url = null;
            try {
                url = new URL(resource);
            }
            catch (MalformedURLException e) {
                return false;
            }
            URLHelper helper = ParsingUtils.getURLHelper(url);
            return helper.exists();
        }
        if (IOUtil.hasScheme(resource)) {
            return Files.exists(IOUtil.getPath(resource), new LinkOption[0]);
        }
        return new File(resource).exists();
    }

    public static URLHelper getURLHelper(URL url) {
        if (urlHelperFactory != null) {
            System.out.println("Using igv factory");
            return urlHelperFactory.getHelper(url);
        }
        try {
            return ParsingUtils.getURLHelper(urlHelperClass, url);
        }
        catch (Exception e) {
            return ParsingUtils.getURLHelper(defaultUrlHelperClass, url);
        }
    }

    private static URLHelper getURLHelper(Class helperClass, URL url) {
        try {
            Constructor constr = helperClass.getConstructor(URL.class);
            return (URLHelper)constr.newInstance(url);
        }
        catch (Exception e) {
            String errMsg = "Error instantiating url helper for class: " + helperClass;
            throw new IllegalStateException(errMsg, e);
        }
    }

    public static void registerHelperClass(Class helperClass) {
        if (!URLHelper.class.isAssignableFrom(helperClass)) {
            throw new IllegalArgumentException("helperClass must implement URLHelper");
        }
        urlHelperClass = helperClass;
    }

    public static void registerHelperFactory(URLHelperFactory factory) {
        urlHelperFactory = factory;
    }

    public static String appendToPath(String filepath, String indexExtension) {
        String tabxIndex = null;
        URL url = null;
        try {
            url = new URL(filepath);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            String path = url.getPath();
            String indexPath = path + indexExtension;
            tabxIndex = filepath.replace(path, indexPath);
        } else {
            tabxIndex = filepath + indexExtension;
        }
        return tabxIndex;
    }

    static {
        defaultUrlHelperClass = RemoteURLHelper.class;
        urlHelperClass = defaultUrlHelperClass;
        colorSymbols.put("white", "FFFFFF");
        colorSymbols.put("silver", "C0C0C0");
        colorSymbols.put("gray", "808080");
        colorSymbols.put("black", "000000");
        colorSymbols.put("red", "FF0000");
        colorSymbols.put("maroon", "800000");
        colorSymbols.put("yellow", "FFFF00");
        colorSymbols.put("olive", "808000");
        colorSymbols.put("lime", "00FF00");
        colorSymbols.put("green", "008000");
        colorSymbols.put("aqua", "00FFFF");
        colorSymbols.put("teal", "008080");
        colorSymbols.put("blue", "0000FF");
        colorSymbols.put("navy", "000080");
        colorSymbols.put("fuchsia", "FF00FF");
        colorSymbols.put("purple", "800080");
        colorSymbols.put("orange", "FFA500");
        colorSymbols.put("magenta", "FF00FF");
        URL_SCHEMES = new HashSet<String>(Arrays.asList("http", "ftp", "https"));
    }
}

