/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.legend.HeatmapLegendEditor;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.util.UIUtilities;

public class HeatmapLegendPanel
extends LegendPanel {
    static Logger log = Logger.getLogger(HeatmapLegendPanel.class);
    private Orientation orientation = Orientation.HORIZONTAL;
    private TrackType type;
    protected ContinuousColorScale colorScale;

    public HeatmapLegendPanel(TrackType type) {
        this.type = type;
        this.colorScale = PreferencesManager.getPreferences().getColorScale(type);
    }

    public HeatmapLegendPanel(TrackType type, Orientation orientation) {
        this(type);
        this.orientation = orientation;
    }

    @Override
    protected void persistResetPreferences() {
        PreferencesManager.getPreferences().setColorScale(this.type, this.colorScale);
    }

    @Override
    protected void resetPreferencesToDefault() {
        PreferencesManager.getPreferences();
        this.colorScale = IGVPreferences.getDefaultColorScale(this.type);
        this.persistResetPreferences();
        this.showResetDisplay();
    }

    @Override
    protected void reloadPreferences() {
        PreferencesManager.getPreferences().setColorScale(this.type, this.colorScale);
        this.repaint();
    }

    @Override
    public void edit() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGV.getInstance().setStatusBarMessage("Setting view properties...");
                HeatmapLegendEditor dialog = new HeatmapLegendEditor(IGV.getMainFrame(), true, HeatmapLegendPanel.this.type, HeatmapLegendPanel.this.colorScale);
                dialog.setTitle("HeatMap Preferences");
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    IGV.getInstance().resetStatusMessage();
                    return;
                }
                HeatmapLegendPanel.this.colorScale = dialog.getColorScheme();
                PreferencesManager.getPreferences().setColorScale(HeatmapLegendPanel.this.type, HeatmapLegendPanel.this.colorScale);
                IGV.getInstance().revalidateTrackPanels();
                try {
                    HeatmapLegendPanel.this.reloadPreferences();
                }
                catch (Throwable throwable) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.getWindowAncestor(HeatmapLegendPanel.this).toFront();
                        }
                    });
                    IGV.getInstance().resetStatusMessage();
                    throw throwable;
                }
                UIUtilities.invokeOnEventThread(new /* invalid duplicate definition of identical inner class */);
                IGV.getInstance().resetStatusMessage();
            }
        });
    }

    @Override
    protected void paintLegend(Graphics2D g) {
        if (this.orientation == Orientation.HORIZONTAL) {
            this.paintHorizontal(g);
        } else {
            this.paintVertical(g);
        }
    }

    protected void paintHorizontal(Graphics2D g2D) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        g2D.setFont(FontManager.getFont(10));
        int npts = 5;
        double max = this.colorScale.getMaximum();
        double min = this.colorScale.getMinimum();
        int w = this.getWidth() - 20;
        double dx = (double)w / (double)npts;
        double dxj = dx / 10.0;
        double delta = (max - min) / (double)npts;
        double deltaj = delta / 10.0;
        for (int i = 0; i < npts + 1; ++i) {
            for (int j = i * 10; j < i * 10 + 10; ++j) {
                double val = min + (double)j * deltaj;
                Color c = this.colorScale.getColor((float)val);
                g2D.setColor(c);
                int x0 = (int)((double)j * dxj);
                int x1 = (int)((double)(j + 1) * dxj);
                g2D.fillRect(x0, 0, x1 - x0, this.getHeight() / 2);
            }
            double labelVal = min + (double)i * delta;
            int x0 = (int)((double)i * dx);
            g2D.setColor(Color.BLACK);
            g2D.drawString(formatter.format(labelVal), x0, this.getHeight() - 5);
        }
    }

    void paintVertical(Graphics2D g2D) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        g2D.setFont(FontManager.getFont(10));
        int npts = 5;
        double max = this.colorScale.getMaximum();
        double min = this.colorScale.getMinimum();
        int h = this.getWidth() - 20;
        double dy = (double)h / (double)npts;
        double dyj = dy / 10.0;
        double delta = (max - min) / (double)npts;
        double deltaj = delta / 10.0;
        int x0 = 10;
        int dx = 10;
        int y1 = 0;
        for (int i = 0; i < npts + 1; ++i) {
            for (int j = i * 10; j < i * 10 + 10; ++j) {
                double val = min + (double)j * deltaj;
                Color c = this.colorScale.getColor((float)val);
                g2D.setColor(c);
                int y0 = (int)((double)j * dyj);
                y1 = (int)((double)(j + 1) * dyj);
                g2D.fillRect(x0, y0, dx, y1 - y0);
            }
            double labelVal = min + (double)i * delta;
            g2D.setColor(Color.BLACK);
            g2D.drawString(formatter.format(labelVal), x0 + 15, y1 - 5);
        }
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

