/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.prefs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Utilities;

public class PreferenceEditorNew {
    private static Logger log = Logger.getLogger(PreferenceEditorNew.class);
    private static final Font labelFont = new Font("Lucida Grande", 1, 14);

    public static void main(String[] args) throws IOException {
        PreferenceEditorNew.open(null);
    }

    public static void open(Frame parent) throws IOException {
        List<PreferencesManager.PreferenceGroup> preferenceGroups = PreferencesManager.loadPreferenceList();
        SwingUtilities.invokeLater(() -> {
            JDialog frame = new JDialog(parent, "Preferences", true);
            JPanel panel = new JPanel();
            SwingUtilities.invokeLater(() -> PreferenceEditorNew.init(frame, panel, preferenceGroups));
            panel.setPreferredSize(new Dimension(750, 590));
            panel.setMaximumSize(new Dimension(750, 590));
            frame.add(panel);
            frame.pack();
            frame.setSize(800, 600);
            frame.setLocationRelativeTo(parent);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }

    private static void init(JDialog parent, JPanel panel, List<PreferencesManager.PreferenceGroup> preferenceGroups) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(750, 590));
        tabbedPane.setMaximumSize(new Dimension(750, 590));
        panel.setLayout(new BorderLayout());
        panel.add((Component)tabbedPane, "Center");
        HashMap updatedPreferencesMap = new HashMap();
        for (PreferencesManager.PreferenceGroup entry : preferenceGroups) {
            JButton moveButton;
            JLabel currentDirectoryLabel;
            String currentDirectory;
            if (entry.tabLabel.equals("Hidden")) continue;
            final IGVPreferences preferences = PreferencesManager.getPreferences(entry.category);
            final HashMap updatedPrefs = updatedPreferencesMap.containsKey(entry.category) ? (Map)updatedPreferencesMap.get(entry.category) : new HashMap();
            updatedPreferencesMap.put(entry.category, updatedPrefs);
            String tabLabel = entry.tabLabel;
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(750, 590));
            scrollPane.setMaximumSize(new Dimension(750, 590));
            scrollPane.setName(tabLabel);
            tabbedPane.addTab(tabLabel, scrollPane);
            JPanel content = new JPanel();
            int contentRow = 0;
            GridBagLayout contentGrid = new GridBagLayout();
            content.setLayout(contentGrid);
            scrollPane.setViewportView(content);
            JPanel group = new JPanel();
            int row = 0;
            GridBagLayout grid = new GridBagLayout();
            group.setLayout(grid);
            contentGrid.addLayoutComponent(group, new GridBagConstraints(0, contentRow++, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 5, 5));
            content.add(group);
            String currentGroup = null;
            JLabel groupSpacer = new JLabel("    ");
            groupSpacer.setPreferredSize(new Dimension(1, 1));
            grid.addLayoutComponent(groupSpacer, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            group.add(groupSpacer);
            for (final PreferencesManager.Preference pref : entry.preferences) {
                try {
                    JLabel label;
                    if (pref.getKey().equals("---")) {
                        JSeparator sep = new JSeparator();
                        grid.addLayoutComponent(sep, new GridBagConstraints(0, row, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 5, 2));
                        group.add(sep);
                        ++row;
                        continue;
                    }
                    if (pref.getKey().equals("info")) {
                        label = new JLabel(pref.getLabel());
                        label.setFont(labelFont);
                        grid.addLayoutComponent(label, new GridBagConstraints(0, ++row, 4, 1, 1.0, 0.0, 13, 2, new Insets(3, 5, 5, 5), 5, 2));
                        group.add(label);
                        ++row;
                        continue;
                    }
                    if (pref.group != null && !pref.group.equals(currentGroup)) {
                        row = 0;
                        if (group.getComponentCount() > 0) {
                            group = new JPanel();
                            grid = new GridBagLayout();
                            group.setLayout(grid);
                            contentGrid.addLayoutComponent(group, new GridBagConstraints(0, contentRow++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 5, 5));
                            content.add(group);
                            groupSpacer = new JLabel("    ");
                            groupSpacer.setPreferredSize(new Dimension(1, 1));
                            grid.addLayoutComponent(groupSpacer, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                            group.add(groupSpacer);
                        }
                        currentGroup = pref.group;
                        group.setBorder(BorderFactory.createTitledBorder(currentGroup));
                    }
                    if (pref.getType().equals("boolean")) {
                        JCheckBox cb = new JCheckBox(pref.getLabel());
                        cb.setSelected(preferences.getAsBoolean(pref.getKey()));
                        cb.addActionListener(event -> updatedPrefs.put(pref.getKey(), Boolean.toString(cb.isSelected())));
                        grid.addLayoutComponent(cb, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 5, 2, 5), 2, 2));
                        group.add(cb);
                        if (pref.getComment() != null) {
                            cb.setToolTipText(pref.getComment());
                        }
                    } else if (pref.getType().startsWith("select")) {
                        label = new JLabel(pref.getLabel());
                        String[] selections = Globals.whitespacePattern.split(pref.getType())[1].split("\\|");
                        JComboBox<String> comboBox = new JComboBox<String>(selections);
                        comboBox.setSelectedItem(pref.getDefaultValue().toString());
                        comboBox.addActionListener(event -> log.debug((Object)("Set " + pref.getLabel() + " " + comboBox.getSelectedItem())));
                        grid.addLayoutComponent(label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 5, 2, 3), 2, 2));
                        grid.addLayoutComponent(comboBox, new GridBagConstraints(1, row, 3, 1, 1.0, 0.0, 17, 0, new Insets(3, 2, 2, 5), 2, 2));
                        group.add(label);
                        group.add(comboBox);
                        if (pref.getComment() != null) {
                            label.setToolTipText(pref.getComment());
                            comboBox.setToolTipText(pref.getComment());
                        }
                    } else {
                        label = new JLabel(pref.getLabel());
                        final JTextField field = new JTextField(preferences.get(pref.getKey()));
                        Dimension d = field.getPreferredSize();
                        d.width = 300;
                        field.setPreferredSize(d);
                        field.setMaximumSize(d);
                        field.addActionListener(event -> {
                            String text = field.getText();
                            if (PreferenceEditorNew.validate(text, pref.getType())) {
                                if (pref.getKey().equals("PROXY.PW")) {
                                    text = Utilities.base64Encode(text);
                                }
                                updatedPrefs.put(pref.getKey(), text);
                            } else {
                                field.setText(preferences.get(pref.getKey()));
                            }
                        });
                        field.addFocusListener(new FocusAdapter(){

                            @Override
                            public void focusLost(FocusEvent e) {
                                String text = field.getText();
                                if (PreferenceEditorNew.validate(text, pref.getType())) {
                                    if (pref.getKey().equals("PROXY.PW")) {
                                        text = Utilities.base64Encode(text);
                                    }
                                    updatedPrefs.put(pref.getKey(), text);
                                } else {
                                    field.setText(preferences.get(pref.getKey()));
                                }
                            }
                        });
                        grid.addLayoutComponent(label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 2, 3), 2, 2));
                        grid.addLayoutComponent(field, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 2, 2, 5), 2, 2));
                        group.add(label);
                        group.add(field);
                        if (pref.getComment() != null) {
                            label.setToolTipText(pref.getComment());
                            field.setToolTipText(pref.getComment());
                        }
                    }
                    ++row;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (tabLabel.equalsIgnoreCase("Cram")) {
                currentDirectory = DirectoryManager.getFastaCacheDirectory().getAbsolutePath();
                currentDirectoryLabel = new JLabel("Cache directory: " + currentDirectory);
                moveButton = new JButton("Move...");
                grid.addLayoutComponent(currentDirectoryLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 2, 5), 2, 2));
                grid.addLayoutComponent(moveButton, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 2, 5), 2, 2));
                group.add(currentDirectoryLabel);
                group.add(moveButton);
                moveButton.addActionListener(event -> UIUtilities.invokeOnEventThread(() -> {
                    File directory = DirectoryManager.getFastaCacheDirectory();
                    File newDirectory = FileDialogUtils.chooseDirectory("Select cache directory", DirectoryManager.getUserDirectory());
                    if (newDirectory != null && !newDirectory.equals(directory)) {
                        DirectoryManager.moveDirectoryContents(directory, newDirectory);
                        SwingUtilities.invokeLater(() -> currentDirectoryLabel.setText(newDirectory.getAbsolutePath()));
                    }
                }));
            }
            if (tabLabel.equalsIgnoreCase("Advanced")) {
                currentDirectory = DirectoryManager.getIgvDirectory().getAbsolutePath();
                currentDirectoryLabel = new JLabel("IGV Directory: " + currentDirectory);
                moveButton = new JButton("Move...");
                grid.addLayoutComponent(currentDirectoryLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 2, 5), 2, 2));
                grid.addLayoutComponent(moveButton, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 2, 5), 2, 2));
                group.add(currentDirectoryLabel);
                group.add(moveButton);
                moveButton.addActionListener(event -> UIUtilities.invokeOnEventThread(() -> {
                    File igvDirectory = DirectoryManager.getIgvDirectory();
                    File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
                    if (newDirectory != null && !newDirectory.equals(igvDirectory)) {
                        DirectoryManager.moveIGVDirectory(newDirectory);
                        SwingUtilities.invokeLater(() -> currentDirectoryLabel.setText(newDirectory.getAbsolutePath()));
                    }
                }));
            }
            JPanel contentSpacer = new JPanel();
            contentGrid.addLayoutComponent(contentSpacer, new GridBagConstraints(0, contentRow++, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 2, 2));
            content.add(contentSpacer);
        }
        JPanel saveCancelPanel = new JPanel();
        saveCancelPanel.setBackground(new Color(51, 102, 153));
        saveCancelPanel.setPreferredSize(new Dimension(750, 40));
        saveCancelPanel.setMaximumSize(new Dimension(750, 40));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(100, 30));
        cancelButton.setMaximumSize(new Dimension(100, 30));
        cancelButton.addActionListener(event -> SwingUtilities.invokeLater(() -> parent.setVisible(false)));
        JButton saveButton = new JButton("Save");
        saveButton.setPreferredSize(new Dimension(100, 30));
        saveButton.setMaximumSize(new Dimension(100, 30));
        saveButton.setDefaultCapable(true);
        saveButton.addActionListener(event -> {
            PreferencesManager.updateAll(updatedPreferencesMap);
            SwingUtilities.invokeLater(() -> parent.setVisible(false));
            if (IGV.hasInstance()) {
                IGV.getInstance().doRefresh();
            }
        });
        saveCancelPanel.add(cancelButton);
        saveCancelPanel.add(saveButton);
        panel.add((Component)saveCancelPanel, "South");
    }

    private static boolean validate(String text, String type) {
        if (type.equals("integer")) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (type.equals("float")) {
            try {
                Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

