/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.fasta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;

public class FastaDirectorySequence
implements Sequence {
    Map<String, FastaIndexedSequence> sequenceMap;
    List<String> chromosomeNames;
    Map<String, Integer> chrLengths;

    public FastaDirectorySequence(String directoryPath, String[] fastaFiles) throws IOException {
        this.readIndexes(directoryPath, fastaFiles);
    }

    private void readIndexes(String directoryPath, String[] fastaFiles) throws IOException {
        this.sequenceMap = new LinkedHashMap<String, FastaIndexedSequence>();
        for (String file : fastaFiles) {
            String fastaPath = directoryPath + "/" + file;
            FastaIndexedSequence fastaSequence = new FastaIndexedSequence(fastaPath);
            for (String chr : fastaSequence.getChromosomeNames()) {
                this.sequenceMap.put(chr, fastaSequence);
            }
        }
        this.chromosomeNames = new ArrayList<String>();
        for (FastaIndexedSequence fastaSequence : this.getFastaSequences()) {
            this.chromosomeNames.addAll(fastaSequence.getChromosomeNames());
        }
        Collections.sort(this.chromosomeNames, ChromosomeNameComparator.get());
        this.chrLengths = new HashMap<String, Integer>(this.chromosomeNames.size());
        for (FastaIndexedSequence fastaSequence : this.getFastaSequences()) {
            for (String chr : fastaSequence.getChromosomeNames()) {
                int length = fastaSequence.getChromosomeLength(chr);
                this.chrLengths.put(chr, length);
            }
        }
    }

    public Collection<FastaIndexedSequence> getFastaSequences() {
        return this.sequenceMap.values();
    }

    @Override
    public byte[] getSequence(String chr, int start, int end, boolean useCache) {
        if (!this.sequenceMap.containsKey(chr)) {
            return null;
        }
        return this.sequenceMap.get(chr).getSequence(chr, start, end, useCache);
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    @Override
    public byte getBase(String chr, int position) {
        throw new RuntimeException("getBase() is not implemented for class " + FastaIndexedSequence.class.getName());
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return this.chrLengths.get(chrname);
    }

    @Override
    public boolean isRemote() {
        for (FastaIndexedSequence seq : this.sequenceMap.values()) {
            if (!seq.isRemote()) continue;
            return true;
        }
        return false;
    }
}

