/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.digest;

import htsjdk.samtools.cram.digest.AbstractSerialDigest;
import htsjdk.samtools.cram.digest.Combine;
import java.nio.ByteOrder;
import java.util.zip.CRC32;

class Crc32Hasher
extends AbstractSerialDigest<Integer> {
    private final CRC32 crc32 = new CRC32();
    private final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;

    Crc32Hasher(Combine<Integer> combine) {
        super(combine, null);
    }

    @Override
    protected void resetAndUpdate(byte[] data) {
        this.crc32.reset();
        this.crc32.update(data);
    }

    @Override
    protected Integer getValue() {
        return (int)(this.crc32.getValue() & 0xFFFFFFFFL);
    }

    @Override
    protected byte[] asByteArray() {
        byte[] array = new byte[4];
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            array[3] = (byte)((Integer)this.value >>> 24 & 0xFF);
            array[2] = (byte)((Integer)this.value >>> 16 & 0xFF);
            array[1] = (byte)((Integer)this.value >>> 8 & 0xFF);
            array[0] = (byte)((Integer)this.value & 0xFF);
        } else {
            array[0] = (byte)((Integer)this.value >>> 24 & 0xFF);
            array[1] = (byte)((Integer)this.value >>> 16 & 0xFF);
            array[2] = (byte)((Integer)this.value >>> 8 & 0xFF);
            array[3] = (byte)((Integer)this.value & 0xFF);
        }
        return array;
    }
}

