/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.color;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.util.ObjectCache;

public class ColorUtilities {
    private static Logger log = Logger.getLogger(ColorUtilities.class);
    public static ObjectCache<Object, Color> colorCache = new ObjectCache(1000);
    private static float[] whiteComponents = Color.white.getRGBColorComponents(null);
    private static Map<Integer, Color> grayscaleColors = new HashMap<Integer, Color>();
    static Map<String, String> colorSymbols = new HashMap<String, String>();
    private static Map<String, ColorPalette> palettes;
    public static Map<Color, float[]> componentsCache;
    static int nextPaletteIdx;
    static ArrayList<String> palleteNames;

    private static int[] quasiRandomColor(int idx) {
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        int r = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        int g = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        int b = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new int[]{r, g, b};
    }

    public static Color randomColor(int idx) {
        return ColorUtilities.randomColor(idx, 1.0f);
    }

    public static Color randomColor(int idx, float alpha) {
        int[] rgb = ColorUtilities.quasiRandomColor(idx);
        int r = rgb[0];
        int g = rgb[1];
        int b = rgb[2];
        if (r > 200 && g > 200 && b > 200) {
            int tmp = r % 3;
            if (tmp == 0) {
                r = 255 - r;
            } else if (tmp == 1) {
                g = 255 - g;
            } else {
                b = 255 - b;
            }
        }
        return new Color(r, g, b, (int)(255.0f * alpha));
    }

    public static void main(String[] args) {
        for (int i = 200; i < 300; ++i) {
            System.out.println(i % 3);
        }
    }

    public static Color randomDesaturatedColor(float alpha) {
        float hue = (float)Math.random();
        float brightenss = (float)(Math.random() * 0.7);
        Color base = Color.getHSBColor(hue, 0.0f, brightenss);
        if (alpha >= 1.0f) {
            return base;
        }
        return new Color(base.getRed(), base.getGreen(), base.getBlue(), (int)(alpha * 255.0f));
    }

    public static Color adjustHSB(Color inputColor, float hue, float saturation, float brightness) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(inputColor.getRed(), inputColor.getGreen(), inputColor.getBlue(), hsbvals);
        return Color.getHSBColor(hue * hsbvals[0], saturation * hsbvals[1], brightness * hsbvals[2]);
    }

    public static String colorToString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }

    public static Color stringToColor(String string) {
        return ColorUtilities.stringToColor(string, Color.black);
    }

    public static Color stringToColor(String string, Color defaultColor) {
        if (string == null) {
            return defaultColor;
        }
        try {
            Color c = ColorUtilities.stringToColorNoDefault(string);
            if (c == null) {
                c = defaultColor;
            }
            colorCache.put(string, c);
            return c;
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)"Error in color string. ", (Throwable)numberFormatException);
            return defaultColor;
        }
    }

    private static Color stringToColorNoDefault(String string) throws NumberFormatException {
        Color c;
        block7: {
            string = string.replace("\"", "").replace("'", "");
            c = null;
            if (string.contains(",")) {
                String[] rgb = string.split(",");
                int red = Integer.parseInt(rgb[0]);
                int green = Integer.parseInt(rgb[1]);
                int blue = Integer.parseInt(rgb[2]);
                c = new Color(red, green, blue);
            } else if (string.startsWith("#")) {
                c = ColorUtilities.hexToColor(string.substring(1));
            } else {
                try {
                    int intValue = Integer.parseInt(string);
                    if (intValue >= 0) {
                        c = new Color(intValue);
                    }
                }
                catch (NumberFormatException e) {
                    String hexString = colorSymbols.get(string.toLowerCase());
                    if (hexString == null) break block7;
                    c = ColorUtilities.hexToColor(hexString);
                }
            }
        }
        return c;
    }

    private static Color hexToColor(String string) {
        if (string.length() == 6) {
            int red = Integer.parseInt(string.substring(0, 2), 16);
            int green = Integer.parseInt(string.substring(2, 4), 16);
            int blue = Integer.parseInt(string.substring(4, 6), 16);
            return new Color(red, green, blue);
        }
        return null;
    }

    public static float[] getRGBColorComponents(Color color) {
        float[] comps = componentsCache.get(color);
        if (comps == null) {
            comps = color.getRGBColorComponents(null);
            componentsCache.put(color, comps);
        }
        return comps;
    }

    public static Color getCompositeColor(Color backgroundColor, Color foregroundColor, float alpha) {
        int b;
        int g;
        float[] dest = ColorUtilities.getRGBColorComponents(backgroundColor);
        int a = 255;
        float[] source = ColorUtilities.getRGBColorComponents(foregroundColor);
        int r = (int)((double)((alpha * source[0] + (1.0f - alpha) * dest[0]) * 255.0f) + 0.5);
        int value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | ((g = (int)((double)((alpha * source[1] + (1.0f - alpha) * dest[1]) * 255.0f) + 0.5)) & 0xFF) << 8 | ((b = (int)((double)((alpha * source[2] + (1.0f - alpha) * dest[2]) * 255.0f) + 0.5)) & 0xFF) << 0;
        Color c = colorCache.get(value);
        if (c == null) {
            c = new Color(value);
            colorCache.put(value, c);
        }
        return c;
    }

    public static Color getCompositeColor(Color source, float alpha) {
        return ColorUtilities.getCompositeColor(Color.white, source, alpha);
    }

    public static Map<String, ColorPalette> loadPalettes() throws IOException {
        ColorPalette palette;
        String nextLine;
        InputStream is = ColorUtilities.class.getResourceAsStream("resources/colorPalettes.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        palettes = new LinkedHashMap<String, ColorPalette>();
        palleteNames = new ArrayList();
        String currentPalletName = null;
        ArrayList<Color> currentColorList = new ArrayList<Color>();
        while ((nextLine = br.readLine()) != null) {
            String[] tokens;
            if ((nextLine = nextLine.trim()).length() == 0) continue;
            if (nextLine.startsWith("#")) {
                if (currentPalletName != null) {
                    palette = new ColorPalette(currentPalletName, currentColorList.toArray(new Color[currentColorList.size()]));
                    palettes.put(currentPalletName, palette);
                    palleteNames.add(currentPalletName);
                    currentColorList.clear();
                }
                currentPalletName = nextLine.substring(1);
                continue;
            }
            for (String s : tokens = nextLine.split(";")) {
                s = s.replaceAll(" ", "");
                Color c = ColorUtilities.stringToColor(s);
                currentColorList.add(c);
            }
        }
        if (!currentColorList.isEmpty()) {
            palette = new ColorPalette(currentPalletName, currentColorList.toArray(new Color[currentColorList.size()]));
            palettes.put(currentPalletName, palette);
            palleteNames.add(currentPalletName);
        }
        return palettes;
    }

    public static ColorPalette getNextPalette() {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            ColorPalette pallete = palettes.get(palleteNames.get(nextPaletteIdx));
            if (++nextPaletteIdx >= palleteNames.size()) {
                nextPaletteIdx = 0;
            }
            return pallete;
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    public static ColorPalette getPalette(String s) {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            return palettes.get(s);
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    public static ColorPalette getDefaultPalette() {
        try {
            if (palettes == null) {
                ColorUtilities.loadPalettes();
            }
            if (palettes.isEmpty()) {
                return null;
            }
            return palettes.values().iterator().next();
        }
        catch (IOException e) {
            log.error((Object)"Error loading color palletes", (Throwable)e);
            return null;
        }
    }

    public static synchronized Color getGrayscaleColor(int gray) {
        Color c = grayscaleColors.get(gray = Math.max(0, Math.min(255, gray)));
        if (c == null) {
            c = new Color(gray, gray, gray);
            grayscaleColors.put(gray, c);
        }
        return c;
    }

    public static Color modifyAlpha(Color oldColor, int newAlpha) {
        return new Color(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), newAlpha);
    }

    public static int[] hslToRgb(double h, double s, double l) {
        double b;
        double g;
        double r;
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double hprime = h / 60.0;
        double x = c * (1.0 - Math.abs(hprime % 2.0 - 1.0));
        if (hprime < 1.0) {
            r = c;
            g = x;
            b = 0.0;
        } else if (hprime < 2.0) {
            r = x;
            g = c;
            b = 0.0;
        } else if (hprime < 3.0) {
            r = 0.0;
            g = c;
            b = x;
        } else if (hprime < 4.0) {
            r = 0.0;
            g = x;
            b = c;
        } else if (hprime < 5.0) {
            r = x;
            g = 0.0;
            b = c;
        } else {
            r = c;
            g = 0.0;
            b = x;
        }
        double m = l - 0.5 * c;
        return new int[]{(int)((r + m) * 255.0), (int)((g + m) * 255.0), (int)((b + m) * 255.0)};
    }

    static {
        componentsCache = Collections.synchronizedMap(new HashMap());
        colorSymbols.put("white", "FFFFFF");
        colorSymbols.put("silver", "C0C0C0");
        colorSymbols.put("gray", "808080");
        colorSymbols.put("black", "000000");
        colorSymbols.put("red", "FF0000");
        colorSymbols.put("maroon", "800000");
        colorSymbols.put("yellow", "FFFF00");
        colorSymbols.put("olive", "808000");
        colorSymbols.put("lime", "00FF00");
        colorSymbols.put("green", "008000");
        colorSymbols.put("aqua", "00FFFF");
        colorSymbols.put("teal", "008080");
        colorSymbols.put("blue", "0000FF");
        colorSymbols.put("navy", "000080");
        colorSymbols.put("fuchsia", "FF00FF");
        colorSymbols.put("purple", "800080");
        colorSymbols.put("orange", "FFA500");
        colorSymbols.put("magenta", "FF00FF");
        nextPaletteIdx = 0;
        palleteNames = new ArrayList();
    }
}

