/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSortOrderChecker;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.Closeable;

public interface SamReader
extends Iterable<SAMRecord>,
Closeable {
    public SAMFileHeader getFileHeader();

    public Type type();

    public String getResourceDescription();

    public boolean hasIndex();

    public Indexing indexing();

    public SAMRecordIterator iterator();

    public SAMRecordIterator query(String var1, int var2, int var3, boolean var4);

    public SAMRecordIterator queryOverlapping(String var1, int var2, int var3);

    public SAMRecordIterator queryContained(String var1, int var2, int var3);

    public SAMRecordIterator query(QueryInterval[] var1, boolean var2);

    public SAMRecordIterator queryOverlapping(QueryInterval[] var1);

    public SAMRecordIterator queryContained(QueryInterval[] var1);

    public SAMRecordIterator queryUnmapped();

    public SAMRecordIterator queryAlignmentStart(String var1, int var2);

    public SAMRecord queryMate(SAMRecord var1);

    public static abstract class ReaderImplementation
    implements PrimitiveSamReader {
        abstract void enableFileSource(SamReader var1, boolean var2);

        abstract void enableIndexCaching(boolean var1);

        abstract void enableIndexMemoryMapping(boolean var1);

        abstract void enableCrcChecking(boolean var1);

        abstract void setSAMRecordFactory(SAMRecordFactory var1);

        abstract void setValidationStringency(ValidationStringency var1);
    }

    public static class AssertingIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMSortOrderChecker checker;

        static AssertingIterator of(CloseableIterator<SAMRecord> iterator) {
            return new AssertingIterator(iterator);
        }

        public AssertingIterator(CloseableIterator<SAMRecord> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            this.checker = new SAMSortOrderChecker(sortOrder);
            return this;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = (SAMRecord)this.wrappedIterator.next();
            if (this.checker != null) {
                SAMRecord previous = this.checker.getPreviousRecord();
                if (!this.checker.isSorted(result)) {
                    throw new IllegalStateException(String.format("Record %s should come after %s when sorting with %s ordering.", new Object[]{previous.getSAMString().trim(), result.getSAMString().trim(), this.checker.getSortOrder()}));
                }
            }
            return result;
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }

    public static class PrimitiveSamReaderToSamReaderAdapter
    implements SamReader,
    Indexing {
        final PrimitiveSamReader p;
        final SamInputResource resource;

        public PrimitiveSamReaderToSamReaderAdapter(PrimitiveSamReader p, SamInputResource resource) {
            this.p = p;
            this.resource = resource;
        }

        public PrimitiveSamReader underlyingReader() {
            return this.p;
        }

        @Override
        public SAMRecordIterator queryOverlapping(String sequence, int start, int end) {
            return this.query(sequence, start, end, false);
        }

        @Override
        public SAMRecordIterator queryOverlapping(QueryInterval[] intervals) {
            return this.query(intervals, false);
        }

        @Override
        public SAMRecordIterator queryContained(String sequence, int start, int end) {
            return this.query(sequence, start, end, true);
        }

        @Override
        public SAMRecordIterator queryContained(QueryInterval[] intervals) {
            return this.query(intervals, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord queryMate(SAMRecord rec) {
            if (!rec.getReadPairedFlag()) {
                throw new IllegalArgumentException("queryMate called for unpaired read.");
            }
            if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
                throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
            }
            boolean firstOfPair = rec.getFirstOfPairFlag();
            try (SAMRecordIterator it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());){
                SAMRecord mateRec = null;
                while (it.hasNext()) {
                    SAMRecord next = (SAMRecord)it.next();
                    if (!next.getReadPairedFlag()) {
                        if (!rec.getReadName().equals(next.getReadName())) continue;
                        throw new SAMFormatException("Paired and unpaired reads with same name: " + rec.getReadName());
                    }
                    if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                    if (mateRec != null) {
                        throw new SAMFormatException("Multiple SAMRecord with read name " + rec.getReadName() + " for " + (firstOfPair ? "second" : "first") + " end.");
                    }
                    mateRec = next;
                }
                SAMRecord sAMRecord = mateRec;
                return sAMRecord;
            }
        }

        @Override
        public boolean hasBrowseableIndex() {
            return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
        }

        @Override
        public BrowseableBAMIndex getBrowseableIndex() {
            BAMIndex index = this.getIndex();
            if (!(index instanceof BrowseableBAMIndex)) {
                throw new SAMException("Cannot return index: index created by BAM is not browseable.");
            }
            return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(index);
        }

        @Override
        public SAMRecordIterator iterator() {
            return new AssertingIterator(this.p.getIterator());
        }

        @Override
        public SAMRecordIterator iterator(SAMFileSpan chunks) {
            return new AssertingIterator(this.p.getIterator(chunks));
        }

        @Override
        public void close() {
            this.p.close();
        }

        @Override
        public SAMFileSpan getFilePointerSpanningReads() {
            return this.p.getFilePointerSpanningReads();
        }

        @Override
        public SAMFileHeader getFileHeader() {
            return this.p.getFileHeader();
        }

        @Override
        public Type type() {
            return this.p.type();
        }

        @Override
        public String getResourceDescription() {
            return this.resource.toString();
        }

        @Override
        public boolean hasIndex() {
            return this.p.hasIndex();
        }

        @Override
        public Indexing indexing() {
            return this;
        }

        @Override
        public BAMIndex getIndex() {
            return this.p.getIndex();
        }

        @Override
        public SAMRecordIterator query(QueryInterval[] intervals, boolean contained) {
            return AssertingIterator.of(this.p.query(intervals, contained));
        }

        @Override
        public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
            return this.query(new QueryInterval[]{new QueryInterval(this.getFileHeader().getSequenceIndex(sequence), start, end)}, contained);
        }

        @Override
        public SAMRecordIterator queryUnmapped() {
            return AssertingIterator.of(this.p.queryUnmapped());
        }

        @Override
        public SAMRecordIterator queryAlignmentStart(String sequence, int start) {
            return AssertingIterator.of(this.p.queryAlignmentStart(sequence, start));
        }
    }

    public static interface PrimitiveSamReader {
        public Type type();

        public boolean hasIndex();

        public BAMIndex getIndex();

        public SAMFileHeader getFileHeader();

        public CloseableIterator<SAMRecord> getIterator();

        public CloseableIterator<SAMRecord> getIterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();

        public CloseableIterator<SAMRecord> query(QueryInterval[] var1, boolean var2);

        public CloseableIterator<SAMRecord> queryAlignmentStart(String var1, int var2);

        public CloseableIterator<SAMRecord> queryUnmapped();

        public void close();

        public ValidationStringency getValidationStringency();
    }

    public static interface Indexing {
        public BAMIndex getIndex();

        public boolean hasBrowseableIndex();

        public BrowseableBAMIndex getBrowseableIndex();

        public SAMRecordIterator iterator(SAMFileSpan var1);

        public SAMFileSpan getFilePointerSpanningReads();
    }

    public static abstract class Type {
        public static final Type SRA_TYPE = new TypeImpl("SRA", "sra", null);
        public static final Type CRAM_TYPE = new TypeImpl("CRAM", "cram", "crai");
        public static final Type BAM_TYPE = new TypeImpl("BAM", "bam", "bai");
        public static final Type SAM_TYPE = new TypeImpl("SAM", "sam", null);
        public static final Type BAM_CSI_TYPE = new TypeImpl("BAM", "bam", "csi");

        public abstract String name();

        public abstract String fileExtension();

        public abstract String indexExtension();

        static class TypeImpl
        extends Type {
            final String name;
            final String fileExtension;
            final String indexExtension;

            TypeImpl(String name, String fileExtension, String indexExtension) {
                this.name = name;
                this.fileExtension = fileExtension;
                this.indexExtension = indexExtension;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String fileExtension() {
                return this.fileExtension;
            }

            @Override
            public String indexExtension() {
                return this.indexExtension;
            }

            public String toString() {
                return String.format("TypeImpl{name='%s', fileExtension='%s', indexExtension='%s'}", this.name, this.fileExtension, this.indexExtension);
            }
        }
    }
}

