/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.broad.igv.gwas.DescriptionCache;
import org.broad.igv.util.collections.DoubleArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class GWASData {
    private static final Logger log = Logger.getLogger(GWASData.class);
    private LinkedHashMap<String, IntArrayList> locations = new LinkedHashMap();
    private LinkedHashMap<String, DoubleArrayList> values = new LinkedHashMap();
    private DescriptionCache descriptionCache = new DescriptionCache();
    private IntArrayList fileIndex = new IntArrayList(100);
    private double maxValue = 0.0;

    public DescriptionCache getDescriptionCache() {
        return this.descriptionCache;
    }

    public IntArrayList getFileIndex() {
        return this.fileIndex;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getCumulativeChrLocation(String chr) {
        Object[] keys = this.locations.keySet().toArray();
        int lineCounter = 0;
        for (int chrCounter = 0; chrCounter < keys.length && !keys[chrCounter].toString().equals(chr); ++chrCounter) {
            lineCounter += this.locations.get(keys[chrCounter].toString()).size();
        }
        return lineCounter;
    }

    public int getNearestIndexByLocation(String chr, int location, double minValue, double maxValue, int maxDistance) {
        int index = -1;
        int iBefore = -1;
        int iAfter = -1;
        if (this.locations.containsKey(chr)) {
            int distance;
            int indexCounter;
            int[] locList = this.locations.get(chr).toArray();
            double[] valueList = this.values.get(chr).toArray();
            for (indexCounter = 0; indexCounter < locList.length && locList[indexCounter] < location; ++indexCounter) {
                if (!(valueList[indexCounter] > minValue) || !(valueList[indexCounter] < maxValue)) continue;
                iBefore = indexCounter;
            }
            while (indexCounter < valueList.length) {
                if (valueList[indexCounter] > minValue && valueList[indexCounter] < maxValue) {
                    iAfter = indexCounter;
                    break;
                }
                ++indexCounter;
            }
            if (iBefore >= 0 && iAfter >= 0) {
                int before = locList[iBefore];
                int after = locList[iAfter];
                index = Math.abs(location - before) < Math.abs(location - after) ? iBefore : iAfter;
            } else {
                if (iBefore >= 0) {
                    index = iBefore;
                }
                if (iAfter >= 0) {
                    index = iAfter;
                }
            }
            if (index >= 0 && (distance = Math.abs(location - locList[index])) > maxDistance) {
                index = -1;
            }
        }
        return index;
    }

    public void addLocation(String chr, int location) {
        IntArrayList locList = new IntArrayList(1);
        if (this.locations != null && this.locations.get(chr) != null) {
            locList = this.locations.get(chr);
        }
        locList.add(location);
        this.addLocations(chr, locList);
    }

    void addLocations(String chr, IntArrayList locations) {
        if (this.locations == null) {
            this.locations = new LinkedHashMap();
        }
        this.locations.put(chr, locations);
    }

    public void addValue(String chr, double value) {
        DoubleArrayList valueList = new DoubleArrayList(1);
        if (this.values != null && this.values.get(chr) != null) {
            valueList = this.values.get(chr);
        }
        valueList.add(value);
        this.addValues(chr, valueList);
        if (this.maxValue < value) {
            this.maxValue = value;
        }
    }

    void addValues(String chr, DoubleArrayList values) {
        if (this.values == null) {
            this.values = new LinkedHashMap();
        }
        this.values.put(chr, values);
    }

    public LinkedHashMap<String, IntArrayList> getLocations() {
        return this.locations;
    }

    public LinkedHashMap<String, DoubleArrayList> getValues() {
        return this.values;
    }
}

