/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.ftp;

import htsjdk.samtools.seekablestream.UserPasswordInput;
import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPReply;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class FTPUtils {
    static Map<String, String> userCredentials = new HashMap<String, String>();
    static int TIMEOUT = 10000;

    public static boolean resourceAvailable(URL url) {
        Object is = null;
        try {
            return FTPUtils.getContentLength(url) > 0L;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL url) throws IOException {
        FTPClient ftp = null;
        try {
            ftp = FTPUtils.connect(url.getHost(), url.getUserInfo(), null);
            String sizeString = ftp.executeCommand("size " + url.getPath()).getReplyString();
            long l = Integer.parseInt(sizeString);
            return l;
        }
        catch (Exception e) {
            long l = -1L;
            return l;
        }
        finally {
            if (ftp != null) {
                ftp.disconnect();
            }
        }
    }

    public static synchronized FTPClient connect(String host, String userInfo, UserPasswordInput userPasswordInput) throws IOException {
        FTPClient ftp = new FTPClient();
        FTPReply reply = ftp.connect(host);
        if (!reply.isSuccess()) {
            throw new RuntimeException("Could not connect to " + host);
        }
        String user = "anonymous";
        String password = "igv@broadinstitute.org";
        if (userInfo == null) {
            userInfo = userCredentials.get(host);
        }
        if (userInfo != null) {
            String[] tmp = userInfo.split(":");
            user = tmp[0];
            if (tmp.length > 1) {
                password = tmp[1];
            }
        }
        if (!(reply = ftp.login(user, password)).isSuccess()) {
            if (userPasswordInput == null) {
                throw new RuntimeException("Login failure for host: " + host);
            }
            userPasswordInput.setHost(host);
            boolean success = false;
            while (!success && userPasswordInput.showDialog()) {
                user = userPasswordInput.getUser();
                password = userPasswordInput.getPassword();
                reply = ftp.login(user, password);
                success = reply.isSuccess();
            }
            if (success) {
                userInfo = user + ":" + password;
                userCredentials.put(host, userInfo);
            } else {
                throw new RuntimeException("Login failure for host: " + host);
            }
        }
        if (!(reply = ftp.binary()).isSuccess()) {
            throw new RuntimeException("Could not set binary mode on host: " + host);
        }
        return ftp;
    }
}

