/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class CytobandRenderer {
    boolean drawLabels = true;
    public static final int CYTOBAND_Y_OFFSET = 5;
    public static final int LABEL_OFFSET = 25;
    private static Map<Integer, Color> stainColors = new HashMap<Integer, Color>();

    public void draw(List<Cytoband> data, Graphics g2D, Rectangle graphicRect, ReferenceFrame frame) {
        if (data.size() > 0) {
            String locus;
            if ((IGV.getInstance().isExportingSnapshot() || FrameManager.isGeneListMode()) && (locus = frame.getChrName()) != null) {
                Graphics g2 = g2D.create();
                g2.setFont(FontManager.getFont(1, 11));
                g2.drawString(locus, 3, 11);
                g2.dispose();
            }
            this.drawBands(data, g2D, graphicRect, frame.getMaxCoordinate());
            if (this.drawLabels && !FrameManager.isGeneListMode()) {
                this.drawLabels(g2D, graphicRect, data, frame.getMaxCoordinate());
            }
        }
    }

    public void drawBands(List<Cytoband> data, Graphics g2D, Rectangle graphicRect, int chromoLength) {
        int[] xC = new int[3];
        int[] yC = new int[3];
        double scale = graphicRect.getWidth() / (double)chromoLength;
        int lastPX = -1;
        for (Cytoband cytoband : data) {
            int start = (int)(graphicRect.getX() + scale * (double)cytoband.getStart());
            int end = (int)(graphicRect.getX() + scale * (double)cytoband.getEnd());
            if (end > lastPX) {
                int y = (int)graphicRect.getY() + 5;
                int height = (int)graphicRect.getHeight();
                if (cytoband.getType() == 'c') {
                    int center = y + height / 2;
                    if (cytoband.getName().startsWith("p")) {
                        xC[0] = start;
                        yC[0] = (int)graphicRect.getMaxY() + 5;
                        xC[1] = start;
                        yC[1] = y;
                        xC[2] = end;
                        yC[2] = center;
                    } else {
                        xC[0] = end;
                        yC[0] = (int)graphicRect.getMaxY() + 5;
                        xC[1] = end;
                        yC[1] = y;
                        xC[2] = start;
                        yC[2] = center;
                    }
                    g2D.setColor(Color.RED.darker());
                    g2D.fillPolygon(xC, yC, 3);
                } else {
                    g2D.setColor(CytobandRenderer.getCytobandColor(cytoband));
                    g2D.fillRect(start, y, end - start, height);
                    g2D.setColor(Color.BLACK);
                    g2D.drawRect(start, y, end - start, height);
                }
            }
            lastPX = end;
        }
    }

    private void drawLabels(Graphics g, Rectangle graphicRect, List<Cytoband> cytobands, int chromoLength) {
        double width = graphicRect.getWidth();
        int y = (int)graphicRect.getY() + 25;
        g.setColor(Color.BLACK);
        FontMetrics fm = g.getFontMetrics();
        int minSpacing = 10;
        int prevEnd = 0;
        double sc = width / (double)chromoLength;
        int adjustedY = y;
        if (cytobands != null) {
            for (Cytoband cytoband : cytobands) {
                int stringWidth;
                int e;
                int s = (int)(sc * (double)cytoband.getStart());
                int x = s + ((e = (int)(sc * (double)cytoband.getEnd())) - s - (stringWidth = (int)fm.getStringBounds(cytoband.getName(), g).getWidth())) / 2;
                if (x <= prevEnd + minSpacing) continue;
                g.drawString(cytoband.getName(), x, adjustedY);
                prevEnd = x + stringWidth;
            }
        }
    }

    public void applyTextTranslationAndRotation(Graphics2D graphics2, int x, int y) {
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(-1.5707963267948966);
        graphics2.transform(transform);
    }

    private static Color getCytobandColor(Cytoband data) {
        if (data.getType() == 'p') {
            short stain = data.getStain();
            int shade = (int)(255.0 - (double)stain / 100.0 * 255.0);
            Color c = stainColors.get(shade);
            if (c == null) {
                c = new Color(shade, shade, shade);
                stainColors.put(shade, c);
            }
            return c;
        }
        if (data.getType() == 'c') {
            return Color.PINK;
        }
        return Color.WHITE;
    }
}

