/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.data.cufflinks.ExpDiffCodec;
import org.broad.igv.data.cufflinks.FPKMTrackingCodec;
import org.broad.igv.feature.Range;

public class CufflinksParser {
    public static List<? extends Range> parse(String path) throws IOException {
        String s = path.toLowerCase();
        if (s.endsWith("fpkm_tracking")) {
            FPKMTrackingCodec codec = new FPKMTrackingCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        if (s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff")) {
            ExpDiffCodec codec = new ExpDiffCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        throw new RuntimeException("Unsupported file type: " + path);
    }

    public static <T extends Range> List<T> parse(AsciiFeatureCodec<T> codec, String path) throws IOException {
        ArrayList values = new ArrayList();
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(path, codec, false);
        CloseableTribbleIterator iter = reader.iterator();
        while (iter.hasNext()) {
            values.add(iter.next());
        }
        return values;
    }
}

